/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.gwc.ConfigurableBlobStore;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.util.logging.Logging;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.blobstore.file.FileBlobStore;
import org.geowebcache.storage.blobstore.memory.CacheConfiguration;
import org.geowebcache.storage.blobstore.memory.CacheProvider;
import org.geowebcache.storage.blobstore.memory.MemoryBlobStore;
import org.geowebcache.storage.blobstore.memory.NullBlobStore;
import org.geowebcache.storage.blobstore.memory.guava.GuavaCacheProvider;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ConfigurableBlobStoreTest
extends GeoServerSystemTestSupport {
    private static final Logger LOGGER = Logging.getLogger(ConfigurableBlobStoreTest.class);
    public static final String TEST_BLOB_DIR_NAME = "gwcTestBlobs";
    public static final String LAYER_NAME = "test:123123 112";
    private static CacheProvider cache;
    private BlobStore defaultStore;
    private ConfigurableBlobStore blobStore;
    private File directory;

    @BeforeClass
    public static void initialSetup() {
        cache = new GuavaCacheProvider(new CacheConfiguration());
    }

    @Before
    public void setup() throws IOException {
        File dataDirectoryRoot = ((SystemTestData)this.getTestData()).getDataDirectoryRoot();
        MemoryBlobStore mbs = new MemoryBlobStore();
        NullBlobStore nbs = new NullBlobStore();
        this.directory = new File(dataDirectoryRoot, "testConfigurableBlobStore");
        if (this.directory.exists()) {
            FileUtils.deleteDirectory((File)this.directory);
        }
        this.directory.mkdirs();
        this.defaultStore = (BlobStore)Mockito.spy((Object)new FileBlobStore(this.directory.getAbsolutePath()));
        this.blobStore = new ConfigurableBlobStore(this.defaultStore, mbs, nbs);
        this.blobStore.setCache(cache);
    }

    @After
    public void after() throws IOException {
        this.blobStore.destroy();
        if (this.directory.exists()) {
            FileUtils.deleteQuietly((File)this.directory);
        }
    }

    @Test
    public void testNullStore() throws Exception {
        GWCConfig gwcConfig = new GWCConfig();
        gwcConfig.setInnerCachingEnabled(true);
        gwcConfig.setEnabledPersistence(false);
        this.blobStore.setChanged(gwcConfig, false);
        BlobStore delegate = this.blobStore.getDelegate();
        Assert.assertTrue((boolean)(delegate instanceof MemoryBlobStore));
        Assert.assertTrue((boolean)(((MemoryBlobStore)delegate).getStore() instanceof NullBlobStore));
        ByteArrayResource bytes = new ByteArrayResource("1 2 3 4 5 6 test".getBytes());
        long[] xyz = new long[]{1L, 2L, 3L};
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("a", "x");
        parameters.put("b", "\u00f8");
        TileObject to = TileObject.createCompleteTileObject((String)LAYER_NAME, (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters, (Resource)bytes);
        this.blobStore.put(to);
        TileObject to2 = TileObject.createQueryTileObject((String)LAYER_NAME, (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        this.blobStore.get(to2);
        Assert.assertEquals((Object)to.getBlobFormat(), (Object)to2.getBlobFormat());
        try (InputStream is = to.getBlob().getInputStream();
             InputStream is2 = to2.getBlob().getInputStream();){
            this.checkInputStreams(is, is2);
        }
        TileObject to3 = cache.getTileObj(to);
        Assert.assertNotNull((Object)to3);
        Assert.assertEquals((Object)to.getBlobFormat(), (Object)to3.getBlobFormat());
        try (InputStream is = to.getBlob().getInputStream();
             InputStream is3 = to3.getBlob().getInputStream();){
            this.checkInputStreams(is, is3);
        }
        Assert.assertFalse((boolean)((MemoryBlobStore)delegate).getStore().get(to));
    }

    @Test
    public void testTilePut() throws Exception {
        GWCConfig gwcConfig = new GWCConfig();
        gwcConfig.setInnerCachingEnabled(true);
        gwcConfig.setEnabledPersistence(true);
        this.blobStore.setChanged(gwcConfig, false);
        Assert.assertTrue((boolean)(this.blobStore.getDelegate() instanceof MemoryBlobStore));
        ByteArrayResource bytes = new ByteArrayResource("1 2 3 4 5 6 test".getBytes());
        long[] xyz = new long[]{1L, 2L, 3L};
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("a", "x");
        parameters.put("b", "\u00f8");
        TileObject to = TileObject.createCompleteTileObject((String)LAYER_NAME, (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters, (Resource)bytes);
        this.blobStore.put(to);
        TileObject to2 = TileObject.createQueryTileObject((String)LAYER_NAME, (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        this.blobStore.get(to2);
        Assert.assertEquals((Object)to.getBlobFormat(), (Object)to2.getBlobFormat());
        try (InputStream is = to.getBlob().getInputStream();
             InputStream is2 = to2.getBlob().getInputStream();){
            this.checkInputStreams(is, is2);
        }
        TileObject to3 = cache.getTileObj(to);
        Assert.assertNotNull((Object)to3);
        Assert.assertEquals((Object)to.getBlobFormat(), (Object)to3.getBlobFormat());
        try (InputStream is = to.getBlob().getInputStream();
             InputStream is3 = to3.getBlob().getInputStream();){
            this.checkInputStreams(is, is3);
        }
        MatcherAssert.assertThat((Object)this.blobStore.layerExists(LAYER_NAME), (Matcher)Matchers.equalTo((Object)true));
        Map parametersMapping = this.blobStore.getParametersMapping(LAYER_NAME);
        MatcherAssert.assertThat((Object)parametersMapping.size(), (Matcher)Matchers.equalTo((Object)1));
        Optional value = (Optional)parametersMapping.values().iterator().next();
        MatcherAssert.assertThat((Object)value.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((Map)value.get()), (Matcher)Matchers.hasEntry((Object)"a", (Object)"x"));
        MatcherAssert.assertThat((Object)((Map)value.get()), (Matcher)Matchers.hasEntry((Object)"b", (Object)"\u00f8"));
    }

    @Test
    public void testTileDelete() throws Exception {
        GWCConfig gwcConfig = new GWCConfig();
        gwcConfig.setInnerCachingEnabled(false);
        this.blobStore.setChanged(gwcConfig, false);
        Assert.assertTrue((boolean)(this.blobStore.getDelegate() instanceof FileBlobStore));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("a", "x");
        parameters.put("b", "\u00f8");
        ByteArrayResource bytes = new ByteArrayResource("1 2 3 4 5 6 test".getBytes());
        long[] xyz = new long[]{5L, 6L, 7L};
        TileObject to = TileObject.createCompleteTileObject((String)LAYER_NAME, (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters, (Resource)bytes);
        this.blobStore.put(to);
        TileObject to2 = TileObject.createQueryTileObject((String)LAYER_NAME, (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        this.blobStore.get(to2);
        try (InputStream is = to2.getBlob().getInputStream();
             InputStream is2 = bytes.getInputStream();){
            this.checkInputStreams(is, is2);
        }
        TileObject to3 = TileObject.createQueryTileObject((String)LAYER_NAME, (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        this.blobStore.delete(to3);
        TileObject to4 = TileObject.createQueryTileObject((String)LAYER_NAME, (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        Assert.assertFalse((boolean)this.blobStore.get(to4));
    }

    @Test
    public void testTileDeleteByParameters() throws Exception {
        GWCConfig gwcConfig = new GWCConfig();
        gwcConfig.setInnerCachingEnabled(false);
        this.blobStore.setChanged(gwcConfig, false);
        Assert.assertTrue((boolean)(this.blobStore.getDelegate() instanceof FileBlobStore));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("a", "x");
        parameters.put("b", "\u00f8");
        ByteArrayResource bytes = new ByteArrayResource("1 2 3 4 5 6 test".getBytes());
        long[] xyz = new long[]{5L, 6L, 7L};
        TileObject to = TileObject.createCompleteTileObject((String)LAYER_NAME, (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters, (Resource)bytes);
        this.blobStore.put(to);
        this.blobStore.deleteByParameters(LAYER_NAME, parameters);
        TileObject to4 = TileObject.createQueryTileObject((String)LAYER_NAME, (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        Assert.assertFalse((boolean)this.blobStore.get(to4));
    }

    @Test
    public void testTileDeleteByParametersId() throws Exception {
        GWCConfig gwcConfig = new GWCConfig();
        gwcConfig.setInnerCachingEnabled(false);
        this.blobStore.setChanged(gwcConfig, false);
        Assert.assertTrue((boolean)(this.blobStore.getDelegate() instanceof FileBlobStore));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("a", "x");
        parameters.put("b", "\u00f8");
        ByteArrayResource bytes = new ByteArrayResource("1 2 3 4 5 6 test".getBytes());
        long[] xyz = new long[]{5L, 6L, 7L};
        TileObject to = TileObject.createCompleteTileObject((String)LAYER_NAME, (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters, (Resource)bytes);
        this.blobStore.put(to);
        String parametersId = (String)this.blobStore.getParametersMapping(LAYER_NAME).keySet().iterator().next();
        this.blobStore.deleteByParametersId(LAYER_NAME, parametersId);
        TileObject to4 = TileObject.createQueryTileObject((String)LAYER_NAME, (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        Assert.assertFalse((boolean)this.blobStore.get(to4));
    }

    @Test
    public void testListeners() throws Exception {
        GWCConfig gwcConfig = new GWCConfig();
        gwcConfig.setInnerCachingEnabled(true);
        gwcConfig.setEnabledPersistence(true);
        this.blobStore.setChanged(gwcConfig, false);
        BlobStoreListener l1 = (BlobStoreListener)Mockito.mock(BlobStoreListener.class);
        BlobStoreListener l2 = (BlobStoreListener)Mockito.mock(BlobStoreListener.class);
        Assert.assertTrue((boolean)(this.blobStore.getDelegate() instanceof MemoryBlobStore));
        this.blobStore.addListener(l1);
        this.blobStore.addListener(l2);
        ((BlobStore)Mockito.verify((Object)this.defaultStore, (VerificationMode)Mockito.times((int)2))).addListener((BlobStoreListener)Mockito.any(BlobStoreListener.class));
        Mockito.reset((Object[])new BlobStore[]{this.defaultStore});
        GWCConfig newConfig = new GWCConfig();
        newConfig.setInnerCachingEnabled(false);
        newConfig.setEnabledPersistence(true);
        this.blobStore.setChanged(newConfig, false);
        Assert.assertFalse((boolean)(this.blobStore.getDelegate() instanceof MemoryBlobStore));
        ((BlobStore)Mockito.verify((Object)this.defaultStore, (VerificationMode)Mockito.times((int)2))).removeListener((BlobStoreListener)Mockito.any(BlobStoreListener.class));
        ((BlobStore)Mockito.verify((Object)this.defaultStore, (VerificationMode)Mockito.times((int)2))).addListener((BlobStoreListener)Mockito.any(BlobStoreListener.class));
    }

    private void checkInputStreams(InputStream is, InputStream is2) throws IOException {
        try (InputStream inputStream = is;
             InputStream inputStream2 = is2;){
            Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)is, (InputStream)is2));
            try {
                is.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                Assert.fail();
            }
            try {
                is2.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                Assert.fail();
            }
        }
    }
}

