/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import org.easymock.EasyMock;
import org.geoserver.gwc.GWCZoomContextFinder;
import org.geotools.styling.zoom.ScaleRange;
import org.geotools.styling.zoom.TestUtils;
import org.geotools.styling.zoom.ZoomContext;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Ignore;
import org.junit.Test;

public class GWCZoomContextFinderTest {
    private static final double EPSILON = 1.0E-9;

    Grid mockGrid(int level, double denom, GridSet mockGridset) {
        Grid grid = (Grid)EasyMock.createMock(Grid.class);
        EasyMock.expect((Object)mockGridset.getGrid(level)).andStubReturn((Object)grid);
        EasyMock.expect((Object)grid.getScaleDenominator()).andStubReturn((Object)denom);
        return grid;
    }

    @Test
    public void testGetContext() throws Exception {
        GridSetBroker broker = (GridSetBroker)EasyMock.createMock(GridSetBroker.class);
        GridSet set = (GridSet)EasyMock.createMock(GridSet.class);
        EasyMock.expect((Object)broker.get("test")).andReturn((Object)set);
        Grid grid1 = this.mockGrid(1, 5.0E8, set);
        EasyMock.replay((Object[])new Object[]{broker, set, grid1});
        GWCZoomContextFinder finder = new GWCZoomContextFinder(broker);
        ZoomContext zContext = finder.get("test");
        MatcherAssert.assertThat((Object)zContext, (Matcher)Matchers.notNullValue());
        EasyMock.verify((Object[])new Object[]{broker, set, grid1});
    }

    @Test
    public void testCouldntFind() throws Exception {
        GridSetBroker broker = (GridSetBroker)EasyMock.createMock(GridSetBroker.class);
        GridSet set = (GridSet)EasyMock.createMock(GridSet.class);
        EasyMock.expect((Object)broker.get("test")).andStubReturn((Object)set);
        EasyMock.expect((Object)broker.get("doesntexist")).andStubReturn(null);
        Grid grid1 = this.mockGrid(1, 5.0E8, set);
        EasyMock.replay((Object[])new Object[]{broker, set, grid1});
        GWCZoomContextFinder finder = new GWCZoomContextFinder(broker);
        ZoomContext zContext = finder.get("doesntexist");
        MatcherAssert.assertThat((Object)zContext, (Matcher)Matchers.nullValue());
        EasyMock.verify((Object[])new Object[]{broker, set, grid1});
    }

    @Test
    public void testCorrectScale() throws Exception {
        GridSetBroker broker = (GridSetBroker)EasyMock.createMock(GridSetBroker.class);
        GridSet set = (GridSet)EasyMock.createMock(GridSet.class);
        EasyMock.expect((Object)broker.get("test")).andStubReturn((Object)set);
        Grid grid1 = this.mockGrid(1, 5.0E8, set);
        EasyMock.expect((Object)set.getNumLevels()).andStubReturn((Object)5);
        EasyMock.replay((Object[])new Object[]{broker, set, grid1});
        GWCZoomContextFinder finder = new GWCZoomContextFinder(broker);
        ZoomContext zContext = finder.get("test");
        double denom = zContext.getScaleDenominator(1);
        MatcherAssert.assertThat((Object)denom, (Matcher)Matchers.closeTo((double)5.0E8, (double)1.0E-9));
        EasyMock.verify((Object[])new Object[]{broker, set, grid1});
    }

    @Test
    public void testScaleNegativeLevel() throws Exception {
        GridSetBroker broker = (GridSetBroker)EasyMock.createMock(GridSetBroker.class);
        GridSet set = (GridSet)EasyMock.createMock(GridSet.class);
        EasyMock.expect((Object)broker.get("test")).andStubReturn((Object)set);
        EasyMock.expect((Object)set.getNumLevels()).andStubReturn((Object)5);
        EasyMock.replay((Object[])new Object[]{broker, set});
        GWCZoomContextFinder finder = new GWCZoomContextFinder(broker);
        ZoomContext zContext = finder.get("test");
        double denom = zContext.getScaleDenominator(-1);
        MatcherAssert.assertThat((Object)denom, (Matcher)Matchers.is((Object)Double.POSITIVE_INFINITY));
        EasyMock.verify((Object[])new Object[]{broker, set});
    }

    @Test
    public void testScalePastEnd() throws Exception {
        GridSetBroker broker = (GridSetBroker)EasyMock.createMock(GridSetBroker.class);
        GridSet set = (GridSet)EasyMock.createMock(GridSet.class);
        EasyMock.expect((Object)broker.get("test")).andStubReturn((Object)set);
        EasyMock.expect((Object)set.getNumLevels()).andStubReturn((Object)5);
        EasyMock.replay((Object[])new Object[]{broker, set});
        GWCZoomContextFinder finder = new GWCZoomContextFinder(broker);
        ZoomContext zContext = finder.get("test");
        double denom = zContext.getScaleDenominator(5);
        MatcherAssert.assertThat((Object)denom, (Matcher)Matchers.is((Object)0.0));
        EasyMock.verify((Object[])new Object[]{broker, set});
    }

    @Test
    public void testRange() throws Exception {
        GridSetBroker broker = (GridSetBroker)EasyMock.createMock(GridSetBroker.class);
        GridSet set = (GridSet)EasyMock.createMock(GridSet.class);
        EasyMock.expect((Object)broker.get("test")).andStubReturn((Object)set);
        Grid grid1 = this.mockGrid(1, 5.0E8, set);
        Grid grid2 = this.mockGrid(2, 2.0E8, set);
        Grid grid3 = this.mockGrid(3, 1.0E8, set);
        EasyMock.expect((Object)set.getNumLevels()).andStubReturn((Object)5);
        EasyMock.replay((Object[])new Object[]{broker, set, grid1, grid2, grid3});
        GWCZoomContextFinder finder = new GWCZoomContextFinder(broker);
        ZoomContext zContext = finder.get("test");
        ScaleRange range = zContext.getRange(Integer.valueOf(2), Integer.valueOf(2));
        MatcherAssert.assertThat((Object)range, (Matcher)TestUtils.rangeContains((double)2.0E8));
        MatcherAssert.assertThat((Object)range, (Matcher)Matchers.not((Matcher)TestUtils.rangeContains((double)5.0E8)));
        MatcherAssert.assertThat((Object)range, (Matcher)Matchers.not((Matcher)TestUtils.rangeContains((double)1.0E8)));
        EasyMock.verify((Object[])new Object[]{broker, set, grid1, grid2, grid3});
    }

    @Test
    public void testRangeStart() throws Exception {
        GridSetBroker broker = (GridSetBroker)EasyMock.createMock(GridSetBroker.class);
        GridSet set = (GridSet)EasyMock.createMock(GridSet.class);
        EasyMock.expect((Object)broker.get("test")).andStubReturn((Object)set);
        Grid grid0 = this.mockGrid(0, 5.0E8, set);
        Grid grid1 = this.mockGrid(1, 2.0E8, set);
        Grid grid2 = this.mockGrid(2, 1.0E8, set);
        EasyMock.expect((Object)set.getNumLevels()).andStubReturn((Object)5);
        EasyMock.replay((Object[])new Object[]{broker, set, grid0, grid1, grid2});
        GWCZoomContextFinder finder = new GWCZoomContextFinder(broker);
        ZoomContext zContext = finder.get("test");
        ScaleRange range = zContext.getRange(Integer.valueOf(0), Integer.valueOf(1));
        MatcherAssert.assertThat((Object)range, (Matcher)TestUtils.rangeContains((double)9.999999999999999E8));
        MatcherAssert.assertThat((Object)range, (Matcher)TestUtils.rangeContains((double)5.0E8));
        MatcherAssert.assertThat((Object)range, (Matcher)TestUtils.rangeContains((double)2.0E8));
        MatcherAssert.assertThat((Object)range, (Matcher)Matchers.not((Matcher)TestUtils.rangeContains((double)1.0E8)));
        MatcherAssert.assertThat((Object)range, (Matcher)Matchers.not((Matcher)TestUtils.rangeContains((double)1.0E-9)));
        EasyMock.verify((Object[])new Object[]{broker, set, grid0, grid1, grid2});
    }

    @Test
    public void testRangeEnd() throws Exception {
        GridSetBroker broker = (GridSetBroker)EasyMock.createMock(GridSetBroker.class);
        GridSet set = (GridSet)EasyMock.createMock(GridSet.class);
        EasyMock.expect((Object)broker.get("test")).andStubReturn((Object)set);
        Grid grid2 = this.mockGrid(2, 5.0E8, set);
        Grid grid3 = this.mockGrid(3, 2.0E8, set);
        Grid grid4 = this.mockGrid(4, 1.0E8, set);
        EasyMock.expect((Object)set.getNumLevels()).andStubReturn((Object)5);
        EasyMock.replay((Object[])new Object[]{broker, set, grid2, grid3, grid4});
        GWCZoomContextFinder finder = new GWCZoomContextFinder(broker);
        ZoomContext zContext = finder.get("test");
        ScaleRange range = zContext.getRange(Integer.valueOf(3), Integer.valueOf(4));
        MatcherAssert.assertThat((Object)range, (Matcher)Matchers.not((Matcher)TestUtils.rangeContains((double)9.999999999999999E8)));
        MatcherAssert.assertThat((Object)range, (Matcher)Matchers.not((Matcher)TestUtils.rangeContains((double)5.0E8)));
        MatcherAssert.assertThat((Object)range, (Matcher)TestUtils.rangeContains((double)2.0E8));
        MatcherAssert.assertThat((Object)range, (Matcher)TestUtils.rangeContains((double)1.0E8));
        MatcherAssert.assertThat((Object)range, (Matcher)TestUtils.rangeContains((double)1.0E-9));
        EasyMock.verify((Object[])new Object[]{broker, set, grid2, grid3, grid4});
    }

    @Test
    public void testRangePastEnd() throws Exception {
        GridSetBroker broker = (GridSetBroker)EasyMock.createMock(GridSetBroker.class);
        GridSet set = (GridSet)EasyMock.createMock(GridSet.class);
        EasyMock.expect((Object)broker.get("test")).andStubReturn((Object)set);
        Grid grid2 = this.mockGrid(2, 5.0E8, set);
        Grid grid3 = this.mockGrid(3, 2.0E8, set);
        Grid grid4 = this.mockGrid(4, 1.0E8, set);
        EasyMock.expect((Object)set.getNumLevels()).andStubReturn((Object)5);
        EasyMock.replay((Object[])new Object[]{broker, set, grid2, grid3, grid4});
        GWCZoomContextFinder finder = new GWCZoomContextFinder(broker);
        ZoomContext zContext = finder.get("test");
        ScaleRange range = zContext.getRange(Integer.valueOf(6), Integer.valueOf(7));
        MatcherAssert.assertThat((Object)range, (Matcher)Matchers.not((Matcher)TestUtils.rangeContains((double)9.999999999999999E8)));
        MatcherAssert.assertThat((Object)range, (Matcher)Matchers.not((Matcher)TestUtils.rangeContains((double)5.0E8)));
        MatcherAssert.assertThat((Object)range, (Matcher)Matchers.not((Matcher)TestUtils.rangeContains((double)2.0E8)));
        MatcherAssert.assertThat((Object)range, (Matcher)Matchers.not((Matcher)TestUtils.rangeContains((double)1.0E8)));
        MatcherAssert.assertThat((Object)range, (Matcher)Matchers.not((Matcher)TestUtils.rangeContains((double)1.0E-9)));
        EasyMock.verify((Object[])new Object[]{broker, set, grid2, grid3, grid4});
    }

    @Test
    public void testRangePastStart() throws Exception {
        GridSetBroker broker = (GridSetBroker)EasyMock.createMock(GridSetBroker.class);
        GridSet set = (GridSet)EasyMock.createMock(GridSet.class);
        EasyMock.expect((Object)broker.get("test")).andStubReturn((Object)set);
        Grid grid2 = this.mockGrid(2, 5.0E8, set);
        Grid grid3 = this.mockGrid(3, 2.0E8, set);
        Grid grid4 = this.mockGrid(4, 1.0E8, set);
        EasyMock.expect((Object)set.getNumLevels()).andStubReturn((Object)5);
        EasyMock.replay((Object[])new Object[]{broker, set, grid2, grid3, grid4});
        GWCZoomContextFinder finder = new GWCZoomContextFinder(broker);
        ZoomContext zContext = finder.get("test");
        ScaleRange range = zContext.getRange(Integer.valueOf(-2), Integer.valueOf(-1));
        MatcherAssert.assertThat((Object)range, (Matcher)Matchers.not((Matcher)TestUtils.rangeContains((double)9.999999999999999E8)));
        MatcherAssert.assertThat((Object)range, (Matcher)Matchers.not((Matcher)TestUtils.rangeContains((double)5.0E8)));
        MatcherAssert.assertThat((Object)range, (Matcher)Matchers.not((Matcher)TestUtils.rangeContains((double)2.0E8)));
        MatcherAssert.assertThat((Object)range, (Matcher)Matchers.not((Matcher)TestUtils.rangeContains((double)1.0E8)));
        MatcherAssert.assertThat((Object)range, (Matcher)Matchers.not((Matcher)TestUtils.rangeContains((double)1.0E-9)));
        EasyMock.verify((Object[])new Object[]{broker, set, grid2, grid3, grid4});
    }

    @Test
    public void testRangeBoundaryLikeTileFuser() throws Exception {
        GridSetBroker broker = (GridSetBroker)EasyMock.createMock(GridSetBroker.class);
        GridSet set = (GridSet)EasyMock.createMock(GridSet.class);
        EasyMock.expect((Object)broker.get("test")).andStubReturn((Object)set);
        Grid grid2 = this.mockGrid(2, 5.0E8, set);
        Grid grid3 = this.mockGrid(3, 2.0E8, set);
        Grid grid4 = this.mockGrid(4, 1.0E8, set);
        EasyMock.expect((Object)set.getNumLevels()).andStubReturn((Object)5);
        EasyMock.replay((Object[])new Object[]{broker, set, grid2, grid3, grid4});
        GWCZoomContextFinder finder = new GWCZoomContextFinder(broker);
        ZoomContext zContext = finder.get("test");
        ScaleRange range = zContext.getRange(Integer.valueOf(3), Integer.valueOf(3));
        MatcherAssert.assertThat((Object)range.getMaxDenom(), (Matcher)Matchers.closeTo((double)4.9751243781094533E8, (double)1.0E-9));
        MatcherAssert.assertThat((Object)range.getMinDenom(), (Matcher)Matchers.closeTo((double)1.9900497512437814E8, (double)1.0E-9));
        EasyMock.verify((Object[])new Object[]{broker, set, grid2, grid3, grid4});
    }

    @Test
    @Ignore
    public void testRangeBoundaryGeometric() throws Exception {
        GridSetBroker broker = (GridSetBroker)EasyMock.createMock(GridSetBroker.class);
        GridSet set = (GridSet)EasyMock.createMock(GridSet.class);
        EasyMock.expect((Object)broker.get("test")).andStubReturn((Object)set);
        Grid grid2 = this.mockGrid(2, 5.0E8, set);
        Grid grid3 = this.mockGrid(3, 2.0E8, set);
        Grid grid4 = this.mockGrid(4, 1.0E8, set);
        EasyMock.expect((Object)set.getNumLevels()).andStubReturn((Object)5);
        EasyMock.replay((Object[])new Object[]{broker, set, grid2, grid3, grid4});
        GWCZoomContextFinder finder = new GWCZoomContextFinder(broker);
        ZoomContext zContext = finder.get("test");
        ScaleRange range = zContext.getRange(Integer.valueOf(3), Integer.valueOf(3));
        MatcherAssert.assertThat((Object)range.getMaxDenom(), (Matcher)Matchers.closeTo((double)Math.sqrt(1.0E17), (double)1.0E-9));
        MatcherAssert.assertThat((Object)range.getMinDenom(), (Matcher)Matchers.closeTo((double)Math.sqrt(2.0E16), (double)1.0E-9));
        EasyMock.verify((Object[])new Object[]{broker, set, grid2, grid3, grid4});
    }
}

