/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.config;

import org.geoserver.data.test.SystemTestData;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geowebcache.storage.blobstore.memory.guava.GuavaCacheProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GWCConfigTest
extends GeoServerSystemTestSupport {
    private GWCConfig oldDefaults;
    private GWCConfig config;

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
    }

    @Before
    public void setup() throws Exception {
        this.oldDefaults = GWCConfig.getOldDefaults();
        this.config = new GWCConfig();
    }

    @Test
    public void testSaneConfig() {
        Assert.assertTrue((boolean)this.config.isSane());
        Assert.assertSame((Object)this.config, (Object)this.config.saneConfig());
        Assert.assertTrue((boolean)this.oldDefaults.isSane());
        Assert.assertSame((Object)this.oldDefaults, (Object)this.oldDefaults.saneConfig());
        this.config.setMetaTilingX(-1);
        Assert.assertFalse((boolean)this.config.isSane());
        this.config = this.config.saneConfig();
        Assert.assertTrue((boolean)this.config.isSane());
        this.config.setMetaTilingY(-1);
        Assert.assertFalse((boolean)this.config.isSane());
        this.config = this.config.saneConfig();
        Assert.assertTrue((boolean)this.config.isSane());
        this.config.setMetaTilingThreads(Integer.valueOf(-1));
        Assert.assertFalse((boolean)this.config.isSane());
        this.config = this.config.saneConfig();
        Assert.assertTrue((boolean)this.config.isSane());
        this.config.setGutter(-1);
        Assert.assertFalse((boolean)this.config.isSane());
        this.config = this.config.saneConfig();
        Assert.assertTrue((boolean)this.config.isSane());
        this.config.getDefaultCachingGridSetIds().clear();
        Assert.assertFalse((boolean)this.config.isSane());
        this.config = this.config.saneConfig();
        Assert.assertTrue((boolean)this.config.isSane());
        this.config.getDefaultCoverageCacheFormats().clear();
        Assert.assertFalse((boolean)this.config.isSane());
        this.config = this.config.saneConfig();
        Assert.assertTrue((boolean)this.config.isSane());
        this.config.getDefaultOtherCacheFormats().clear();
        Assert.assertFalse((boolean)this.config.isSane());
        this.config = this.config.saneConfig();
        Assert.assertTrue((boolean)this.config.isSane());
        this.config.getDefaultVectorCacheFormats().clear();
        Assert.assertFalse((boolean)this.config.isSane());
        this.config = this.config.saneConfig();
        Assert.assertTrue((boolean)this.config.isSane());
    }

    @Test
    public void testClone() {
        GWCConfig clone = this.config.clone();
        Assert.assertEquals((Object)this.config, (Object)clone);
        Assert.assertNotSame((Object)this.config.getDefaultCachingGridSetIds(), (Object)clone.getDefaultCachingGridSetIds());
        Assert.assertNotSame((Object)this.config.getDefaultCoverageCacheFormats(), (Object)clone.getDefaultCoverageCacheFormats());
        Assert.assertNotSame((Object)this.config.getDefaultOtherCacheFormats(), (Object)clone.getDefaultOtherCacheFormats());
        Assert.assertNotSame((Object)this.config.getDefaultVectorCacheFormats(), (Object)clone.getDefaultVectorCacheFormats());
        Assert.assertNotSame((Object)this.config.getCacheConfigurations(), (Object)clone.getCacheConfigurations());
        Assert.assertTrue((boolean)clone.getCacheConfigurations().containsKey(GuavaCacheProvider.class.toString()));
    }

    @Test
    public void testIsServiceEnabled() {
        this.config.setWMSCEnabled(!this.config.isWMSCEnabled());
        this.config.setTMSEnabled(!this.config.isTMSEnabled());
        Assert.assertEquals((Object)this.config.isEnabled("wms"), (Object)this.config.isWMSCEnabled());
        Assert.assertEquals((Object)this.config.isEnabled("WMS"), (Object)this.config.isWMSCEnabled());
        Assert.assertEquals((Object)this.config.isEnabled("tms"), (Object)this.config.isTMSEnabled());
        Assert.assertEquals((Object)this.config.isEnabled("TMS"), (Object)this.config.isTMSEnabled());
        Assert.assertTrue((boolean)this.config.isEnabled("anything else"));
    }
}

