/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.catalog.event.impl.CatalogAddEventImpl;
import org.geoserver.catalog.event.impl.CatalogRemoveEventImpl;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.CatalogLayerEventListener;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;

public class CatalogLayerEventListenerTest {
    private static final String NAMESPACE_PREFIX = "mock";
    private static final String RESOURCE_NAME = "Layer";
    private static final String PREFIXED_RESOURCE_NAME = "mock:Layer";
    private static final String LAYER_GROUP_NAME = "LayerGroupName";
    private GWC mockMediator;
    private LayerInfo mockLayerInfo;
    private FeatureTypeInfo mockResourceInfo;
    private NamespaceInfo mockNamespaceInfo;
    private LayerGroupInfo mockLayerGroupInfo;
    private CatalogLayerEventListener listener;
    private StyleInfo mockDefaultStyle;

    @Before
    public void setUp() throws Exception {
        GWCConfig configDefaults = GWCConfig.getOldDefaults();
        this.mockMediator = (GWC)Mockito.mock(GWC.class);
        Mockito.when((Object)this.mockMediator.getConfig()).thenReturn((Object)configDefaults);
        GridSetBroker gridsets = new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, true)));
        Mockito.when((Object)this.mockMediator.getGridSetBroker()).thenReturn((Object)gridsets);
        this.mockLayerInfo = (LayerInfo)Mockito.mock(LayerInfo.class);
        MetadataMap layerMetadata = new MetadataMap();
        Mockito.when((Object)this.mockLayerInfo.getMetadata()).thenReturn((Object)layerMetadata);
        this.mockLayerGroupInfo = (LayerGroupInfo)Mockito.mock(LayerGroupInfo.class);
        MetadataMap groupMetadata = new MetadataMap();
        Mockito.when((Object)this.mockLayerGroupInfo.getMetadata()).thenReturn((Object)groupMetadata);
        this.mockResourceInfo = (FeatureTypeInfo)Mockito.mock(FeatureTypeInfo.class);
        this.mockNamespaceInfo = (NamespaceInfo)Mockito.mock(NamespaceInfo.class);
        this.mockDefaultStyle = (StyleInfo)Mockito.mock(StyleInfo.class);
        Mockito.when((Object)this.mockDefaultStyle.prefixedName()).thenReturn((Object)"defaultStyle");
        Mockito.when((Object)this.mockLayerGroupInfo.getName()).thenReturn((Object)LAYER_GROUP_NAME);
        Mockito.when((Object)this.mockLayerGroupInfo.prefixedName()).thenReturn((Object)LAYER_GROUP_NAME);
        Mockito.when((Object)this.mockLayerGroupInfo.getLayers()).thenReturn(Arrays.asList(this.mockLayerInfo));
        Mockito.when((Object)this.mockLayerGroupInfo.getStyles()).thenReturn(Arrays.asList(new StyleInfo[]{null}));
        Mockito.when((Object)this.mockResourceInfo.prefixedName()).thenReturn((Object)PREFIXED_RESOURCE_NAME);
        Mockito.when((Object)this.mockResourceInfo.getName()).thenReturn((Object)RESOURCE_NAME);
        Mockito.when((Object)this.mockResourceInfo.getNamespace()).thenReturn((Object)this.mockNamespaceInfo);
        Mockito.when((Object)this.mockNamespaceInfo.getPrefix()).thenReturn((Object)NAMESPACE_PREFIX);
        Mockito.when((Object)this.mockLayerInfo.getResource()).thenReturn((Object)this.mockResourceInfo);
        Catalog mockCatalog = (Catalog)Mockito.mock(Catalog.class);
        Mockito.when((Object)mockCatalog.getLayerGroups()).thenReturn(Arrays.asList(this.mockLayerGroupInfo));
        Mockito.when((Object)this.mockLayerInfo.getDefaultStyle()).thenReturn((Object)this.mockDefaultStyle);
        this.listener = new CatalogLayerEventListener(this.mockMediator, mockCatalog);
    }

    @Test
    public void testLayerInfoAdded() throws Exception {
        CatalogAddEventImpl event = new CatalogAddEventImpl();
        event.setSource((CatalogInfo)this.mockLayerInfo);
        this.listener.handleAddEvent((CatalogAddEvent)event);
        ((GWC)Mockito.verify((Object)this.mockMediator)).add((GeoServerTileLayer)Mockito.any(GeoServerTileLayer.class));
    }

    @Test
    public void testLayerGroupInfoAdded() throws Exception {
        CatalogAddEventImpl event = new CatalogAddEventImpl();
        event.setSource((CatalogInfo)this.mockLayerGroupInfo);
        this.listener.handleAddEvent((CatalogAddEvent)event);
        ((GWC)Mockito.verify((Object)this.mockMediator)).add((GeoServerTileLayer)Mockito.any(GeoServerTileLayer.class));
    }

    @Test
    public void testLayerInfoRemoved() throws Exception {
        CatalogRemoveEventImpl event = new CatalogRemoveEventImpl();
        event.setSource((CatalogInfo)this.mockLayerInfo);
        Mockito.when((Object)this.mockMediator.hasTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockLayerInfo))).thenReturn((Object)true);
        this.listener.handleRemoveEvent((CatalogRemoveEvent)event);
        ((GWC)Mockito.verify((Object)this.mockMediator)).removeTileLayers((List)ArgumentMatchers.eq(Arrays.asList(this.mockResourceInfo.prefixedName())));
    }

    @Test
    public void testLayerGroupInfoRemoved() throws Exception {
        CatalogRemoveEventImpl event = new CatalogRemoveEventImpl();
        event.setSource((CatalogInfo)this.mockLayerGroupInfo);
        Mockito.when((Object)this.mockMediator.hasTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockLayerGroupInfo))).thenReturn((Object)true);
        this.listener.handleRemoveEvent((CatalogRemoveEvent)event);
        ((GWC)Mockito.verify((Object)this.mockMediator)).removeTileLayers((List)ArgumentMatchers.eq(Arrays.asList(GWC.tileLayerName((LayerGroupInfo)this.mockLayerGroupInfo))));
    }

    @Test
    public void testResourceInfoRenamed() throws Exception {
        String oldTileLayerName = this.mockResourceInfo.prefixedName();
        String renamedResouceName = "Layer_Renamed";
        String renamedPrefixedResouceName = "mock:Layer_Renamed";
        Mockito.when((Object)this.mockResourceInfo.getName()).thenReturn((Object)"Layer_Renamed");
        Mockito.when((Object)this.mockResourceInfo.prefixedName()).thenReturn((Object)"mock:Layer_Renamed");
        CatalogModifyEvent modifyEvent = (CatalogModifyEvent)Mockito.mock(CatalogModifyEvent.class);
        Mockito.when((Object)modifyEvent.getSource()).thenReturn((Object)this.mockResourceInfo);
        Mockito.when((Object)modifyEvent.getPropertyNames()).thenReturn(Arrays.asList("name"));
        Mockito.when((Object)modifyEvent.getOldValues()).thenReturn(Arrays.asList(RESOURCE_NAME));
        Mockito.when((Object)modifyEvent.getNewValues()).thenReturn(Arrays.asList("Layer_Renamed"));
        GeoServerTileLayerInfoImpl info = TileLayerInfoUtil.loadOrCreate((LayerInfo)this.mockLayerInfo, (GWCConfig)GWCConfig.getOldDefaults());
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)Mockito.mock(GeoServerTileLayer.class);
        Mockito.when((Object)this.mockMediator.hasTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockResourceInfo))).thenReturn((Object)true);
        Mockito.when((Object)tileLayer.getInfo()).thenReturn((Object)info);
        Mockito.when((Object)tileLayer.getPublishedInfo()).thenReturn((Object)this.mockLayerInfo);
        Mockito.when((Object)this.mockMediator.getTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockResourceInfo))).thenReturn((Object)tileLayer);
        Mockito.when((Object)this.mockMediator.getTileLayerByName((String)ArgumentMatchers.eq((Object)oldTileLayerName))).thenReturn((Object)tileLayer);
        this.listener.handleModifyEvent(modifyEvent);
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).hasTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockResourceInfo));
        CatalogPostModifyEvent postModifyEvent = (CatalogPostModifyEvent)Mockito.mock(CatalogPostModifyEvent.class);
        Mockito.when((Object)postModifyEvent.getSource()).thenReturn((Object)this.mockResourceInfo);
        this.listener.handlePostModifyEvent(postModifyEvent);
        ((GWC)Mockito.verify((Object)this.mockMediator)).rename(oldTileLayerName, "mock:Layer_Renamed");
        GeoServerTileLayer saved = this.mockMediator.getTileLayer((CatalogInfo)this.mockResourceInfo);
        Assert.assertNotNull((Object)saved);
        Assert.assertNotNull((Object)saved.getInfo());
        GeoServerTileLayerInfo savedInfo = saved.getInfo();
        Assert.assertSame((Object)info, (Object)savedInfo);
        Assert.assertEquals((Object)"mock:Layer_Renamed", (Object)savedInfo.getName());
    }

    @Test
    public void testCqlFilterChanged() throws Exception {
        String cqlFilter = "name LIKE 'Foo%'";
        Mockito.when((Object)this.mockResourceInfo.getCqlFilter()).thenReturn((Object)cqlFilter);
        CatalogModifyEvent modifyEvent = (CatalogModifyEvent)Mockito.mock(CatalogModifyEvent.class);
        Mockito.when((Object)modifyEvent.getSource()).thenReturn((Object)this.mockResourceInfo);
        Mockito.when((Object)modifyEvent.getPropertyNames()).thenReturn(Arrays.asList("cqlFilter"));
        Mockito.when((Object)modifyEvent.getOldValues()).thenReturn(Arrays.asList(new Object[]{null}));
        Mockito.when((Object)modifyEvent.getNewValues()).thenReturn(Arrays.asList(cqlFilter));
        GeoServerTileLayerInfoImpl info = TileLayerInfoUtil.loadOrCreate((LayerInfo)this.mockLayerInfo, (GWCConfig)GWCConfig.getOldDefaults());
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)Mockito.mock(GeoServerTileLayer.class);
        Mockito.when((Object)this.mockMediator.hasTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockResourceInfo))).thenReturn((Object)true);
        Mockito.when((Object)tileLayer.getInfo()).thenReturn((Object)info);
        Mockito.when((Object)tileLayer.getPublishedInfo()).thenReturn((Object)this.mockLayerInfo);
        Mockito.when((Object)this.mockMediator.getTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockResourceInfo))).thenReturn((Object)tileLayer);
        String resourceName = this.mockResourceInfo.prefixedName();
        Mockito.when((Object)this.mockMediator.getTileLayerByName((String)ArgumentMatchers.eq((Object)resourceName))).thenReturn((Object)tileLayer);
        this.listener.handleModifyEvent(modifyEvent);
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).hasTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockResourceInfo));
        CatalogPostModifyEvent postModifyEvent = (CatalogPostModifyEvent)Mockito.mock(CatalogPostModifyEvent.class);
        Mockito.when((Object)postModifyEvent.getSource()).thenReturn((Object)this.mockResourceInfo);
        this.listener.handlePostModifyEvent(postModifyEvent);
        ((GWC)Mockito.verify((Object)this.mockMediator)).truncate((String)ArgumentMatchers.eq((Object)resourceName));
    }

    @Test
    public void testLayerGroupInfoRenamed() throws Exception {
        String oldGroupName = LAYER_GROUP_NAME;
        String renamedGroupName = "LayerGroupName_Renamed";
        CatalogModifyEvent modifyEvent = (CatalogModifyEvent)Mockito.mock(CatalogModifyEvent.class);
        Mockito.when((Object)modifyEvent.getSource()).thenReturn((Object)this.mockLayerGroupInfo);
        Mockito.when((Object)modifyEvent.getPropertyNames()).thenReturn(Arrays.asList("name"));
        Mockito.when((Object)modifyEvent.getOldValues()).thenReturn(Arrays.asList(LAYER_GROUP_NAME));
        Mockito.when((Object)modifyEvent.getNewValues()).thenReturn(Arrays.asList("LayerGroupName_Renamed"));
        GeoServerTileLayerInfoImpl info = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)this.mockLayerGroupInfo, (GWCConfig)GWCConfig.getOldDefaults());
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)Mockito.mock(GeoServerTileLayer.class);
        Mockito.when((Object)tileLayer.getInfo()).thenReturn((Object)info);
        Mockito.when((Object)tileLayer.getPublishedInfo()).thenReturn((Object)this.mockLayerGroupInfo);
        Mockito.when((Object)this.mockMediator.hasTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockLayerGroupInfo))).thenReturn((Object)true);
        Mockito.when((Object)this.mockMediator.getTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockLayerGroupInfo))).thenReturn((Object)tileLayer);
        Mockito.when((Object)this.mockMediator.getTileLayerByName((String)ArgumentMatchers.eq((Object)LAYER_GROUP_NAME))).thenReturn((Object)tileLayer);
        Mockito.when((Object)GWC.tileLayerName((LayerGroupInfo)this.mockLayerGroupInfo)).thenReturn((Object)"LayerGroupName_Renamed");
        this.listener.handleModifyEvent(modifyEvent);
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).hasTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockLayerGroupInfo));
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).getTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockLayerGroupInfo));
        CatalogPostModifyEvent postModifyEvent = (CatalogPostModifyEvent)Mockito.mock(CatalogPostModifyEvent.class);
        Mockito.when((Object)postModifyEvent.getSource()).thenReturn((Object)this.mockLayerGroupInfo);
        this.listener.handlePostModifyEvent(postModifyEvent);
        ((GWC)Mockito.verify((Object)this.mockMediator)).rename(LAYER_GROUP_NAME, "LayerGroupName_Renamed");
        GeoServerTileLayer saved = this.mockMediator.getTileLayer((CatalogInfo)this.mockLayerGroupInfo);
        Assert.assertNotNull((Object)saved);
        Assert.assertNotNull((Object)saved.getInfo());
        GeoServerTileLayerInfo savedInfo = saved.getInfo();
        Assert.assertSame((Object)info, (Object)savedInfo);
        Assert.assertEquals((Object)"LayerGroupName_Renamed", (Object)savedInfo.getName());
    }

    @Test
    public void testLayerGroupInfoRenamedDueToWorkspaceChanged() throws Exception {
        WorkspaceInfo workspace = (WorkspaceInfo)Mockito.mock(WorkspaceInfo.class);
        Mockito.when((Object)workspace.getName()).thenReturn((Object)"mockWs");
        CatalogModifyEvent modifyEvent = (CatalogModifyEvent)Mockito.mock(CatalogModifyEvent.class);
        Mockito.when((Object)modifyEvent.getSource()).thenReturn((Object)this.mockLayerGroupInfo);
        Mockito.when((Object)modifyEvent.getPropertyNames()).thenReturn(Arrays.asList("workspace"));
        Mockito.when((Object)modifyEvent.getOldValues()).thenReturn(Arrays.asList(new Object[]{null}));
        Mockito.when((Object)modifyEvent.getNewValues()).thenReturn(Arrays.asList(workspace));
        GeoServerTileLayerInfoImpl info = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)this.mockLayerGroupInfo, (GWCConfig)GWCConfig.getOldDefaults());
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)Mockito.mock(GeoServerTileLayer.class);
        Mockito.when((Object)tileLayer.getInfo()).thenReturn((Object)info);
        Mockito.when((Object)tileLayer.getPublishedInfo()).thenReturn((Object)this.mockLayerGroupInfo);
        Mockito.when((Object)this.mockMediator.hasTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockLayerGroupInfo))).thenReturn((Object)true);
        Mockito.when((Object)this.mockMediator.getTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockLayerGroupInfo))).thenReturn((Object)tileLayer);
        String oldLayerName = GWC.tileLayerName((LayerGroupInfo)this.mockLayerGroupInfo);
        Mockito.when((Object)this.mockMediator.getTileLayerByName((String)ArgumentMatchers.eq((Object)oldLayerName))).thenReturn((Object)tileLayer);
        this.listener.handleModifyEvent(modifyEvent);
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).hasTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockLayerGroupInfo));
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).getTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockLayerGroupInfo));
        CatalogPostModifyEvent postModifyEvent = (CatalogPostModifyEvent)Mockito.mock(CatalogPostModifyEvent.class);
        Mockito.when((Object)postModifyEvent.getSource()).thenReturn((Object)this.mockLayerGroupInfo);
        Mockito.when((Object)this.mockLayerGroupInfo.getWorkspace()).thenReturn((Object)workspace);
        String prefixedName = workspace.getName() + ":" + this.mockLayerGroupInfo.getName();
        Mockito.when((Object)this.mockLayerGroupInfo.prefixedName()).thenReturn((Object)prefixedName);
        this.listener.handlePostModifyEvent(postModifyEvent);
        ((GWC)Mockito.verify((Object)this.mockMediator)).rename(oldLayerName, prefixedName);
        GeoServerTileLayer saved = this.mockMediator.getTileLayer((CatalogInfo)this.mockLayerGroupInfo);
        Assert.assertNotNull((Object)saved);
        Assert.assertNotNull((Object)saved.getInfo());
        GeoServerTileLayerInfo savedInfo = saved.getInfo();
        Assert.assertSame((Object)info, (Object)savedInfo);
        String tileLayerName = GWC.tileLayerName((LayerGroupInfo)this.mockLayerGroupInfo);
        String actual = savedInfo.getName();
        Assert.assertEquals((Object)tileLayerName, (Object)actual);
    }

    @Test
    public void testResourceInfoNamespaceChanged() throws Exception {
        NamespaceInfo newNamespace = (NamespaceInfo)Mockito.mock(NamespaceInfo.class);
        Mockito.when((Object)newNamespace.getPrefix()).thenReturn((Object)"newMock");
        String oldPrefixedName = this.mockResourceInfo.prefixedName();
        String newPrefixedName = newNamespace.getPrefix() + ":" + this.mockResourceInfo.getName();
        Mockito.when((Object)this.mockResourceInfo.getNamespace()).thenReturn((Object)newNamespace);
        Mockito.when((Object)this.mockResourceInfo.prefixedName()).thenReturn((Object)newPrefixedName);
        CatalogModifyEvent modifyEvent = (CatalogModifyEvent)Mockito.mock(CatalogModifyEvent.class);
        Mockito.when((Object)modifyEvent.getSource()).thenReturn((Object)this.mockResourceInfo);
        Mockito.when((Object)modifyEvent.getPropertyNames()).thenReturn(Arrays.asList("namespace"));
        Mockito.when((Object)modifyEvent.getOldValues()).thenReturn(Arrays.asList(this.mockNamespaceInfo));
        Mockito.when((Object)modifyEvent.getNewValues()).thenReturn(Arrays.asList(newNamespace));
        GeoServerTileLayerInfoImpl info = TileLayerInfoUtil.loadOrCreate((LayerInfo)this.mockLayerInfo, (GWCConfig)GWCConfig.getOldDefaults());
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)Mockito.mock(GeoServerTileLayer.class);
        Mockito.when((Object)tileLayer.getInfo()).thenReturn((Object)info);
        Mockito.when((Object)tileLayer.getPublishedInfo()).thenReturn((Object)this.mockLayerInfo);
        Mockito.when((Object)this.mockMediator.hasTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockResourceInfo))).thenReturn((Object)true);
        Mockito.when((Object)this.mockMediator.getTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockResourceInfo))).thenReturn((Object)tileLayer);
        Mockito.when((Object)this.mockMediator.getTileLayerByName((String)ArgumentMatchers.eq((Object)oldPrefixedName))).thenReturn((Object)tileLayer);
        this.listener.handleModifyEvent(modifyEvent);
        CatalogPostModifyEvent postModifyEvent = (CatalogPostModifyEvent)Mockito.mock(CatalogPostModifyEvent.class);
        Mockito.when((Object)postModifyEvent.getSource()).thenReturn((Object)this.mockResourceInfo);
        this.listener.handlePostModifyEvent(postModifyEvent);
        ((GWC)Mockito.verify((Object)this.mockMediator)).rename(oldPrefixedName, newPrefixedName);
        GeoServerTileLayer saved = this.mockMediator.getTileLayer((CatalogInfo)this.mockResourceInfo);
        Assert.assertNotNull((Object)saved);
        Assert.assertNotNull((Object)saved.getInfo());
        GeoServerTileLayerInfo savedInfo = saved.getInfo();
        Assert.assertSame((Object)info, (Object)savedInfo);
        Assert.assertEquals((Object)newPrefixedName, (Object)savedInfo.getName());
    }

    @Test
    public void testLayerGroupInfoLayersChanged() throws Exception {
        CatalogModifyEvent modifyEvent = (CatalogModifyEvent)Mockito.mock(CatalogModifyEvent.class);
        Mockito.when((Object)modifyEvent.getSource()).thenReturn((Object)this.mockLayerGroupInfo);
        Mockito.when((Object)modifyEvent.getPropertyNames()).thenReturn(Arrays.asList("layers"));
        List oldLayers = Collections.emptyList();
        List<LayerInfo> newLayers = Collections.singletonList(this.mockLayerInfo);
        Mockito.when((Object)modifyEvent.getOldValues()).thenReturn(Collections.singletonList(oldLayers));
        Mockito.when((Object)modifyEvent.getNewValues()).thenReturn(Collections.singletonList(newLayers));
        GeoServerTileLayerInfoImpl tileLayerInfo = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)this.mockLayerGroupInfo, (GWCConfig)this.mockMediator.getConfig());
        GridSetBroker gridsets = new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, true)));
        GeoServerTileLayer tileLayer = new GeoServerTileLayer((PublishedInfo)this.mockLayerGroupInfo, gridsets, (GeoServerTileLayerInfo)tileLayerInfo);
        Mockito.when((Object)this.mockMediator.hasTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockLayerGroupInfo))).thenReturn((Object)true);
        Mockito.when((Object)this.mockMediator.getTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockLayerGroupInfo))).thenReturn((Object)tileLayer);
        this.listener.handleModifyEvent(modifyEvent);
        CatalogPostModifyEvent postModifyEvent = (CatalogPostModifyEvent)Mockito.mock(CatalogPostModifyEvent.class);
        Mockito.when((Object)postModifyEvent.getSource()).thenReturn((Object)this.mockLayerGroupInfo);
        this.listener.handlePostModifyEvent(postModifyEvent);
        ((GWC)Mockito.verify((Object)this.mockMediator)).truncate((String)ArgumentMatchers.eq((Object)LAYER_GROUP_NAME));
    }

    @Test
    public void testLayerGroupInfoStylesChanged() throws Exception {
        CatalogModifyEvent modifyEvent = (CatalogModifyEvent)Mockito.mock(CatalogModifyEvent.class);
        Mockito.when((Object)modifyEvent.getSource()).thenReturn((Object)this.mockLayerGroupInfo);
        Mockito.when((Object)modifyEvent.getPropertyNames()).thenReturn(Arrays.asList("styles"));
        List oldStyles = Collections.emptyList();
        StyleInfo newStyle = (StyleInfo)Mockito.mock(StyleInfo.class);
        List<StyleInfo> newStyles = Collections.singletonList(newStyle);
        Mockito.when((Object)modifyEvent.getOldValues()).thenReturn(Collections.singletonList(oldStyles));
        Mockito.when((Object)modifyEvent.getNewValues()).thenReturn(Collections.singletonList(newStyles));
        GeoServerTileLayerInfoImpl info = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)this.mockLayerGroupInfo, (GWCConfig)GWCConfig.getOldDefaults());
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)Mockito.mock(GeoServerTileLayer.class);
        Mockito.when((Object)tileLayer.getInfo()).thenReturn((Object)info);
        Mockito.when((Object)this.mockMediator.hasTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockLayerGroupInfo))).thenReturn((Object)true);
        Mockito.when((Object)this.mockMediator.getTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockLayerGroupInfo))).thenReturn((Object)tileLayer);
        this.listener.handleModifyEvent(modifyEvent);
        CatalogPostModifyEvent postModifyEvent = (CatalogPostModifyEvent)Mockito.mock(CatalogPostModifyEvent.class);
        Mockito.when((Object)postModifyEvent.getSource()).thenReturn((Object)this.mockLayerGroupInfo);
        this.listener.handlePostModifyEvent(postModifyEvent);
        ((GWC)Mockito.verify((Object)this.mockMediator)).truncate((String)ArgumentMatchers.eq((Object)LAYER_GROUP_NAME));
    }

    @Test
    public void testLayerInfoDefaultStyleChanged() throws Exception {
        String oldName = "oldStyle";
        String newName = "newStyle";
        StyleInfo oldStyle = (StyleInfo)Mockito.mock(StyleInfo.class);
        Mockito.when((Object)oldStyle.prefixedName()).thenReturn((Object)"oldStyle");
        StyleInfo newStyle = (StyleInfo)Mockito.mock(StyleInfo.class);
        Mockito.when((Object)newStyle.prefixedName()).thenReturn((Object)"newStyle");
        Mockito.when((Object)this.mockLayerInfo.getDefaultStyle()).thenReturn((Object)newStyle);
        CatalogModifyEvent modifyEvent = (CatalogModifyEvent)Mockito.mock(CatalogModifyEvent.class);
        Mockito.when((Object)modifyEvent.getSource()).thenReturn((Object)this.mockLayerInfo);
        Mockito.when((Object)modifyEvent.getPropertyNames()).thenReturn(Arrays.asList("defaultStyle"));
        Mockito.when((Object)modifyEvent.getOldValues()).thenReturn(Collections.singletonList(oldStyle));
        Mockito.when((Object)modifyEvent.getNewValues()).thenReturn(Collections.singletonList(newStyle));
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)Mockito.mock(GeoServerTileLayer.class);
        Mockito.when((Object)this.mockMediator.getTileLayerByName((String)ArgumentMatchers.eq((Object)PREFIXED_RESOURCE_NAME))).thenReturn((Object)tileLayer);
        GeoServerTileLayer lgTileLayer = (GeoServerTileLayer)Mockito.mock(GeoServerTileLayer.class);
        Mockito.when((Object)this.mockMediator.getTileLayer((CatalogInfo)this.mockLayerGroupInfo)).thenReturn((Object)lgTileLayer);
        GeoServerTileLayerInfoImpl info = TileLayerInfoUtil.loadOrCreate((LayerInfo)this.mockLayerInfo, (GWCConfig)GWCConfig.getOldDefaults());
        Mockito.when((Object)tileLayer.getInfo()).thenReturn((Object)info);
        GeoServerTileLayerInfoImpl groupInfo = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)this.mockLayerGroupInfo, (GWCConfig)GWCConfig.getOldDefaults());
        Mockito.when((Object)lgTileLayer.getInfo()).thenReturn((Object)groupInfo);
        Mockito.when((Object)this.mockMediator.hasTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockLayerInfo))).thenReturn((Object)true);
        Mockito.when((Object)this.mockMediator.getTileLayer((CatalogInfo)ArgumentMatchers.same((Object)this.mockLayerInfo))).thenReturn((Object)tileLayer);
        this.listener.handleModifyEvent(modifyEvent);
        CatalogPostModifyEvent postModifyEvent = (CatalogPostModifyEvent)Mockito.mock(CatalogPostModifyEvent.class);
        Mockito.when((Object)postModifyEvent.getSource()).thenReturn((Object)this.mockLayerInfo);
        this.listener.handlePostModifyEvent(postModifyEvent);
        ((GWC)Mockito.verify((Object)this.mockMediator)).truncateByLayerDefaultStyle((String)ArgumentMatchers.eq((Object)PREFIXED_RESOURCE_NAME));
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)2))).save((TileLayer)ArgumentMatchers.any(GeoServerTileLayer.class));
        ((GWC)Mockito.verify((Object)this.mockMediator)).truncate(LAYER_GROUP_NAME);
    }

    @Test
    public void testLayerInfoAlternateStylesChanged() throws Exception {
        StyleInfo removedStyle = (StyleInfo)Mockito.mock(StyleInfo.class);
        Mockito.when((Object)removedStyle.prefixedName()).thenReturn((Object)"removedStyleName");
        StyleInfo remainingStyle = (StyleInfo)Mockito.mock(StyleInfo.class);
        Mockito.when((Object)remainingStyle.prefixedName()).thenReturn((Object)"remainingStyle");
        HashSet<StyleInfo> oldStyles = new HashSet<StyleInfo>(Arrays.asList(remainingStyle, removedStyle));
        Mockito.when((Object)this.mockLayerInfo.getStyles()).thenReturn(oldStyles);
        StyleInfo addedStyle = (StyleInfo)Mockito.mock(StyleInfo.class);
        Mockito.when((Object)addedStyle.prefixedName()).thenReturn((Object)"addedStyleName");
        HashSet<StyleInfo> newStyles = new HashSet<StyleInfo>(Arrays.asList(addedStyle, remainingStyle));
        CatalogModifyEvent modifyEvent = (CatalogModifyEvent)Mockito.mock(CatalogModifyEvent.class);
        Mockito.when((Object)modifyEvent.getSource()).thenReturn((Object)this.mockLayerInfo);
        Mockito.when((Object)modifyEvent.getPropertyNames()).thenReturn(Arrays.asList("styles"));
        Mockito.when((Object)modifyEvent.getOldValues()).thenReturn(Collections.singletonList(oldStyles));
        Mockito.when((Object)modifyEvent.getNewValues()).thenReturn(Collections.singletonList(newStyles));
        GeoServerTileLayerInfo info = (GeoServerTileLayerInfo)Mockito.mock(GeoServerTileLayerInfo.class);
        Mockito.when((Object)info.cachedStyles()).thenReturn((Object)ImmutableSet.of((Object)"remainingStyle", (Object)"removedStyleName"));
        Mockito.when((Object)info.isAutoCacheStyles()).thenReturn((Object)true);
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)Mockito.mock(GeoServerTileLayer.class);
        Mockito.when((Object)tileLayer.getInfo()).thenReturn((Object)info);
        Mockito.when((Object)this.mockMediator.hasTileLayer((CatalogInfo)ArgumentMatchers.any(CatalogInfo.class))).thenReturn((Object)true);
        Mockito.when((Object)this.mockMediator.getTileLayer((CatalogInfo)ArgumentMatchers.any(CatalogInfo.class))).thenReturn((Object)tileLayer);
        this.listener.handleModifyEvent(modifyEvent);
        CatalogPostModifyEvent postModifyEvent = (CatalogPostModifyEvent)Mockito.mock(CatalogPostModifyEvent.class);
        Mockito.when((Object)this.mockLayerInfo.getStyles()).thenReturn(newStyles);
        Mockito.when((Object)postModifyEvent.getSource()).thenReturn((Object)this.mockLayerInfo);
        this.listener.handlePostModifyEvent(postModifyEvent);
        ((GWC)Mockito.verify((Object)this.mockMediator)).truncateByLayerAndStyle((String)ArgumentMatchers.eq((Object)PREFIXED_RESOURCE_NAME), (String)ArgumentMatchers.eq((Object)"removedStyleName"));
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.atMost((int)1))).truncateByLayerAndStyle(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        ((GWC)Mockito.verify((Object)this.mockMediator)).save((TileLayer)MockitoHamcrest.argThat((Matcher)new BaseMatcher<GeoServerTileLayer>(){

            public boolean matches(Object item) {
                GeoServerTileLayer tl = (GeoServerTileLayer)item;
                return tl.getPublishedInfo() == CatalogLayerEventListenerTest.this.mockLayerInfo;
            }

            public void describeTo(Description description) {
            }
        }));
    }
}

