/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.gwc.JDBCPasswordEncryptionHelper;
import org.geoserver.gwc.config.GeoserverXMLResourceProvider;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceStore;
import org.geoserver.platform.resource.Resources;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.SecurityManagerListener;
import org.geotools.util.logging.Logging;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.diskquota.jdbc.JDBCConfiguration;
import org.geowebcache.diskquota.jdbc.JDBCQuotaStoreFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

class JDBCConfigurationStorage
implements ApplicationContextAware,
SecurityManagerListener {
    static final Logger LOGGER = Logging.getLogger(JDBCConfigurationStorage.class);
    private JDBCPasswordEncryptionHelper passwordHelper;
    private ApplicationContext applicationContext;
    private Resource configDir;

    public JDBCConfigurationStorage(ResourceStore store, GeoServerSecurityManager securityManager) {
        GeoserverXMLResourceProvider configProvider = (GeoserverXMLResourceProvider)GeoServerExtensions.bean((String)"jdbcDiskQuotaConfigResourceProvider");
        this.configDir = configProvider.getConfigDirectory();
        this.passwordHelper = new JDBCPasswordEncryptionHelper(securityManager);
        securityManager.addListener((SecurityManagerListener)this);
    }

    public synchronized void saveDiskQuotaConfig(DiskQuotaConfig config, JDBCConfiguration jdbcConfig) throws ConfigurationException, IOException, InterruptedException {
        Resource configFile = this.configDir.get("geowebcache-diskquota-jdbc.xml");
        if ("JDBC".equals(config.getQuotaStore())) {
            JDBCConfiguration.validateConfiguration((JDBCConfiguration)jdbcConfig);
            JDBCConfiguration encrypted = this.passwordHelper.encryptPassword(jdbcConfig);
            try (OutputStream os = configFile.out();){
                JDBCConfiguration.store((JDBCConfiguration)encrypted, (OutputStream)os);
            }
        } else if (Resources.exists((Resource)configFile) && !configFile.delete()) {
            LOGGER.log(Level.SEVERE, "Failed to delete " + configFile + ", this might cause misbehavior on GeoServer restart");
        }
    }

    public synchronized JDBCConfiguration getJDBCDiskQuotaConfig() throws IOException, ConfigurationException {
        Resource configFile = this.configDir.get("geowebcache-diskquota-jdbc.xml");
        if (!Resources.exists((Resource)configFile)) {
            return null;
        }
        try {
            JDBCConfiguration configuration;
            try (InputStream is = configFile.in();){
                configuration = JDBCConfiguration.load((InputStream)is);
            }
            return this.passwordHelper.unencryptPassword(configuration);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to load geowebcache-diskquota-jdbc.xml", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQuotaConfiguration(JDBCConfiguration jdbcConfiguration) throws ConfigurationException, IOException {
        JDBCConfiguration.validateConfiguration((JDBCConfiguration)jdbcConfiguration);
        JDBCQuotaStoreFactory factory = (JDBCQuotaStoreFactory)GeoServerExtensions.bean(JDBCQuotaStoreFactory.class);
        QuotaStore qs = null;
        try {
            qs = factory.getJDBCStore(this.applicationContext, jdbcConfiguration);
        }
        finally {
            if (qs != null) {
                try {
                    qs.close();
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Failed to dispose test quota store", e);
                }
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void handlePostChanged(GeoServerSecurityManager securityManager) {
        block17: {
            try {
                JDBCConfiguration c1;
                JDBCConfiguration config = this.getJDBCDiskQuotaConfig();
                if (config == null) break block17;
                Resource configFile = this.configDir.get("geowebcache-diskquota-jdbc.xml");
                if (!Resources.exists((Resource)configFile)) {
                    return;
                }
                try (InputStream is = configFile.in();){
                    c1 = JDBCConfiguration.load((InputStream)is);
                }
                if (c1 == null || c1.getConnectionPool() == null) {
                    return;
                }
                String originalEncrypted = c1.getConnectionPool().getPassword();
                if (originalEncrypted == null) {
                    return;
                }
                JDBCConfiguration c2 = this.passwordHelper.unencryptPassword(c1);
                JDBCConfiguration c3 = this.passwordHelper.encryptPassword(c2);
                String newEncrypted = c3.getConnectionPool().getPassword();
                if (originalEncrypted.equals(newEncrypted)) break block17;
                try (OutputStream os = configFile.out();){
                    JDBCConfiguration.store((JDBCConfiguration)c3, (OutputStream)os);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "", e);
            }
        }
    }
}

