/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.awt.Dimension;
import java.io.IOException;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.config.GeoServer;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.dispatch.GwcServiceDispatcherCallback;
import org.geoserver.gwc.layer.CatalogConfiguration;
import org.geoserver.gwc.layer.DynamicGridSubset;
import org.geoserver.gwc.layer.GeoServerMetaTile;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.ows.Request;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.RequestInfo;
import org.geoserver.util.DimensionWarning;
import org.geoserver.util.HTTPWarningAppender;
import org.geoserver.wms.RasterCleaner;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.capabilities.CapabilityUtil;
import org.geoserver.wms.capabilities.LegendSample;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.config.legends.LegendInfo;
import org.geowebcache.config.legends.LegendInfoBuilder;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.parameters.ParameterException;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.grid.SRS;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.ExpirationRule;
import org.geowebcache.layer.LayerListenerList;
import org.geowebcache.layer.MetaTile;
import org.geowebcache.layer.ProxyLayer;
import org.geowebcache.layer.TileJSONProvider;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerListener;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.layer.meta.MetadataURL;
import org.geowebcache.layer.meta.TileJSON;
import org.geowebcache.layer.meta.VectorLayerMetadata;
import org.geowebcache.layer.updatesource.UpdateSourceDefinition;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.mime.FormatModifier;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.TileObject;
import org.geowebcache.util.ServletUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class GeoServerTileLayer
extends TileLayer
implements ProxyLayer,
TileJSONProvider {
    private static final Logger LOGGER = Logging.getLogger(GeoServerTileLayer.class);
    public static final int ENV_TX_POINTS = Integer.parseInt(System.getProperty("GWC_ENVELOPE_TX_POINTS", "5"));
    private final GeoServerTileLayerInfo info;
    public static final String GWC_SEED_INTERCEPT_TOKEN = "GWC_SEED_INTERCEPT";
    public static final ThreadLocal<WebMap> WEB_MAP = new ThreadLocal();
    public static final ThreadLocal<Set<DimensionWarning>> DIMENSION_WARNINGS = new ThreadLocal();
    private String configErrorMessage;
    private final AtomicReference<Map<String, GridSubset>> _subSets;
    private static LayerListenerList listeners = new LayerListenerList();
    private final GridSetBroker gridSetBroker;
    private Catalog catalog;
    private final String publishedInfoId;
    private final AtomicReference<PublishedInfo> _publishedInfo;
    private LegendSample legendSample;
    private WMS wms;

    public GeoServerTileLayer(PublishedInfo publishedInfo, GWCConfig configDefaults, GridSetBroker gridsets) {
        Preconditions.checkNotNull((Object)publishedInfo, (Object)"publishedInfo");
        Preconditions.checkNotNull((Object)gridsets, (Object)"gridsets");
        Preconditions.checkNotNull((Object)configDefaults, (Object)"configDefaults");
        this.gridSetBroker = gridsets;
        this._publishedInfo = new AtomicReference<PublishedInfo>(publishedInfo);
        this.publishedInfoId = publishedInfo.getId();
        this.info = TileLayerInfoUtil.loadOrCreate((CatalogInfo)this.getPublishedInfo(), configDefaults);
        this._subSets = new AtomicReference();
    }

    public GeoServerTileLayer(PublishedInfo publishedInfo, GridSetBroker gridsets, GeoServerTileLayerInfo state) {
        Preconditions.checkNotNull((Object)publishedInfo, (Object)"publishedInfo");
        Preconditions.checkNotNull((Object)gridsets, (Object)"gridsets");
        Preconditions.checkNotNull((Object)state, (Object)"state");
        this.gridSetBroker = gridsets;
        this._publishedInfo = new AtomicReference<PublishedInfo>(publishedInfo);
        this.publishedInfoId = publishedInfo.getId();
        this.info = state;
        this._subSets = new AtomicReference();
        TileLayerInfoUtil.checkAutomaticStyles(publishedInfo, state);
    }

    public GeoServerTileLayer(Catalog catalog, String publishedId, GridSetBroker gridsetBroker, GeoServerTileLayerInfo state) {
        Preconditions.checkNotNull((Object)catalog, (Object)"catalog");
        Preconditions.checkNotNull((Object)publishedId, (Object)"publishedId");
        Preconditions.checkNotNull((Object)gridsetBroker, (Object)"gridsets");
        Preconditions.checkNotNull((Object)state, (Object)"state");
        this.gridSetBroker = gridsetBroker;
        this.catalog = catalog;
        this.publishedInfoId = publishedId;
        this._publishedInfo = new AtomicReference();
        this.info = state;
        this._subSets = new AtomicReference();
    }

    protected GeoServerTileLayer(GeoServerTileLayer layer) {
        this.gridSetBroker = layer.gridSetBroker;
        this.catalog = layer.catalog;
        this.publishedInfoId = layer.publishedInfoId;
        this._publishedInfo = new AtomicReference();
        this.info = layer.info;
        this._subSets = new AtomicReference();
        this.legendSample = layer.legendSample;
        this.wms = layer.wms;
    }

    public String getId() {
        return this.info.getId();
    }

    public String getBlobStoreId() {
        return this.info.getBlobStoreId();
    }

    public String getName() {
        String gwcOperation = GwcServiceDispatcherCallback.GWC_OPERATION.get();
        if (gwcOperation != null && gwcOperation.equalsIgnoreCase("GetCapabilities")) {
            return this.getContextualName();
        }
        return this.info.getName();
    }

    public String getContextualName() {
        WorkspaceInfo localWorkspace = LocalWorkspace.get();
        if (localWorkspace != null) {
            return CatalogConfiguration.removeWorkspacePrefix(this.info.getName(), this.catalog);
        }
        return this.info.getName();
    }

    void setConfigErrorMessage(String configErrorMessage) {
        this.configErrorMessage = configErrorMessage;
    }

    public String getConfigErrorMessage() {
        return this.configErrorMessage;
    }

    public List<ParameterFilter> getParameterFilters() {
        return new ArrayList<ParameterFilter>(this.info.getParameterFilters());
    }

    public void resetParameterFilters() {
        this.defaultParameterFilterValues = null;
    }

    public boolean isEnabled() {
        boolean tileLayerInfoEnabled = this.info.isEnabled();
        if (!tileLayerInfoEnabled) {
            return false;
        }
        if (this.getConfigErrorMessage() != null) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Layer " + this.getName() + "is not enabled due to config error: " + this.getConfigErrorMessage());
            }
            return false;
        }
        PublishedInfo published = this.getPublishedInfo();
        boolean geoserverLayerEnabled = published instanceof LayerInfo ? ((LayerInfo)published).enabled() : true;
        return tileLayerInfoEnabled && geoserverLayerEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.info.setEnabled(enabled);
    }

    public boolean isQueryable() {
        boolean queryable = GWC.get().isQueryable(this);
        return queryable;
    }

    public PublishedInfo getPublishedInfo() {
        PublishedInfo publishedInfo = this._publishedInfo.get();
        while (publishedInfo == null) {
            LayerInfo catalogLayer = this.catalog.getLayer(this.publishedInfoId);
            if (catalogLayer == null) {
                catalogLayer = this.catalog.getLayerGroup(this.publishedInfoId);
            }
            if (catalogLayer == null) {
                throw new IllegalStateException("Could not locate a layer or layer group with id " + this.publishedInfoId + " within GeoServer configuration, the GWC configuration seems to be out of synch");
            }
            TileLayerInfoUtil.checkAutomaticStyles((PublishedInfo)catalogLayer, this.info);
            this._publishedInfo.compareAndSet(null, (PublishedInfo)catalogLayer);
            publishedInfo = this._publishedInfo.get();
        }
        return publishedInfo;
    }

    private ResourceInfo getResourceInfo() {
        PublishedInfo publishedInfo = this.getPublishedInfo();
        return publishedInfo instanceof LayerInfo ? ((LayerInfo)publishedInfo).getResource() : null;
    }

    public LayerMetaInformation getMetaInformation() {
        ResourceInfo resourceInfo;
        String title = this.getName();
        String description = "";
        List keywords = Collections.emptyList();
        List contacts = Collections.emptyList();
        PublishedInfo publishedInfo = this.getPublishedInfo();
        ResourceInfo resourceInfo2 = resourceInfo = publishedInfo instanceof LayerInfo ? ((LayerInfo)publishedInfo).getResource() : null;
        if (resourceInfo != null) {
            title = resourceInfo.getTitle();
            description = resourceInfo.getAbstract();
            keywords = new ArrayList();
            for (KeywordInfo kw : resourceInfo.getKeywords()) {
                keywords.add(kw.getValue());
            }
        } else if (publishedInfo instanceof LayerGroupInfo) {
            LayerGroupInfo lg = (LayerGroupInfo)publishedInfo;
            if (lg.getTitle() != null) {
                title = lg.getTitle();
            }
            if (lg.getAbstract() != null) {
                description = lg.getAbstract();
            }
        }
        LayerMetaInformation meta = new LayerMetaInformation(title, description, keywords, contacts);
        return meta;
    }

    public String getStyles() {
        PublishedInfo published = this.getPublishedInfo();
        if (!(published instanceof LayerInfo)) {
            return null;
        }
        LayerInfo layerInfo = (LayerInfo)published;
        StyleInfo defaultStyle = layerInfo.getDefaultStyle();
        if (defaultStyle == null) {
            this.setConfigErrorMessage("Underlying GeoSever Layer has no default style");
            return null;
        }
        return defaultStyle.prefixedName();
    }

    public Resource getFeatureInfo(ConveyorTile convTile, BoundingBox bbox, int height, int width, int x, int y) throws GeoWebCacheException {
        Resource response;
        Map<String, String> params = this.buildGetFeatureInfo(convTile, bbox, height, width, x, y);
        try {
            response = GWC.get().dispatchOwsRequest(params, null);
        }
        catch (Exception e) {
            throw new GeoWebCacheException((Throwable)e);
        }
        return response;
    }

    private Map<String, String> buildGetFeatureInfo(ConveyorTile convTile, BoundingBox bbox, int height, int width, int x, int y) {
        Map fullParameters;
        HashMap<String, String> wmsParams = new HashMap<String, String>();
        wmsParams.put("SERVICE", "WMS");
        wmsParams.put("VERSION", "1.1.1");
        wmsParams.put("REQUEST", "GetFeatureInfo");
        wmsParams.put("LAYERS", this.getName());
        wmsParams.put("STYLES", "");
        wmsParams.put("QUERY_LAYERS", this.getName());
        MimeType mimeType = convTile.getMimeType();
        if (mimeType == null) {
            mimeType = this.getMimeTypes().get(0);
        }
        wmsParams.put("FORMAT", mimeType.getFormat());
        wmsParams.put("EXCEPTIONS", "SE_XML");
        wmsParams.put("INFO_FORMAT", convTile.getMimeType().getFormat());
        GridSubset gridSubset = convTile.getGridSubset();
        wmsParams.put("SRS", gridSubset.getSRS().toString());
        wmsParams.put("HEIGHT", String.valueOf(height));
        wmsParams.put("WIDTH", String.valueOf(width));
        wmsParams.put("BBOX", bbox.toString());
        wmsParams.put("X", String.valueOf(x));
        wmsParams.put("Y", String.valueOf(y));
        Map values = ServletUtils.selectedStringsFromMap((Map)convTile.servletReq.getParameterMap(), (String)convTile.servletReq.getCharacterEncoding(), (String[])new String[]{"feature_count"});
        String featureCount = (String)values.get("feature_count");
        if (featureCount != null) {
            wmsParams.put("FEATURE_COUNT", featureCount);
        }
        if ((fullParameters = convTile.getFilteringParameters()).isEmpty()) {
            fullParameters = this.getDefaultParameterFilters();
        }
        wmsParams.putAll(fullParameters);
        return wmsParams;
    }

    public ConveyorTile getTile(ConveyorTile tile) throws GeoWebCacheException, IOException, OutsideCoverageException {
        int metaY;
        int metaX;
        MimeType mime = tile.getMimeType();
        List<MimeType> formats = this.getMimeTypes();
        if (mime == null) {
            mime = formats.get(0);
        } else if (!formats.contains(mime)) {
            throw new IllegalArgumentException(mime.getFormat() + " is not a supported format for " + this.getName());
        }
        String tileGridSetId = tile.getGridSetId();
        GridSubset gridSubset = this.getGridSubset(tileGridSetId);
        if (gridSubset == null) {
            throw new IllegalArgumentException("Requested gridset not found: " + tileGridSetId);
        }
        long[] gridLoc = tile.getTileIndex();
        Preconditions.checkNotNull((Object)gridLoc);
        gridSubset.checkCoverage(gridLoc);
        if (mime.supportsTiling()) {
            metaX = this.info.getMetaTilingX();
            metaY = this.info.getMetaTilingY();
        } else {
            metaY = 1;
            metaX = 1;
        }
        ConveyorTile returnTile = this.getMetatilingResponse(tile, true, metaX, metaY);
        this.sendTileRequestedEvent(returnTile);
        return returnTile;
    }

    public void addLayerListener(TileLayerListener listener) {
        listeners.addListener(listener);
    }

    public boolean removeLayerListener(TileLayerListener listener) {
        listeners.removeListener(listener);
        return true;
    }

    protected final void sendTileRequestedEvent(ConveyorTile tile) {
        if (listeners != null) {
            listeners.sendTileRequested((TileLayer)this, tile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConveyorTile getMetatilingResponse(ConveyorTile conveyorTile, boolean tryCache, int metaX, int metaY) throws GeoWebCacheException, IOException {
        block14: {
            if (tryCache && this.tryCacheFetch(conveyorTile)) {
                return this.finalizeTile(conveyorTile);
            }
            GeoServerMetaTile metaTile = this.createMetaTile(conveyorTile, metaX, metaY);
            Executor executor = GWC.get().getMetaTilingExecutor();
            if (Dispatcher.REQUEST.get() == null) {
                executor = null;
            }
            LockProvider.Lock metaTileLock = this.getLock(this.buildMetaTileLockKey(conveyorTile, metaTile));
            try {
                boolean foundInCache = false;
                if (tryCache) {
                    if (executor == null) {
                        foundInCache = this.fetchPrimaryTile(conveyorTile, metaTile);
                    } else {
                        String lockKey = this.buildTileLockKey(conveyorTile, conveyorTile.getTileIndex());
                        LockProvider.Lock tileLock = this.getLock(lockKey);
                        try {
                            foundInCache = this.fetchPrimaryTile(conveyorTile, metaTile);
                        }
                        finally {
                            tileLock.release();
                        }
                    }
                }
                if (foundInCache) break block14;
                LOGGER.log(Level.FINER, () -> "--> " + Thread.currentThread().getName() + " submitting getMap request for meta grid location " + Arrays.toString(metaTile.getMetaGridPos()) + " on " + metaTile);
                try {
                    this.computeMetaTile(conveyorTile, metaTile, executor);
                }
                catch (Exception e) {
                    Throwables.throwIfInstanceOf((Throwable)e, GeoWebCacheException.class);
                    throw new GeoWebCacheException("Problem communicating with GeoServer", (Throwable)e);
                }
            }
            finally {
                metaTileLock.release();
            }
        }
        return this.finalizeTile(conveyorTile);
    }

    private boolean fetchPrimaryTile(ConveyorTile conveyorTile, GeoServerMetaTile metaTile) {
        if (!this.tryCacheFetch(conveyorTile)) {
            return false;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            String threadName = Thread.currentThread().getName();
            String gridPos = Arrays.toString(metaTile.getMetaGridPos());
            LOGGER.finest("--> " + threadName + " returns cache hit for " + gridPos);
        }
        metaTile.dispose();
        return true;
    }

    private LockProvider.Lock getLock(String lockKey) throws GeoWebCacheException {
        return GWC.get().getLockProvider().getLock(lockKey);
    }

    private void computeMetaTile(ConveyorTile conveyorTile, GeoServerMetaTile metaTile, Executor executor) throws Exception {
        long requestTime = System.currentTimeMillis();
        WebMap map = this.dispatchGetMap(conveyorTile, metaTile);
        Preconditions.checkNotNull((Object)map, (Object)"Did not obtain a WebMap from GeoServer's Dispatcher");
        metaTile.setWebMap(map);
        this.setupCachingStrategy(conveyorTile);
        long[][] gridPositions = metaTile.getTilesGridPositions();
        long[] gridLoc = conveyorTile.getTileIndex();
        GridSubset gridSubset = this.getGridSubset(conveyorTile.getGridSetId());
        int numberOfTiles = gridPositions.length;
        int zoomLevel = (int)gridLoc[2];
        boolean store = this.getExpireCache(zoomLevel) != -1;
        ArrayList completableFutures = new ArrayList();
        CountDownLatch tileLockLatch = new CountDownLatch(numberOfTiles);
        for (int tileIndex = 0; tileIndex < numberOfTiles; ++tileIndex) {
            CompletableFuture<Void> completableFuture;
            long[] gridPos = gridPositions[tileIndex];
            int finalTileIndex = tileIndex;
            boolean isConveyorTile = Arrays.equals(gridLoc, gridPos);
            if (!isConveyorTile && !store) continue;
            if (!gridSubset.covers(gridPos)) {
                tileLockLatch.countDown();
                continue;
            }
            Supplier<Resource> encodeTileTask = this.encodeTileTask(metaTile, tileIndex);
            if (isConveyorTile) {
                Resource resource = encodeTileTask.get();
                conveyorTile.setBlob(resource);
                conveyorTile.getStorageObject().setCreated(requestTime);
                Runnable saveTileTask = this.withTileLock(conveyorTile, tileLockLatch, gridPos, this.saveTileTask(metaTile, tileIndex, conveyorTile, resource, requestTime));
                if (executor == null) {
                    saveTileTask.run();
                    continue;
                }
                completableFuture = CompletableFuture.runAsync(saveTileTask, executor);
                completableFutures.add(completableFuture);
                continue;
            }
            Runnable tileSaver = () -> {
                Resource resource = (Resource)encodeTileTask.get();
                this.saveTileTask(metaTile, finalTileIndex, conveyorTile, resource, requestTime).run();
            };
            Runnable encodeAndSaveTask = this.withTileLock(conveyorTile, tileLockLatch, gridPos, this.withRasterCleaner(tileSaver));
            if (executor == null) {
                encodeAndSaveTask.run();
                continue;
            }
            completableFuture = CompletableFuture.runAsync(encodeAndSaveTask, executor);
            completableFutures.add(completableFuture);
        }
        tileLockLatch.await();
        if (!completableFutures.isEmpty()) {
            this.runAsyncAfterAllFuturesComplete(completableFutures, metaTile::dispose, executor);
        } else {
            metaTile.dispose();
        }
    }

    private void runAsyncAfterAllFuturesComplete(List<CompletableFuture<?>> futures, Runnable runnable, Executor executor) {
        CompletableFuture[] futureArray = futures.toArray(new CompletableFuture[0]);
        CompletableFuture<Void> afterAllFutures = CompletableFuture.allOf(futureArray);
        afterAllFutures.thenRunAsync(runnable, executor);
    }

    private Runnable withRasterCleaner(Runnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            finally {
                RasterCleaner.cleanup();
            }
        };
    }

    private Runnable withTileLock(ConveyorTile conveyorTile, CountDownLatch tileLockLatch, long[] gridPosition, Runnable runnable) {
        return () -> {
            try {
                LockProvider.Lock tileLock = this.getLock(this.buildTileLockKey(conveyorTile, gridPosition));
                try {
                    tileLockLatch.countDown();
                    runnable.run();
                }
                finally {
                    tileLock.release();
                }
            }
            catch (GeoWebCacheException ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    private Supplier<Resource> encodeTileTask(GeoServerMetaTile metaTile, int tileIndex) {
        return () -> {
            boolean completed;
            ByteArrayResource resource = new ByteArrayResource(16384);
            try {
                completed = metaTile.writeTileToStream(tileIndex, (Resource)resource);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Unable to write image tile to ByteArrayOutputStream", e);
                throw new RuntimeException(e);
            }
            if (!completed) {
                LOGGER.severe("metaTile.writeTileToStream returned false, no tiles saved");
            }
            return resource;
        };
    }

    private Runnable saveTileTask(GeoServerMetaTile metaTile, int tileIndex, ConveyorTile tileProto, Resource resource, long requestTime) {
        return () -> {
            try {
                long[][] gridPositions = metaTile.getTilesGridPositions();
                long[] gridPosition = gridPositions[tileIndex];
                long[] idx = new long[]{gridPosition[0], gridPosition[1], gridPosition[2]};
                TileObject tile = TileObject.createCompleteTileObject((String)this.getName(), (long[])idx, (String)tileProto.getGridSetId(), (String)tileProto.getMimeType().getFormat(), (Map)tileProto.getParameters(), (Resource)resource);
                tile.setCreated(requestTime);
                StorageBroker storageBroker = tileProto.getStorageBroker();
                if (tileProto.isMetaTileCacheOnly()) {
                    storageBroker.putTransient(tile);
                } else {
                    storageBroker.put(tile);
                }
                tileProto.getStorageObject().setCreated(tile.getCreated());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    private void setupCachingStrategy(ConveyorTile tile) {
        int zLevel;
        GridSubset gridSubset = this.getGridSubset(tile.getGridSetId());
        if (!gridSubset.shouldCacheAtZoom((long)(zLevel = (int)tile.getTileIndex()[2]))) {
            LOGGER.fine("Skipping tile caching because zoom level is not configured for caching");
            tile.setMetaTileCacheOnly(true);
            return;
        }
        Set<DimensionWarning.WarningType> warningSkips = this.info.getCacheWarningSkips();
        if (warningSkips != null && HTTPWarningAppender.anyMatch(warningSkips)) {
            LOGGER.fine("Skipping tile caching due to a WMS dimension warning");
            tile.setMetaTileCacheOnly(true);
        }
    }

    private String buildMetaTileLockKey(ConveyorTile tilePrototype, GeoServerMetaTile metaTile) {
        return this.buildLockKey(tilePrototype, "gwc_metatile_", metaTile.getMetaGridPos());
    }

    private String buildTileLockKey(ConveyorTile tilePrototype, long[] gridPosition) {
        return this.buildLockKey(tilePrototype, "gwc_tile_", gridPosition);
    }

    private String buildLockKey(ConveyorTile tilePrototype, String prefix, long[] position) {
        StringBuilder lockKey = new StringBuilder();
        lockKey.append(prefix);
        long x = position[0];
        long y = position[1];
        long z = position[2];
        lockKey.append(tilePrototype.getLayerId());
        lockKey.append("_").append(tilePrototype.getGridSetId());
        lockKey.append("_").append(x).append("_").append(y).append("_").append(z);
        if (tilePrototype.getParametersId() != null) {
            lockKey.append("_").append(tilePrototype.getParametersId());
        }
        lockKey.append(".").append(tilePrototype.getMimeType().getFileExtension());
        return lockKey.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebMap dispatchGetMap(ConveyorTile tile, MetaTile metaTile) throws Exception {
        WebMap map;
        Map<String, String> params = this.buildGetMap(tile, metaTile);
        try {
            HttpServletRequest actualRequest = tile.servletReq;
            Cookie[] cookies = actualRequest == null ? null : actualRequest.getCookies();
            GWC.get().dispatchOwsRequest(params, cookies);
            map = WEB_MAP.get();
            if (!(map instanceof WebMap)) {
                throw new IllegalStateException("Expected: RenderedImageMap, got " + map);
            }
            Set<DimensionWarning> warnings = DIMENSION_WARNINGS.get();
            if (warnings != null) {
                warnings.forEach(w -> HTTPWarningAppender.addWarning((DimensionWarning)w));
            }
        }
        finally {
            WEB_MAP.remove();
        }
        return map;
    }

    private GeoServerMetaTile createMetaTile(ConveyorTile tile, int metaX, int metaY) {
        String tileGridSetId = tile.getGridSetId();
        GridSubset gridSubset = this.getGridSubset(tileGridSetId);
        MimeType responseFormat = tile.getMimeType();
        FormatModifier formatModifier = null;
        long[] tileGridPosition = tile.getTileIndex();
        int gutter = responseFormat.isVector() ? 0 : this.info.getGutter();
        GeoServerMetaTile metaTile = new GeoServerMetaTile(gridSubset, responseFormat, formatModifier, tileGridPosition, metaX, metaY, gutter);
        return metaTile;
    }

    private Map<String, String> buildGetMap(ConveyorTile tile, MetaTile metaTile) throws ParameterException {
        Map filteredParams;
        HashMap<String, String> params = new HashMap<String, String>();
        MimeType mimeType = tile.getMimeType();
        String gridSetId = tile.getGridSetId();
        GridSubset gridSubset = this.getGridSubset(gridSetId);
        int width = metaTile.getMetaTileWidth();
        int height = metaTile.getMetaTileHeight();
        String srs = gridSubset.getSRS().toString();
        String format = mimeType.getFormat();
        BoundingBox bbox = metaTile.getMetaTileBounds();
        params.put("SERVICE", "WMS");
        params.put("VERSION", "1.1.1");
        params.put("REQUEST", "GetMap");
        params.put("LAYERS", this.getName());
        params.put("SRS", srs);
        params.put("FORMAT", format);
        params.put("WIDTH", String.valueOf(width));
        params.put("HEIGHT", String.valueOf(height));
        params.put("BBOX", bbox.toString());
        params.put("EXCEPTIONS", "SE_XML");
        params.put("STYLES", "");
        params.put("TRANSPARENT", "true");
        params.put(GWC_SEED_INTERCEPT_TOKEN, "true");
        GeoServer gs = (GeoServer)GeoServerExtensions.bean(GeoServer.class);
        if (gs != null && !gs.getGlobal().isGlobalServices().booleanValue()) {
            PublishedInfo publishedInfo = this.getPublishedInfo();
            if (publishedInfo instanceof LayerInfo) {
                LayerInfo layerInfo = (LayerInfo)publishedInfo;
                params.put("WORKSPACE", layerInfo.getResource().getNamespace().getName());
            } else if (publishedInfo instanceof LayerGroupInfo) {
                LayerGroupInfo groupInfo = (LayerGroupInfo)publishedInfo;
                WorkspaceInfo workspace = groupInfo.getWorkspace();
                if (workspace == null) {
                    throw new ParameterException("Global web services are disabled, global LayerGroup " + groupInfo.getName() + " inaccessible");
                }
                params.put("WORKSPACE", workspace.getName());
            }
        }
        if ((filteredParams = tile.getFilteringParameters()).isEmpty()) {
            filteredParams = this.getDefaultParameterFilters();
        }
        params.putAll(filteredParams);
        return params;
    }

    private boolean tryCacheFetch(ConveyorTile tile) {
        int expireCache = this.getExpireCache((int)tile.getTileIndex()[2]);
        if (expireCache != -1) {
            try {
                return tile.retrieve((long)expireCache * 1000L);
            }
            catch (GeoWebCacheException gwce) {
                LOGGER.info(gwce.getMessage());
                tile.setErrorMsg(gwce.getMessage());
                return false;
            }
        }
        return false;
    }

    private ConveyorTile finalizeTile(ConveyorTile tile) {
        if (tile.getStatus() == 0 && !tile.getError()) {
            tile.setStatus(200);
        }
        if (tile.servletResp != null) {
            HashMap<String, String> headers = new HashMap<String, String>();
            GWC.setCacheControlHeaders(headers, this, (int)tile.getTileIndex()[2]);
            headers.forEach((k, v) -> tile.servletResp.setHeader(k, v));
            this.setTileIndexHeader(tile);
        }
        tile.setTileLayer((TileLayer)this);
        return tile;
    }

    private void setTileIndexHeader(ConveyorTile tile) {
        tile.servletResp.addHeader("geowebcache-tile-index", Arrays.toString(tile.getTileIndex()));
    }

    public ConveyorTile getNoncachedTile(ConveyorTile tile) throws GeoWebCacheException {
        try {
            return this.getMetatilingResponse(tile, false, 1, 1);
        }
        catch (IOException e) {
            throw new GeoWebCacheException((Throwable)e);
        }
    }

    public ConveyorTile doNonMetatilingRequest(ConveyorTile tile) throws GeoWebCacheException {
        try {
            return this.getMetatilingResponse(tile, true, 1, 1);
        }
        catch (IOException e) {
            throw new GeoWebCacheException((Throwable)e);
        }
    }

    public void seedTile(ConveyorTile tile, boolean tryCache) throws GeoWebCacheException, IOException {
        int zLevel;
        GridSubset gridSubset = this.getGridSubset(tile.getGridSetId());
        if (!gridSubset.shouldCacheAtZoom((long)(zLevel = (int)tile.getTileIndex()[2]))) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Ignoring seed call on tile " + tile + " as it's outside the cacheable zoom level range");
            }
            return;
        }
        int metaX = this.info.getMetaTilingX();
        int metaY = this.info.getMetaTilingY();
        if (!tile.getMimeType().supportsTiling()) {
            metaY = 1;
            metaX = 1;
        }
        this.getMetatilingResponse(tile, tryCache, metaX, metaY);
    }

    public Set<String> getGridSubsets() {
        Set<XMLGridSubset> gridSubsets = this.info.getGridSubsets();
        if (gridSubsets == null) {
            return Collections.emptySet();
        }
        return gridSubsets.stream().map(ss -> ss.getGridSetName()).collect(Collectors.toSet());
    }

    public GridSubset getGridSubset(String gridSetId) {
        return this.gridSubsets().get(gridSetId);
    }

    private Map<String, GridSubset> gridSubsets() {
        Map<String, GridSubset> gridSubsets = this._subSets.get();
        while (gridSubsets == null) {
            gridSubsets = this._subSets.accumulateAndGet(null, (currValue, nullNewValue) -> {
                if (currValue == null) {
                    return this.computeGridSubsets();
                }
                return null;
            });
        }
        return gridSubsets;
    }

    public GridSubset removeGridSubset(String gridSetId) {
        this.gridSubsets();
        GridSubset oldValue = this.gridSubsets().remove(gridSetId);
        HashSet<XMLGridSubset> gridSubsets = new HashSet<XMLGridSubset>(this.info.getGridSubsets());
        Iterator it = gridSubsets.iterator();
        while (it.hasNext()) {
            if (!((XMLGridSubset)it.next()).getGridSetName().equals(gridSetId)) continue;
            it.remove();
            break;
        }
        this.info.setGridSubsets(gridSubsets);
        this._subSets.set(null);
        return oldValue;
    }

    public void addGridSubset(GridSubset gridSubset) {
        XMLGridSubset gridSubsetInfo = new XMLGridSubset(gridSubset);
        if (gridSubset instanceof DynamicGridSubset) {
            gridSubsetInfo.setExtent(null);
        }
        HashSet<XMLGridSubset> gridSubsets = new HashSet<XMLGridSubset>(this.info.getGridSubsets());
        gridSubsets.add(gridSubsetInfo);
        this.info.setGridSubsets(gridSubsets);
        this._subSets.set(null);
    }

    public void boundsChanged() {
        this._subSets.set(null);
    }

    private Map<String, GridSubset> computeGridSubsets() {
        try {
            return this.getGrids(this.gridSetBroker);
        }
        catch (ConfigurationException e) {
            String msg = "Can't create grids for '" + this.getName() + "': " + e.getMessage();
            LOGGER.log(Level.WARNING, msg, e);
            this.setConfigErrorMessage(msg);
            throw new IllegalStateException(e);
        }
    }

    private Map<String, GridSubset> getGrids(GridSetBroker gridSetBroker) throws ConfigurationException {
        Set<XMLGridSubset> cachedGridSets = this.info.getGridSubsets();
        if (cachedGridSets.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, GridSubset> grids = new HashMap<String, GridSubset>(2);
        for (XMLGridSubset xmlGridSubset : cachedGridSets) {
            String gridSetId = xmlGridSubset.getGridSetName();
            GridSet gridSet = gridSetBroker.get(gridSetId);
            if (gridSet == null) {
                LOGGER.info("No GWC GridSet named '" + gridSetId + "' exists.");
                continue;
            }
            BoundingBox extent = xmlGridSubset.getExtent();
            boolean dynamic = Objects.isNull(extent);
            if (dynamic) {
                try {
                    BoundingBox intersection;
                    SRS srs = gridSet.getSrs();
                    try {
                        extent = this.getBounds(srs);
                    }
                    catch (RuntimeException cantComputeBounds) {
                        String msg = "Can't compute bounds for tile layer " + this.getName() + " in CRS " + srs + ". Assuming full GridSet bounds. (" + cantComputeBounds.getMessage() + ")";
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, msg, cantComputeBounds);
                        } else {
                            LOGGER.warning(msg);
                        }
                        extent = gridSet.getBounds();
                    }
                    BoundingBox maxBounds = gridSet.getBounds();
                    extent = intersection = maxBounds.intersection(extent);
                }
                catch (RuntimeException e) {
                    LOGGER.log(Level.WARNING, "Error computing layer bounds, assuming whole GridSet bounds", e);
                    extent = gridSet.getOriginalExtent();
                }
            }
            xmlGridSubset.setExtent(extent);
            GridSubset gridSubSet = xmlGridSubset.getGridSubSet(gridSetBroker);
            if (dynamic) {
                gridSubSet = new DynamicGridSubset(gridSubSet);
            }
            grids.put(gridSetId, gridSubSet);
        }
        return grids;
    }

    private BoundingBox getBounds(SRS srs) {
        ReferencedEnvelope transformedBounds;
        ReferencedEnvelope nativeBounds;
        CoordinateReferenceSystem targetCrs;
        try {
            String epsgCode = srs.toString();
            boolean longitudeFirst = true;
            targetCrs = CRS.decode((String)epsgCode, (boolean)true);
            Preconditions.checkNotNull((Object)targetCrs);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        ResourceInfo resourceInfo = this.getResourceInfo();
        if (resourceInfo != null) {
            try {
                nativeBounds = resourceInfo.boundingBox();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            nativeBounds = ((LayerGroupInfo)this.getPublishedInfo()).getBounds();
        }
        Preconditions.checkState((nativeBounds != null ? 1 : 0) != 0, (String)this.getName(), (Object)" has no native bounds set");
        try {
            transformedBounds = nativeBounds.transform(targetCrs, true, ENV_TX_POINTS);
        }
        catch (Exception e) {
            Geometry targetAov = GWC.getAreaOfValidityAsGeometry(targetCrs, this.gridSetBroker);
            if (null == targetAov) {
                String msg = "Can't compute tile layer bounds out of resource native bounds for CRS " + srs;
                LOGGER.log(Level.WARNING, msg, e);
                throw new IllegalArgumentException(msg, e);
            }
            LOGGER.log(Level.FINE, "Can't compute tile layer bounds out of resource native bounds for CRS " + srs, e);
            CoordinateReferenceSystem nativeCrs = nativeBounds.getCoordinateReferenceSystem();
            try {
                ReferencedEnvelope targetAovBounds = new ReferencedEnvelope(targetAov.getEnvelopeInternal(), targetCrs);
                ReferencedEnvelope targetAovInNativeCrs = targetAovBounds.transform(nativeCrs, true, ENV_TX_POINTS);
                ReferencedEnvelope intersection = targetAovInNativeCrs.intersection((Envelope)nativeBounds);
                ReferencedEnvelope clipped = new ReferencedEnvelope((Envelope)intersection, nativeCrs);
                transformedBounds = clipped.transform(targetCrs, true, ENV_TX_POINTS);
            }
            catch (Exception e1) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        BoundingBox targetBbox = new BoundingBox(transformedBounds.getMinX(), transformedBounds.getMinY(), transformedBounds.getMaxX(), transformedBounds.getMaxY());
        return targetBbox;
    }

    public GeoServerTileLayerInfo getInfo() {
        return this.info;
    }

    public List<UpdateSourceDefinition> getUpdateSources() {
        return Collections.emptyList();
    }

    public boolean useETags() {
        return false;
    }

    public List<FormatModifier> getFormatModifiers() {
        return Collections.emptyList();
    }

    public void setFormatModifiers(List<FormatModifier> formatModifiers) {
        throw new UnsupportedOperationException();
    }

    public int[] getMetaTilingFactors() {
        return new int[]{this.info.getMetaTilingX(), this.info.getMetaTilingY()};
    }

    public Boolean isCacheBypassAllowed() {
        return true;
    }

    public void setCacheBypassAllowed(boolean allowed) {
        throw new UnsupportedOperationException();
    }

    public Integer getBackendTimeout() {
        return 0;
    }

    public void setBackendTimeout(int seconds) {
        throw new UnsupportedOperationException();
    }

    public List<MimeType> getMimeTypes() {
        Set<String> mimeFormats = this.info.getMimeFormats();
        ArrayList<MimeType> mimeTypes = new ArrayList<MimeType>(mimeFormats.size());
        for (String format : mimeFormats) {
            try {
                mimeTypes.add(MimeType.createFromFormat((String)format));
            }
            catch (MimeException e) {
                LOGGER.log(Level.WARNING, "Can't create MimeType from format " + format, e);
            }
        }
        return mimeTypes;
    }

    public int getExpireClients(int zoomLevel) {
        if (this.info.getExpireClients() > 0) {
            return this.info.getExpireClients();
        }
        PublishedInfo published = this.getPublishedInfo();
        if (published instanceof LayerInfo) {
            return this.getLayerMaxAge((LayerInfo)published);
        }
        LayerGroupInfo layerGroupInfo = (LayerGroupInfo)published;
        if (layerGroupInfo != null) {
            return this.getGroupMaxAge(layerGroupInfo);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Found a GeoServerTileLayer that is not base on either LayerInfo or LayerGroupInfo, setting its max age to 0");
        }
        return 0;
    }

    private int getGroupMaxAge(LayerGroupInfo lg) {
        if (this.isCachingEnabled(lg.getMetadata())) {
            return this.getCacheMaxAge(lg.getMetadata());
        }
        int maxAge = Integer.MAX_VALUE;
        for (PublishedInfo pi : lg.getLayers()) {
            int piAge;
            if (pi instanceof LayerInfo) {
                piAge = this.getLayerMaxAge((LayerInfo)pi);
            } else if (pi instanceof LayerGroupInfo) {
                piAge = this.getGroupMaxAge((LayerGroupInfo)pi);
            } else {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Found a PublishedInfo that is nor LayerInfo nor LayerGroupInfo, setting its max age to 0: " + pi);
                }
                piAge = 0;
            }
            maxAge = Math.min(piAge, maxAge);
        }
        return maxAge;
    }

    private int getLayerMaxAge(LayerInfo li) {
        MetadataMap metadata = li.getResource().getMetadata();
        if (this.isCachingEnabled(metadata)) {
            return this.getCacheMaxAge(metadata);
        }
        return 0;
    }

    private boolean isCachingEnabled(MetadataMap metadata) {
        Boolean value = (Boolean)metadata.get("cachingEnabled", Boolean.class);
        return value != null ? value : false;
    }

    private int getCacheMaxAge(MetadataMap metadata) {
        Integer value = (Integer)metadata.get("cacheAgeMax", Integer.class);
        return value != null ? value : 0;
    }

    public int getExpireCache(int zoomLevel) {
        if (this.info.getExpireCacheList() != null) {
            ExpirationRule matchedRule = null;
            for (ExpirationRule rule : this.info.getExpireCacheList()) {
                if (zoomLevel < rule.getMinZoom()) break;
                matchedRule = rule;
            }
            if (matchedRule != null) {
                return matchedRule.getExpiration();
            }
        }
        return this.info.getExpireCache();
    }

    public List<RequestFilter> getRequestFilters() {
        return null;
    }

    public boolean initialize(GridSetBroker gridSetBroker) {
        return true;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.info + "]";
    }

    public List<MimeType> getInfoMimeTypes() {
        List typeStrings = ((WMS)GeoServerExtensions.bean((String)"wms")).getAvailableFeatureInfoFormats();
        ArrayList<MimeType> types = new ArrayList<MimeType>(typeStrings.size());
        for (String typeString : typeStrings) {
            try {
                types.add(MimeType.createFromFormat((String)typeString));
            }
            catch (MimeException e) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return types;
    }

    public void proxyRequest(ConveyorTile tile) throws GeoWebCacheException {
        try {
            GWC.get().proxyOwsRequest(tile);
        }
        catch (Exception e) {
            throw new GeoWebCacheException("Failed to cascade request", (Throwable)e);
        }
    }

    public List<MetadataURL> getMetadataURLs() {
        List gsMetadataLinks;
        ArrayList<MetadataURL> gwcMetadataLinks = new ArrayList<MetadataURL>();
        PublishedInfo published = this.getPublishedInfo();
        if (published instanceof LayerInfo) {
            gsMetadataLinks = ((LayerInfo)published).getResource().getMetadataLinks();
        } else {
            gsMetadataLinks = new ArrayList();
            for (LayerInfo layer : Iterables.filter((Iterable)((LayerGroupInfo)published).getLayers(), LayerInfo.class)) {
                List metadataLinksLayer = layer.getResource().getMetadataLinks();
                if (metadataLinksLayer == null) continue;
                gsMetadataLinks.addAll(metadataLinksLayer);
            }
        }
        String baseUrl = GeoServerTileLayer.baseUrl();
        for (MetadataLinkInfo gsMetadata : gsMetadataLinks) {
            String url = org.vfny.geoserver.util.ResponseUtils.proxifyMetadataLink((MetadataLinkInfo)gsMetadata, (String)baseUrl);
            try {
                gwcMetadataLinks.add(new MetadataURL(gsMetadata.getMetadataType(), gsMetadata.getType(), new URL(url)));
            }
            catch (MalformedURLException exception) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.warning("Error adding layer metadata URL.");
            }
        }
        return gwcMetadataLinks;
    }

    public boolean isAdvertised() {
        return true;
    }

    public void setAdvertised(boolean advertised) {
    }

    public boolean isTransientLayer() {
        return false;
    }

    public void setTransientLayer(boolean transientLayer) {
    }

    public void setBlobStoreId(String blobStoreId) {
        this.info.setBlobStoreId(blobStoreId);
    }

    public Map<String, LegendInfo> getLayerLegendsInfo() {
        PublishedInfo publishedInfo = this.getPublishedInfo();
        if (!(publishedInfo instanceof LayerInfo)) {
            return Collections.emptyMap();
        }
        HashMap<String, LegendInfo> legends = new HashMap<String, LegendInfo>();
        LayerInfo layerInfo = (LayerInfo)publishedInfo;
        HashSet<StyleInfo> styles = new HashSet<StyleInfo>(layerInfo.getStyles());
        styles.add(layerInfo.getDefaultStyle());
        for (StyleInfo styleInfo : styles) {
            NumberRange scalesDenominator;
            if (styleInfo == null) continue;
            try {
                scalesDenominator = CapabilityUtil.searchMinMaxScaleDenominator(Collections.singleton(styleInfo));
            }
            catch (Exception exception) {
                throw new RuntimeException(String.format("Error searching max and min scale denominators for style '%s'.", styleInfo.getName()), exception);
            }
            org.geoserver.catalog.LegendInfo legendInfo = styleInfo.getLegend();
            LegendInfoBuilder gwcLegendInfo = new LegendInfoBuilder();
            if (legendInfo != null) {
                String baseUrl = GeoServerTileLayer.baseUrl();
                gwcLegendInfo.withStyleName(styleInfo.getName()).withWidth(Integer.valueOf(legendInfo.getWidth())).withHeight(Integer.valueOf(legendInfo.getHeight())).withFormat(legendInfo.getFormat()).withMinScale(Double.valueOf(scalesDenominator.getMinimum())).withMaxScale(Double.valueOf(scalesDenominator.getMaximum())).withCompleteUrl(ResponseUtils.buildURL((String)baseUrl, (String)legendInfo.getOnlineResource(), null, (URLMangler.URLType)URLMangler.URLType.SERVICE));
                legends.put(styleInfo.prefixedName(), gwcLegendInfo.build());
                continue;
            }
            int finalWidth = 20;
            int finalHeight = 20;
            String finalFormat = "image/png";
            try {
                Dimension dimension = this.getLegendSample().getLegendURLSize(styleInfo);
                if (dimension != null) {
                    finalWidth = (int)dimension.getWidth();
                    finalHeight = (int)dimension.getHeight();
                }
                if (null == this.getWms().getLegendGraphicOutputFormat(finalFormat)) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.warning("Default legend format (" + finalFormat + ")is not supported (jai not available?), can't add LegendURL element");
                    continue;
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Error getting LegendURL dimensions from sample", exception);
            }
            String layerName = layerInfo.prefixedName();
            Map params = ResponseUtils.params((String[])new String[]{"service", "WMS", "request", "GetLegendGraphic", "version", "1.1.0", "format", finalFormat, "width", String.valueOf(finalWidth), "height", String.valueOf(finalHeight), "layer", layerName});
            if (!styleInfo.getName().equals(layerInfo.getDefaultStyle().getName())) {
                params.put("style", styleInfo.getName());
            }
            String baseUrl = GeoServerTileLayer.baseUrl();
            gwcLegendInfo.withStyleName(styleInfo.getName()).withWidth(Integer.valueOf(finalWidth)).withHeight(Integer.valueOf(finalHeight)).withFormat(finalFormat).withMinScale(Double.valueOf(scalesDenominator.getMinimum())).withMaxScale(Double.valueOf(scalesDenominator.getMaximum())).withCompleteUrl(ResponseUtils.buildURL((String)baseUrl, (String)"ows", (Map)params, (URLMangler.URLType)URLMangler.URLType.RESOURCE));
            legends.put(styleInfo.prefixedName(), gwcLegendInfo.build());
        }
        return legends;
    }

    private LegendSample getLegendSample() {
        if (this.legendSample == null) {
            this.legendSample = (LegendSample)GeoServerExtensions.bean(LegendSample.class);
        }
        return this.legendSample;
    }

    private WMS getWms() {
        if (this.wms == null) {
            this.wms = (WMS)GeoServerExtensions.bean(WMS.class);
        }
        return this.wms;
    }

    void setLegendSample(LegendSample legendSample) {
        this.legendSample = legendSample;
    }

    void setWms(WMS wms) {
        this.wms = wms;
    }

    private static String baseUrl() {
        Request owsRequest = (Request)Dispatcher.REQUEST.get();
        if (owsRequest != null) {
            return ResponseUtils.baseURL((HttpServletRequest)((Request)Dispatcher.REQUEST.get()).getHttpRequest());
        }
        RequestInfo restRequest = RequestInfo.get();
        if (restRequest != null) {
            return restRequest.getBaseURL();
        }
        return null;
    }

    public boolean supportsTileJSON() {
        return this.getGridSubsetForSRS(SRS.getEPSG3857()) != null || this.getGridSubsetForSRS(SRS.getEPSG900913()) != null;
    }

    public TileJSON getTileJSON() {
        TileJSON tileJSON = new TileJSON();
        tileJSON.setName(this.getName());
        LayerMetaInformation metaInformation = this.getMetaInformation();
        if (metaInformation != null) {
            tileJSON.setDescription(metaInformation.getDescription());
        }
        BoundingBox wgs84Bounds = this.getBounds(SRS.getEPSG4326());
        PublishedInfo publishedInfo = this.getPublishedInfo();
        PublishedType type = publishedInfo.getType();
        ArrayList<VectorLayerMetadata> metadataLayers = new ArrayList<VectorLayerMetadata>();
        if (type == PublishedType.VECTOR) {
            this.setVectorLayers(publishedInfo, metadataLayers);
        } else if (type == PublishedType.GROUP) {
            this.setVectorLayersGroup(publishedInfo, metadataLayers);
        }
        if (!metadataLayers.isEmpty()) {
            tileJSON.setLayers(metadataLayers);
        }
        tileJSON.setBounds(new double[]{wgs84Bounds.getMinX(), wgs84Bounds.getMinY(), wgs84Bounds.getMaxX(), wgs84Bounds.getMaxY()});
        return tileJSON;
    }

    private void setVectorLayers(PublishedInfo publishedInfo, List<VectorLayerMetadata> metadataLayers) {
        ResourceInfo resource = this.getResource(publishedInfo);
        if (resource instanceof FeatureTypeInfo) {
            this.addVectorLayerMetadata((FeatureTypeInfo)resource, metadataLayers);
        }
    }

    private void setVectorLayersGroup(PublishedInfo publishedInfo, List<VectorLayerMetadata> metadataLayers) {
        LayerGroupInfo layerGroupInfo = null;
        if (Proxy.isProxyClass(publishedInfo.getClass())) {
            layerGroupInfo = (LayerGroupInfo)ModificationProxy.unwrap((Object)publishedInfo);
        } else if (publishedInfo instanceof LayerGroupInfo) {
            layerGroupInfo = (LayerGroupInfo)publishedInfo;
        }
        if (layerGroupInfo != null) {
            List layers = layerGroupInfo.getLayers();
            ArrayList<FeatureTypeInfo> featureTypes = new ArrayList<FeatureTypeInfo>();
            for (PublishedInfo layer : layers) {
                ResourceInfo resource = this.getResource(layer);
                if (!(resource instanceof FeatureTypeInfo)) {
                    return;
                }
                featureTypes.add((FeatureTypeInfo)resource);
            }
            for (FeatureTypeInfo featureTypeInfo : featureTypes) {
                this.addVectorLayerMetadata(featureTypeInfo, metadataLayers);
            }
        }
    }

    private ResourceInfo getResource(PublishedInfo publishedInfo) {
        ResourceInfo resource = null;
        if (Proxy.isProxyClass(publishedInfo.getClass())) {
            LayerInfo inner = (LayerInfo)ModificationProxy.unwrap((Object)publishedInfo);
            resource = inner.getResource();
        } else if (publishedInfo instanceof LayerInfo) {
            resource = ((LayerInfo)publishedInfo).getResource();
        }
        return resource;
    }

    private void addVectorLayerMetadata(FeatureTypeInfo featureTypeInfo, List<VectorLayerMetadata> metadataLayers) {
        VectorLayerMetadata metadata = null;
        ResourcePool resourcePool = this.catalog.getResourcePool();
        try {
            FeatureType featureType = resourcePool.getFeatureType(featureTypeInfo);
            Collection descriptors = featureType.getDescriptors();
            HashMap<String, String> fields = new HashMap<String, String>();
            for (PropertyDescriptor pd : descriptors) {
                if (pd instanceof GeometryDescriptor) continue;
                String pdName = pd.getName().toString();
                String typeName = pd.getType().getBinding().getSimpleName();
                fields.put(pdName, typeName);
            }
            metadata = new VectorLayerMetadata();
            metadata.setId(featureTypeInfo.getName());
            metadata.setFields(fields);
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Could not parse featureType " + featureTypeInfo, e);
        }
        if (metadata != null) {
            metadataLayers.add(metadata);
        }
    }
}

