/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.wms;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.nio.channels.Channels;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.WebMapService;
import org.geoserver.wms.map.RawMap;
import org.geotools.util.logging.Logging;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayer;

public class CachingWebMapService
implements MethodInterceptor {
    private static final Logger LOGGER = Logging.getLogger(CachingWebMapService.class);
    private GWC gwc;

    public CachingWebMapService(GWC gwc) {
        this.gwc = gwc;
    }

    public WebMap invoke(MethodInvocation invocation) throws Throwable {
        byte[] tileBytes;
        Resource mapContents;
        boolean isSeedingRequest;
        GWCConfig config = this.gwc.getConfig();
        if (!config.isDirectWMSIntegrationEnabled()) {
            return (WebMap)invocation.proceed();
        }
        GetMapRequest request = this.getRequest(invocation);
        boolean tiled = request.isTiled() || !config.isRequireTiledParameter();
        Map rawKvp = request.getRawKvp();
        boolean bl = isSeedingRequest = rawKvp != null && rawKvp.containsKey("GWC_SEED_INTERCEPT");
        if (!tiled || isSeedingRequest) {
            return (WebMap)invocation.proceed();
        }
        StringBuilder requestMistmatchTarget = new StringBuilder();
        ConveyorTile cachedTile = this.gwc.dispatch(request, requestMistmatchTarget);
        if (cachedTile == null) {
            WebMap dynamicResult = (WebMap)invocation.proceed();
            dynamicResult.setResponseHeader("geowebcache-cache-result", Conveyor.CacheResult.MISS.toString());
            dynamicResult.setResponseHeader("geowebcache-miss-reason", requestMistmatchTarget.toString());
            return dynamicResult;
        }
        Preconditions.checkState((cachedTile.getTileLayer() != null ? 1 : 0) != 0);
        TileLayer layer = cachedTile.getTileLayer();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("GetMap request intercepted, serving cached content: " + request);
        }
        if ((mapContents = cachedTile.getBlob()) instanceof ByteArrayResource) {
            tileBytes = ((ByteArrayResource)mapContents).getContents();
        } else {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            mapContents.transferTo(Channels.newChannel(out));
            tileBytes = out.toByteArray();
        }
        String ifNoneMatch = request.getHttpRequestHeader("If-None-Match");
        String etag = GWC.getETag(tileBytes);
        if (etag.equals(ifNoneMatch)) {
            LOGGER.finer("ETag matches, returning 304");
            throw new HttpErrorCodeException(304);
        }
        LOGGER.finer("No matching ETag, returning cached tile");
        String mimeType = cachedTile.getMimeType().getMimeType();
        RawMap map = new RawMap(null, tileBytes, mimeType);
        map.setContentDispositionHeader(null, "." + cachedTile.getMimeType().getFileExtension(), false);
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        GWC.setCacheControlHeaders(headers, layer, (int)cachedTile.getTileIndex()[2]);
        GWC.setConditionalGetHeaders(headers, cachedTile, etag, request.getHttpRequestHeader("If-Modified-Since"));
        GWC.setCacheMetadataHeaders(headers, cachedTile, layer);
        headers.forEach((k, v) -> map.setResponseHeader(k, v));
        return map;
    }

    private GetMapRequest getRequest(MethodInvocation invocation) {
        Method method = invocation.getMethod();
        Preconditions.checkArgument((boolean)method.getDeclaringClass().equals(WebMapService.class));
        Preconditions.checkArgument((boolean)"getMap".equals(method.getName()));
        Object[] arguments = invocation.getArguments();
        Preconditions.checkArgument((arguments.length == 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)(arguments[0] instanceof GetMapRequest));
        GetMapRequest request = (GetMapRequest)arguments[0];
        return request;
    }
}

