/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.gwc.GWC;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.DataAccessLimits;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.TestResourceAccessManager;
import org.geoserver.security.impl.AbstractUserGroupService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geowebcache.service.ve.VEConverter;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.io.WKTReader;
import org.springframework.mock.web.MockHttpServletResponse;

public class GWCDataSecurityTest
extends WMSTestSupport {
    static final Logger LOGGER = Logging.getLogger(GWCDataSecurityTest.class);
    private static final String SECURITY_ERROR_TYPE = "text/plain";
    private static final String NOT_FOUND_ERROR_TYPE = "text/html";

    @Before
    public void cleanUpCrsHints() {
        CRS.cleanupThreadLocals();
    }

    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("classpath:/org/geoserver/wms/ResourceAccessManagerContext.xml");
    }

    protected List<javax.servlet.Filter> getFilters() {
        return Collections.singletonList((javax.servlet.Filter)GeoServerExtensions.bean((String)"filterChainProxy"));
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        GWC.get().getConfig().setSecurityEnabled(true);
        testData.addStyle("raster", "raster.sld", SystemTestData.class, this.getCatalog());
        HashMap<SystemTestData.LayerProperty, String> properties = new HashMap<SystemTestData.LayerProperty, String>();
        properties.put(SystemTestData.LayerProperty.STYLE, "raster");
        testData.addRasterLayer(new QName(MockData.SF_URI, "mosaic", MockData.SF_PREFIX), "raster-filter-test.zip", null, properties, SystemTestData.class, this.getCatalog());
        testData.addRasterLayer(new QName(MockData.SF_URI, "Mosaic2", MockData.SF_PREFIX), "raster-filter-test.zip", null, properties, SystemTestData.class, this.getCatalog());
        CoverageInfo sfMosaicCI = this.getCatalog().getCoverageByName("sf:mosaic");
        sfMosaicCI.setNativeBoundingBox(CiteTestData.DEFAULT_LATLON_ENVELOPE);
        this.getCatalog().save((ResourceInfo)sfMosaicCI);
        GeoServerUserGroupStore ugStore = this.getSecurityManager().loadUserGroupService(AbstractUserGroupService.DEFAULT_NAME).createStore();
        ugStore.addUser(ugStore.createUserObject("cite", "cite", true));
        ugStore.addUser(ugStore.createUserObject("cite_mosaic2", "cite", true));
        ugStore.addUser(ugStore.createUserObject("cite_nomosaic", "cite", true));
        ugStore.addUser(ugStore.createUserObject("cite_cropmosaic", "cite", true));
        ugStore.addUser(ugStore.createUserObject("cite_filtermosaic", "cite", true));
        ugStore.addUser(ugStore.createUserObject("cite_nogroup", "cite", true));
        ugStore.store();
        GeoServerRoleStore roleStore = this.getSecurityManager().getActiveRoleService().createStore();
        GeoServerRole role = roleStore.createRoleObject("ROLE_DUMMY");
        roleStore.addRole(role);
        roleStore.associateRoleToUser(role, "cite");
        roleStore.associateRoleToUser(role, "cite_mosaic2");
        roleStore.associateRoleToUser(role, "cite_nogroup");
        roleStore.associateRoleToUser(role, "cite_nomosaic");
        roleStore.associateRoleToUser(role, "cite_cropmosaic");
        roleStore.associateRoleToUser(role, "cite_filtermosaic");
        roleStore.store();
        Catalog catalog = this.getCatalog();
        TestResourceAccessManager tam = (TestResourceAccessManager)applicationContext.getBean("testResourceAccessManager");
        CoverageInfo coverage = catalog.getCoverageByName("sf:mosaic");
        CoverageInfo coverage2 = catalog.getCoverageByName("sf:Mosaic2");
        tam.putLimits("cite_mosaic2", (CatalogInfo)coverage, (AccessLimits)new DataAccessLimits(CatalogMode.HIDE, (Filter)Filter.EXCLUDE));
        tam.putLimits("cite", (CatalogInfo)coverage, (AccessLimits)new DataAccessLimits(CatalogMode.HIDE, (Filter)Filter.INCLUDE));
        tam.putLimits("cite", (CatalogInfo)coverage2, (AccessLimits)new DataAccessLimits(CatalogMode.CHALLENGE, (Filter)Filter.EXCLUDE));
        tam.putLimits("cite_mosaic2", (CatalogInfo)coverage2, (AccessLimits)new DataAccessLimits(CatalogMode.CHALLENGE, (Filter)Filter.INCLUDE));
        tam.putLimits("cite_nomosaic", (CatalogInfo)coverage, (AccessLimits)new CoverageAccessLimits(CatalogMode.HIDE, (Filter)Filter.EXCLUDE, null, null));
        WKTReader wkt = new WKTReader();
        MultiPolygon cropper = (MultiPolygon)wkt.read("MULTIPOLYGON(((140 -50, 150 -50, 150 -30, 140 -30, 140 -50)))");
        tam.putLimits("cite_cropmosaic", (CatalogInfo)coverage, (AccessLimits)new CoverageAccessLimits(CatalogMode.HIDE, (Filter)Filter.INCLUDE, cropper, null));
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Contains filter = ff.contains((Expression)ff.property("geometry"), (Expression)ff.literal((Object)cropper));
        tam.putLimits("cite_filtermosaic", (CatalogInfo)coverage, (AccessLimits)new CoverageAccessLimits(CatalogMode.HIDE, (Filter)filter, null, null));
    }

    @Test
    public void testNoMosaic() throws Exception {
        GWC.get().getConfig().setSecurityEnabled(true);
        this.setRequestAuth("cite", "cite");
        String path = "gwc/service/wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,-90,180,90&WIDTH=256&HEIGHT=256&transparent=false";
        MockHttpServletResponse response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        this.setRequestAuth("cite_nomosaic", "cite");
        response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)NOT_FOUND_ERROR_TYPE, (Object)response.getContentType());
        String str = this.string(this.getBinaryInputStream(response));
        Assert.assertTrue((boolean)str.contains("org.geotools.ows.ServiceException: Could not find layer sf:mosaic"));
    }

    @Test
    public void testPermissionMosaicTileWmts() throws Exception {
        this.doPermissionMosaicTileTest(layer -> String.format("gwc/service/wmts?LAYER=%s&FORMAT=image/png&SERVICE=WMTS&VERSION=1.0.0&REQUEST=GetTile&TILEMATRIXSET=EPSG:900913&TILEMATRIX=EPSG:900913:0&TILECOL=0&TILEROW=0", layer), SECURITY_ERROR_TYPE, NOT_FOUND_ERROR_TYPE);
    }

    Matcher<MockHttpServletResponse> hasBody(final Matcher<String> matcher) {
        return new BaseMatcher<MockHttpServletResponse>(){

            public boolean matches(Object item) {
                try {
                    return matcher.matches((Object)GWCDataSecurityTest.this.string(GWCDataSecurityTest.this.getBinaryInputStream((MockHttpServletResponse)item)));
                }
                catch (Exception e) {
                    return false;
                }
            }

            public void describeTo(Description description) {
                description.appendText("HTTP Response with body ").appendDescriptionOf((SelfDescribing)matcher);
            }

            public void describeMismatch(Object item, Description description) {
                description.appendText("body was: \n");
                try {
                    description.appendValue((Object)GWCDataSecurityTest.this.string(GWCDataSecurityTest.this.getBinaryInputStream((MockHttpServletResponse)item)));
                }
                catch (Exception e) {
                    description.appendText("\tcould not read body ").appendValue((Object)e.getMessage());
                }
            }
        };
    }

    Matcher<MockHttpServletResponse> addBodyOnFail(final Matcher<? extends MockHttpServletResponse> matcher) {
        return new BaseMatcher<MockHttpServletResponse>(){

            public boolean matches(Object item) {
                return matcher.matches(item);
            }

            public void describeTo(Description description) {
                matcher.describeTo(description);
            }

            public void describeMismatch(Object item, Description description) {
                matcher.describeMismatch(item, description);
                if (((MockHttpServletResponse)item).getContentType().startsWith("image")) {
                    description.appendText("\n  was an image");
                }
                try {
                    String body = GWCDataSecurityTest.this.string(GWCDataSecurityTest.this.getBinaryInputStream((MockHttpServletResponse)item));
                    description.appendText("\n  body:").appendValue((Object)body);
                }
                catch (Exception e) {
                    description.appendText("\n  could not get body:").appendValue((Object)e.getMessage());
                }
            }
        };
    }

    protected void doPermissionCropTileTest(BiFunction<String, long[], String> pathForLayer, String failFormat, TestGridset grid) throws Exception {
        String tileFormat = "image/png";
        String pathInBounds = pathForLayer.apply("sf:mosaic", grid.tileInBounds);
        String pathOutOfBounds = pathForLayer.apply("sf:mosaic", grid.tileOutOfBounds);
        GWC.get().getConfig().setSecurityEnabled(true);
        this.setRequestAuth("cite", "cite");
        MockHttpServletResponse response = this.getAsServletResponse(pathOutOfBounds);
        MatcherAssert.assertThat((Object)response, this.addBodyOnFail((Matcher<? extends MockHttpServletResponse>)Matchers.hasProperty((String)"contentType", (Matcher)Matchers.equalTo((Object)"image/png"))));
        this.setRequestAuth("cite_cropmosaic", "cite");
        response = this.getAsServletResponse(pathOutOfBounds);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"contentType", (Matcher)Matchers.equalTo((Object)failFormat)), this.hasBody((Matcher<String>)Matchers.containsString((String)"Not Authorized"))));
        response = this.getAsServletResponse(pathInBounds);
        MatcherAssert.assertThat((Object)response, this.addBodyOnFail((Matcher<? extends MockHttpServletResponse>)Matchers.hasProperty((String)"contentType", (Matcher)Matchers.equalTo((Object)"image/png"))));
    }

    protected void doPermissionMosaicTileTest(Function<String, String> pathForLayer, String secFailFormat, String otherFailFormat) throws Exception {
        String tileFormat = "image/png";
        String path = pathForLayer.apply("sf:mosaic");
        String path2 = pathForLayer.apply("sf:Mosaic2");
        GWC.get().getConfig().setSecurityEnabled(true);
        this.setRequestAuth("cite", "cite");
        MockHttpServletResponse response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        this.setRequestAuth("cite_mosaic2", "cite");
        response = this.getAsServletResponse(path2);
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        response = this.getAsServletResponse(path2);
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        this.setRequestAuth("cite", "cite");
        response = this.getAsServletResponse(path2);
        Assert.assertEquals((Object)secFailFormat, (Object)response.getContentType());
        MatcherAssert.assertThat((Object)this.string(this.getBinaryInputStream(response)), (Matcher)Matchers.containsString((String)"Not Authorized"));
        this.setRequestAuth("cite_mosaic2", "cite");
        response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)otherFailFormat, (Object)response.getContentType());
        MatcherAssert.assertThat((Object)this.string(this.getBinaryInputStream(response)), (Matcher)Matchers.containsString((String)"Could not find layer sf:mosaic"));
    }

    @Test
    public void testPermissionMosaicTileGmaps() throws Exception {
        this.doPermissionMosaicTileTest(layer -> String.format("gwc/service/gmaps?LAYERS=%s&FORMAT=image/png&ZOOM=0&X=0&Y=0", layer), SECURITY_ERROR_TYPE, NOT_FOUND_ERROR_TYPE);
    }

    @Test
    public void testPermissionMosaicTileMGmaps() throws Exception {
        this.doPermissionMosaicTileTest(layer -> String.format("gwc/service/mgmaps?LAYERS=%s&FORMAT=image/png&ZOOM=17&X=0&Y=0", layer), SECURITY_ERROR_TYPE, NOT_FOUND_ERROR_TYPE);
    }

    @Test
    public void testPermissionMosaicTileTms() throws Exception {
        this.doPermissionMosaicTileTest(layer -> String.format("gwc/service/tms/1.0.0/%s@EPSG:900913@png/0/0/0.png", layer), SECURITY_ERROR_TYPE, NOT_FOUND_ERROR_TYPE);
    }

    @Test
    public void testPermissionMosaicTileKml() throws Exception {
        this.doPermissionMosaicTileTest(layer -> String.format("gwc/service/kml/%s/x0y0z0.png", layer), SECURITY_ERROR_TYPE, NOT_FOUND_ERROR_TYPE);
    }

    @Test
    public void testPermissionCropTileTms() throws Exception {
        this.doPermissionCropTileTest((layer, index) -> String.format("gwc/service/tms/1.0.0/%s@EPSG:900913@png/%d/%d/%d.png", layer, index[2], index[0], index[1]), SECURITY_ERROR_TYPE, TestGridset.GoogleMapsCompatible);
    }

    @Test
    public void testPermissionCropTileWmts() throws Exception {
        this.doPermissionCropTileTest((layer, index) -> String.format("gwc/service/wmts?LAYER=%s&FORMAT=image/png&SERVICE=WMTS&VERSION=1.0.0&REQUEST=GetTile&TILEMATRIXSET=EPSG:900913&TILEMATRIX=EPSG:900913:%d&TILECOL=%d&TILEROW=%d", layer, index[2], index[0], (long)(1 << (int)index[2]) - index[1] - 1L), SECURITY_ERROR_TYPE, TestGridset.GoogleMapsCompatible);
    }

    @Test
    public void testPermissionCropTileGmaps() throws Exception {
        this.doPermissionCropTileTest((layer, index) -> String.format("gwc/service/gmaps?LAYERS=%s&FORMAT=image/png&ZOOM=%d&X=%d&Y=%d", layer, index[2], index[0], (long)(1 << (int)index[2]) - index[1] - 1L), SECURITY_ERROR_TYPE, TestGridset.GoogleMapsCompatible);
    }

    @Test
    public void testPermissionCropTileMGmaps() throws Exception {
        this.doPermissionCropTileTest((layer, index) -> String.format("gwc/service/mgmaps?LAYERS=%s&FORMAT=image/png&ZOOM=%d&X=%d&Y=%d", layer, 17L - index[2], index[0], (long)(1 << (int)index[2]) - index[1] - 1L), SECURITY_ERROR_TYPE, TestGridset.GoogleMapsCompatible);
    }

    @Test
    public void testPermissionCropTileKml() throws Exception {
        this.doPermissionCropTileTest((layer, index) -> String.format("gwc/service/kml/%s/x%dy%dz%d.png", layer, index[0], index[1], index[2]), SECURITY_ERROR_TYPE, TestGridset.GlobalCRS84Geometric);
    }

    @Test
    public void testPermissionCropTileBing() throws Exception {
        this.doPermissionCropTileTest((layer, index) -> {
            long col = index[0];
            long row = (long)(1 << (int)index[2]) - index[1] - 1L;
            long zoom = index[2];
            long key = 0L;
            int i = 0;
            while ((long)i < zoom) {
                key |= (col & (long)(1 << i)) != 0L ? (long)(1 << i * 2) : 0L;
                key |= (row & (long)(1 << i)) != 0L ? (long)(1 << i * 2 + 1) : 0L;
                ++i;
            }
            String quadKey = Long.toString(key, 4);
            MatcherAssert.assertThat((Object)VEConverter.convert((String)quadKey), (Matcher)Matchers.equalTo((Object)index));
            return String.format("gwc/service/ve?layers=%s&format=image/png&quadKey=%s", layer, quadKey);
        }, SECURITY_ERROR_TYPE, TestGridset.GoogleMapsCompatible);
    }

    protected void doPermissionKmlOverlay(Function<String, String> pathForLayer, String overlayFormat) throws Exception {
        String failFormat = NOT_FOUND_ERROR_TYPE;
        String path = pathForLayer.apply("sf:mosaic");
        String path2 = pathForLayer.apply("sf:Mosaic2");
        GWC.get().getConfig().setSecurityEnabled(true);
        this.setRequestAuth("cite", "cite");
        MockHttpServletResponse response = this.getAsServletResponse(path);
        String mime = this.getBaseMimeType(response.getContentType());
        Assert.assertEquals((Object)overlayFormat, (Object)mime);
        this.setRequestAuth("cite_mosaic2", "cite");
        response = this.getAsServletResponse(path2);
        mime = this.getBaseMimeType(response.getContentType());
        Assert.assertEquals((Object)overlayFormat, (Object)mime);
        this.setRequestAuth("cite_mosaic2", "cite");
        response = this.getAsServletResponse(path);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"contentType", (Matcher)Matchers.equalTo((Object)NOT_FOUND_ERROR_TYPE)), this.hasBody((Matcher<String>)Matchers.containsString((String)"Could not find layer sf:mosaic"))));
    }

    @Test
    public void testPermissionMosaicKmlRasterSuperOverlay() throws Exception {
        this.doPermissionKmlOverlay(layer -> String.format("gwc/service/kml/%s.png.kmz", layer), "application/vnd.google-earth.kmz");
    }

    @Test
    public void testPermissionMosaicKmlVectorSuperOverlay() throws Exception {
        this.doPermissionKmlOverlay(layer -> String.format("gwc/service/kml/%s.kml.kmz", layer), "application/vnd.google-earth.kmz");
    }

    @Test
    public void testCroppedMosaic() throws Exception {
        this.setRequestAuth("cite", "cite");
        String path = "gwc/service/wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,-90,180,90&WIDTH=256&HEIGHT=256&transparent=false";
        MockHttpServletResponse response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        this.setRequestAuth("cite_cropmosaic", "cite");
        path = "gwc/service/wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,-90,180,90&WIDTH=256&HEIGHT=256&transparent=false";
        response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)SECURITY_ERROR_TYPE, (Object)response.getContentType());
        String str = this.string(this.getBinaryInputStream(response));
        Assert.assertTrue((boolean)str.contains("Not Authorized"));
        path = "gwc/service/wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=143.4375,-42.1875,146.25,-39.375&WIDTH=256&HEIGHT=256&transparent=false";
        response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
    }

    @Test
    public void testFilterMosaic() throws Exception {
        this.setRequestAuth("cite", "cite");
        String path = "gwc/service/wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,-90,180,90&WIDTH=256&HEIGHT=256&transparent=false";
        MockHttpServletResponse response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        this.setRequestAuth("cite_filtermosaic", "cite");
        path = "gwc/service/wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,-90,180,90&WIDTH=256&HEIGHT=256&transparent=false";
        response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)SECURITY_ERROR_TYPE, (Object)response.getContentType());
        String str = this.string(this.getBinaryInputStream(response));
        MatcherAssert.assertThat((Object)str, (Matcher)Matchers.containsString((String)"Not Authorized"));
        path = "gwc/service/wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=143.4375,-42.1875,146.25,-39.375&WIDTH=256&HEIGHT=256&transparent=false";
        response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
    }

    @Test
    public void testLayerGroup() throws Exception {
        this.setRequestAuth(null, null);
        String path = "gwc/service/wms?bgcolor=0x000000&LAYERS=nature&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,-90,180,90&WIDTH=256&HEIGHT=256&transparent=false";
        MockHttpServletResponse response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        TestResourceAccessManager tam = (TestResourceAccessManager)applicationContext.getBean("testResourceAccessManager");
        LayerInfo lakes = this.getCatalog().getLayerByName(this.getLayerId(MockData.LAKES));
        tam.putLimits("cite_nogroup", (CatalogInfo)lakes, (AccessLimits)new DataAccessLimits(CatalogMode.HIDE, (Filter)Filter.EXCLUDE));
        tam.putLimits("cite", (CatalogInfo)lakes, (AccessLimits)new DataAccessLimits(CatalogMode.HIDE, (Filter)Filter.INCLUDE));
        this.setRequestAuth("cite_nogroup", "cite");
        response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)NOT_FOUND_ERROR_TYPE, (Object)response.getContentType());
        String str = this.string(this.getBinaryInputStream(response));
        Assert.assertTrue((boolean)str.contains("org.geotools.ows.ServiceException: Could not find layer nature"));
        this.setRequestAuth("cite", "cite");
        response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
    }

    @Test
    public void testWorkspacedLayerGroup() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerInfo lakes = catalog.getLayerByName(this.getLayerId(MockData.LAKES));
        WorkspaceInfo ws = lakes.getResource().getStore().getWorkspace();
        LayerGroupInfo workspacedLayerGroup = this.getCatalog().getFactory().createLayerGroup();
        workspacedLayerGroup.setWorkspace(ws);
        workspacedLayerGroup.setName("citeGroup");
        workspacedLayerGroup.getLayers().add(lakes);
        workspacedLayerGroup.getStyles().add(null);
        catalog.add(workspacedLayerGroup);
        GWC.get().getConfig().setDirectWMSIntegrationEnabled(true);
        this.setRequestAuth(null, null);
        String path = ws.getName() + "/wms?bgcolor=0x000000&LAYERS=" + workspacedLayerGroup.prefixedName() + "&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,-90,180,90&WIDTH=256&HEIGHT=256&transparent=false&tiled=true";
        MockHttpServletResponse response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
    }

    static enum TestGridset {
        GlobalCRS84Geometric("EPSG:4326", new long[]{7489L, 1245L, 12L}, new long[]{4096L, 2048L, 12L}),
        GoogleMapsCompatible("EPSG:900913", new long[]{7489L, 3237L, 13L}, new long[]{4096L, 4096L, 13L});

        public final String name;
        public final long[] tileInBounds;
        public final long[] tileOutOfBounds;

        private TestGridset(String name, long[] tileInBounds, long[] tileOutOfBounds) {
            this.name = name;
            this.tileInBounds = tileInBounds;
            this.tileOutOfBounds = tileOutOfBounds;
        }
    }
}

