/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.utils.DateUtils;
import org.awaitility.Awaitility;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupHelper;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.GeoServerLoader;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.gwc.ConfigurableQuotaStore;
import org.geoserver.gwc.ConfigurableQuotaStoreProvider;
import org.geoserver.gwc.DummyQuotaStore;
import org.geoserver.gwc.FakeHttpServletRequest;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.HttpRequestRecorderCallback;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.CatalogConfiguration;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.wmts.WMTSInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.util.DimensionWarning;
import org.geoserver.wms.WMSDimensionsTestSupport;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.XMLGridSet;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.diskquota.jdbc.JDBCConfiguration;
import org.geowebcache.diskquota.jdbc.JDBCQuotaStore;
import org.geowebcache.diskquota.jdbc.JDBCQuotaStoreFactory;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeType;
import org.geowebcache.seed.TruncateAllRequest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class GWCIntegrationTest
extends GeoServerSystemTestSupport {
    private static final Map<String, String> WMTS_NAMESPACES_10 = new HashMap<String, String>();
    private static final XpathEngine WMTS_XPATH_10;
    static final String SIMPLE_LAYER_GROUP = "SIMPLE_LAYER_GROUP";
    static final String FLAT_LAYER_GROUP = "flatLayerGroup";
    static final String NESTED_LAYER_GROUP = "nestedLayerGroup";
    static final String CONTAINER_LAYER_GROUP = "containerLayerGroup";
    static final String WORKSPACED_LAYER_GROUP = "workspacedLayerGroup";
    static final String TEST_WORKSPACE_NAME = "testWorkspace";
    static final String TEST_WORKSPACE_URI = "http://geoserver.org/GWCIntegerationTest/testWorkspace";
    static final String WORKSPACED_STYLE_NAME = "workspacedStyle";
    static final String WORKSPACED_STYLE_FILE = "workspacedStyle.sld";
    static final String WORKSPACED_LAYER = "workspacedLayer";
    static final QName WORKSPACED_LAYER_QNAME;
    static QName BASIC_POLYGONS_NO_CRS;
    static QName V_TIME_ELEVATION;

    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("gwc-integration-test.xml");
    }

    @After
    public void cleanupDispatcherRequest() {
        Dispatcher.REQUEST.remove();
    }

    private void prepareDataDirectory(SystemTestData testData) throws Exception {
        Catalog catalog = this.getCatalog();
        testData.addWorkspace(TEST_WORKSPACE_NAME, TEST_WORKSPACE_URI, catalog);
        WorkspaceInfo wi = catalog.getWorkspaceByName(TEST_WORKSPACE_NAME);
        testData.addStyle(wi, WORKSPACED_STYLE_NAME, WORKSPACED_STYLE_FILE, ((Object)((Object)this)).getClass(), catalog);
        MatcherAssert.assertThat((Object)catalog.getStyleByName(wi, WORKSPACED_STYLE_NAME), (Matcher)Matchers.describedAs((String)"Style %0 should be in workspace %1.", (Matcher)Matchers.not((Matcher)Matchers.nullValue()), (Object[])new Object[]{WORKSPACED_STYLE_NAME, TEST_WORKSPACE_NAME}));
        HashMap<SystemTestData.LayerProperty, String> props = new HashMap<SystemTestData.LayerProperty, String>();
        props.put(SystemTestData.LayerProperty.STYLE, WORKSPACED_STYLE_NAME);
        testData.addVectorLayer(WORKSPACED_LAYER_QNAME, props, ((Object)((Object)this)).getClass(), catalog);
        LayerInfo li = catalog.getLayerByName(this.getLayerId(WORKSPACED_LAYER_QNAME));
        li.setDefaultStyle(catalog.getStyleByName(wi, WORKSPACED_STYLE_NAME));
        catalog.save(li);
        this.createLayerGroup(SIMPLE_LAYER_GROUP, MockData.BUILDINGS, MockData.BRIDGES);
        GWC.get().getConfig().setDirectWMSIntegrationEnabled(false);
        props = new HashMap();
        props.put(SystemTestData.LayerProperty.SRS, "4326");
        props.put(SystemTestData.LayerProperty.PROJECTION_POLICY, (String)ProjectionPolicy.FORCE_DECLARED);
        testData.addVectorLayer(BASIC_POLYGONS_NO_CRS, null, "BasicPolygonsNoCrs.properties", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("stylegroup", "stylegroup.sld", GWCIntegrationTest.class, catalog);
        LayerGroupInfo group = catalog.getFactory().createLayerGroup();
        group.getLayers().add(null);
        group.getStyles().add(catalog.getStyleByName("stylegroup"));
        group.setName("stylegroup");
        new LayerGroupHelper(group).calculateBounds();
        catalog.add(group);
        testData.addVectorLayer(V_TIME_ELEVATION, null, "TimeElevation.properties", WMSDimensionsTestSupport.class, catalog);
        HttpRequestRecorderCallback.reset();
    }

    @Before
    public void cleanup() throws Exception {
        SystemTestData testData = (SystemTestData)this.getTestData();
        for (File f : testData.getDataDirectoryRoot().listFiles()) {
            FileUtils.deleteQuietly((File)f);
        }
        testData.setUp();
        testData.setUpDefault();
        this.getGeoServer().reload();
        this.prepareDataDirectory(testData);
    }

    @Before
    public void resetMetatileThreads() throws Exception {
        this.setMetatileThreads(null);
    }

    private void setMetatileThreads(Integer threadCount) throws IOException {
        GWC gwc = GWC.get();
        GWCConfig config = gwc.getConfig();
        if (!Objects.equals(threadCount, config.getMetaTilingThreads())) {
            config.setMetaTilingThreads(threadCount);
            gwc.saveConfig(config);
        }
    }

    protected GridSet namedGridsetCopy(String newName, GridSet oldGridset) {
        XMLGridSet xmlGridSet = new XMLGridSet(oldGridset);
        xmlGridSet.setName(newName);
        GridSet newGridset = xmlGridSet.makeGridSet();
        return newGridset;
    }

    @Test
    public void testPngIntegration() throws Exception {
        String layerId = this.getLayerId(MockData.BASIC_POLYGONS);
        MockHttpServletResponse sr = this.getAsServletResponse("gwc/service/wmts?request=GetTile&layer=" + layerId + "&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0");
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr.getContentType());
    }

    @Test
    public void testRequestReplacement() throws Exception {
        String layerId = this.getLayerId(MockData.BASIC_POLYGONS);
        MockHttpServletResponse sr = this.getAsServletResponse("gwc/service/wmts?request=GetTile&layer=" + layerId + "&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=1");
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr.getContentType());
    }

    @Test
    public void testWorkspacedStyle() throws Exception {
        String layerId = this.getLayerId(WORKSPACED_LAYER_QNAME);
        MockHttpServletResponse sr = this.getAsServletResponse("gwc/service/wmts?request=GetTile&layer=" + layerId + "&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0");
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr.getContentType());
    }

    @Test
    public void testGetLegendGraphics() throws Exception {
        String layerId = this.getLayerId(MockData.BASIC_POLYGONS);
        MockHttpServletResponse sr = this.getAsServletResponse("gwc/service/wms?service=wms&version=1.1.1&request=GetLegendGraphic&layer=" + layerId + "&style=&format=image/png");
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr.getContentType());
    }

    @Test
    public void testCachingHeadersSingleLayer() throws Exception {
        String layerId = this.getLayerId(MockData.BASIC_POLYGONS);
        this.setCachingMetadata(layerId, true, 7200);
        MockHttpServletResponse sr = this.getAsServletResponse("gwc/service/wmts?request=GetTile&layer=" + layerId + "&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0");
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr.getContentType());
        Assert.assertEquals((Object)"max-age=7200, must-revalidate", (Object)sr.getHeader("Cache-Control"));
    }

    @Test
    public void testCachingHeadersSingleLayerNoHeaders() throws Exception {
        String layerId = this.getLayerId(MockData.BASIC_POLYGONS);
        this.setCachingMetadata(layerId, false, -1);
        MockHttpServletResponse sr = this.getAsServletResponse("gwc/service/wmts?request=GetTile&layer=" + layerId + "&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0");
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr.getContentType());
        Assert.assertEquals((Object)"no-cache, no-store, must-revalidate", (Object)sr.getHeader("Cache-Control"));
    }

    @Test
    public void testCachingHeadersFlatLayerGroup() throws Exception {
        String bpLayerId = this.getLayerId(MockData.BASIC_POLYGONS);
        this.setCachingMetadata(bpLayerId, true, 7200);
        String mpLayerId = this.getLayerId(MockData.MPOINTS);
        this.setCachingMetadata(mpLayerId, true, 1000);
        LayerGroupInfo lg = this.getCatalog().getFactory().createLayerGroup();
        lg.setName(FLAT_LAYER_GROUP);
        lg.getLayers().add(this.getCatalog().getLayerByName(bpLayerId));
        lg.getLayers().add(this.getCatalog().getLayerByName(mpLayerId));
        lg.getStyles().add(null);
        lg.getStyles().add(null);
        new CatalogBuilder(this.getCatalog()).calculateLayerGroupBounds(lg);
        this.getCatalog().add(lg);
        MockHttpServletResponse sr = this.getAsServletResponse("gwc/service/wmts?request=GetTile&layer=flatLayerGroup&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0");
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr.getContentType());
        Assert.assertEquals((Object)"max-age=1000, must-revalidate", (Object)sr.getHeader("Cache-Control"));
    }

    @Test
    public void testCachingHeadersNestedLayerGroup() throws Exception {
        String bpLayerId = this.getLayerId(MockData.BASIC_POLYGONS);
        this.setCachingMetadata(bpLayerId, true, 7200);
        String mpLayerId = this.getLayerId(MockData.MPOINTS);
        this.setCachingMetadata(mpLayerId, true, 1000);
        CatalogBuilder builder = new CatalogBuilder(this.getCatalog());
        LayerGroupInfo nested = this.getCatalog().getFactory().createLayerGroup();
        nested.setName(NESTED_LAYER_GROUP);
        nested.getLayers().add(this.getCatalog().getLayerByName(bpLayerId));
        nested.getStyles().add(null);
        builder.calculateLayerGroupBounds(nested);
        this.getCatalog().add(nested);
        LayerGroupInfo container = this.getCatalog().getFactory().createLayerGroup();
        container.setName(CONTAINER_LAYER_GROUP);
        container.getLayers().add(this.getCatalog().getLayerByName(mpLayerId));
        container.getLayers().add(this.getCatalog().getLayerGroupByName(NESTED_LAYER_GROUP));
        container.getStyles().add(null);
        container.getStyles().add(null);
        builder.calculateLayerGroupBounds(container);
        this.getCatalog().add(container);
        MockHttpServletResponse sr = this.getAsServletResponse("gwc/service/wmts?request=GetTile&layer=nestedLayerGroup&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0");
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr.getContentType());
        Assert.assertEquals((Object)"max-age=7200, must-revalidate", (Object)sr.getHeader("Cache-Control"));
        sr = this.getAsServletResponse("gwc/service/wmts?request=GetTile&layer=containerLayerGroup&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0");
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr.getContentType());
        Assert.assertEquals((Object)"max-age=1000, must-revalidate", (Object)sr.getHeader("Cache-Control"));
    }

    private void setCachingMetadata(String layerId, boolean cachingEnabled, int cacheAgeMax) {
        FeatureTypeInfo ft = (FeatureTypeInfo)this.getCatalog().getResourceByName(layerId, FeatureTypeInfo.class);
        ft.getMetadata().put("cachingEnabled", (Serializable)Boolean.valueOf(cachingEnabled));
        ft.getMetadata().put("cacheAgeMax", (Serializable)Integer.valueOf(cacheAgeMax));
        this.getCatalog().save((ResourceInfo)ft);
    }

    @Test
    public void testDirectWMSIntegration() throws Exception {
        GWC gwc = GWC.get();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String request = this.buildGetMap(true, layerName, "EPSG:4326", null);
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        Assert.assertNull((Object)response.getHeader("geowebcache-tile-index"));
        String tiledRequest = request + "&tiled=true";
        response = this.getAsServletResponse(tiledRequest);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("geowebcache-tile-index"));
    }

    @Test
    public void testDirectWMSIntegrationWithRequireTileParameter() throws Exception {
        GWC gwc = GWC.get();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String request = this.buildGetMap(true, layerName, "EPSG:4326", null);
        MockHttpServletResponse response = this.getAsServletResponse(request);
        gwc.getConfig().setRequireTiledParameter(true);
        response = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        Assert.assertNull((Object)response.getHeader("geowebcache-tile-index"));
        gwc.getConfig().setRequireTiledParameter(false);
        response = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("geowebcache-tile-index"));
    }

    @Test
    public void testDirectWMSIntegrationResponseHeaders() throws Exception {
        GWC gwc = GWC.get();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String request = this.buildGetMap(true, layerName, "EPSG:4326", null) + "&tiled=true";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        Assert.assertEquals((Object)layerName, (Object)response.getHeader("geowebcache-layer"));
        Assert.assertEquals((Object)"[0, 0, 0]", (Object)response.getHeader("geowebcache-tile-index"));
        Assert.assertEquals((Object)"-180.0,-90.0,0.0,90.0", (Object)response.getHeader("geowebcache-tile-bounds"));
        Assert.assertEquals((Object)"EPSG:4326", (Object)response.getHeader("geowebcache-gridset"));
        Assert.assertEquals((Object)"EPSG:4326", (Object)response.getHeader("geowebcache-crs"));
    }

    @Test
    public void testDirectWMSIntegrationResponseHeaders13() throws Exception {
        GWC gwc = GWC.get();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String request = "wms?service=wms&version=1.3.0&request=GetMap&styles=&layers=" + layerName + "&srs=EPSG:4326&bbox=-90,-180,90,0&format=image/png&width=256&height=256&tiled=true";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        Assert.assertEquals((Object)layerName, (Object)response.getHeader("geowebcache-layer"));
        Assert.assertEquals((Object)"[0, 0, 0]", (Object)response.getHeader("geowebcache-tile-index"));
        Assert.assertEquals((Object)"-180.0,-90.0,0.0,90.0", (Object)response.getHeader("geowebcache-tile-bounds"));
        Assert.assertEquals((Object)"EPSG:4326", (Object)response.getHeader("geowebcache-gridset"));
        Assert.assertEquals((Object)"EPSG:4326", (Object)response.getHeader("geowebcache-crs"));
    }

    @Test
    public void testDirectWMSIntegrationIfModifiedSinceSupport() throws Exception {
        GWC gwc = GWC.get();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String url = this.buildGetMap(true, layerName, "EPSG:4326", null) + "&tiled=true";
        MockHttpServletResponse response = this.getAsServletResponse(url);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        String lastModifiedHeader = response.getHeader("Last-Modified");
        Assert.assertNotNull((Object)lastModifiedHeader);
        Date lastModified = DateUtils.parseDate((String)lastModifiedHeader);
        MockHttpServletRequest httpReq = this.createGetRequest(url);
        httpReq.addHeader("If-Modified-Since", (Object)lastModifiedHeader);
        response = this.dispatch((HttpServletRequest)httpReq, "UTF-8");
        Assert.assertEquals((long)304L, (long)response.getStatus());
        Date past = new Date(lastModified.getTime() - 5000L);
        String ifModifiedSince = DateUtils.formatDate((Date)past);
        httpReq = this.createGetRequest(url);
        httpReq.addHeader("If-Modified-Since", (Object)ifModifiedSince);
        response = this.dispatch((HttpServletRequest)httpReq, "UTF-8");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Date future = new Date(lastModified.getTime() + 5000L);
        ifModifiedSince = DateUtils.formatDate((Date)future);
        httpReq = this.createGetRequest(url);
        httpReq.addHeader("If-Modified-Since", (Object)ifModifiedSince);
        response = this.dispatch((HttpServletRequest)httpReq, "UTF-8");
        Assert.assertEquals((long)304L, (long)response.getStatus());
    }

    private MockHttpServletRequest createGetRequest(String path) {
        MockHttpServletRequest httpReq = this.createRequest(path);
        httpReq.setMethod("GET");
        httpReq.setContent(new byte[0]);
        return httpReq;
    }

    @Test
    public void testDirectWMSIntegrationMaxAge() throws Exception {
        GWC gwc = GWC.get();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String path = this.buildGetMap(true, layerName, "EPSG:4326", null) + "&tiled=true";
        String qualifiedName = super.getLayerId(MockData.BASIC_POLYGONS);
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)gwc.getTileLayerByName(qualifiedName);
        ((LayerInfo)tileLayer.getPublishedInfo()).getResource().getMetadata().put("cachingEnabled", (Serializable)((Object)"true"));
        ((LayerInfo)tileLayer.getPublishedInfo()).getResource().getMetadata().put("cacheAgeMax", (Serializable)Integer.valueOf(3456));
        MockHttpServletResponse response = this.getAsServletResponse(path);
        String cacheControl = response.getHeader("Cache-Control");
        Assert.assertEquals((Object)"max-age=3456, must-revalidate", (Object)cacheControl);
        Assert.assertNotNull((Object)response.getHeader("Last-Modified"));
        ((LayerInfo)tileLayer.getPublishedInfo()).getResource().getMetadata().put("cachingEnabled", (Serializable)((Object)"false"));
        response = this.getAsServletResponse(path);
        this.checkNoCacheHeaders(response);
        ((LayerInfo)tileLayer.getPublishedInfo()).getResource().getMetadata().put("cachingEnabled", (Serializable)Boolean.FALSE);
        response = this.getAsServletResponse(path);
        this.checkNoCacheHeaders(response);
    }

    @Test
    public void testDirectWMSIntegrationWithVirtualServices() throws Exception {
        GWC gwc = GWC.get();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String qualifiedName = super.getLayerId(MockData.BASIC_POLYGONS);
        String localName = MockData.BASIC_POLYGONS.getLocalPart();
        TileLayer tileLayer = gwc.getTileLayerByName(qualifiedName);
        Assert.assertNotNull((Object)tileLayer);
        boolean directWMSIntegrationEndpoint = true;
        String request = MockData.CITE_PREFIX + "/" + this.buildGetMap(directWMSIntegrationEndpoint, localName, "EPSG:4326", null, tileLayer) + "&tiled=true";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        Assert.assertEquals((Object)qualifiedName, (Object)response.getHeader("geowebcache-layer"));
    }

    @Test
    public void testDirectWMSIntegrationWithVirtualServicesAndWorkspacedStyle() throws Exception {
        GWC gwc = GWC.get();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String qualifiedName = super.getLayerId(WORKSPACED_LAYER_QNAME);
        String localName = WORKSPACED_LAYER_QNAME.getLocalPart();
        TileLayer tileLayer = gwc.getTileLayerByName(qualifiedName);
        Assert.assertNotNull((Object)tileLayer);
        boolean directWMSIntegrationEndpoint = true;
        String request = "testWorkspace/" + this.buildGetMap(directWMSIntegrationEndpoint, localName, "EPSG:4326", null, tileLayer) + "&tiled=true";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        Assert.assertEquals((Object)qualifiedName, (Object)response.getHeader("geowebcache-layer"));
        MatcherAssert.assertThat((Object)response.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"MISS"));
        MockHttpServletResponse response2 = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response2.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response2.getContentType());
        Assert.assertEquals((Object)qualifiedName, (Object)response2.getHeader("geowebcache-layer"));
        MatcherAssert.assertThat((Object)response2.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"HIT"));
        request = "testWorkspace/" + this.buildGetMap(directWMSIntegrationEndpoint, localName, "EPSG:4326", WORKSPACED_STYLE_NAME, tileLayer) + "&tiled=true";
        MockHttpServletResponse response3 = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response3.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response3.getContentType());
        Assert.assertEquals((Object)qualifiedName, (Object)response3.getHeader("geowebcache-layer"));
        MatcherAssert.assertThat((Object)response3.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"HIT"));
        String oldWorkspaceName = TEST_WORKSPACE_NAME;
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName(oldWorkspaceName);
        String newWorkspaceName = oldWorkspaceName + "_renamed";
        ws.setName(newWorkspaceName);
        this.getCatalog().save(ws);
        request = newWorkspaceName + "/" + this.buildGetMap(directWMSIntegrationEndpoint, localName, "EPSG:4326", WORKSPACED_STYLE_NAME, tileLayer) + "&tiled=true";
        MockHttpServletResponse response4 = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response4.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response4.getContentType());
        Assert.assertEquals((Object)(newWorkspaceName + ":workspacedLayer"), (Object)response4.getHeader("geowebcache-layer"));
        MatcherAssert.assertThat((Object)response4.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"HIT"));
    }

    @Test
    public void testAutomaticTruncationDefaultStyleContentsChange() throws Exception {
        GWC gwc = GWC.get();
        Catalog catalog = this.getCatalog();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String qualifiedName = super.getLayerId(WORKSPACED_LAYER_QNAME);
        TileLayer tileLayer = gwc.getTileLayerByName(qualifiedName);
        Assert.assertNotNull((Object)tileLayer);
        LayerInfo layer = catalog.getLayerByName(qualifiedName);
        Assert.assertNotNull((Object)layer);
        String request = "gwc/service/wmts?request=GetTile&layer=" + qualifiedName + "&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        MatcherAssert.assertThat((Object)response.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"MISS"));
        MockHttpServletResponse response2 = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response2.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response2.getContentType());
        MatcherAssert.assertThat((Object)response2.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"HIT"));
        StyleInfo styleToRewrite = layer.getDefaultStyle();
        StyleInfo generic = catalog.getStyleByName("generic");
        catalog.getResourcePool().writeStyle(styleToRewrite, new GeoServerDataDirectory(catalog.getResourceLoader()).style(generic).in());
        catalog.save(styleToRewrite);
        this.waitTileBreederCompletion();
        MockHttpServletResponse response3 = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response3.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response3.getContentType());
        MatcherAssert.assertThat((Object)response3.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"MISS"));
    }

    @Test
    public void testAutomaticTruncationDefaultStyleChange() throws Exception {
        GWC gwc = GWC.get();
        Catalog catalog = this.getCatalog();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String qualifiedName = super.getLayerId(WORKSPACED_LAYER_QNAME);
        TileLayer tileLayer = gwc.getTileLayerByName(qualifiedName);
        Assert.assertNotNull((Object)tileLayer);
        LayerInfo layer = catalog.getLayerByName(qualifiedName);
        Assert.assertNotNull((Object)layer);
        String request = "gwc/service/wmts?request=GetTile&layer=" + qualifiedName + "&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        MatcherAssert.assertThat((Object)response.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"MISS"));
        MockHttpServletResponse response2 = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response2.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response2.getContentType());
        MatcherAssert.assertThat((Object)response2.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"HIT"));
        layer.setDefaultStyle(catalog.getStyleByName("generic"));
        catalog.save(layer);
        this.waitTileBreederCompletion();
        MockHttpServletResponse response3 = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response3.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response3.getContentType());
        MatcherAssert.assertThat((Object)response3.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"MISS"));
    }

    @Test
    public void testAutomaticTruncationLayerStyleChange() throws Exception {
        GWC gwc = GWC.get();
        Catalog catalog = this.getCatalog();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String qualifiedName = super.getLayerId(WORKSPACED_LAYER_QNAME);
        TileLayer tileLayer = gwc.getTileLayerByName(qualifiedName);
        Assert.assertNotNull((Object)tileLayer);
        LayerInfo layer = catalog.getLayerByName(qualifiedName);
        Assert.assertNotNull((Object)layer);
        layer.getStyles().add(catalog.getStyleByName("generic"));
        catalog.save(layer);
        layer = catalog.getLayerByName(qualifiedName);
        String request = "gwc/service/wmts?request=GetTile&layer=" + qualifiedName + "&style=generic&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        MatcherAssert.assertThat((Object)response.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"MISS"));
        MockHttpServletResponse response2 = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response2.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response2.getContentType());
        MatcherAssert.assertThat((Object)response2.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"HIT"));
        layer.getStyles().remove(catalog.getStyleByName("generic"));
        catalog.save(layer);
        layer = catalog.getLayerByName(qualifiedName);
        layer.getStyles().add(catalog.getStyleByName("generic"));
        catalog.save(layer);
        this.waitTileBreederCompletion();
        MockHttpServletResponse response3 = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response3.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response3.getContentType());
        MatcherAssert.assertThat((Object)response3.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"MISS"));
    }

    @Test
    public void testAutomaticTruncationLayerStyleContentsChange() throws Exception {
        GWC gwc = GWC.get();
        Catalog catalog = this.getCatalog();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String qualifiedName = super.getLayerId(WORKSPACED_LAYER_QNAME);
        TileLayer tileLayer = gwc.getTileLayerByName(qualifiedName);
        Assert.assertNotNull((Object)tileLayer);
        LayerInfo layer = catalog.getLayerByName(qualifiedName);
        Assert.assertNotNull((Object)layer);
        layer.getStyles().add(catalog.getStyleByName("generic"));
        catalog.save(layer);
        String request = "gwc/service/wmts?request=GetTile&layer=" + qualifiedName + "&style=generic&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        MatcherAssert.assertThat((Object)response.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"MISS"));
        MockHttpServletResponse response2 = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response2.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response2.getContentType());
        MatcherAssert.assertThat((Object)response2.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"HIT"));
        StyleInfo styleToRewrite = catalog.getStyleByName("generic");
        try (InputStream is = GeoServerLoader.class.getResourceAsStream("default_generic.sld");){
            catalog.getResourcePool().writeStyle(styleToRewrite, is);
        }
        catalog.save(styleToRewrite);
        this.waitTileBreederCompletion();
        MockHttpServletResponse response3 = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response3.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response3.getContentType());
        MatcherAssert.assertThat((Object)response3.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"MISS"));
    }

    @Test
    public void testAutomaticTruncationFeatureChange() throws Exception {
        GWC gwc = GWC.get();
        Catalog catalog = this.getCatalog();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String qualifiedName = super.getLayerId(WORKSPACED_LAYER_QNAME);
        TileLayer tileLayer = gwc.getTileLayerByName(qualifiedName);
        Assert.assertNotNull((Object)tileLayer);
        LayerInfo layer = catalog.getLayerByName(qualifiedName);
        Assert.assertNotNull((Object)layer);
        String request = "gwc/service/wmts?request=GetTile&layer=" + qualifiedName + "&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        this.waitTileBreederCompletion();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        MatcherAssert.assertThat((Object)response.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"MISS"));
        MockHttpServletResponse response2 = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response2.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response2.getContentType());
        MatcherAssert.assertThat((Object)response2.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"HIT"));
        String wfsInsert = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:testWorkspace=\"http://geoserver.org/GWCIntegerationTest/testWorkspace\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.0.0/WFS-transaction.xsd http://geoserver.org/GWCIntegerationTest/testWorkspace http://localhost:8080/geoserver/wfs/DescribeFeatureType?typename=testWorkspace:workspacedLayer\">\n    <wfs:Insert>\n        <testWorkspace:workspacedLayer>\n            <testWorkspace:location>\n                    <gml:Point srsName=\"http://www.opengis.net/gml/srs/epsg.xml#4326\" >\n                      <gml:coordinates decimal=\".\" cs=\",\" ts=\" \">0,0</gml:coordinates>\n                    </gml:Point>\n            </testWorkspace:location>\n            <testWorkspace:name>origin</testWorkspace:name>\n            <testWorkspace:value>0</testWorkspace:value>\n        </testWorkspace:workspacedLayer>\n    </wfs:Insert>\n</wfs:Transaction>";
        String wfsRequest = "testWorkspace/wfs?service=WFS&version=1.0.0&request=Transaction";
        MockHttpServletResponse wfsResponse = this.postAsServletResponse(wfsRequest, "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:testWorkspace=\"http://geoserver.org/GWCIntegerationTest/testWorkspace\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.0.0/WFS-transaction.xsd http://geoserver.org/GWCIntegerationTest/testWorkspace http://localhost:8080/geoserver/wfs/DescribeFeatureType?typename=testWorkspace:workspacedLayer\">\n    <wfs:Insert>\n        <testWorkspace:workspacedLayer>\n            <testWorkspace:location>\n                    <gml:Point srsName=\"http://www.opengis.net/gml/srs/epsg.xml#4326\" >\n                      <gml:coordinates decimal=\".\" cs=\",\" ts=\" \">0,0</gml:coordinates>\n                    </gml:Point>\n            </testWorkspace:location>\n            <testWorkspace:name>origin</testWorkspace:name>\n            <testWorkspace:value>0</testWorkspace:value>\n        </testWorkspace:workspacedLayer>\n    </wfs:Insert>\n</wfs:Transaction>");
        Assert.assertEquals((long)200L, (long)wfsResponse.getStatus());
        this.waitTileBreederCompletion();
        MockHttpServletResponse response3 = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response3.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response3.getContentType());
        MatcherAssert.assertThat((Object)response3.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"MISS"));
    }

    private void waitTileBreederCompletion() {
        Awaitility.await().atMost(20L, TimeUnit.SECONDS).pollDelay(10L, TimeUnit.MILLISECONDS).until(() -> !GWC.get().getRunningAndPendingTasks().hasNext());
    }

    @Test
    public void testLayerGroupInWorkspace() throws Exception {
        String workspaceName = MockData.BASIC_POLYGONS.getPrefix();
        LayerGroupInfo lg = this.getCatalog().getFactory().createLayerGroup();
        lg.setName(WORKSPACED_LAYER_GROUP);
        String bpLayerId = this.getLayerId(MockData.BASIC_POLYGONS);
        String mpLayerId = this.getLayerId(MockData.LAKES);
        lg.getLayers().add(this.getCatalog().getLayerByName(bpLayerId));
        lg.getLayers().add(this.getCatalog().getLayerByName(mpLayerId));
        lg.getStyles().add(null);
        lg.getStyles().add(null);
        lg.setWorkspace(this.getCatalog().getWorkspaceByName(workspaceName));
        new CatalogBuilder(this.getCatalog()).calculateLayerGroupBounds(lg);
        this.getCatalog().add(lg);
        String request = "gwc/service/wmts?request=GetTile&layer=" + workspaceName + ":workspacedLayerGroup&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0";
        MockHttpServletResponse sr = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr.getContentType());
        MatcherAssert.assertThat((Object)sr.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"MISS"));
        sr = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr.getContentType());
        MatcherAssert.assertThat((Object)sr.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"HIT"));
        GWC gwc = GWC.get();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        TileLayer tileLayer = gwc.getTileLayerByName(lg.prefixedName());
        request = this.buildGetMap(true, lg.prefixedName(), "EPSG:4326", null, tileLayer) + "&tiled=true";
        sr = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr.getContentType());
        Assert.assertEquals((Object)lg.prefixedName(), (Object)sr.getHeader("geowebcache-layer"));
        MatcherAssert.assertThat((Object)sr.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"HIT"));
        request = workspaceName + "/" + this.buildGetMap(true, lg.getName(), "EPSG:4326", null, tileLayer) + "&tiled=true";
        sr = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)lg.prefixedName(), (Object)sr.getHeader("geowebcache-layer"));
        MatcherAssert.assertThat((Object)sr.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"HIT"));
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName(workspaceName);
        String newWorkspaceName = workspaceName + "_renamed";
        ws.setName(newWorkspaceName);
        this.getCatalog().save(ws);
        request = "gwc/service/wmts?request=GetTile&layer=" + newWorkspaceName + ":workspacedLayerGroup&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0";
        sr = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr.getContentType());
        MatcherAssert.assertThat((Object)sr.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"HIT"));
        String newQualifiedName = newWorkspaceName + ":" + lg.getName();
        request = this.buildGetMap(true, newQualifiedName, "EPSG:4326", null, tileLayer) + "&tiled=true";
        sr = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr.getContentType());
        Assert.assertEquals((Object)lg.prefixedName(), (Object)sr.getHeader("geowebcache-layer"));
        MatcherAssert.assertThat((Object)sr.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"HIT"));
        request = newWorkspaceName + "/" + this.buildGetMap(true, lg.getName(), "EPSG:4326", null, tileLayer) + "&tiled=true";
        sr = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)newQualifiedName, (Object)sr.getHeader("geowebcache-layer"));
        MatcherAssert.assertThat((Object)sr.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"HIT"));
    }

    @Test
    public void testDirectWMSIntegrationWithVirtualServicesHiddenLayer() throws Exception {
        GWC gwc = GWC.get();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String qualifiedName = super.getLayerId(MockData.BASIC_POLYGONS);
        String localName = MockData.BASIC_POLYGONS.getLocalPart();
        TileLayer tileLayer = gwc.getTileLayerByName(qualifiedName);
        Assert.assertNotNull((Object)tileLayer);
        boolean directWMSIntegrationEndpoint = true;
        String request = MockData.CDF_PREFIX + "/" + this.buildGetMap(directWMSIntegrationEndpoint, localName, "EPSG:4326", null, tileLayer) + "&tiled=true";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertTrue((String)response.getContentType(), (boolean)response.getContentType().startsWith("application/vnd.ogc.se_xml"));
        Assert.assertTrue((String)response.getContentAsString(), (boolean)response.getContentAsString().contains("Could not find layer cdf:BasicPolygons"));
    }

    @Test
    public void testDirectWMSIntegrationCustomHost() throws Exception {
        GWC gwc = GWC.get();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String requestURL = this.buildGetMap(true, layerName, "EPSG:4326", null) + "&tiled=true";
        MockHttpServletRequest request = this.createRequest(requestURL);
        request.setMethod("GET");
        request.setContent(new byte[0]);
        String THE_HOST = "foobar";
        request.setRemoteHost("foobar");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request, null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        Assert.assertEquals((Object)layerName, (Object)response.getHeader("geowebcache-layer"));
        Assert.assertEquals((Object)"[0, 0, 0]", (Object)response.getHeader("geowebcache-tile-index"));
        Assert.assertEquals((Object)"-180.0,-90.0,0.0,90.0", (Object)response.getHeader("geowebcache-tile-bounds"));
        Assert.assertEquals((Object)"EPSG:4326", (Object)response.getHeader("geowebcache-gridset"));
        Assert.assertEquals((Object)"EPSG:4326", (Object)response.getHeader("geowebcache-crs"));
        ArrayList<HttpServletRequest> requests = HttpRequestRecorderCallback.getRequests();
        Assert.assertEquals((long)2L, (long)requests.size());
        MatcherAssert.assertThat((Object)requests.get(1), (Matcher)CoreMatchers.instanceOf(FakeHttpServletRequest.class));
        FakeHttpServletRequest fake = (FakeHttpServletRequest)requests.get(1);
        Assert.assertEquals((Object)"foobar", (Object)fake.getRemoteHost());
    }

    @Test
    public void testBasicIntegration() throws Exception {
        Catalog cat = this.getCatalog();
        TileLayerDispatcher tld = (TileLayerDispatcher)GeoWebCacheExtensions.bean(TileLayerDispatcher.class);
        Assert.assertNotNull((Object)tld);
        GridSetBroker gridSetBroker = (GridSetBroker)GeoWebCacheExtensions.bean(GridSetBroker.class);
        Assert.assertNotNull((Object)gridSetBroker);
        try {
            tld.getTileLayer("");
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean foundLakes = false;
        for (Object tl : tld.getLayerList()) {
            if (!tl.getName().equals("cite:Lakes")) continue;
            foundLakes = true;
            break;
        }
        Assert.assertTrue((boolean)foundLakes);
        boolean foudAGF = false;
        for (TileLayer tl : tld.getLayerList()) {
            if (!tl.getName().equals("sf:AggregateGeoFeature")) continue;
            foudAGF = true;
            GridSubset epsg4326 = tl.getGridSubset(gridSetBroker.getWorldEpsg4326().getName());
            Assert.assertEquals((Object)epsg4326.getGridSetBounds(), (Object)new BoundingBox(-180.0, -90.0, 180.0, 90.0));
            String mime = ((MimeType)tl.getMimeTypes().get(1)).getMimeType();
            Assert.assertTrue((mime.startsWith("image/") || mime.startsWith("application/vnd.google-earth.kml+xml") ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)foudAGF);
        LayerInfo li = cat.getLayerByName(super.getLayerId(MockData.MPOINTS));
        String layerName = GWC.tileLayerName((LayerInfo)li);
        TileLayer tl = tld.getTileLayer(layerName);
        Assert.assertEquals((Object)layerName, (Object)tl.getName());
        cat.remove(li);
        Assert.assertNull((Object)cat.getLayerByName(tl.getName()));
        try {
            tld.getTileLayer(layerName);
            Assert.fail((String)"Layer should not exist");
        }
        catch (GeoWebCacheException gwce) {
            Assert.assertTrue((boolean)true);
        }
    }

    private String buildGetMap(boolean directWMSIntegrationEndpoint, String layerName, String gridsetId, String styles) {
        GWC gwc = GWC.get();
        TileLayer tileLayer = gwc.getTileLayerByName(layerName);
        return this.buildGetMap(directWMSIntegrationEndpoint, layerName, gridsetId, styles, tileLayer);
    }

    private String buildGetMap(boolean directWMSIntegrationEndpoint, String queryLayerName, String gridsetId, String styles, TileLayer tileLayer) {
        GridSubset gridSubset = tileLayer.getGridSubset(gridsetId);
        long[] coverage = gridSubset.getCoverage(0);
        long[] tileIndex = new long[]{coverage[0], coverage[1], coverage[4]};
        BoundingBox bounds = gridSubset.boundsFromIndex(tileIndex);
        String endpoint = directWMSIntegrationEndpoint ? "wms" : "gwc/service/wms";
        StringBuilder sb = new StringBuilder(endpoint);
        sb.append("?service=WMS&request=GetMap&version=1.1.1&format=image/png");
        sb.append("&layers=").append(queryLayerName);
        sb.append("&srs=").append(gridSubset.getSRS());
        sb.append("&width=").append(gridSubset.getGridSet().getTileWidth());
        sb.append("&height=").append(gridSubset.getGridSet().getTileHeight());
        sb.append("&styles=");
        if (styles != null) {
            sb.append(styles);
        }
        sb.append("&bbox=").append(bounds.toString());
        return sb.toString();
    }

    @Test
    public void testMissingGeoServerLayerAtStartUp() throws Exception {
        Catalog catalog = this.getCatalog();
        GWC mediator = GWC.get();
        String layerName = this.getLayerId(MockData.BASIC_POLYGONS);
        LayerInfo layerInfo = catalog.getLayerByName(layerName);
        Assert.assertNotNull((Object)layerInfo);
        TileLayer tileLayer = mediator.getTileLayerByName(layerName);
        Assert.assertNotNull((Object)tileLayer);
        Assert.assertTrue((boolean)tileLayer.isEnabled());
        this.getCatalog().remove(layerInfo);
        this.getGeoServer().reload();
        Assert.assertNull((Object)catalog.getLayerByName(layerName));
        CatalogConfiguration config = (CatalogConfiguration)GeoServerExtensions.bean(CatalogConfiguration.class);
        Assert.assertFalse((boolean)config.getLayer(layerName).isPresent());
        try {
            mediator.getTileLayerByName(layerName);
            Assert.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testRemoveLayerAfterReload() throws Exception {
        Catalog cat = this.getCatalog();
        TileLayerDispatcher tld = (TileLayerDispatcher)GeoWebCacheExtensions.bean(TileLayerDispatcher.class);
        LayerInfo li = cat.getLayerByName(super.getLayerId(MockData.MPOINTS));
        String layerName = GWC.tileLayerName((LayerInfo)li);
        Assert.assertNotNull((Object)tld.getTileLayer(layerName));
        this.getGeoServer().reload();
        cat.remove(li);
        try {
            tld.getTileLayer(layerName);
            Assert.fail((String)"Layer should not exist");
        }
        catch (GeoWebCacheException geoWebCacheException) {
            // empty catch block
        }
    }

    @Test
    public void testDiskQuotaStorage() throws Exception {
        JDBCQuotaStoreFactory.ENABLE_HSQL_AUTO_SHUTDOWN = true;
        GWC gwc = GWC.get();
        ConfigurableQuotaStoreProvider provider = (ConfigurableQuotaStoreProvider)GeoServerExtensions.bean(ConfigurableQuotaStoreProvider.class);
        DiskQuotaConfig quota = gwc.getDiskQuotaConfig();
        JDBCConfiguration jdbc = gwc.getJDBCDiskQuotaConfig();
        Assert.assertFalse((String)"Disk quota is enabled??", (boolean)quota.isEnabled());
        Assert.assertNull((String)"jdbc quota config should be missing", (Object)jdbc);
        Assert.assertTrue((boolean)(this.getActualStore(provider) instanceof DummyQuotaStore));
        quota.setEnabled(Boolean.valueOf(true));
        quota.setQuotaStore("HSQL");
        gwc.saveDiskQuotaConfig(quota, null);
        GeoServerDataDirectory dd = (GeoServerDataDirectory)GeoServerExtensions.bean(GeoServerDataDirectory.class);
        String jdbcConfigPath = "gwc/geowebcache-diskquota-jdbc.xml";
        Assert.assertNull((String)("jdbc config (" + jdbcConfigPath + ") should not be there"), (Object)dd.findFile(new String[]{jdbcConfigPath}));
        String hsqlStorePath = "gwc/diskquota_page_store_hsql";
        Assert.assertNotNull((String)("jdbc store (" + hsqlStorePath + ") should be there"), (Object)dd.findFile(new String[]{hsqlStorePath}));
        Assert.assertTrue((boolean)(this.getActualStore(provider) instanceof JDBCQuotaStore));
        quota.setEnabled(Boolean.valueOf(false));
        gwc.saveDiskQuotaConfig(quota, null);
        FileUtils.deleteDirectory((File)dd.findFile(new String[]{"gwc/diskquota_page_store_hsql"}));
        quota.setEnabled(Boolean.valueOf(true));
        quota.setQuotaStore("JDBC");
        jdbc = new JDBCConfiguration();
        jdbc.setDialect("HSQL");
        JDBCConfiguration.ConnectionPoolConfiguration pool = new JDBCConfiguration.ConnectionPoolConfiguration();
        pool.setDriver("org.hsqldb.jdbcDriver");
        pool.setUrl("jdbc:hsqldb:file:./target/quota-hsql");
        pool.setUsername("sa");
        pool.setPassword("");
        pool.setMinConnections(1);
        pool.setMaxConnections(1);
        pool.setMaxOpenPreparedStatements(50);
        jdbc.setConnectionPool(pool);
        gwc.saveDiskQuotaConfig(quota, jdbc);
        Assert.assertNotNull((String)("jdbc config (" + jdbcConfigPath + ") should be there"), (Object)dd.findFile(new String[]{jdbcConfigPath}));
        Assert.assertNull((String)("jdbc store (" + hsqlStorePath + ") should be there"), (Object)dd.findDataFile(new String[]{hsqlStorePath}));
        File newQuotaStore = new File("./target/quota-hsql.script");
        Assert.assertTrue((boolean)newQuotaStore.exists());
        File jdbcConfigFile = dd.findFile(new String[]{jdbcConfigPath});
        try (FileInputStream fis = new FileInputStream(jdbcConfigFile);){
            Document dom = this.dom(fis);
            String storedPassword = XMLUnit.newXpathEngine().evaluate("/gwcJdbcConfiguration/connectionPool/password", dom);
            Assert.assertTrue((boolean)storedPassword.startsWith("crypt1:"));
        }
        JDBCQuotaStoreFactory.ENABLE_HSQL_AUTO_SHUTDOWN = false;
    }

    @Test
    public void testDiskQuotaH2Storage() throws Exception {
        GWC gwc = GWC.get();
        ConfigurableQuotaStoreProvider provider = (ConfigurableQuotaStoreProvider)GeoServerExtensions.bean(ConfigurableQuotaStoreProvider.class);
        DiskQuotaConfig quota = gwc.getDiskQuotaConfig();
        JDBCConfiguration jdbc = gwc.getJDBCDiskQuotaConfig();
        Assert.assertFalse((String)"Disk quota is enabled??", (boolean)quota.isEnabled());
        Assert.assertNull((String)"jdbc quota config should be missing", (Object)jdbc);
        Assert.assertTrue((boolean)(this.getActualStore(provider) instanceof DummyQuotaStore));
        GeoServerDataDirectory dd = (GeoServerDataDirectory)GeoServerExtensions.bean(GeoServerDataDirectory.class);
        String jdbcConfigPath = "gwc/geowebcache-diskquota-jdbc.xml";
        String h2StorePath = "gwc/diskquota_page_store_h2";
        quota.setEnabled(Boolean.valueOf(true));
        quota.setQuotaStore("JDBC");
        jdbc = new JDBCConfiguration();
        jdbc.setDialect("H2");
        JDBCConfiguration.ConnectionPoolConfiguration pool = new JDBCConfiguration.ConnectionPoolConfiguration();
        pool.setDriver("org.h2.Driver");
        pool.setUrl("jdbc:h2:file:./target/quota-h2");
        pool.setUsername("sa");
        pool.setPassword("");
        pool.setMinConnections(1);
        pool.setMaxConnections(1);
        pool.setMaxOpenPreparedStatements(50);
        jdbc.setConnectionPool(pool);
        pool.setValidationQuery("SELECT 1");
        gwc.saveDiskQuotaConfig(quota, jdbc);
        Assert.assertNotNull((String)("jdbc config (" + jdbcConfigPath + ") should be there"), (Object)dd.findFile(new String[]{jdbcConfigPath}));
        Assert.assertNull((String)("jdbc store (" + h2StorePath + ") should be there"), (Object)dd.findDataFile(new String[]{h2StorePath}));
        File newQuotaStore = new File("./target/quota-h2.data.db");
        Assert.assertTrue((boolean)newQuotaStore.exists());
        try {
            pool.setValidationQuery("SELECT 1 FROM DUAL");
            gwc.saveDiskQuotaConfig(quota, jdbc);
            Assert.fail((String)"Expect configuration due to incorrect validation query used for H2");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        File jdbcConfigFile = dd.findFile(new String[]{jdbcConfigPath});
        try (FileInputStream fis = new FileInputStream(jdbcConfigFile);){
            Document dom = this.dom(fis);
            String storedPassword = XMLUnit.newXpathEngine().evaluate("/gwcJdbcConfiguration/connectionPool/password", dom);
            Assert.assertTrue((boolean)storedPassword.startsWith("crypt1:"));
        }
    }

    private QuotaStore getActualStore(ConfigurableQuotaStoreProvider provider) throws ConfigurationException, IOException {
        return ((ConfigurableQuotaStore)provider.getQuotaStore()).getStore();
    }

    @Test
    public void testPreserveHeaders() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("gwc/service/wms?service=wms&version=1.1.0&request=GetCapabilities");
        Assert.assertEquals((Object)"application/vnd.ogc.wms_xml", (Object)this.getBaseMimeType(response.getContentType()));
        Assert.assertEquals((Object)"inline;filename=wms-getcapabilities.xml", (Object)response.getHeader("content-disposition"));
    }

    @Test
    public void testGutter() throws Exception {
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)GWC.get().getTileLayerByName(this.getLayerId(MockData.BASIC_POLYGONS));
        GeoServerTileLayerInfo info = tileLayer.getInfo();
        info.setGutter(100);
        GWC.get().save((TileLayer)tileLayer);
        String request = "gwc/service/wms?LAYERS=cite%3ABasicPolygons&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&STYLES=&SRS=EPSG%3A4326&BBOX=0,0,11.25,11.25&WIDTH=256&HEIGHT=256";
        BufferedImage image = this.getAsImage(request, "image/png");
        Assert.assertEquals((long)256L, (long)image.getWidth());
        Assert.assertEquals((long)256L, (long)image.getHeight());
    }

    @Test
    public void testSaveConfig() throws Exception {
        GWCConfig config = GWC.get().getConfig();
        config.setGutter(100);
        GWC.get().saveConfig(config);
        this.getGeoServer().reload();
        Assert.assertEquals((long)100L, (long)GWC.get().getConfig().getGutter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameWorkspace() throws Exception {
        String wsName = MockData.CITE_PREFIX;
        String wsRenamed = MockData.CITE_PREFIX + "Renamed";
        Catalog catalog = this.getCatalog();
        WorkspaceInfo ws = catalog.getWorkspaceByName(wsName);
        try {
            Object prefixedName;
            ArrayList<String> layerNames = new ArrayList<String>();
            for (LayerInfo layer : catalog.getLayers()) {
                if (!wsName.equals(layer.getResource().getStore().getWorkspace().getName())) continue;
                prefixedName = layer.prefixedName();
                try {
                    GWC.get().getTileLayerByName((String)prefixedName);
                    layerNames.add(layer.getName());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            ws.setName(wsRenamed);
            catalog.save(ws);
            for (String name : layerNames) {
                prefixedName = wsRenamed + ":" + name;
                GWC.get().getTileLayerByName((String)prefixedName);
            }
        }
        finally {
            if (wsRenamed.equals(ws.getName())) {
                ws.setName(wsName);
                catalog.save(ws);
            }
        }
    }

    @Test
    public void testRemoveCachedLayer() throws Exception {
        this.setMetatileThreads(0);
        String layerName = this.getLayerId(MockData.BASIC_POLYGONS);
        Assert.assertEquals((Object)"cite:BasicPolygons", (Object)layerName);
        String cacheDirectory = "gwc/cite_BasicPolygons";
        String cachedTile = "gwc/cite_BasicPolygons/EPSG_4326_00/0_0/00_00.png";
        GeoServerResourceLoader loader = this.getResourceLoader();
        Assert.assertNull((String)("Unexpected cache directory " + cacheDirectory), (Object)loader.find(cacheDirectory));
        Assert.assertNull((String)("Unexpected cached tile " + cachedTile), (Object)loader.find(cachedTile));
        MockHttpServletResponse response = this.getAsServletResponse("gwc/service/wmts?request=GetTile&layer=" + layerName + "&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        Assert.assertNotNull((String)("Missing cache directory " + cacheDirectory), (Object)loader.find(cacheDirectory));
        Assert.assertNotNull((String)("Missing cached tile " + cachedTile), (Object)loader.find(cachedTile));
        this.getCatalog().remove(this.getCatalog().getLayerByName(layerName));
        Assert.assertNull((String)("Unexpected cache directory " + cacheDirectory), (Object)loader.find(cacheDirectory));
        Assert.assertNull((String)("Unexpected cached tile " + cachedTile), (Object)loader.find(cachedTile));
    }

    @Test
    public void testGetCapabilitiesWithLocalWorkspace() throws Exception {
        Document doc = this.assertGetCapabilitiesWithLocalWorkspace();
        MatcherAssert.assertThat((Object)WMTS_XPATH_10.evaluate("//wmts:ServiceMetadataURL[2]/@xlink:href", doc), (Matcher)Matchers.equalTo((Object)"http://localhost:8080/geoserver/cite/gwc/service/wmts/rest/WMTSCapabilities.xml"));
    }

    public Document assertGetCapabilitiesWithLocalWorkspace() throws Exception {
        Document document = this.getAsDOM(MockData.CITE_PREFIX + "/gwc/service/wmts?request=GetCapabilities");
        List<LayerInfo> citeLayers = this.getWorkspaceLayers(MockData.CITE_PREFIX);
        MatcherAssert.assertThat((Object)Integer.parseInt(WMTS_XPATH_10.evaluate("count(//wmts:Contents/wmts:Layer)", document)), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)Integer.parseInt(WMTS_XPATH_10.evaluate("count(//wmts:Contents/wmts:Layer)", document)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(citeLayers.size())));
        MatcherAssert.assertThat((Object)WMTS_XPATH_10.evaluate("count(//wmts:Contents/wmts:Layer[ows:Identifier='" + MockData.BUILDINGS.getLocalPart() + "'])", document), (Matcher)Matchers.is((Object)"1"));
        return document;
    }

    @Test
    public void testGetCapabilitiesWithLocalWorkspaceAndProxyBase() throws Exception {
        GeoServer gs = this.getGeoServer();
        try {
            this.setProxyBase(gs, "http://fooBar/geoserver");
            Document doc = this.assertGetCapabilitiesWithLocalWorkspace();
            MatcherAssert.assertThat((Object)WMTS_XPATH_10.evaluate("//wmts:ServiceMetadataURL[2]/@xlink:href", doc), (Matcher)Matchers.equalTo((Object)"http://fooBar/geoserver/cite/gwc/service/wmts/rest/WMTSCapabilities.xml"));
        }
        finally {
            this.setProxyBase(gs, null);
        }
    }

    public void setProxyBase(GeoServer gs, String s) {
        GeoServerInfo global = gs.getGlobal();
        global.getSettings().setProxyBaseUrl(s);
        gs.save(global);
    }

    @Test
    public void testComputeGridsetBounds() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo ft = catalog.getFeatureTypeByName(this.getLayerId(BASIC_POLYGONS_NO_CRS));
        CatalogBuilder cb = new CatalogBuilder(catalog);
        ft.setNativeCRS(null);
        cb.setupBounds((ResourceInfo)ft);
        catalog.save((ResourceInfo)ft);
        GridSetBroker gridSetBroker = GWC.get().getGridSetBroker();
        GridSet testGridSet = this.namedGridsetCopy("TEST", gridSetBroker.getDefaults().worldEpsg4326());
        gridSetBroker.addGridSet(testGridSet);
        GridSubset testGridSubset = GridSubsetFactory.createGridSubSet((GridSet)testGridSet, (BoundingBox)new BoundingBox(-180.0, 0.0, 0.0, 90.0), (Integer)0, (Integer)(testGridSet.getNumLevels() - 1));
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)GWC.get().getTileLayerByName(this.getLayerId(BASIC_POLYGONS_NO_CRS));
        tileLayer.addGridSubset(testGridSubset);
        Document document = this.getAsDOM(MockData.CITE_PREFIX + "/" + BASIC_POLYGONS_NO_CRS.getLocalPart() + "/gwc/service/wmts?request=GetCapabilities");
        String basePath = "//wmts:Contents/wmts:Layer[ows:Title='BasicPolygonsNoCrs']/wmts:TileMatrixSetLink[wmts:TileMatrixSet='EPSG:4326']/wmts:TileMatrixSetLimits/wmts:TileMatrixLimits[wmts:TileMatrix='EPSG:4326:1']";
        Assert.assertEquals((Object)"0", (Object)WMTS_XPATH_10.evaluate(basePath + "/wmts:MinTileRow", document));
        Assert.assertEquals((Object)"1", (Object)WMTS_XPATH_10.evaluate(basePath + "/wmts:MaxTileRow", document));
        Assert.assertEquals((Object)"1", (Object)WMTS_XPATH_10.evaluate(basePath + "/wmts:MinTileCol", document));
        Assert.assertEquals((Object)"2", (Object)WMTS_XPATH_10.evaluate(basePath + "/wmts:MaxTileCol", document));
    }

    @Test
    public void testGetCapabilitiesWithLocalLayer() throws Exception {
        Document document = this.getAsDOM(MockData.CITE_PREFIX + "/" + MockData.BUILDINGS.getLocalPart() + "/gwc/service/wmts?request=GetCapabilities");
        MatcherAssert.assertThat((Object)Integer.parseInt(WMTS_XPATH_10.evaluate("count(//wmts:Contents/wmts:Layer)", document)), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)WMTS_XPATH_10.evaluate("count(//wmts:Contents/wmts:Layer[ows:Identifier='" + MockData.BUILDINGS.getLocalPart() + "'])", document), (Matcher)Matchers.is((Object)"1"));
    }

    @Test
    public void testGetCapabilitiesWithLocalGroup() throws Exception {
        Document document = this.getAsDOM("SIMPLE_LAYER_GROUP/gwc/service/wmts?request=GetCapabilities");
        MatcherAssert.assertThat((Object)Integer.parseInt(WMTS_XPATH_10.evaluate("count(//wmts:Contents/wmts:Layer)", document)), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)WMTS_XPATH_10.evaluate("count(//wmts:Contents/wmts:Layer[ows:Identifier='SIMPLE_LAYER_GROUP'])", document), (Matcher)Matchers.is((Object)"1"));
    }

    @Test
    public void testGetTileWithLocalWorkspace() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(MockData.CITE_PREFIX + "/gwc/service/wmts?request=GetTile&layer=" + MockData.BASIC_POLYGONS.getLocalPart() + "&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        response = this.getAsServletResponse(MockData.CITE_PREFIX + "/gwc/service/wmts?request=GetTile&layer=" + MockData.BASIC_POLYGONS.getLocalPart() + "&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        String cacheResult = (String)response.getHeaderValue("geowebcache-cache-result");
        MatcherAssert.assertThat((Object)cacheResult, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)cacheResult, (Matcher)Matchers.is((Object)"HIT"));
    }

    private List<LayerInfo> getWorkspaceLayers(String workspaceName) {
        ArrayList<LayerInfo> layers = new ArrayList<LayerInfo>();
        for (LayerInfo layer : this.getCatalog().getLayers()) {
            WorkspaceInfo workspace = layer.getResource().getStore().getWorkspace();
            if (workspace == null || !workspace.getName().equals(workspaceName)) continue;
            layers.add(layer);
        }
        return layers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWMTSEnabling() throws Exception {
        boolean initialValue = ((WMTSInfo)this.getGeoServer().getService(WMTSInfo.class)).isEnabled();
        try {
            LocalWorkspace.set(null);
            WMTSInfo wmtsInfo = (WMTSInfo)this.getGeoServer().getService(WMTSInfo.class);
            wmtsInfo.setEnabled(false);
            this.getGeoServer().save((ServiceInfo)wmtsInfo);
            MockHttpServletResponse response = this.getAsServletResponse("gwc/service/wmts?service=wmts&version=1.0.0&request=GetCapabilities");
            Assert.assertEquals((long)400L, (long)response.getStatus());
            wmtsInfo.setEnabled(true);
            this.getGeoServer().save((ServiceInfo)wmtsInfo);
            response = this.getAsServletResponse("gwc/service/wmts?service=wmts&version=1.0.0&request=GetCapabilities");
            Assert.assertEquals((long)200L, (long)response.getStatus());
        }
        finally {
            ((WMTSInfo)this.getGeoServer().getService(WMTSInfo.class)).setEnabled(initialValue);
            LocalWorkspace.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWmtsGetCapabilitiesRequest() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/gwc/service/wmts?request=GetCapabilities");
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        Document document = this.dom(response, false);
        this.print(document);
        String result = WMTS_XPATH_10.evaluate("count(//wmts:Contents/wmts:Layer/wmts:Style[@isDefault='true']/ows:Identifier[text()='Default'])", document);
        MatcherAssert.assertThat((Object)Integer.parseInt(result), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        result = WMTS_XPATH_10.evaluate("count(//ows:ServiceProvider/ows:ProviderName[text()='GeoServer'])", document);
        MatcherAssert.assertThat((Object)Integer.parseInt(result), (Matcher)Matchers.is((Object)1));
        result = WMTS_XPATH_10.evaluate("count(//wmts:Contents/wmts:Layer/wmts:Style/wmts:LegendURL[@minScaleDenominator='0.0'])", document);
        MatcherAssert.assertThat((Object)Integer.parseInt(result), (Matcher)Matchers.is((Object)0));
        result = WMTS_XPATH_10.evaluate("count(//wmts:Contents/wmts:Layer/wmts:Style/wmts:LegendURL[@maxScaleDenominator='NaN'])", document);
        MatcherAssert.assertThat((Object)Integer.parseInt(result), (Matcher)Matchers.is((Object)0));
        result = WMTS_XPATH_10.evaluate("count(//wmts:Contents/wmts:Layer/wmts:Style/wmts:LegendURL[@minScaleDenominator='100000.0'][@maxScaleDenominator='300000.0'])", document);
        MatcherAssert.assertThat((Object)Integer.parseInt(result), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        result = WMTS_XPATH_10.evaluate("count(//wmts:Contents/wmts:Layer[ows:Identifier='stylegroup'])", document);
        MatcherAssert.assertThat((Object)Integer.parseInt(result), (Matcher)Matchers.equalTo((Object)1));
        WorkspaceInfo workspace = this.getCatalog().getWorkspaceByName(TEST_WORKSPACE_NAME);
        MatcherAssert.assertThat((Object)workspace, (Matcher)Matchers.notNullValue());
        LocalWorkspace.set((WorkspaceInfo)workspace);
        try {
            response = this.getAsServletResponse("testWorkspace/gwc/service/wmts?request=GetCapabilities");
            document = this.dom(response, false);
            result = WMTS_XPATH_10.evaluate("count(//wmts:Contents/wmts:Layer/wmts:Style/wmts:LegendURL[contains(@xlink:href,'geoserver/testWorkspace/ows')])", document);
            MatcherAssert.assertThat((Object)Integer.parseInt(result), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        }
        finally {
            LocalWorkspace.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWmtsGetCapabilitiesVersionNegotiationSuccesful() throws Exception {
        GeoServer gs = this.getGeoServer();
        WMTSInfo wmts = (WMTSInfo)gs.getService(WMTSInfo.class);
        wmts.setCiteCompliant(true);
        gs.save((ServiceInfo)wmts);
        try {
            MockHttpServletResponse response = this.getAsServletResponse("/gwc/service/wmts?service=WMTS&request=GetCapabilities&acceptVersions=2.0.0,1.5.0,1.0.0");
            Document document = this.dom(response, false);
            Assert.assertEquals((Object)"1.0.0", (Object)WMTS_XPATH_10.evaluate("//wmts:Capabilities/@version", document));
        }
        finally {
            wmts.setCiteCompliant(false);
            gs.save((ServiceInfo)wmts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWmtsGetCapabilitiesVersionNegotiationFail() throws Exception {
        GeoServer gs = this.getGeoServer();
        WMTSInfo wmts = (WMTSInfo)gs.getService(WMTSInfo.class);
        wmts.setCiteCompliant(true);
        gs.save((ServiceInfo)wmts);
        try {
            MockHttpServletResponse response = this.getAsServletResponse("/gwc/service/wmts?service=WMTS&request=GetCapabilities&acceptVersions=2.0.0,1.5.0");
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
            Document document = this.dom(response, false);
            this.print(document);
            Assert.assertEquals((Object)"VersionNegotiationFailed", (Object)WMTS_XPATH_10.evaluate("/ows:ExceptionReport/ows:Exception/@exceptionCode", document));
        }
        finally {
            wmts.setCiteCompliant(false);
            gs.save((ServiceInfo)wmts);
        }
    }

    @Test
    public void testGetCapabilitiesRequestRestEndpoints() throws Exception {
        int totLayers = this.getCatalog().getLayers().size() + 1;
        Document doc = this.getAsDOM("/gwc/service/wmts?request=GetCapabilities");
        Assert.assertEquals((Object)String.valueOf(totLayers), (Object)WMTS_XPATH_10.evaluate("count(//wmts:Contents/wmts:Layer/wmts:ResourceURL[@resourceType='tile'][@format='image/png'][contains(@template,'http://localhost:8080/geoserver/gwc/service/wmts/rest/')][contains(@template,'/{style}/{TileMatrixSet}/{TileMatrix}/{TileRow}/{TileCol}?format=image/png')])", doc));
        Assert.assertEquals((Object)String.valueOf(totLayers), (Object)WMTS_XPATH_10.evaluate("count(//wmts:Contents/wmts:Layer/wmts:ResourceURL[@resourceType='FeatureInfo'][@format='text/plain'][contains(@template,'http://localhost:8080/geoserver/gwc/service/wmts/rest/')][contains(@template,'/{style}/{TileMatrixSet}/{TileMatrix}/{TileRow}/{TileCol}/{J}/{I}?format=text/plain')])", doc));
        Assert.assertEquals((Object)"1", (Object)WMTS_XPATH_10.evaluate("count(//wmts:ServiceMetadataURL[@xlink:href='http://localhost:8080/geoserver/gwc/service/wmts?SERVICE=wmts&REQUEST=getcapabilities&VERSION=1.0.0'])", doc));
        Assert.assertEquals((Object)"1", (Object)WMTS_XPATH_10.evaluate("count(//wmts:ServiceMetadataURL[@xlink:href='http://localhost:8080/geoserver/gwc/service/wmts/rest/WMTSCapabilities.xml'])", doc));
    }

    @Test
    public void testGetCapabilitiesWithRestEndpoints() throws Exception {
        MockHttpServletRequest request = this.createRequest("/gwc/service/wmts/rest/WMTSCapabilities.xml");
        request.setMethod("GET");
        request.setContent(new byte[0]);
        Request mockRequest = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)mockRequest.getHttpRequest()).thenReturn((Object)request);
        Dispatcher.REQUEST.set(mockRequest);
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request, null);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        GWCIntegrationTest.assertContentType((String)"text/xml;charset=UTF-8", (MockHttpServletResponse)response);
    }

    @Test
    public void testGetCapabilitiesWithRestEndpointsWorkspaceService() throws Exception {
        MockHttpServletRequest request = this.createRequest(MockData.CITE_PREFIX + "/gwc/service/wmts/rest/WMTSCapabilities.xml");
        request.setMethod("GET");
        Request mockRequest = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)mockRequest.getHttpRequest()).thenReturn((Object)request);
        Dispatcher.REQUEST.set(mockRequest);
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request, null);
        Document doc = this.dom(new ByteArrayInputStream(response.getContentAsByteArray()), true);
        this.print(doc);
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/cite/ows?service=WMS&request=GetLegendGraphic&version=1.1.0&format=image%2Fpng&width=20&height=20&layer=cite%3ABasicPolygons", (Object)WMTS_XPATH_10.evaluate("//wmts:Contents/wmts:Layer[ows:Title='BasicPolygons']/wmts:Style/wmts:LegendURL/@xlink:href", doc));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/cite/gwc/service/wmts/rest/BasicPolygons/{style}/{TileMatrixSet}/{TileMatrix}/{TileRow}/{TileCol}?format=image/png", (Object)WMTS_XPATH_10.evaluate("//wmts:Contents/wmts:Layer[ows:Title='BasicPolygons']/wmts:ResourceURL[@format='image/png' and @resourceType='tile']/@template", doc));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/cite/gwc/service/wmts/rest/BasicPolygons/{style}/{TileMatrixSet}/{TileMatrix}/{TileRow}/{TileCol}/{J}/{I}?format=text/plain", (Object)WMTS_XPATH_10.evaluate("//wmts:Contents/wmts:Layer[ows:Title='BasicPolygons']/wmts:ResourceURL[@format='text/plain' and @resourceType='FeatureInfo']/@template", doc));
        Assert.assertEquals((Object)"1", (Object)WMTS_XPATH_10.evaluate("count(//wmts:Capabilities/wmts:ServiceMetadataURL[@xlink:href='http://localhost:8080/geoserver/cite/gwc/service/wmts/rest/WMTSCapabilities.xml'])", doc));
    }

    @Test
    public void testGetTileWithRestEndpoints() throws Exception {
        MockHttpServletRequest request = this.createRequest("/gwc/service/wmts/rest/" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "/EPSG:4326/EPSG:4326:0/0/0?format=image/png");
        request.setMethod("GET");
        request.setContent(new byte[0]);
        Request mockRequest = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)mockRequest.getHttpRequest()).thenReturn((Object)request);
        Dispatcher.REQUEST.set(mockRequest);
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request, null);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        GWCIntegrationTest.assertContentType((String)"image/png", (MockHttpServletResponse)response);
    }

    @Test
    public void testGetTileWithRestEndpointsInVirtualService() throws Exception {
        MockHttpServletRequest request = this.createRequest(MockData.BASIC_POLYGONS.getPrefix() + "/gwc/service/wmts/rest/" + MockData.BASIC_POLYGONS.getLocalPart() + "/EPSG:4326/EPSG:4326:0/0/0?format=image/png");
        request.setMethod("GET");
        request.setContent(new byte[0]);
        Request mockRequest = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)mockRequest.getHttpRequest()).thenReturn((Object)request);
        Dispatcher.REQUEST.set(mockRequest);
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request, null);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        GWCIntegrationTest.assertContentType((String)"image/png", (MockHttpServletResponse)response);
    }

    @Test
    public void testFeatureInfoWithRestEndpoints() throws Exception {
        MockHttpServletRequest request = this.createRequest("/gwc/service/wmts/rest/" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "/EPSG:4326/EPSG:4326:0/0/0/0/0?format=text/plain");
        request.setMethod("GET");
        request.setContent(new byte[0]);
        Request mockRequest = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)mockRequest.getHttpRequest()).thenReturn((Object)request);
        Dispatcher.REQUEST.set(mockRequest);
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request, null);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        GWCIntegrationTest.assertContentType((String)"text/plain", (MockHttpServletResponse)response);
    }

    @Test
    public void testFeatureInfoWithRestEndpointsInVirtualService() throws Exception {
        MockHttpServletRequest request = this.createRequest(MockData.BASIC_POLYGONS.getPrefix() + "/gwc/service/wmts/rest/" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "/EPSG:4326/EPSG:4326:0/0/0/0/0?format=text/plain");
        request.setMethod("GET");
        request.setContent(new byte[0]);
        Request mockRequest = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)mockRequest.getHttpRequest()).thenReturn((Object)request);
        Dispatcher.REQUEST.set(mockRequest);
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request, null);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        GWCIntegrationTest.assertContentType((String)"text/plain", (MockHttpServletResponse)response);
    }

    @Test
    public void testGetCapabilitiesWithRestEndpointsAndDimensions() throws Exception {
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)GWC.get().getTileLayerByName(this.getLayerId(MockData.BASIC_POLYGONS));
        GeoServerTileLayerInfo info = tileLayer.getInfo();
        StringParameterFilter time = new StringParameterFilter();
        time.setKey("time");
        time.setValues(Arrays.asList("2016-02-23T03:00:00.000Z"));
        info.addParameterFilter((ParameterFilter)time);
        StringParameterFilter elevation = new StringParameterFilter();
        elevation.setKey("elevation");
        elevation.setValues(Arrays.asList("500"));
        info.addParameterFilter((ParameterFilter)elevation);
        GWC.get().save((TileLayer)tileLayer);
        MockHttpServletRequest request = this.createRequest("/gwc/service/wmts/rest/WMTSCapabilities.xml");
        request.setMethod("GET");
        request.setContent(new byte[0]);
        Request mockRequest = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)mockRequest.getHttpRequest()).thenReturn((Object)request);
        Dispatcher.REQUEST.set(mockRequest);
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request, null);
        ByteArrayInputStream bain = new ByteArrayInputStream(response.getContentAsString().getBytes());
        Document doc = this.dom(bain, true);
        Assert.assertEquals((Object)"1", (Object)WMTS_XPATH_10.evaluate("count(//wmts:Contents/wmts:Layer/wmts:ResourceURL[@resourceType='tile'][@format='image/png'][contains(@template,'http://localhost:8080/geoserver/gwc/service/wmts/rest/" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "/{style}/{TileMatrixSet}/{TileMatrix}/{TileRow}/{TileCol}?format=image/png')])", doc));
    }

    @Test
    public void testCetTileWithInvalidStyle() throws Exception {
        String layerName = this.getLayerId(MockData.BASIC_POLYGONS);
        MockHttpServletResponse response = this.getAsServletResponse("gwc/service/wmts?request=GetTile&layer=" + layerName + "&style=invalid&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0");
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/xml", (Object)response.getContentType());
        Document document = this.dom(response, false);
        String result = WMTS_XPATH_10.evaluate("count(//ows:ExceptionReport/ows:Exception[@exceptionCode='InvalidParameterValue'][@locator='Style'])", document);
        MatcherAssert.assertThat((Object)Integer.parseInt(result), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testMassTruncateAll() throws Exception {
        GWC gwc = GWC.get();
        Catalog catalog = this.getCatalog();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String qualifiedName = super.getLayerId(WORKSPACED_LAYER_QNAME);
        TileLayer tileLayer = gwc.getTileLayerByName(qualifiedName);
        Assert.assertNotNull((Object)tileLayer);
        LayerInfo layer = catalog.getLayerByName(qualifiedName);
        Assert.assertNotNull((Object)layer);
        String request = "gwc/service/wmts?request=GetTile&layer=" + qualifiedName + "&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        MatcherAssert.assertThat((Object)response.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"MISS"));
        response = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        MatcherAssert.assertThat((Object)response.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"HIT"));
        this.waitTileBreederCompletion();
        TruncateAllRequest truncateAll = gwc.truncateAll();
        String truncatedLayers = truncateAll.getTrucatedLayersList();
        Assert.assertTrue((boolean)truncatedLayers.contains(qualifiedName));
        response = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        MatcherAssert.assertThat((Object)response.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"MISS"));
    }

    private void createLayerGroup(String layerGroupName, QName ... layersNames) throws Exception {
        List layers = Arrays.stream(layersNames).map(layerName -> this.getCatalog().getLayerByName((Name)new NameImpl(layerName))).collect(Collectors.toList());
        LayerGroupInfo layerGroup = this.getCatalog().getFactory().createLayerGroup();
        layerGroup.setName(layerGroupName);
        for (LayerInfo layerInfo : layers) {
            layerGroup.getLayers().add(layerInfo);
            layerGroup.getStyles().add(null);
        }
        CatalogBuilder catalogBuilder = new CatalogBuilder(this.getCatalog());
        catalogBuilder.calculateLayerGroupBounds(layerGroup);
        this.getCatalog().add(layerGroup);
    }

    @Test
    public void testDirectDefaultWorkspaceWMSIntegration() throws Exception {
        GWC gwc = GWC.get();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String layerName = MockData.BASIC_POLYGONS.getLocalPart();
        String request = "wms?service=WMS&request=GetMap&version=1.1.1&format=image/png&layers=" + layerName + "&srs=EPSG:4326&width=256&height=256&styles=&bbox=-180.0,-90.0,0.0,90.0&tiled=true";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        response = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("geowebcache-tile-index"));
        Assert.assertTrue((boolean)response.getHeader("geowebcache-cache-result").equalsIgnoreCase("HIT"));
        request = MockData.CITE_PREFIX + "/wms?service=WMS&request=GetMap&version=1.1.1&format=image/png&layers=" + layerName + "&srs=EPSG:4326&width=256&height=256&styles=&bbox=-180.0,-90.0,0.0,90.0&tiled=true";
        response = this.getAsServletResponse(request);
        response = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("geowebcache-tile-index"));
        Assert.assertTrue((boolean)response.getHeader("geowebcache-cache-result").equalsIgnoreCase("HIT"));
    }

    @Test
    public void testDirectDefaultWorkspaceWMSIntegrationLayerGroup() throws Exception {
        GWC gwc = GWC.get();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        LayerGroupInfo lg = this.getCatalog().getFactory().createLayerGroup();
        lg.setName(WORKSPACED_LAYER_GROUP);
        String bpLayerId = this.getLayerId(MockData.BASIC_POLYGONS);
        String mpLayerId = this.getLayerId(MockData.LAKES);
        lg.getLayers().add(this.getCatalog().getLayerByName(bpLayerId));
        lg.getLayers().add(this.getCatalog().getLayerByName(mpLayerId));
        lg.getStyles().add(null);
        lg.getStyles().add(null);
        lg.setWorkspace(this.getCatalog().getWorkspaceByName(MockData.BASIC_POLYGONS.getPrefix()));
        new CatalogBuilder(this.getCatalog()).calculateLayerGroupBounds(lg);
        this.getCatalog().add(lg);
        String request = MockData.BASIC_POLYGONS.getPrefix() + "/wms?service=WMS&request=GetMap&version=1.1.1&format=image/png&layers=workspacedLayerGroup&srs=EPSG:4326&width=256&height=256&styles=&bbox=-180.0,-90.0,0.0,90.0&tiled=true";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        response = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("geowebcache-tile-index"));
        Assert.assertTrue((boolean)response.getHeader("geowebcache-cache-result").equalsIgnoreCase("HIT"));
    }

    @Test
    public void testDimensionWarningsCacheSkip() throws Exception {
        String layerId = this.getLayerId(V_TIME_ELEVATION);
        FeatureTypeInfo vte = this.getCatalog().getFeatureTypeByName(layerId);
        this.addDimension(vte, "time", "time");
        this.addDimension(vte, "elevation", "elevation");
        this.getCatalog().save((ResourceInfo)vte);
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)GWC.get().getTileLayerByName(layerId);
        GeoServerTileLayerInfo info = tileLayer.getInfo();
        StringParameterFilter time = new StringParameterFilter();
        time.setKey("time");
        time.setValues(Arrays.asList("2016-02-23T03:00:00.000Z"));
        info.addParameterFilter((ParameterFilter)time);
        StringParameterFilter elevation = new StringParameterFilter();
        elevation.setKey("elevation");
        elevation.setValues(Arrays.asList("500"));
        info.addParameterFilter((ParameterFilter)elevation);
        info.setCacheWarningSkips(new HashSet<DimensionWarning.WarningType>(Arrays.asList(DimensionWarning.WarningType.Default, DimensionWarning.WarningType.Nearest, DimensionWarning.WarningType.FailedNearest)));
        GWC.get().save((TileLayer)tileLayer);
        MockHttpServletResponse sr = this.getAsServletResponse("gwc/service/wmts?request=GetTile&layer=" + layerId + "&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0");
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr.getContentType());
        Assert.assertEquals((Object)"MISS", (Object)sr.getHeader("geowebcache-cache-result"));
        MatcherAssert.assertThat((Object)sr.getHeaders("Warning"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"99 Default value used: time=2011-05-04T00:00:00.000Z  (sf:TimeElevation)", "99 Default value used: elevation=0.0  (sf:TimeElevation)"}));
        this.checkNoCacheHeaders(sr);
        sr = this.getAsServletResponse("gwc/service/wmts?request=GetTile&layer=" + layerId + "&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0");
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr.getContentType());
        Assert.assertEquals((Object)"MISS", (Object)sr.getHeader("geowebcache-cache-result"));
        this.checkNoCacheHeaders(sr);
    }

    private void checkNoCacheHeaders(MockHttpServletResponse sr) {
        Assert.assertEquals((Object)"no-cache, no-store, must-revalidate", (Object)sr.getHeader("Cache-control"));
        Assert.assertEquals((Object)"no-cache", (Object)sr.getHeader("Pragma"));
        Assert.assertEquals((Object)"0", (Object)sr.getHeader("Expires"));
    }

    private void addDimension(FeatureTypeInfo vte, String dimensionName, String attribute) {
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setEnabled(true);
        di.setAttribute(attribute);
        di.setPresentation(DimensionPresentation.LIST);
        vte.getMetadata().put(dimensionName, (Serializable)di);
    }

    static {
        WMTS_NAMESPACES_10.put("xlink", "http://www.w3.org/1999/xlink");
        WMTS_NAMESPACES_10.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        WMTS_NAMESPACES_10.put("ows", "http://www.opengis.net/ows/1.1");
        WMTS_NAMESPACES_10.put("wmts", "http://www.opengis.net/wmts/1.0");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(WMTS_NAMESPACES_10));
        WMTS_XPATH_10 = XMLUnit.newXpathEngine();
        WORKSPACED_LAYER_QNAME = new QName(TEST_WORKSPACE_URI, WORKSPACED_LAYER, TEST_WORKSPACE_NAME);
        BASIC_POLYGONS_NO_CRS = new QName(MockData.CITE_URI, "BasicPolygonsNoCrs", MockData.CITE_PREFIX);
        V_TIME_ELEVATION = new QName(MockData.SF_URI, "TimeElevation", MockData.SF_PREFIX);
    }
}

