/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.dispatch;

import java.util.Collections;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.gwc.dispatch.GwcServiceDispatcherCallback;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.ows.Request;
import org.geoserver.platform.ServiceException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class GwcServiceDispatcherCallbackTest {
    @After
    public void cleanLocalWorkspace() {
        LocalWorkspace.remove();
    }

    @Test
    public void testThatGwcServiceRequestsAreAccepted() {
        HttpServletRequest httpRequest = this.newMockHttpRequest();
        Mockito.when((Object)httpRequest.getParameterMap()).thenReturn(Collections.emptyMap());
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getHttpRequest()).thenReturn((Object)httpRequest);
        GwcServiceDispatcherCallback callback = new GwcServiceDispatcherCallback(null);
        Mockito.when((Object)request.getContext()).thenReturn((Object)"wms/service");
        MatcherAssert.assertThat((Object)callback.init(request), (Matcher)Matchers.nullValue());
        Mockito.when((Object)request.getContext()).thenReturn((Object)"gwc/service");
        MatcherAssert.assertThat((Object)callback.init(request), (Matcher)Matchers.notNullValue());
        LocalWorkspace.set((WorkspaceInfo)((WorkspaceInfo)Mockito.mock(WorkspaceInfo.class)));
        Mockito.when((Object)request.getContext()).thenReturn((Object)"validWorkspace/gwc/service");
        MatcherAssert.assertThat((Object)callback.init(request), (Matcher)Matchers.notNullValue());
        LocalWorkspace.remove();
        Mockito.when((Object)request.getContext()).thenReturn((Object)"invalidWorkspace/gwc/service");
        try {
            callback.init(request);
            Assert.fail((String)"The workspace is not valid, an exception should have been throw.");
        }
        catch (ServiceException serviceException) {
            MatcherAssert.assertThat((Object)serviceException.getMessage(), (Matcher)Matchers.is((Object)"No such workspace 'invalidWorkspace'"));
        }
    }

    public HttpServletRequest newMockHttpRequest() {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)request.getServerName()).thenReturn((Object)"http");
        Mockito.when((Object)request.getServerPort()).thenReturn((Object)8080);
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"/geoserver/gwc");
        return request;
    }

    @Test
    public void testGwcVirtualServiceRequestWrapper() {
        HttpServletRequest httpRequest = this.newMockHttpRequest();
        Mockito.when((Object)httpRequest.getParameterMap()).thenReturn(new HashMap());
        Mockito.when((Object)httpRequest.getContextPath()).thenReturn((Object)"geoserver");
        Request request = new Request();
        request.setKvp(Collections.singletonMap("LAYER", "someLayer"));
        request.setHttpRequest(httpRequest);
        request.setContext("someWorkspace/gwc/service");
        WorkspaceInfo workspace = (WorkspaceInfo)Mockito.mock(WorkspaceInfo.class);
        Mockito.when((Object)workspace.getName()).thenReturn((Object)"someWorkspace");
        GwcServiceDispatcherCallback callback = new GwcServiceDispatcherCallback(null);
        LocalWorkspace.set((WorkspaceInfo)workspace);
        Request wrappedRequest = callback.init(request);
        MatcherAssert.assertThat((Object)wrappedRequest, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)wrappedRequest.getHttpRequest(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)wrappedRequest.getHttpRequest().getContextPath(), (Matcher)Matchers.is((Object)"geoserver/someWorkspace"));
        MatcherAssert.assertThat((Object)wrappedRequest.getHttpRequest().getParameter("layer"), (Matcher)Matchers.is((Object)"someWorkspace:someLayer"));
        MatcherAssert.assertThat((Object)wrappedRequest.getHttpRequest().getParameterMap(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)((String[])wrappedRequest.getHttpRequest().getParameterMap().get("layer")), (Matcher)Matchers.is((Object)new String[]{"someWorkspace:someLayer"}));
        MatcherAssert.assertThat((Object)wrappedRequest.getHttpRequest().getParameterValues("layer"), (Matcher)Matchers.is((Object)new String[]{"someWorkspace:someLayer"}));
    }

    @Test
    public void testThatGwcOperationIsStored() {
        HttpServletRequest httpRequest = this.newMockHttpRequest();
        Mockito.when((Object)httpRequest.getParameterMap()).thenReturn(Collections.emptyMap());
        Request request = new Request();
        request.setKvp(Collections.singletonMap("REQUEST", "GetCapabilities"));
        request.setHttpRequest(httpRequest);
        request.setContext("gwc/service");
        GwcServiceDispatcherCallback callback = new GwcServiceDispatcherCallback(null);
        Request wrappedRequest = callback.init(request);
        MatcherAssert.assertThat((Object)wrappedRequest, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)((String)GwcServiceDispatcherCallback.GWC_OPERATION.get()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)((String)GwcServiceDispatcherCallback.GWC_OPERATION.get()), (Matcher)Matchers.is((Object)"GetCapabilities"));
    }
}

