/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.impl.CatalogModifyEventImpl;
import org.geoserver.catalog.event.impl.CatalogPostModifyEventImpl;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.CatalogStyleChangeListener;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.gwc.layer.StyleParameterFilter;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.layer.TileLayer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;

public class CatalogStyleChangeListenerTest {
    private final String STYLE_NAME = "highways";
    private String STYLE_NAME_MODIFIED = "highways_modified";
    private final String PREFIXED_RESOURCE_NAME = "mock:Layer";
    private GWC mockMediator;
    private ResourceInfo mockResourceInfo;
    private LayerInfo mockLayerInfo;
    private StyleInfo mockStyle;
    private GeoServerTileLayer mockTileLayer;
    private GeoServerTileLayerInfoImpl mockTileLayerInfo;
    private CatalogModifyEventImpl styleNameModifyEvent;
    private CatalogStyleChangeListener listener;

    @Before
    public void setUp() throws Exception {
        this.mockMediator = (GWC)Mockito.mock(GWC.class);
        this.mockStyle = (StyleInfo)Mockito.mock(StyleInfo.class);
        Mockito.when((Object)this.mockStyle.prefixedName()).thenReturn((Object)"highways");
        this.mockResourceInfo = (ResourceInfo)Mockito.mock(FeatureTypeInfo.class);
        Mockito.when((Object)this.mockResourceInfo.prefixedName()).thenReturn((Object)"mock:Layer");
        this.mockLayerInfo = (LayerInfo)Mockito.mock(LayerInfo.class);
        Mockito.when((Object)this.mockLayerInfo.getResource()).thenReturn((Object)this.mockResourceInfo);
        this.mockTileLayer = (GeoServerTileLayer)Mockito.mock(GeoServerTileLayer.class);
        this.mockTileLayerInfo = (GeoServerTileLayerInfoImpl)Mockito.mock(GeoServerTileLayerInfoImpl.class);
        ImmutableSet empty = ImmutableSet.of();
        Mockito.when((Object)this.mockTileLayerInfo.cachedStyles()).thenReturn((Object)empty);
        Mockito.when((Object)this.mockTileLayer.getPublishedInfo()).thenReturn((Object)this.mockLayerInfo);
        Mockito.when((Object)this.mockTileLayer.getInfo()).thenReturn((Object)this.mockTileLayerInfo);
        Mockito.when((Object)this.mockTileLayer.getName()).thenReturn((Object)"mock:Layer");
        Mockito.when((Object)this.mockMediator.getTileLayersForStyle((String)ArgumentMatchers.eq((Object)"highways"))).thenReturn(Collections.singletonList(this.mockTileLayer));
        Catalog mockCatalog = (Catalog)Mockito.mock(Catalog.class);
        this.listener = new CatalogStyleChangeListener(this.mockMediator, mockCatalog);
        this.styleNameModifyEvent = new CatalogModifyEventImpl();
        this.styleNameModifyEvent.setSource((CatalogInfo)this.mockStyle);
        this.styleNameModifyEvent.setPropertyNames(Arrays.asList("name"));
        this.styleNameModifyEvent.setOldValues(Arrays.asList("highways"));
        this.styleNameModifyEvent.setNewValues(Arrays.asList(this.STYLE_NAME_MODIFIED));
    }

    @Test
    public void testIgnorableChange() throws Exception {
        this.styleNameModifyEvent.setPropertyNames(Arrays.asList("fileName"));
        this.listener.handleModifyEvent((CatalogModifyEvent)this.styleNameModifyEvent);
        this.styleNameModifyEvent.setPropertyNames(Arrays.asList("name"));
        this.styleNameModifyEvent.setOldValues(Arrays.asList("highways"));
        this.styleNameModifyEvent.setNewValues(Arrays.asList("highways"));
        this.listener.handleModifyEvent((CatalogModifyEvent)this.styleNameModifyEvent);
        this.styleNameModifyEvent.setSource((CatalogInfo)Mockito.mock(LayerInfo.class));
        this.listener.handleModifyEvent((CatalogModifyEvent)this.styleNameModifyEvent);
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.never())).truncateByLayerAndStyle(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.never())).save((TileLayer)ArgumentMatchers.any());
        ((GeoServerTileLayer)Mockito.verify((Object)this.mockTileLayer, (VerificationMode)Mockito.never())).getInfo();
        ((GeoServerTileLayerInfoImpl)Mockito.verify((Object)this.mockTileLayerInfo, (VerificationMode)Mockito.never())).cachedStyles();
    }

    @Test
    public void testRenameDefaultStyle() throws Exception {
        this.listener.handleModifyEvent((CatalogModifyEvent)this.styleNameModifyEvent);
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.never())).truncateByLayerAndStyle(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.never())).save((TileLayer)ArgumentMatchers.any());
        ((GeoServerTileLayer)Mockito.verify((Object)this.mockTileLayer, (VerificationMode)Mockito.atLeastOnce())).getInfo();
        ((GeoServerTileLayerInfoImpl)Mockito.verify((Object)this.mockTileLayerInfo, (VerificationMode)Mockito.atLeastOnce())).cachedStyles();
    }

    @Test
    public void testRenameAlternateStyle() throws Exception {
        HashSet<StyleParameterFilter> params = new HashSet<StyleParameterFilter>();
        StyleParameterFilter newStyleFilter = new StyleParameterFilter();
        newStyleFilter.setStyles((Set)ImmutableSet.of((Object)"highways"));
        params.add(newStyleFilter);
        TileLayerInfoUtil.setCachedStyles((GeoServerTileLayerInfo)this.mockTileLayerInfo, null, (Set)ImmutableSet.of((Object)"highways"));
        ((GeoServerTileLayerInfoImpl)Mockito.verify((Object)this.mockTileLayerInfo)).addParameterFilter((ParameterFilter)MockitoHamcrest.argThat((Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"key", (Matcher)Matchers.is((Object)"STYLES")), (Matcher)Matchers.hasProperty((String)"styles", (Matcher)Matchers.is((Object)ImmutableSet.of((Object)"highways"))))));
        ImmutableSet styles = ImmutableSet.of((Object)"highways");
        Mockito.when((Object)this.mockTileLayerInfo.cachedStyles()).thenReturn((Object)styles);
        this.listener.handleModifyEvent((CatalogModifyEvent)this.styleNameModifyEvent);
        ((GeoServerTileLayerInfoImpl)Mockito.verify((Object)this.mockTileLayerInfo)).addParameterFilter((ParameterFilter)MockitoHamcrest.argThat((Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"key", (Matcher)Matchers.is((Object)"STYLES")), (Matcher)Matchers.hasProperty((String)"styles", (Matcher)Matchers.is((Object)ImmutableSet.of((Object)this.STYLE_NAME_MODIFIED))))));
        ((GeoServerTileLayer)Mockito.verify((Object)this.mockTileLayer, (VerificationMode)Mockito.times((int)1))).resetParameterFilters();
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).truncateByLayerAndStyle((String)ArgumentMatchers.eq((Object)"mock:Layer"), (String)ArgumentMatchers.eq((Object)"highways"));
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).save((TileLayer)ArgumentMatchers.same((Object)this.mockTileLayer));
    }

    @Test
    public void testLayerInfoDefaultOrAlternateStyleChanged() throws Exception {
        Mockito.when((Object)this.mockMediator.getLayerInfosFor((StyleInfo)ArgumentMatchers.same((Object)this.mockStyle))).thenReturn(Collections.singleton(this.mockLayerInfo));
        Mockito.when((Object)this.mockMediator.getLayerGroupsFor((StyleInfo)ArgumentMatchers.same((Object)this.mockStyle))).thenReturn(Collections.emptyList());
        CatalogPostModifyEventImpl postModifyEvent = new CatalogPostModifyEventImpl();
        postModifyEvent.setSource((CatalogInfo)this.mockStyle);
        this.listener.handlePostModifyEvent((CatalogPostModifyEvent)postModifyEvent);
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).truncateByLayerAndStyle((String)ArgumentMatchers.eq((Object)"mock:Layer"), (String)ArgumentMatchers.eq((Object)"highways"));
    }

    @Test
    public void testLayerGroupInfoImplicitOrExplicitStyleChanged() throws Exception {
        LayerGroupInfo mockGroup = (LayerGroupInfo)Mockito.mock(LayerGroupInfo.class);
        Mockito.when((Object)GWC.tileLayerName((LayerGroupInfo)mockGroup)).thenReturn((Object)"mockGroup");
        Mockito.when((Object)this.mockMediator.getLayerInfosFor((StyleInfo)ArgumentMatchers.same((Object)this.mockStyle))).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.mockMediator.getLayerGroupsFor((StyleInfo)ArgumentMatchers.same((Object)this.mockStyle))).thenReturn(Collections.singleton(mockGroup));
        CatalogPostModifyEventImpl postModifyEvent = new CatalogPostModifyEventImpl();
        postModifyEvent.setSource((CatalogInfo)this.mockStyle);
        this.listener.handlePostModifyEvent((CatalogPostModifyEvent)postModifyEvent);
        ((GWC)Mockito.verify((Object)this.mockMediator, (VerificationMode)Mockito.times((int)1))).truncate((String)ArgumentMatchers.eq((Object)"mockGroup"));
    }

    @Test
    public void testChangeWorkspaceWithoutName() {
        CatalogModifyEventImpl modifyEvent = new CatalogModifyEventImpl();
        modifyEvent.setSource((CatalogInfo)this.mockStyle);
        modifyEvent.setPropertyNames(Collections.singletonList("workspace"));
        modifyEvent.setOldValues(Collections.singletonList(""));
        modifyEvent.setNewValues(Collections.singletonList("test"));
        this.listener.handleModifyEvent((CatalogModifyEvent)modifyEvent);
    }
}

