/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import java.util.ArrayList;
import java.util.UUID;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.gwc.GWCTestHelpers;
import org.geoserver.gwc.layer.StyleParameterFilter;
import org.junit.Assert;
import org.junit.Test;

public class StyleParameterFilterTest {
    @Test(timeout=10000L)
    public void testConcurrentModification() throws Exception {
        final StyleParameterFilter filter = new StyleParameterFilter();
        String[] styleNames = new String[]{UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString()};
        LayerInfoImpl layerInfo = GWCTestHelpers.mockLayer(UUID.randomUUID().toString(), styleNames, PublishedType.WMS);
        int concurrency = 10;
        final int opsPerThread = 1000;
        ArrayList<Thread> modifierThreads = new ArrayList<Thread>(concurrency);
        for (int i = 0; i < concurrency; ++i) {
            Thread thread = new Thread(new Runnable((LayerInfo)layerInfo){
                final /* synthetic */ LayerInfo val$layerInfo;
                {
                    this.val$layerInfo = layerInfo;
                }

                @Override
                public void run() {
                    for (int j = 0; j < opsPerThread; ++j) {
                        filter.setLayer(this.val$layerInfo);
                    }
                }
            });
            modifierThreads.add(thread);
        }
        for (Thread modifierThread : modifierThreads) {
            modifierThread.start();
        }
        for (Thread modifierThread : modifierThreads) {
            modifierThread.join();
        }
        String value = styleNames[0];
        Assert.assertEquals((Object)value, (Object)filter.apply(value));
    }
}

