/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.impl.LayerGroupInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.GWCTestHelpers;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geowebcache.filter.parameters.FloatParameterFilter;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.RegexParameterFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TileLayerInfoUtilTest {
    private GWCConfig defaults;
    private GeoServerTileLayerInfo defaultVectorInfo;

    @Before
    public void setup() throws Exception {
        this.defaults = GWCConfig.getOldDefaults();
        this.defaultVectorInfo = TileLayerInfoUtil.create((GWCConfig)this.defaults);
        this.defaultVectorInfo.getMimeFormats().clear();
        this.defaultVectorInfo.getMimeFormats().addAll(this.defaults.getDefaultVectorCacheFormats());
    }

    @Test
    public void testCreateLayerInfo() {
        LayerInfoImpl layer = GWCTestHelpers.mockLayer("testLayer", new String[0], PublishedType.RASTER);
        GeoServerTileLayerInfoImpl info = TileLayerInfoUtil.loadOrCreate((LayerInfo)layer, (GWCConfig)this.defaults);
        this.defaultVectorInfo.setId(layer.getId());
        this.defaultVectorInfo.setName(GWC.tileLayerName((LayerInfo)layer));
        Assert.assertNotNull((Object)info);
        Assert.assertEquals((Object)this.defaultVectorInfo, (Object)info);
    }

    @Test
    public void testCreateLayerGroupInfo() {
        LayerGroupInfoImpl group = GWCTestHelpers.mockGroup("testGroup", new PublishedInfo[]{GWCTestHelpers.mockLayer("testLayer", new String[0], PublishedType.RASTER)});
        this.defaults.getDefaultOtherCacheFormats().clear();
        this.defaults.getDefaultOtherCacheFormats().add("image/png8");
        this.defaults.getDefaultOtherCacheFormats().add("image/jpeg");
        GeoServerTileLayerInfoImpl expected = TileLayerInfoUtil.create((GWCConfig)this.defaults);
        expected.setId(group.getId());
        expected.setName(GWC.tileLayerName((LayerGroupInfo)group));
        GeoServerTileLayerInfoImpl info = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)group, (GWCConfig)this.defaults);
        Assert.assertNotNull((Object)info);
        Assert.assertEquals((Object)expected, (Object)info);
    }

    @Test
    public void testCreateLayerInfoAutoCacheStyles() {
        GeoServerTileLayerInfo info = this.defaultVectorInfo;
        info.setAutoCacheStyles(true);
        this.defaults.setCacheNonDefaultStyles(true);
        LayerInfoImpl layer = GWCTestHelpers.mockLayer("testLayer", new String[]{"style1", "style2"}, PublishedType.RASTER);
        GeoServerTileLayerInfoImpl actual = TileLayerInfoUtil.loadOrCreate((LayerInfo)layer, (GWCConfig)this.defaults);
        TileLayerInfoUtil.checkAutomaticStyles((LayerInfo)layer, (GeoServerTileLayerInfo)info);
        TileLayerInfoUtil.setCachedStyles((GeoServerTileLayerInfo)info, (String)"default", (Set)ImmutableSet.of((Object)"style1", (Object)"style2"));
        layer.setDefaultStyle(null);
        TileLayerInfoUtil.setCachedStyles((GeoServerTileLayerInfo)info, (String)"", (Set)ImmutableSet.of((Object)"style1", (Object)"style2"));
        actual = TileLayerInfoUtil.loadOrCreate((LayerInfo)layer, (GWCConfig)this.defaults);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"style1", (Object)"style2"), (Object)actual.cachedStyles());
    }

    @Test
    public void testCreateLayerGroup() {
        LayerGroupInfoImpl lg = GWCTestHelpers.mockGroup("tesGroup", new PublishedInfo[]{GWCTestHelpers.mockLayer("L1", new String[0], PublishedType.RASTER), GWCTestHelpers.mockLayer("L2", new String[0], PublishedType.RASTER)});
        GeoServerTileLayerInfo info = this.defaultVectorInfo;
        info.setId(lg.getId());
        info.setName(GWC.tileLayerName((LayerGroupInfo)lg));
        info.getMimeFormats().clear();
        info.getMimeFormats().addAll(this.defaults.getDefaultOtherCacheFormats());
        GeoServerTileLayerInfoImpl actual = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)lg, (GWCConfig)this.defaults);
        Assert.assertEquals((Object)info, (Object)actual);
    }

    @Test
    public void testUpdateAcceptAllRegExParameterFilter() {
        GeoServerTileLayerInfo info = this.defaultVectorInfo;
        TileLayerInfoUtil.updateAcceptAllRegExParameterFilter((GeoServerTileLayerInfo)info, (String)"ENV", (boolean)false);
        Assert.assertNull((Object)TileLayerInfoUtilTest.findParameterFilter("ENV", info.getParameterFilters()));
        TileLayerInfoUtil.updateAcceptAllRegExParameterFilter((GeoServerTileLayerInfo)info, (String)"ENV", (boolean)true);
        ParameterFilter filter = TileLayerInfoUtilTest.findParameterFilter("ENV", info.getParameterFilters());
        Assert.assertTrue((boolean)(filter instanceof RegexParameterFilter));
        Assert.assertEquals((Object)".*", (Object)((RegexParameterFilter)filter).getRegex());
        TileLayerInfoUtil.updateAcceptAllRegExParameterFilter((GeoServerTileLayerInfo)info, (String)"ENV", (boolean)true);
        ParameterFilter filter2 = TileLayerInfoUtilTest.findParameterFilter("ENV", info.getParameterFilters());
        Assert.assertNotSame((Object)filter, (Object)filter2);
        Assert.assertEquals((Object)filter, (Object)filter2);
        TileLayerInfoUtil.updateAcceptAllRegExParameterFilter((GeoServerTileLayerInfo)info, (String)"ENV", (boolean)false);
        ParameterFilter filter3 = TileLayerInfoUtilTest.findParameterFilter("ENV", info.getParameterFilters());
        Assert.assertNotSame((Object)filter2, (Object)filter3);
        Assert.assertEquals((Object)filter, (Object)filter3);
    }

    @Test
    public void testUpdateAcceptAllFloatParameterFilter() {
        GeoServerTileLayerInfo info = this.defaultVectorInfo;
        TileLayerInfoUtil.updateAcceptAllFloatParameterFilter((GeoServerTileLayerInfo)info, (String)"ELEVATION", (boolean)false);
        Assert.assertNull((Object)TileLayerInfoUtilTest.findParameterFilter("ELEVATION", info.getParameterFilters()));
        TileLayerInfoUtil.updateAcceptAllFloatParameterFilter((GeoServerTileLayerInfo)info, (String)"ELEVATION", (boolean)true);
        ParameterFilter filter = TileLayerInfoUtilTest.findParameterFilter("ELEVATION", info.getParameterFilters());
        Assert.assertTrue((boolean)(filter instanceof FloatParameterFilter));
        Assert.assertEquals((long)0L, (long)((FloatParameterFilter)filter).getValues().size());
        TileLayerInfoUtil.updateAcceptAllFloatParameterFilter((GeoServerTileLayerInfo)info, (String)"ELEVATION", (boolean)true);
        ParameterFilter filter2 = TileLayerInfoUtilTest.findParameterFilter("ELEVATION", info.getParameterFilters());
        Assert.assertNotSame((Object)filter, (Object)filter2);
        Assert.assertEquals((Object)filter, (Object)filter2);
        TileLayerInfoUtil.updateAcceptAllFloatParameterFilter((GeoServerTileLayerInfo)info, (String)"ELEVATION", (boolean)false);
        ParameterFilter filter3 = TileLayerInfoUtilTest.findParameterFilter("ELEVATION", info.getParameterFilters());
        Assert.assertNotSame((Object)filter2, (Object)filter3);
        Assert.assertEquals((Object)filter, (Object)filter3);
    }

    private static ParameterFilter findParameterFilter(String paramName, Set<ParameterFilter> parameterFilters) {
        if (parameterFilters == null || parameterFilters.isEmpty()) {
            return null;
        }
        for (ParameterFilter pf : parameterFilters) {
            if (!paramName.equalsIgnoreCase(pf.getKey())) continue;
            return pf;
        }
        return null;
    }
}

