/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.builder;

import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Kml;
import java.util.List;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.decorator.KmlDecoratorFactory;
import org.geoserver.kml.iterator.IteratorList;
import org.geoserver.kml.iterator.PlainFolderIteratorFactory;
import org.geoserver.platform.ServiceException;

public class StreamingKMLBuilder {
    public Kml buildKMLDocument(KmlEncodingContext context) {
        Kml kml = new Kml();
        Document document = kml.createAndSetDocument();
        String kmltitle = (String)context.getRequest().getFormatOptions().get("kmltitle");
        document.setName(kmltitle);
        List<KmlDecoratorFactory.KmlDecorator> decorators = context.getDecoratorsForClass(Document.class);
        for (KmlDecoratorFactory.KmlDecorator decorator : decorators) {
            document = (Document)decorator.decorate((Feature)document, context);
            if (document != null) continue;
            throw new ServiceException("Coding error in decorator " + decorator + ", document objects cannot be set to null");
        }
        PlainFolderIteratorFactory generatorFactory = new PlainFolderIteratorFactory(context);
        IteratorList<Feature> folders = new IteratorList<Feature>(generatorFactory);
        context.addFeatures(document, folders);
        return kml;
    }
}

