/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.iterator;

import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import de.micromata.opengis.kml.v_2_2_0.GroundOverlay;
import de.micromata.opengis.kml.v_2_2_0.Icon;
import de.micromata.opengis.kml.v_2_2_0.LatLonBox;
import de.micromata.opengis.kml.v_2_2_0.ViewRefreshMode;
import java.util.Iterator;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.iterator.AbstractFolderIteratorFactory;
import org.geoserver.kml.iterator.FeatureIteratorFactory;
import org.geoserver.kml.iterator.IteratorList;
import org.geoserver.kml.iterator.KMLCentroidFeatureCollection;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSRequests;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Envelope;

public class PlainFolderIteratorFactory
extends AbstractFolderIteratorFactory {
    public PlainFolderIteratorFactory(KmlEncodingContext context) {
        super(context);
    }

    @Override
    public Iterator<Feature> newIterator() {
        return new PlainFolderGenerator();
    }

    public class PlainFolderGenerator
    extends AbstractFolderIteratorFactory.AbstractFolderGenerator {
        public PlainFolderGenerator() {
            super(PlainFolderIteratorFactory.this);
        }

        @Override
        protected void encodeFolderContents(Layer layer, Folder folder) {
            if (layer instanceof FeatureLayer) {
                if (this.useVectorOutput(PlainFolderIteratorFactory.this.context)) {
                    IteratorList<Feature> features = new IteratorList<Feature>(new FeatureIteratorFactory(PlainFolderIteratorFactory.this.context, (FeatureLayer)layer));
                    PlainFolderIteratorFactory.this.context.addFeatures(folder, features);
                } else {
                    this.addGroundOverlay(folder, layer);
                    if (PlainFolderIteratorFactory.this.context.isPlacemarkForced()) {
                        this.addFeatureCentroids(layer, folder);
                    }
                }
            } else {
                this.addGroundOverlay(folder, layer);
            }
        }

        private void addFeatureCentroids(Layer layer, Folder folder) {
            KMLCentroidFeatureCollection centroids = new KMLCentroidFeatureCollection((FeatureCollection<SimpleFeatureType, SimpleFeature>)PlainFolderIteratorFactory.this.context.getCurrentFeatureCollection(), PlainFolderIteratorFactory.this.context);
            PlainFolderIteratorFactory.this.context.setCurrentFeatureCollection((SimpleFeatureCollection)centroids);
            FeatureLayer centroidsLayer = new FeatureLayer((FeatureCollection)centroids, layer.getStyle(), layer.getTitle());
            IteratorList<Feature> features = new IteratorList<Feature>(new FeatureIteratorFactory(PlainFolderIteratorFactory.this.context, centroidsLayer));
            PlainFolderIteratorFactory.this.context.addFeatures(folder, features);
        }

        private void addGroundOverlay(Folder folder, Layer layer) {
            boolean reprojectBBox;
            int mapLayerOrder = PlainFolderIteratorFactory.this.context.getMapContent().layers().indexOf(layer);
            GroundOverlay go = folder.createAndAddGroundOverlay();
            go.setName(((MapLayerInfo)PlainFolderIteratorFactory.this.context.getMapContent().getRequest().getLayers().get(mapLayerOrder)).getLabel());
            go.setDrawOrder(mapLayerOrder);
            Icon icon = go.createAndSetIcon();
            icon.setHref(this.getGroundOverlayHRef(layer));
            icon.setViewRefreshMode(ViewRefreshMode.NEVER);
            icon.setViewBoundScale(0.75);
            ReferencedEnvelope box = new ReferencedEnvelope(PlainFolderIteratorFactory.this.context.getMapContent().getRenderingArea());
            boolean bl = reprojectBBox = box.getCoordinateReferenceSystem() != null && !CRS.equalsIgnoreMetadata((Object)box.getCoordinateReferenceSystem(), (Object)DefaultGeographicCRS.WGS84);
            if (reprojectBBox) {
                try {
                    box = box.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
                }
                catch (Exception e) {
                    throw new ServiceException("Could not transform bbox to WGS84", (Throwable)e, "ReprojectionError", "");
                }
            }
            LatLonBox gobox = go.createAndSetLatLonBox();
            gobox.setEast(box.getMaxX());
            gobox.setWest(box.getMinX());
            gobox.setNorth(box.getMaxY());
            gobox.setSouth(box.getMinY());
        }

        String getGroundOverlayHRef(Layer layer) {
            WMSMapContent mapContent = PlainFolderIteratorFactory.this.context.getMapContent();
            if (PlainFolderIteratorFactory.this.context.isKmz()) {
                int mapLayerOrder = mapContent.layers().indexOf(layer);
                String href = "images/layers_" + mapLayerOrder + ".png";
                PlainFolderIteratorFactory.this.context.addKmzGroundOverlay(href, layer);
                return href;
            }
            return WMSRequests.getGetMapUrl((GetMapRequest)mapContent.getRequest(), (Layer)layer, (int)0, (Envelope)mapContent.getRenderingArea(), (String[])new String[]{"format", "image/png", "transparent", "true"});
        }

        boolean useVectorOutput(KmlEncodingContext context) {
            String mode = context.getMode();
            if ("refresh".equalsIgnoreCase(mode)) {
                int kmscore = context.getKmScore();
                if (kmscore == 100) {
                    return true;
                }
                if (kmscore == 0) {
                    return false;
                }
                double magic = Math.pow(10.0, kmscore / 15);
                int currentSize = context.getCurrentFeatureCollection().size();
                return !((double)currentSize > magic);
            }
            return true;
        }
    }
}

