/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.utils;

import java.util.ArrayList;
import java.util.List;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Or;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Rule;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.styling.AbstractStyleVisitor;

public class RuleFiltersCollector
extends AbstractStyleVisitor {
    List<Filter> filters = new ArrayList<Filter>();

    public void visit(FeatureTypeStyle fts) {
        for (Rule rule : fts.rules()) {
            if (rule.isElseFilter()) {
                this.filters.add((Filter)Filter.INCLUDE);
                continue;
            }
            Filter filter = rule.getFilter();
            if (filter == null) {
                this.filters.add((Filter)Filter.INCLUDE);
                continue;
            }
            this.filters.add(filter);
        }
    }

    Filter getSummaryFilter() {
        if (this.filters.isEmpty()) {
            return Filter.INCLUDE;
        }
        if (this.filters.size() == 1) {
            return this.filters.get(0);
        }
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Or or = ff.or(this.filters);
        SimplifyingFilterVisitor simplifier = new SimplifyingFilterVisitor();
        return (Filter)or.accept((FilterVisitor)simplifier, null);
    }
}

