/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import de.micromata.opengis.kml.v_2_2_0.Kml;
import java.awt.RenderingHints;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.kml.KMLEncoder;
import org.geoserver.kml.KMLMap;
import org.geoserver.kml.KMLMapOutputFormat;
import org.geoserver.kml.KMLMapResponse;
import org.geoserver.kml.KMZMapOutputFormat;
import org.geoserver.kml.regionate.CachedHierarchyRegionatingStrategy;
import org.geoserver.ows.kvp.FormatOptionsKvpParser;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.FeatureListener;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.util.xml.SimpleNamespaceContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class KMLReflectorTest
extends WMSTestSupport {
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        testData.addStyle("Bridge", "bridge.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("allsymbolizers", "allsymbolizers.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("labels", "labels.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("SingleFeature", "singlefeature.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("BridgeSubdir", "bridgesubdir.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("dynamicsymbolizer", "dynamicsymbolizer.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("relativeds", "relativeds.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("big-local-image", "big-local-image.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("big-mark", "big-mark.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.copyTo(((Object)((Object)this)).getClass().getResourceAsStream("bridge.png"), "styles/bridge.png");
        testData.copyTo(((Object)((Object)this)).getClass().getResourceAsStream("planet-42.png"), "styles/planet-42.png");
        File stylesDir = new File(testData.getDataDirectoryRoot(), "styles");
        new File(stylesDir, "graphics").mkdir();
        testData.copyTo(((Object)((Object)this)).getClass().getResourceAsStream("bridge.png"), "styles/graphics/bridgesubdir.png");
    }

    protected void onTearDown(SystemTestData testData) throws Exception {
        File dir = this.getDataDirectory().findOrCreateDir(new String[]{"geosearch"});
        CachedHierarchyRegionatingStrategy.clearAllHsqlDatabases((File)dir);
        super.onTearDown(testData);
    }

    @Test
    public void testNoBBOXInHREF() throws Exception {
        String layerName = MockData.BASIC_POLYGONS.getLocalPart();
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String requestURL = "wms/kml?mode=refresh&layers=" + layerName;
        Document dom = this.getAsDOM(requestURL);
        this.print(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(kml:kml/kml:Document)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(kml:kml/kml:Document/kml:NetworkLink)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(kml:kml/kml:Document/kml:LookAt)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)layerName, (String)"kml:kml/kml:Document/kml:NetworkLink[1]/kml:name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"kml:kml/kml:Document/kml:NetworkLink[1]/kml:open", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"kml:kml/kml:Document/kml:NetworkLink[1]/kml:visibility", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"onStop", (String)"kml:kml/kml:Document/kml:NetworkLink[1]/kml:Url/kml:viewRefreshMode", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1.0", (String)"kml:kml/kml:Document/kml:NetworkLink[1]/kml:Url/kml:viewRefreshTime", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1.0", (String)"kml:kml/kml:Document/kml:NetworkLink[1]/kml:Url/kml:viewBoundScale", (Document)dom);
        Map expectedKVP = KvpUtils.parseQueryString((String)"http://localhost:80/geoserver/wms?format_options=MODE%3Arefresh%3Bautofit%3Atrue%3BKMPLACEMARK%3Afalse%3BKMATTR%3Atrue%3BKMSCORE%3A40%3BSUPEROVERLAY%3Afalse&service=wms&srs=EPSG%3A4326&width=2048&styles=BasicPolygons&height=2048&transparent=false&request=GetMap&layers=cite%3ABasicPolygons&format=application%2Fvnd.google-earth.kml+xml&version=1.1.1");
        Map resultedKVP = KvpUtils.parseQueryString((String)xpath.evaluate("kml:kml/kml:Document/kml:NetworkLink[1]/kml:Url/kml:href", dom));
        KMLReflectorTest.assertMapsEqual(expectedKVP, resultedKVP);
        String href = xpath.evaluate("kml:kml/kml:Document/kml:NetworkLink/kml:Link/kml:href", dom);
        Pattern badPattern = Pattern.compile("&bbox=", 2);
        Assert.assertFalse((boolean)badPattern.matcher(href).matches());
    }

    @Test
    public void testBBOXInHREF() throws Exception {
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String requestURL = "wms/kml?layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&bbox=-1,-1,-0.5,-0.5&mode=download";
        Document dom = this.getAsDOM(requestURL);
        Assert.assertEquals((long)1L, (long)xpath.getMatchingNodes("//kml:Placemark", dom).getLength());
    }

    @Test
    public void testDownloadMultiLayer() throws Exception {
        String requestURL = "wms/kml?&layers=" + this.getLayerId(MockData.LAKES) + "," + this.getLayerId(MockData.FORESTS);
        MockHttpServletResponse response = this.getAsServletResponse(requestURL);
        Assert.assertEquals((Object)"application/vnd.google-earth.kml+xml", (Object)response.getContentType());
        Assert.assertEquals((Object)"attachment; filename=cite-Lakes_cite-Forests.kml", (Object)response.getHeader("Content-Disposition"));
        Document dom = this.dom(this.getBinaryInputStream(response));
        this.print(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(kml:kml/kml:Document)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(kml:kml/kml:Document/kml:NetworkLink)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(kml:kml/kml:Document/kml:NetworkLink/kml:LookAt)", (Document)dom);
    }

    @Test
    public void testSuperOverlayReflection() throws Exception {
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String requestUrl = "wms/kml?layers=" + layerName + "&styles=&mode=superoverlay";
        Document dom = this.getAsDOM(requestUrl);
        Assert.assertEquals((Object)"kml", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathExists((String)"kml:kml/kml:Document/kml:Folder/kml:NetworkLink/kml:Link/kml:href", (Document)dom);
        XMLAssert.assertXpathExists((String)"kml:kml/kml:Document/kml:LookAt/kml:longitude", (Document)dom);
    }

    @Test
    public void testWmsRepeatedLayerWithNonStandardStyleAndCqlFiler() throws Exception {
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String titleName = MockData.BASIC_POLYGONS.getLocalPart();
        String abstractValue = "abstract about " + titleName;
        String requestUrl = "wms/kml?mode=refresh&layers=" + layerName + "," + layerName + "&styles=Default,Default&cql_filter=att1<10;att1>1000";
        Document dom = this.getAsDOM(requestUrl);
        Assert.assertEquals((Object)"kml", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(kml:kml/kml:Document/kml:NetworkLink)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)titleName, (String)"kml:kml/kml:Document/kml:NetworkLink[1]/kml:name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)abstractValue, (String)"kml:kml/kml:Document/kml:NetworkLink[1]/kml:description", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)titleName, (String)"kml:kml/kml:Document/kml:NetworkLink[2]/kml:name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)abstractValue, (String)"kml:kml/kml:Document/kml:NetworkLink[2]/kml:description", (Document)dom);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String url1 = xpath.evaluate("/kml:kml/kml:Document/kml:NetworkLink[1]/kml:Url/kml:href", dom);
        String url2 = xpath.evaluate("/kml:kml/kml:Document/kml:NetworkLink[2]/kml:Url/kml:href", dom);
        Assert.assertNotNull((Object)url1);
        Assert.assertNotNull((Object)url2);
        Map kvp1 = KvpUtils.parseQueryString((String)url1);
        Map kvp2 = KvpUtils.parseQueryString((String)url2);
        Assert.assertEquals((Object)layerName, kvp1.get("layers"));
        Assert.assertEquals((Object)layerName, kvp2.get("layers"));
        Assert.assertEquals((Object)"Default", kvp1.get("styles"));
        Assert.assertEquals((Object)"Default", kvp2.get("styles"));
        Assert.assertEquals((Object)"att1<10", kvp1.get("cql_filter"));
        Assert.assertEquals((Object)"att1>1000", kvp2.get("cql_filter"));
    }

    @Test
    public void testKmlFormatOptionsAsKVP() throws Exception {
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String baseUrl = "wms/kml?layers=" + layerName + "&styles=&mode=superoverlay";
        String requestUrl = baseUrl + "&kmltitle=myCustomLayerTitle&kmscore=10&legend=true&kmattr=true";
        Document dom = this.getAsDOM(requestUrl);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String result = xpath.evaluate("//kml:NetworkLink/kml:Link/kml:href", dom);
        Map kvp = KvpUtils.parseQueryString((String)result);
        List<String> formatOptions = Arrays.asList(((String)kvp.get("format_options")).split(";"));
        Assert.assertEquals((long)9L, (long)formatOptions.size());
        Assert.assertTrue((boolean)formatOptions.contains("LEGEND:true"));
        Assert.assertTrue((boolean)formatOptions.contains("SUPEROVERLAY:true"));
        Assert.assertTrue((boolean)formatOptions.contains("AUTOFIT:true"));
        Assert.assertTrue((boolean)formatOptions.contains("KMPLACEMARK:false"));
        Assert.assertTrue((boolean)formatOptions.contains("OVERLAYMODE:auto"));
        Assert.assertTrue((boolean)formatOptions.contains("KMSCORE:10"));
        Assert.assertTrue((boolean)formatOptions.contains("MODE:superoverlay"));
        Assert.assertTrue((boolean)formatOptions.contains("KMATTR:true"));
        Assert.assertTrue((boolean)formatOptions.contains("KMLTITLE:myCustomLayerTitle"));
    }

    @Test
    public void testKmlTitleFormatOption() throws Exception {
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String requestUrl = "wms/kml?layers=" + layerName + "&styles=&mode=superoverlay&format_options=kmltitle:myCustomLayerTitle";
        Document dom = this.getAsDOM(requestUrl);
        Assert.assertEquals((Object)"kml", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"myCustomLayerTitle", (String)"/kml:kml/kml:Document/kml:name", (Document)dom);
    }

    @Test
    public void testKmlRefreshFormatOption() throws Exception {
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String requestUrl = "wms/kml?layers=" + layerName + "&format_options=kmlrefresh:expires";
        Document dom = this.getAsDOM(requestUrl);
        Assert.assertEquals((Object)"kml", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"onExpire", (String)"/kml:kml/kml:Document/kml:NetworkLink/kml:Url/kml:refreshMode", (Document)dom);
        requestUrl = "wms/kml?layers=" + layerName + "&format_options=kmlrefresh:60";
        dom = this.getAsDOM(requestUrl);
        XMLAssert.assertXpathEvaluatesTo((String)"onInterval", (String)"/kml:kml/kml:Document/kml:NetworkLink/kml:Url/kml:refreshMode", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"60.0", (String)"/kml:kml/kml:Document/kml:NetworkLink/kml:Url/kml:refreshInterval", (Document)dom);
    }

    @Test
    public void testKmlVisibleFormatOption() throws Exception {
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String requestUrl = "wms/kml?layers=" + layerName + "&format_options=kmlvisible:true";
        Document dom = this.getAsDOM(requestUrl);
        Assert.assertEquals((Object)"kml", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"/kml:kml/kml:Document/kml:NetworkLink/kml:visibility", (Document)dom);
        requestUrl = "wms/kml?layers=" + layerName + "&format_options=kmlvisible:false";
        dom = this.getAsDOM(requestUrl);
        Assert.assertEquals((Object)"kml", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"/kml:kml/kml:Document/kml:NetworkLink/kml:visibility", (Document)dom);
    }

    @Test
    public void testExternalGraphicBackround() throws Exception {
        String requestUrl = "wms/kml?layers=" + this.getLayerId(MockData.BRIDGES) + "&styles=Bridge&mode=download";
        Document dom = this.getAsDOM(requestUrl);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Style/kml:IconStyle/kml:Icon/kml:href)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//kml:Style/kml:IconStyle/kml:Icon/kml:color)", (Document)dom);
    }

    @Test
    public void testExternalGraphicSubdir() throws Exception {
        String requestUrl = "wms/kml?layers=" + this.getLayerId(MockData.BRIDGES) + "&styles=BridgeSubdir&mode=download";
        Document dom = this.getAsDOM(requestUrl);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/styles/graphics/bridgesubdir.png", (String)"//kml:Style[1]/kml:IconStyle/kml:Icon/kml:href", (Document)dom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProxyBaseURL() throws Exception {
        GeoServerInfo info;
        GeoServer gs = this.getGeoServer();
        try {
            info = gs.getGlobal();
            info.getSettings().setProxyBaseUrl("http://myhost:9999/gs");
            gs.save(info);
            String requestUrl = "wms/kml?layers=" + this.getLayerId(MockData.BRIDGES) + "&styles=Bridge&mode=download";
            Document dom = this.getAsDOM(requestUrl);
            XMLAssert.assertXpathEvaluatesTo((String)"http://myhost:9999/gs/styles/bridge.png", (String)"//kml:Style/kml:IconStyle/kml:Icon/kml:href", (Document)dom);
        }
        finally {
            info = gs.getGlobal();
            info.getSettings().setProxyBaseUrl(null);
            gs.save(info);
        }
    }

    @Test
    public void testFilteredData() throws Exception {
        String requestUrl = "wms/kml?layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=SingleFeature&mode=download";
        Document dom = this.getAsDOM(requestUrl);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Placemark)", (Document)dom);
    }

    @Test
    public void testForceRasterKml() throws Exception {
        String requestUrl = "wms/reflect?layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=&format_options=KMSCORE:0;mode:refresh&format= application/vnd.google-earth.kml+xml";
        Document dom = this.getAsDOM(requestUrl);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Folder/kml:GroundOverlay)", (Document)dom);
        String href = XMLUnit.newXpathEngine().evaluate("//kml:Folder/kml:GroundOverlay/kml:Icon/kml:href", dom);
        Assert.assertTrue((boolean)href.startsWith("http://localhost:8080/geoserver/wms"));
        Assert.assertTrue((boolean)href.contains("request=GetMap"));
        Assert.assertTrue((boolean)href.contains("format=image%2Fpng"));
    }

    @Test
    public void testForceRasterKmz() throws Exception {
        String requestUrl = "wms/reflect?layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=&format_options=KMSCORE:0;mode:refresh&format= application/vnd.google-earth.kmz";
        MockHttpServletResponse response = this.getAsServletResponse(requestUrl);
        Assert.assertEquals((Object)"application/vnd.google-earth.kmz", (Object)response.getContentType());
        Assert.assertEquals((Object)"attachment; filename=cite-BasicPolygons.kmz", (Object)response.getHeader("Content-Disposition"));
        try (ZipInputStream zis = new ZipInputStream(this.getBinaryInputStream(response));){
            ZipEntry entry = zis.getNextEntry();
            Assert.assertEquals((Object)"wms.kml", (Object)entry.getName());
            byte[] data = IOUtils.toByteArray((InputStream)zis);
            Document dom = this.dom(new ByteArrayInputStream(data));
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Folder/kml:GroundOverlay)", (Document)dom);
            String href = XMLUnit.newXpathEngine().evaluate("//kml:Folder/kml:GroundOverlay/kml:Icon/kml:href", dom);
            Assert.assertEquals((Object)"images/layers_0.png", (Object)href);
            zis.closeEntry();
            entry = zis.getNextEntry();
            Assert.assertEquals((Object)"images/", (Object)entry.getName());
            zis.closeEntry();
            entry = zis.getNextEntry();
            Assert.assertEquals((Object)"images/layers_0.png", (Object)entry.getName());
            zis.closeEntry();
            Assert.assertNull((Object)zis.getNextEntry());
        }
    }

    @Test
    public void testRasterTransformerSLD() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("allsymbolizers.sld");
        String urlExternal = URLDecoder.decode(url.toExternalForm(), "UTF-8");
        String requestUrl = "wms/reflect?layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&format_options=KMSCORE:0;mode:refresh&format= application/vnd.google-earth.kml+xml&sld=" + urlExternal;
        Document dom = this.getAsDOM(requestUrl);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Folder/kml:GroundOverlay)", (Document)dom);
        String href = XMLUnit.newXpathEngine().evaluate("//kml:Folder/kml:GroundOverlay/kml:Icon/kml:href", dom);
        href = URLDecoder.decode(href, "UTF-8");
        Assert.assertTrue((boolean)href.startsWith("http://localhost:8080/geoserver/wms"));
        Assert.assertTrue((boolean)href.contains("request=GetMap"));
        Assert.assertTrue((boolean)href.contains("format=image/png"));
        Assert.assertTrue((boolean)href.contains("&sld=" + urlExternal));
    }

    @Test
    public void testRasterPlacemarkTrue() throws Exception {
        this.doTestRasterPlacemark(true);
    }

    @Test
    public void testRasterPlacemarkFalse() throws Exception {
        this.doTestRasterPlacemark(false);
    }

    protected void doTestRasterPlacemark(boolean doPlacemarks) throws Exception {
        String requestUrl = "wms/reflect?layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=&format_options=mode:refresh;kmscore:0;kmplacemark:" + doPlacemarks + "&format=application/vnd.google-earth.kmz";
        MockHttpServletResponse response = this.getAsServletResponse(requestUrl);
        Assert.assertEquals((Object)"application/vnd.google-earth.kmz", (Object)response.getContentType());
        File tempDir = org.geoserver.util.IOUtils.createRandomDirectory((String)"./target", (String)"kmplacemark", (String)"test");
        tempDir.deleteOnExit();
        File zip = new File(tempDir, "kmz.zip");
        zip.deleteOnExit();
        try (FileOutputStream output = new FileOutputStream(zip);){
            FileUtils.writeByteArrayToFile((File)zip, (byte[])this.getBinary(response));
            output.flush();
        }
        Assert.assertTrue((boolean)zip.exists());
        try (ZipFile zipFile = new ZipFile(zip);){
            ZipEntry entry = zipFile.getEntry("wms.kml");
            Assert.assertNotNull((Object)entry);
            Assert.assertNotNull((Object)zipFile.getEntry("images/layers_0.png"));
            byte[] buffer = new byte[1024];
            File temp = File.createTempFile("test_out", "kmz", tempDir);
            temp.deleteOnExit();
            try (InputStream inStream = zipFile.getInputStream(entry);
                 BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(temp));){
                int len;
                while ((len = inStream.read(buffer)) >= 0) {
                    outStream.write(buffer, 0, len);
                }
            }
            Document document = this.dom(new BufferedInputStream(new FileInputStream(temp)));
            Assert.assertEquals((Object)"kml", (Object)document.getDocumentElement().getNodeName());
            if (doPlacemarks) {
                Assert.assertEquals((long)this.getFeatureSource(MockData.BASIC_POLYGONS).getFeatures().size(), (long)document.getElementsByTagName("Placemark").getLength());
                XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//kml:Placemark//kml:Point)", (Document)document);
            } else {
                Assert.assertEquals((long)0L, (long)document.getElementsByTagName("Placemark").getLength());
            }
        }
    }

    @Test
    public void testStyleConverter() throws Exception {
        String requestUrl = "wms/kml?layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=allsymbolizers&mode=download";
        Document doc = this.getAsDOM(requestUrl);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Placemark[1]/kml:Style)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//kml:Placemark[1]/kml:Style/kml:IconStyle/kml:Icon/kml:color)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/kml/icon/allsymbolizers?0.0.0=", (String)"//kml:Placemark[1]/kml:Style/kml:IconStyle/kml:Icon/kml:href", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"b24d4dff", (String)"//kml:Placemark[1]/kml:Style/kml:PolyStyle/kml:color", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"ffba3e00", (String)"//kml:Placemark[1]/kml:Style/kml:LineStyle/kml:color", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"2.0", (String)"//kml:Placemark[1]/kml:Style/kml:LineStyle/kml:width", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1.4", (String)"//kml:Placemark[1]/kml:Style/kml:LabelStyle/kml:scale", (Document)doc);
    }

    @Test
    public void testLabelFromTextSymbolizer() throws Exception {
        String requestUrl = "wms/kml?layers=" + this.getLayerId(MockData.NAMED_PLACES) + "&styles=labels&mode=download";
        Document doc = this.getAsDOM(requestUrl);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//kml:Placemark)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Placemark[kml:name='Ashton'])", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Placemark[kml:name='Goose Island'])", (Document)doc);
    }

    @Test
    public void testDynamicSymbolizer() throws Exception {
        String requestUrl = "wms/kml?layers=" + this.getLayerId(MockData.STREAMS) + "&styles=dynamicsymbolizer&mode=download";
        Document document = this.getAsDOM(requestUrl);
        Assert.assertEquals((Object)"kml", (Object)document.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"http://127.0.0.1/Cam Stream", (String)"//kml:Style[1]/kml:IconStyle/kml:Icon/kml:href", (Document)document);
    }

    @Test
    public void testRelativeDynamicSymbolizer() throws Exception {
        String requestUrl = "wms/kml?layers=" + this.getLayerId(MockData.STREAMS) + "&styles=relativeds&mode=download";
        Document document = this.getAsDOM(requestUrl);
        Assert.assertEquals((Object)"kml", (Object)document.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/styles/icons/Cam%20Stream", (String)"//kml:Style[1]/kml:IconStyle/kml:Icon/kml:href", (Document)document);
    }

    @Test
    public void testLegend() throws Exception {
        String layerId = this.getLayerId(MockData.BASIC_POLYGONS);
        String requestUrl = "wms/kml?layers=" + layerId + "&styles=polygon&mode=download&format_options=legend:true&legend_options=fontStyle:bold;fontColor:ff0000;fontSize:18";
        Document doc = this.getAsDOM(requestUrl);
        Assert.assertEquals((Object)"kml", (Object)doc.getDocumentElement().getNodeName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String href = xpath.evaluate("//kml:ScreenOverlay/kml:Icon/kml:href", doc);
        Assert.assertTrue((boolean)href.contains("request=GetLegendGraphic"));
        Assert.assertTrue((boolean)href.contains("layer=cite%3ABasicPolygons"));
        Assert.assertTrue((boolean)href.contains("style=polygon"));
        Assert.assertTrue((boolean)href.contains("LEGEND_OPTIONS=fontStyle%3Abold%3BfontColor%3Aff0000%3BfontSize%3A18"));
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//kml:ScreenOverlay/kml:overlayXY/@x", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//kml:ScreenOverlay/kml:overlayXY/@y", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"pixels", (String)"//kml:ScreenOverlay/kml:overlayXY/@xunits", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"pixels", (String)"//kml:ScreenOverlay/kml:overlayXY/@yunits", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"10.0", (String)"//kml:ScreenOverlay/kml:screenXY/@x", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"20.0", (String)"//kml:ScreenOverlay/kml:screenXY/@y", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"pixels", (String)"//kml:ScreenOverlay/kml:screenXY/@xunits", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"pixels", (String)"//kml:ScreenOverlay/kml:screenXY/@yunits", (Document)doc);
    }

    @Test
    public void testLookatOptions() throws Exception {
        String layerId = this.getLayerId(MockData.BASIC_POLYGONS);
        String requestUrl = "wms/kml?layers=" + layerId + "&styles=polygon&mode=download&format_options=lookatbbox:-20,-20,20,20;altitude:10;heading:0;tilt:30;range:100;altitudemode:absolute";
        Document doc = this.getAsDOM(requestUrl);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//kml:Document/kml:LookAt/kml:longitude", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//kml:Document/kml:LookAt/kml:latitude", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"10.0", (String)"//kml:Document/kml:LookAt/kml:altitude", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//kml:Document/kml:LookAt/kml:heading", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"30.0", (String)"//kml:Document/kml:LookAt/kml:tilt", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"100.0", (String)"//kml:Document/kml:LookAt/kml:range", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"absolute", (String)"//kml:Document/kml:LookAt/kml:altitudeMode", (Document)doc);
    }

    @Test
    public void testExtendedData() throws Exception {
        String layerId = this.getLayerId(MockData.AGGREGATEGEOFEATURE);
        String requestUrl = "wms/kml?layers=" + layerId + "&mode=download&extendedData=true&kmattr=false&kmscore=100";
        Document doc = this.getAsDOM(requestUrl);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml:Document/kml:Schema)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"6", (String)"count(//kml:Document/kml:Schema/kml:SimpleField)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//kml:Document/kml:Schema/kml:SimpleField[@name='multiPointProperty'])", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//kml:Document/kml:Schema/kml:SimpleField[@name='multiCurveProperty'])", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//kml:Document/kml:Schema/kml:SimpleField[@name='multiSurfaceProperty'])", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"string", (String)"//kml:Document/kml:Schema/kml:SimpleField[@name='description']/@type", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"double", (String)"//kml:Document/kml:Schema/kml:SimpleField[@name='doubleProperty']/@type", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"int", (String)"//kml:Document/kml:Schema/kml:SimpleField[@name='intRangeProperty']/@type", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"string", (String)"//kml:Document/kml:Schema/kml:SimpleField[@name='strProperty']/@type", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"string", (String)"//kml:Document/kml:Schema/kml:SimpleField[@name='featureCode']/@type", (Document)doc);
        String sd = "//kml:Placemark[@id='AggregateGeoFeature.f005']/kml:ExtendedData/kml:SchemaData/kml:SimpleData";
        XMLAssert.assertXpathEvaluatesTo((String)"description-f005", (String)(sd + "[@name='description']"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"name-f005", (String)(sd + "[@name='name']"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"2012.78", (String)(sd + "[@name='doubleProperty']"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Ma quande lingues coalesce, li grammatica del resultant lingue es plu simplic e regulari quam ti del coalescent lingues. Li nov lingua franca va esser plu simplic e regulari quam li existent Europan lingues.", (String)(sd + "[@name='strProperty']"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"BK030", (String)(sd + "[@name='featureCode']"), (Document)doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeightTemplate() throws Exception {
        File template = null;
        try {
            String layerId = this.getLayerId(MockData.LAKES);
            FeatureTypeInfo resource = (FeatureTypeInfo)this.getCatalog().getResourceByName(layerId, FeatureTypeInfo.class);
            File parent = this.getDataDirectory().get((ResourceInfo)resource, new String[0]).dir();
            template = new File(parent, "height.ftl");
            FileUtils.write((File)template, (CharSequence)"${FID.value}", (String)"UTF-8");
            String requestUrl = "wms/kml?layers=" + layerId + "&mode=download";
            Document doc = this.getAsDOM(requestUrl);
            String base = "//kml:Placemark[@id='Lakes.1107531835962']/kml:MultiGeometry";
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(" + base + ")"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)(base + "/kml:Point/kml:extrude"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"relativeToGround", (String)(base + "/kml:Point/kml:altitudeMode"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"0.0017851936218678816,-0.0010838268792710709,101.0", (String)(base + "/kml:Point/kml:coordinates"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)(base + "/kml:Polygon/kml:extrude"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"relativeToGround", (String)(base + "/kml:Polygon/kml:altitudeMode"), (Document)doc);
            this.assertXPathCoordinates("LinearRing", "6.0E-4,-0.0018,101.0 0.0010,-6.0E-4,101.0 0.0024,-1.0E-4,101.0 0.0031,-0.0015,101.0 6.0E-4,-0.0018,101.0", base + "/kml:Polygon/kml:outerBoundaryIs/kml:LinearRing/kml:coordinates", doc);
        }
        finally {
            if (template != null) {
                template.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeightTemplatePoint() throws Exception {
        File template = null;
        try {
            String layerId = this.getLayerId(MockData.POINTS);
            FeatureTypeInfo resource = (FeatureTypeInfo)this.getCatalog().getResourceByName(layerId, FeatureTypeInfo.class);
            File parent = this.getDataDirectory().get((ResourceInfo)resource, new String[0]).dir();
            template = new File(parent, "height.ftl");
            FileUtils.write((File)template, (CharSequence)"${altitude.value}", (String)"UTF-8");
            String requestUrl = "wms/kml?layers=" + layerId + "&mode=download";
            Document doc = this.getAsDOM(requestUrl);
            String base = "//kml:Placemark[@id='Points.0']/kml:Point";
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(" + base + ")"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)(base + "/kml:extrude"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"relativeToGround", (String)(base + "/kml:altitudeMode"), (Document)doc);
        }
        finally {
            if (template != null) {
                template.delete();
            }
        }
    }

    private void assertXPathCoordinates(String message, String expectedText, String xpath, Document doc) throws XpathException {
        String[] actualCoordiantes;
        String[] expectedCoordinates;
        XpathEngine engine = XMLUnit.newXpathEngine();
        String text = engine.evaluate(xpath, doc);
        if (this.equalsRegardingNull(expectedText, text)) {
            return;
        }
        if (expectedText != null && text != null && (expectedCoordinates = expectedText.split("(\\s|,)")).length == (actualCoordiantes = text.split("(\\s|,)")).length) {
            int LENGTH = actualCoordiantes.length;
            boolean checked = true;
            for (int i = 0; i < LENGTH; ++i) {
                String expected = expectedCoordinates[i];
                String actual = actualCoordiantes[i];
                if (expected.length() == actual.length()) {
                    if (expected.equals(actual)) continue;
                    checked = false;
                    break;
                }
                try {
                    double expectedOrdinate = Double.parseDouble(expected);
                    double actualOridnate = Double.parseDouble(actual);
                    if (Double.compare(expectedOrdinate, actualOridnate) == 0) continue;
                }
                catch (NumberFormatException formatException) {
                    checked = false;
                }
                break;
            }
            if (checked) {
                return;
            }
        }
        Assert.assertEquals((String)message, (Object)expectedText, (Object)text);
    }

    private boolean equalsRegardingNull(String expected, String actual) {
        if (expected == null) {
            return actual == null;
        }
        return expected.equals(actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeightTemplateNoExtrude() throws Exception {
        File template = null;
        try {
            String layerId = this.getLayerId(MockData.LAKES);
            FeatureTypeInfo resource = (FeatureTypeInfo)this.getCatalog().getResourceByName(layerId, FeatureTypeInfo.class);
            File parent = this.getDataDirectory().get((ResourceInfo)resource, new String[0]).dir();
            template = new File(parent, "height.ftl");
            FileUtils.write((File)template, (CharSequence)"${FID.value}", (String)"UTF-8");
            String requestUrl = "wms/kml?layers=" + layerId + "&mode=download&extrude=false";
            Document doc = this.getAsDOM(requestUrl);
            String base = "//kml:Placemark[@id='Lakes.1107531835962']/kml:MultiGeometry";
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(" + base + ")"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"0", (String)(base + "/kml:Point/kml:extrude"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"relativeToGround", (String)(base + "/kml:Point/kml:altitudeMode"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"0.0017851936218678816,-0.0010838268792710709,101.0", (String)(base + "/kml:Point/kml:coordinates"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"0", (String)(base + "/kml:Polygon/kml:extrude"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"relativeToGround", (String)(base + "/kml:Polygon/kml:altitudeMode"), (Document)doc);
            this.assertXPathCoordinates("kml:LinearRing", "6.0E-4,-0.0018,101.0 0.001,-6.0E-4,101.0 0.0024,-1.0E-4,101.0 0.0031,-0.0015,101.0 6.0E-4,-0.0018,101.0", base + "/kml:Polygon/kml:outerBoundaryIs/kml:LinearRing/kml:coordinates", doc);
        }
        finally {
            if (template != null) {
                template.delete();
            }
        }
    }

    @Test
    public void testCoordinateShift() throws Exception {
        Document document = this.getAsDOM("wms/kml?layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&mode=download&bbox=150,-90,380,90");
        Assert.assertEquals((long)3L, (long)document.getElementsByTagName("Placemark").getLength());
    }

    @Test
    public void testValidKML() throws Exception {
        GetMapRequest req = this.createGetMapRequest(MockData.STREAMS);
        req.setWidth(256);
        req.setHeight(256);
        WMSMapContent mapContent = new WMSMapContent(req);
        mapContent.addLayer(this.createMapLayer(MockData.STREAMS, "big-local-image"));
        mapContent.getViewport().setBounds(new ReferencedEnvelope(-180.0, 0.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        mapContent.setMapHeight(256);
        mapContent.setMapWidth(256);
        KMLMapOutputFormat of = new KMLMapOutputFormat(this.getWMS());
        KMLMap map = of.produceMap(mapContent);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new KMLEncoder().encode(map.getKml(), (OutputStream)bout, null);
        Document document = this.dom(new ByteArrayInputStream(bout.toByteArray()));
        XMLAssert.assertXpathNotExists((String)"//kml:IconStyle/kml:Icon/kml:refreshInterval", (Document)document);
        XMLAssert.assertXpathNotExists((String)"//kml:IconStyle/kml:Icon/kml:viewRefreshTime", (Document)document);
        XMLAssert.assertXpathNotExists((String)"//kml:IconStyle/kml:Icon/kml:viewBoundScale", (Document)document);
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Kml.class}).createUnmarshaller();
        unmarshaller.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new Source[]{new StreamSource(((Object)((Object)this)).getClass().getResource("/org/geoserver/kml/xAL.xsd").toExternalForm()), new StreamSource(((Object)((Object)this)).getClass().getResource("/schema/ogckml/ogckml22.xsd").toExternalForm())}));
        unmarshaller.unmarshal((Node)document);
    }

    @Ignore
    @Test
    public void testKmlTransformationMemoryUsage() throws Exception {
        final int size = 10000000;
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("test");
        ftb.setSRS("EPSG:4326");
        ftb.add("geom", Point.class);
        final SimpleFeatureType ft = ftb.buildFeatureType();
        final SimpleFeatureBuilder fb = new SimpleFeatureBuilder(ft);
        fb.add((Object)new GeometryFactory().createPoint(new Coordinate(0.0, 0.0)));
        SimpleFeatureSource fs = new SimpleFeatureSource(){

            public void removeFeatureListener(FeatureListener listener) {
                throw new UnsupportedOperationException();
            }

            public Set<RenderingHints.Key> getSupportedHints() {
                throw new UnsupportedOperationException();
            }

            public SimpleFeatureType getSchema() {
                return ft;
            }

            public QueryCapabilities getQueryCapabilities() {
                throw new UnsupportedOperationException();
            }

            public Name getName() {
                throw new UnsupportedOperationException();
            }

            public org.geotools.api.data.ResourceInfo getInfo() {
                throw new UnsupportedOperationException();
            }

            public DataAccess<SimpleFeatureType, SimpleFeature> getDataStore() {
                throw new UnsupportedOperationException();
            }

            public int getCount(Query query) throws IOException {
                throw new UnsupportedOperationException();
            }

            public ReferencedEnvelope getBounds(Query query) throws IOException {
                throw new UnsupportedOperationException();
            }

            public ReferencedEnvelope getBounds() throws IOException {
                throw new UnsupportedOperationException();
            }

            public void addFeatureListener(FeatureListener listener) {
                throw new UnsupportedOperationException();
            }

            public SimpleFeatureCollection getFeatures(Query query) throws IOException {
                return new AbstractFeatureCollection(ft){

                    public int size() {
                        throw new UnsupportedOperationException();
                    }

                    protected Iterator<SimpleFeature> openIterator() {
                        return new Iterator<SimpleFeature>(){
                            int i = 0;

                            @Override
                            public SimpleFeature next() {
                                return fb.buildFeature(String.valueOf(this.i++));
                            }

                            @Override
                            public boolean hasNext() {
                                return this.i < size;
                            }
                        };
                    }

                    public ReferencedEnvelope getBounds() {
                        return new ReferencedEnvelope(-180.0, 0.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                    }
                };
            }

            public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
                throw new UnsupportedOperationException();
            }

            public SimpleFeatureCollection getFeatures() throws IOException {
                throw new UnsupportedOperationException();
            }
        };
        GetMapRequest req = new GetMapRequest();
        req.setBaseUrl("http://localhost:8080/geoserver");
        req.setLayers(List.of(new MapLayerInfo(fs)));
        req.setRawKvp(new HashMap());
        WMSMapContent mapContent = new WMSMapContent(req);
        mapContent.addLayer((Layer)new FeatureLayer((FeatureSource)fs, this.getCatalog().getStyleByName("point").getStyle()));
        mapContent.getViewport().setBounds(new ReferencedEnvelope(-180.0, 0.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        mapContent.setMapHeight(256);
        mapContent.setMapWidth(256);
        KMLMapOutputFormat of = new KMLMapOutputFormat(this.getWMS());
        KMLMap map = of.produceMap(mapContent);
        new KMLEncoder().encode(map.getKml(), OutputStream.nullOutputStream(), null);
    }

    @Test
    public void testExternalImageSize() throws Exception {
        GetMapRequest req = this.createGetMapRequest(MockData.STREAMS);
        req.setWidth(256);
        req.setHeight(256);
        WMSMapContent mapContent = new WMSMapContent(req);
        mapContent.addLayer(this.createMapLayer(MockData.STREAMS, "big-local-image"));
        mapContent.getViewport().setBounds(new ReferencedEnvelope(-180.0, 0.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        mapContent.setMapHeight(256);
        mapContent.setMapWidth(256);
        KMLMapOutputFormat of = new KMLMapOutputFormat(this.getWMS());
        KMLMap map = of.produceMap(mapContent);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new KMLEncoder().encode(map.getKml(), (OutputStream)bout, null);
        Document document = this.dom(new ByteArrayInputStream(bout.toByteArray()));
        Assert.assertEquals((Object)"kml", (Object)document.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)document.getElementsByTagName("Style").getLength());
        XMLAssert.assertXpathExists((String)"//kml:IconStyle/kml:scale", (Document)document);
        XPath xPath = XPathFactory.newInstance().newXPath();
        this.initXPath(xPath);
        Double scale = (Double)xPath.evaluate("//kml:IconStyle/kml:scale", document.getDocumentElement(), XPathConstants.NUMBER);
        Assert.assertEquals((double)2.625, (double)scale, (double)0.01);
    }

    @Test
    public void testKmzEmbededPointImageSize() throws Exception {
        WMSMapContent mapContent = this.createMapContext(MockData.POINTS, "big-mark");
        File temp = File.createTempFile("test", "kmz", new File("target"));
        temp.delete();
        temp.mkdir();
        temp.deleteOnExit();
        File zip = new File(temp, "kmz.zip");
        zip.deleteOnExit();
        KMZMapOutputFormat mapProducer = new KMZMapOutputFormat(this.getWMS());
        KMLMap map = mapProducer.produceMap(mapContent);
        try (FileOutputStream output = new FileOutputStream(zip);){
            new KMLMapResponse(new KMLEncoder(), this.getWMS()).write((Object)map, (OutputStream)output, null);
            output.flush();
        }
        Assert.assertTrue((boolean)zip.exists());
        try (ZipFile zipFile = new ZipFile(zip);){
            ZipEntry kmlEntry = zipFile.getEntry("wms.kml");
            try (InputStream kmlStream = zipFile.getInputStream(kmlEntry);){
                Document kmlResult = XMLUnit.buildTestDocument((InputSource)new InputSource(kmlStream));
                Double scale = Double.parseDouble(XMLUnit.newXpathEngine().getMatchingNodes("(//kml:Style)[1]/kml:IconStyle/kml:scale", kmlResult).item(0).getTextContent());
                Assert.assertEquals((double)3.0625, (double)scale, (double)0.01);
            }
        }
    }

    WMSMapContent createMapContext(QName layer, String style) throws Exception {
        WMSMapContent mapContent = new WMSMapContent();
        mapContent.addLayer(this.createMapLayer(layer, style));
        mapContent.setMapHeight(256);
        mapContent.setMapWidth(256);
        GetMapRequest getMapRequest = this.createGetMapRequest(new QName[]{layer});
        getMapRequest.setWidth(256);
        getMapRequest.setHeight(256);
        mapContent.setRequest(getMapRequest);
        mapContent.getViewport().setBounds(new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        return mapContent;
    }

    void initXPath(XPath xpath) {
        SimpleNamespaceContext ctx = new SimpleNamespaceContext();
        ctx.bindNamespaceUri("kml", "http://www.opengis.net/kml/2.2");
        xpath.setNamespaceContext((NamespaceContext)ctx);
    }

    static Map<String, String> toKvp(String url) {
        String[] tuples;
        if (url.indexOf(63) > 0) {
            url = url.substring(url.indexOf(63) + 1);
        }
        HashMap<String, String> kvpMap = new HashMap<String, String>();
        for (String tuple : tuples = url.split("&")) {
            String value;
            String[] kvp = tuple.split("=");
            String key = kvp[0].toUpperCase();
            String string = value = kvp.length > 1 ? kvp[1] : null;
            if (value != null) {
                try {
                    value = URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            kvpMap.put(key, value);
        }
        return kvpMap;
    }

    static void assertMapsEqual(Map<String, Object> expected, Map<String, Object> actual) throws Exception {
        for (Map.Entry<String, Object> entry : expected.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("format_options")) {
                FormatOptionsKvpParser parser = new FormatOptionsKvpParser();
                Map expectedFormatOptions = (Map)parser.parse((String)entry.getValue());
                Map actualFormatOptions = (Map)parser.parse((String)actual.get(entry.getKey()));
                Iterator iterator = expectedFormatOptions.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry formatOption = o = iterator.next();
                    Assert.assertEquals(formatOption.getValue(), actualFormatOptions.get(formatOption.getKey()));
                }
                for (Map.Entry key : actualFormatOptions.keySet()) {
                    Assert.assertTrue((String)("found unexpected key '" + key + "' in format options"), (boolean)expectedFormatOptions.containsKey(key));
                }
                continue;
            }
            Assert.assertEquals((Object)entry.getValue(), (Object)actual.get(entry.getKey()));
        }
        for (String key : actual.keySet()) {
            Assert.assertTrue((boolean)expected.containsKey(key));
        }
    }

    @Test
    public void testLookatOptionsWithRefreshMode() throws Exception {
        String layerId = this.getLayerId(MockData.BASIC_POLYGONS);
        String requestUrl = "wms/kml?layers=" + layerId + "&styles=polygon&mode=refresh&bbox=10.56,46.99,11.50,47.26";
        Document doc = this.getAsDOM(requestUrl);
        XMLAssert.assertXpathValuesNotEqual((String)"//kml:Document/kml:LookAt/kml:altitude", (String)"//kml:Document/kml:NetworkLink/kml:LookAt/kml:altitude", (Document)doc);
    }

    @Test
    public void testWMSTimeRequest() throws Exception {
        String layerId = this.getLayerId(MockData.BASIC_POLYGONS);
        String expectedTS = "time=2014-03-01";
        String requestUrl = "wms/kml?layers=" + layerId + "&styles=polygon&mode=refresh&bbox=10.56,46.99,11.50,47.26&" + expectedTS;
        Document doc = this.getAsDOM(requestUrl);
        NodeList nodes = doc.getElementsByTagName("href");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            String actualTS = e.getTextContent();
            Assert.assertTrue((String)"Time parameter missing", (boolean)actualTS.contains(expectedTS));
        }
    }

    @Test
    public void testWMSElevationRequest() throws Exception {
        String layerId = this.getLayerId(MockData.BASIC_POLYGONS);
        String expectedTS = "elevation=500";
        String requestUrl = "wms/kml?layers=" + layerId + "&styles=polygon&mode=refresh&bbox=10.56,46.99,11.50,47.26&" + expectedTS;
        Document doc = this.getAsDOM(requestUrl);
        NodeList nodes = doc.getElementsByTagName("href");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            String actualTS = e.getTextContent();
            Assert.assertTrue((String)"Elevation parameter missing", (boolean)actualTS.contains(expectedTS));
        }
    }
}

