/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.iterator;

import java.util.Iterator;
import junit.framework.AssertionFailedError;
import org.easymock.EasyMock;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.iterator.FeatureIteratorFactory;
import org.geoserver.wms.WMSMapContent;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.Symbolizer;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.map.FeatureLayer;
import org.geotools.styling.StyleBuilder;
import org.junit.Assert;
import org.junit.Test;

public class FeatureIteratorFactoryTest {
    @Test
    public void testNoScanOnEmptyStyle() {
        StyleBuilder sb = new StyleBuilder();
        Style style = sb.createStyle((Symbolizer)sb.createPolygonSymbolizer());
        ((Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0)).setMaxScaleDenominator(1000.0);
        DefaultFeatureCollection fc = new DefaultFeatureCollection();
        FeatureLayer layer = new FeatureLayer((FeatureCollection)fc, style);
        WMSMapContent mc = (WMSMapContent)EasyMock.createNiceMock(WMSMapContent.class);
        EasyMock.expect((Object)mc.getScaleDenominator()).andReturn((Object)2000.0).anyTimes();
        EasyMock.replay((Object[])new Object[]{mc});
        KmlEncodingContext context = (KmlEncodingContext)EasyMock.createNiceMock(KmlEncodingContext.class);
        EasyMock.expect((Object)context.openIterator((FeatureCollection)EasyMock.anyObject(SimpleFeatureCollection.class))).andThrow((Throwable)new AssertionFailedError("Should not have called openIterator")).anyTimes();
        EasyMock.expect((Object)context.getCurrentFeatureCollection()).andReturn((Object)fc).anyTimes();
        EasyMock.expect((Object)context.getMapContent()).andReturn((Object)mc).anyTimes();
        EasyMock.replay((Object[])new Object[]{context});
        FeatureIteratorFactory sf = new FeatureIteratorFactory(context, layer);
        Iterator sequence = sf.newIterator();
        Assert.assertNull(sequence.next());
    }
}

