/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.decorator;

import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Icon;
import de.micromata.opengis.kml.v_2_2_0.ScreenOverlay;
import de.micromata.opengis.kml.v_2_2_0.Units;
import de.micromata.opengis.kml.v_2_2_0.Vec2;
import java.util.List;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.decorator.KmlDecoratorFactory;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSRequest;
import org.geoserver.wms.WMSRequests;
import org.geotools.map.Layer;

public class LegendDecoratorFactory
implements KmlDecoratorFactory {
    @Override
    public KmlDecoratorFactory.KmlDecorator getDecorator(Class<? extends Feature> featureClass, KmlEncodingContext context) {
        if (!(context.getService() instanceof WMSInfo)) {
            return null;
        }
        GetMapRequest request = context.getRequest();
        Boolean legend = (Boolean)request.getFormatOptions().get("legend");
        if (legend != null && legend.booleanValue() && Document.class.isAssignableFrom(featureClass)) {
            return new LegendDecorator();
        }
        return null;
    }

    static class LegendDecorator
    implements KmlDecoratorFactory.KmlDecorator {
        LegendDecorator() {
        }

        @Override
        public Feature decorate(Feature feature, KmlEncodingContext context) {
            Document doc = (Document)feature;
            ScreenOverlay go = doc.createAndAddScreenOverlay();
            go.setName("Legend");
            go.setOverlayXY(this.createPixelsVec(0, 0));
            go.setScreenXY(this.createPixelsVec(10, 20));
            Icon icon = go.createAndSetIcon();
            String legendOptions = (String)context.getRequest().getRawKvp().get("LEGEND_OPTIONS");
            String[] kvpArray = null;
            if (legendOptions != null) {
                kvpArray = new String[]{"LEGEND_OPTIONS", legendOptions};
            }
            List layerList = context.getMapContent().layers();
            Layer[] layers = layerList.toArray(new Layer[layerList.size()]);
            icon.setHref(WMSRequests.getGetLegendGraphicUrl((WMSRequest)context.getRequest(), (Layer[])layers, (String[])kvpArray));
            return feature;
        }

        private Vec2 createPixelsVec(int x, int y) {
            Vec2 vec = new Vec2();
            vec.setX((double)x);
            vec.setY((double)y);
            vec.setXunits(Units.PIXELS);
            vec.setYunits(Units.PIXELS);
            return vec;
        }
    }
}

