/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.regionate;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.kml.regionate.RegionatingStrategy;
import org.geoserver.kml.regionate.Tile;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.ServiceException;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wms.WMSMapContent;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.util.CanonicalSet;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public abstract class CachedHierarchyRegionatingStrategy
implements RegionatingStrategy {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.geosearch");
    static final double MAX_ERROR = 0.02;
    static final Set<String> NO_FIDS = Collections.emptySet();
    static CanonicalSet<String> canonicalizer = CanonicalSet.newInstance(String.class);
    protected ReferencedEnvelope dataEnvelope;
    protected FeatureTypeInfo featureType;
    protected Integer featuresPerTile;
    protected String tableName;
    protected GeoServer gs;

    protected CachedHierarchyRegionatingStrategy(GeoServer gs) {
        this.gs = gs;
    }

    @Override
    public Filter getFilter(WMSMapContent context, Layer layer) {
        Catalog catalog = this.gs.getCatalog();
        Set<Object> featuresInTile = Collections.emptySet();
        try {
            FeatureSource featureSource = layer.getFeatureSource();
            this.featureType = catalog.getFeatureTypeByName(featureSource.getName());
            String dataDir = catalog.getResourceLoader().getBaseDirectory().getCanonicalPath();
            this.tableName = this.getDatabaseName(context, layer);
            this.featuresPerTile = (Integer)this.featureType.getMetadata().get("kml.regionateFeatureLimit", Integer.class);
            if (this.featuresPerTile == null || this.featuresPerTile <= 1) {
                this.featuresPerTile = 64;
            }
            if (this.featureType.getFeatureType().getGeometryDescriptor() == null) {
                throw new ServiceException(this.featureType.getName() + " is geometryless, cannot generate KML!");
            }
            ReferencedEnvelope requestedEnvelope = context.getRenderingArea().transform(Tile.WGS84, true);
            LOGGER.log(Level.FINE, "Requested tile: {0}", requestedEnvelope);
            this.dataEnvelope = this.featureType.getLatLonBoundingBox();
            CachedTile cachedTile = new CachedTile(requestedEnvelope);
            ReferencedEnvelope tileEnvelope = cachedTile.getEnvelope();
            if (!this.envelopeMatch(tileEnvelope, requestedEnvelope)) {
                throw new ServiceException("Invalid bounding box request, it does not fit the nearest regionating tile. Requested area: " + requestedEnvelope + ", nearest tile: " + tileEnvelope);
            }
            featuresInTile = this.getFeaturesForTile(dataDir, cachedTile);
            LOGGER.log(Level.FINE, "Found " + featuresInTile.size() + " features in tile " + cachedTile.toString());
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Error occurred while pre-processing regionated features", t);
            throw new ServiceException("Failure while pre-processing regionated features", t);
        }
        if (featuresInTile.isEmpty()) {
            throw new HttpErrorCodeException(204);
        }
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        for (String string : featuresInTile) {
            ids.add(ff.featureId(string));
        }
        return ff.id(ids);
    }

    @SuppressFBWarnings(value={"DMI_CONSTANT_DB_PASSWORD"})
    private static Connection getHsqlConnection(String dbDir, String dbName) throws SQLException {
        return DriverManager.getConnection("jdbc:hsqldb:file:" + dbDir + "/hsqlcache_" + dbName, "geoserver", "geopass");
    }

    @Override
    public void clearCache(FeatureTypeInfo cfg) {
        try {
            GeoServerResourceLoader loader = this.gs.getCatalog().getResourceLoader();
            Resource geosearch = loader.get("geosearch");
            if (geosearch.getType() == Resource.Type.DIRECTORY) {
                CachedHierarchyRegionatingStrategy.clearHsqlDatabase(geosearch.dir(), this.getDatabaseName(cfg));
            }
        }
        catch (Exception ioe) {
            LOGGER.severe("Couldn't clear out config dir due to: " + ioe);
        }
    }

    public static void clearAllHsqlDatabases(File dbDir) {
        List allDbNames = Stream.of(dbDir.listFiles()).filter(file -> !file.isDirectory()).map(File::getName).filter(fileName -> fileName.matches("^hsqlcache_.*\\.script$")).map(fileName -> fileName.substring(10, fileName.length() - 7)).collect(Collectors.toList());
        for (String dbName : allDbNames) {
            CachedHierarchyRegionatingStrategy.clearHsqlDatabase(dbDir, dbName);
        }
    }

    public static void clearHsqlDatabase(File dbDir, String dbName) {
        try (Connection conn = CachedHierarchyRegionatingStrategy.getHsqlConnection(dbDir.getPath(), dbName);){
            conn.createStatement().execute("SHUTDOWN");
        }
        catch (SQLException e) {
            LOGGER.severe("Couldn't clear HSQL regionation database: " + dbName + " exception: " + e);
        }
        Stream.of(dbDir.listFiles()).filter(file -> file.getName().startsWith("hsqlcache_" + dbName)).forEach(file -> file.delete());
    }

    private boolean envelopeMatch(ReferencedEnvelope tileEnvelope, ReferencedEnvelope expectedEnvelope) {
        double widthRatio = Math.abs(1.0 - tileEnvelope.getWidth() / expectedEnvelope.getWidth());
        double heightRatio = Math.abs(1.0 - tileEnvelope.getHeight() / expectedEnvelope.getHeight());
        double xRatio = Math.abs((tileEnvelope.getMinX() - expectedEnvelope.getMinX()) / tileEnvelope.getWidth());
        double yRatio = Math.abs((tileEnvelope.getMinY() - expectedEnvelope.getMinY()) / tileEnvelope.getHeight());
        return widthRatio < 0.02 && heightRatio < 0.02 && xRatio < 0.02 && yRatio < 0.02;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Set<String> getFeaturesForTile(String dataDir, Tile tile) throws Exception {
        String synchToken;
        canonicalizer.add((Object)this.tableName);
        String string = synchToken = (this.tableName = (String)canonicalizer.get((Object)this.tableName));
        synchronized (string) {
            try (Connection conn = CachedHierarchyRegionatingStrategy.getHsqlConnection(dataDir + "/geosearch", this.tableName);){
                Set<String> set;
                block15: {
                    Statement st = conn.createStatement();
                    try {
                        st.execute("CREATE CACHED TABLE IF NOT EXISTS TILECACHE( x BIGINT, y BIGINT, z INT, fid varchar (64))");
                        st.execute("CREATE INDEX IF NOT EXISTS IDX_TILECACHE ON TILECACHE(x, y, z)");
                        set = this.readFeaturesForTile(tile, conn);
                        if (st == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (st != null) {
                            try {
                                st.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    st.close();
                }
                return set;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> readFeaturesForTile(Tile tile, Connection conn) throws Exception {
        Set<String> fids = this.readCachedTileFids(tile, conn);
        if (fids != null) {
            return fids;
        }
        Object tileKey = this.tableName + tile.x + "-" + tile.y + "-" + tile.z;
        canonicalizer.add(tileKey);
        Object object = tileKey = (String)canonicalizer.get(tileKey);
        synchronized (object) {
            fids = this.readCachedTileFids(tile, conn);
            if (fids != null) {
                return fids;
            }
            fids = this.computeFids(tile, conn);
            this.storeFids(tile, fids, conn);
            if (fids.size() < this.featuresPerTile) {
                for (Tile child : tile.getChildren()) {
                    this.storeFids(child, NO_FIDS, conn);
                }
            }
        }
        return fids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeFids(Tile t, Set<String> fids, Connection conn) throws SQLException {
        try {
            String stmt = "INSERT INTO TILECACHE VALUES (" + t.x + ", " + t.y + ", " + t.z + ", ?)";
            try (PreparedStatement ps = conn.prepareStatement(stmt);){
                if (fids.isEmpty()) {
                    ps.setString(1, null);
                    ps.execute();
                } else {
                    conn.setAutoCommit(false);
                    for (String fid : fids) {
                        ps.setString(1, fid);
                        ps.execute();
                    }
                    conn.commit();
                }
            }
        }
        finally {
            conn.setAutoCommit(true);
        }
    }

    private Set<String> computeFids(Tile tile, Connection conn) throws Exception {
        Tile parent = tile.getParent();
        Set<String> parentFids = this.getUpwardFids(parent, conn);
        HashSet<String> currFids = new HashSet<String>();
        FeatureSource fs = this.featureType.getFeatureSource(null, null);
        GeometryDescriptor geom = fs.getSchema().getGeometryDescriptor();
        CoordinateReferenceSystem nativeCrs = geom.getCoordinateReferenceSystem();
        ReferencedEnvelope nativeTileEnvelope = null;
        if (!CRS.equalsIgnoreMetadata((Object)Tile.WGS84, (Object)nativeCrs)) {
            try {
                nativeTileEnvelope = tile.getEnvelope().transform(nativeCrs, true);
            }
            catch (ProjectionException pe) {
                LOGGER.log(Level.INFO, "Could not reproject the current tile bounds " + tile.getEnvelope() + " to the native SRS, intersecting with the layer declared lat/lon bounds and retrying");
                ReferencedEnvelope llEnv = this.featureType.getLatLonBoundingBox();
                ReferencedEnvelope reduced = tile.getEnvelope().intersection((Envelope)llEnv);
                if (reduced.isNull() || reduced.getWidth() == 0.0 || reduced.getHeight() == 0.0) {
                    return Collections.emptySet();
                }
                ReferencedEnvelope refRed = new ReferencedEnvelope((Envelope)reduced, tile.getEnvelope().getCoordinateReferenceSystem());
                nativeTileEnvelope = refRed.transform(nativeCrs, true);
            }
        } else {
            nativeTileEnvelope = tile.getEnvelope();
        }
        try (FeatureIterator fi = this.getSortedFeatures(geom, tile.getEnvelope(), nativeTileEnvelope, conn);){
            MathTransform tx = null;
            double[] coords = new double[2];
            boolean first = true;
            while (fi.hasNext() && currFids.size() < this.featuresPerTile) {
                SimpleFeature f = (SimpleFeature)fi.next();
                if (parentFids.contains(f.getID())) continue;
                if (first) {
                    first = false;
                    CoordinateReferenceSystem nativeCRS = f.getType().getCoordinateReferenceSystem();
                    this.featureType.getFeatureType().getCoordinateReferenceSystem();
                    if (nativeCRS != null && !CRS.equalsIgnoreMetadata((Object)nativeCRS, (Object)Tile.WGS84)) {
                        tx = CRS.findMathTransform((CoordinateReferenceSystem)nativeCRS, (CoordinateReferenceSystem)Tile.WGS84);
                    }
                }
                Point p = ((Geometry)f.getDefaultGeometry()).getCentroid();
                coords[0] = p.getX();
                coords[1] = p.getY();
                if (tx != null) {
                    tx.transform(coords, 0, coords, 0, 1);
                }
                if (!tile.contains(coords[0], coords[1])) continue;
                currFids.add(f.getID());
            }
        }
        return currFids;
    }

    protected abstract FeatureIterator getSortedFeatures(GeometryDescriptor var1, ReferencedEnvelope var2, ReferencedEnvelope var3, Connection var4) throws Exception;

    private Set<String> getUpwardFids(Tile tile, Connection conn) throws Exception {
        if (tile == null) {
            return Collections.emptySet();
        }
        HashSet<String> fids = new HashSet<String>();
        fids.addAll(this.readFeaturesForTile(tile, conn));
        Tile parent = tile.getParent();
        if (parent != null) {
            fids.addAll(this.getUpwardFids(parent, conn));
        }
        return fids;
    }

    /*
     * Unable to fully structure code
     */
    protected Set<String> readCachedTileFids(Tile tile, Connection conn) throws SQLException {
        st = conn.createStatement();
        try {
            block17: {
                block15: {
                    block16: {
                        rs = st.executeQuery("SELECT fid FROM TILECACHE where x = " + tile.x + " AND y = " + tile.y + " and z = " + tile.z);
                        fids = null;
                        if (!rs.next()) ** GOTO lbl19
                        fid = rs.getString(1);
                        if (fid != null) break block15;
                        var7_11 = Collections.emptySet();
                        if (rs == null) break block16;
                        rs.close();
                    }
                    return var7_11;
                }
                try {
                    fids = new HashSet<String>();
                    fids.add(fid);
lbl19:
                    // 3 sources

                    while (rs.next()) {
                        fids.add(rs.getString(1));
                    }
                    var6_9 = fids;
                    if (rs == null) break block17;
                }
                catch (Throwable var5_7) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable var6_10) {
                            var5_7.addSuppressed(var6_10);
                        }
                    }
                    throw var5_7;
                }
                rs.close();
            }
            return var6_9;
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    protected String getDatabaseName(WMSMapContent con, Layer layer) throws Exception {
        return this.getDatabaseName(this.featureType);
    }

    protected String getDatabaseName(FeatureTypeInfo cfg) throws Exception {
        return cfg.getNamespace().getPrefix() + "_" + cfg.getName();
    }

    static {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize the class constants", e);
        }
    }

    protected class CachedTile
    extends Tile {
        public CachedTile(long x, long y, long z) {
            super(x, y, z);
        }

        @Override
        public boolean contains(double x, double y) {
            if (super.contains(x, y)) {
                return true;
            }
            double maxx = this.envelope.getMaxX();
            double maxy = this.envelope.getMaxY();
            if (x == maxx && x >= CachedHierarchyRegionatingStrategy.this.dataEnvelope.getMaxX()) {
                return true;
            }
            return y == maxy && y >= CachedHierarchyRegionatingStrategy.this.dataEnvelope.getMaxY();
        }

        public CachedTile(ReferencedEnvelope wgs84Envelope) {
            super(wgs84Envelope);
        }

        public CachedTile(Tile parent) {
            super(parent.x, parent.y, parent.z);
        }

        @Override
        public Tile getParent() {
            if (this.envelope.contains((BoundingBox)CachedHierarchyRegionatingStrategy.this.dataEnvelope)) {
                return null;
            }
            Tile parent = super.getParent();
            if (parent != null) {
                parent = new CachedTile(super.getParent());
            }
            return parent;
        }
    }
}

