/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.utils;

import java.util.ArrayList;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.brewer.styling.builder.FeatureTypeStyleBuilder;
import org.geotools.feature.FeatureTypes;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;

public class ScaleStyleVisitor
extends DuplicatingStyleVisitor {
    static final double TOLERANCE = 1.0E-6;
    double scaleDenominator;
    SimpleFeatureType schema;

    public ScaleStyleVisitor(double scaleDenominator, SimpleFeatureType schema) {
        this.scaleDenominator = scaleDenominator;
        this.schema = schema;
    }

    public void visit(Style style) {
        super.visit(style);
        Style copy = (Style)this.pages.peek();
        ArrayList<FeatureTypeStyle> filtered = new ArrayList<FeatureTypeStyle>();
        for (FeatureTypeStyle fts : copy.featureTypeStyles()) {
            if (!fts.featureTypeNames().isEmpty() && !fts.featureTypeNames().stream().anyMatch(tn -> FeatureTypes.matches((FeatureType)this.schema, (Name)tn))) continue;
            filtered.add(fts);
        }
        copy.featureTypeStyles().clear();
        copy.featureTypeStyles().addAll(filtered);
    }

    public void visit(FeatureTypeStyle fts) {
        FeatureTypeStyle copy = new FeatureTypeStyleBuilder().reset(fts).build();
        ArrayList<Rule> rulesCopy = new ArrayList<Rule>();
        for (Rule r : fts.rules()) {
            if (!(r.getMinScaleDenominator() - 1.0E-6 <= this.scaleDenominator) || !(r.getMaxScaleDenominator() + 1.0E-6 > this.scaleDenominator)) continue;
            rulesCopy.add(r);
        }
        copy.rules().clear();
        copy.rules().addAll(rulesCopy);
        this.pages.push(copy);
    }

    public Style getSimplifiedStyle() {
        return this.getCopy();
    }

    public Style getCopy() {
        return (Style)super.getCopy();
    }
}

