/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver;

import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.geoserver.GeoserverInitStartupListener;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.FeatureFactory;
import org.opengis.filter.FilterFactory;
import org.opengis.style.StyleFactory;
import org.springframework.mock.web.MockServletContext;

public class GeoServerInitStartupListenerTest {
    private static final double CUSTOM_TOLERANCE = 1.0E-7;
    private GeoserverInitStartupListener listener;

    @Before
    public void init() {
        System.setProperty("COMPARISON_TOLERANCE", Double.toString(1.0E-7));
        this.listener = new GeoserverInitStartupListener();
        MockServletContext ctx = new MockServletContext();
        this.listener.contextInitialized(new ServletContextEvent((ServletContext)ctx));
    }

    @After
    public void reset() {
        System.clearProperty("COMPARISON_TOLERANCE");
    }

    @Test
    public void testStartupListener() {
        Hints hints = GeoTools.getDefaultHints();
        Object factory = hints.get((Object)Hints.GRID_COVERAGE_FACTORY);
        Assert.assertNotNull((Object)factory);
        Assert.assertTrue((boolean)(factory instanceof GridCoverageFactory));
        Object datumShift = hints.get((Object)Hints.LENIENT_DATUM_SHIFT);
        Assert.assertNotNull((Object)datumShift);
        Assert.assertTrue((boolean)((Boolean)datumShift));
        Object tolerance = hints.get((Object)Hints.COMPARISON_TOLERANCE);
        Assert.assertNotNull((Object)tolerance);
        Assert.assertEquals((double)1.0E-7, (double)((Double)tolerance), (double)1.0E-12);
        Object filterFactory = hints.get((Object)Hints.FILTER_FACTORY);
        Assert.assertNotNull((Object)filterFactory);
        Assert.assertTrue((boolean)(filterFactory instanceof FilterFactory));
        Object styleFactory = hints.get((Object)Hints.STYLE_FACTORY);
        Assert.assertNotNull((Object)styleFactory);
        Assert.assertTrue((boolean)(styleFactory instanceof StyleFactory));
        Object featureFactory = hints.get((Object)Hints.FEATURE_FACTORY);
        Assert.assertNotNull((Object)featureFactory);
        Assert.assertTrue((boolean)(featureFactory instanceof FeatureFactory));
        Object executorService = hints.get((Object)Hints.EXECUTOR_SERVICE);
        Assert.assertNotNull((Object)executorService);
        Assert.assertTrue((boolean)(executorService instanceof ExecutorService));
    }

    @Test
    public void testJPEG2000Registration() {
        IIORegistry registry = IIORegistry.getDefaultInstance();
        this.assertNoSunJPEG2000(registry, ImageReaderSpi.class);
        this.assertNoSunJPEG2000(registry, ImageWriterSpi.class);
    }

    private <T extends ImageReaderWriterSpi> void assertNoSunJPEG2000(IIORegistry registry, Class<T> category) {
        Iterator<T> it = registry.getServiceProviders(category, false);
        while (it.hasNext()) {
            ImageReaderWriterSpi spi = (ImageReaderWriterSpi)it.next();
            Assert.assertThat((Object)spi.getClass().getPackage().getName(), (Matcher)CoreMatchers.not((Matcher)Matchers.startsWith((String)"com.sun.media.imageioimpl.plugins.jpeg2000")));
        }
    }
}

