/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver;

import java.net.InetAddress;
import org.easymock.EasyMock;
import org.geoserver.GeoServerNodeData;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GeoServerNodeDataTest {
    @Before
    public void mockAddress() {
        InetAddress addr = (InetAddress)EasyMock.createMock(InetAddress.class);
        EasyMock.expect((Object)addr.getHostAddress()).andStubReturn((Object)"192.2.0.42");
        EasyMock.expect((Object)addr.getHostName()).andStubReturn((Object)"test.local");
        EasyMock.replay((Object[])new Object[]{addr});
        GeoServerNodeData.setMockAddress((InetAddress)addr);
    }

    @After
    public void cleanUp() {
        GeoServerNodeData.clearMockAddress();
    }

    @Test
    public void testCreate() {
        GeoServerNodeData data = GeoServerNodeData.createFromString((String)"id:foo");
        Assert.assertEquals((Object)"foo", (Object)data.getId());
        Assert.assertNotNull((Object)data.getIdStyle());
    }

    @Test
    public void testIP() {
        GeoServerNodeData data = GeoServerNodeData.createFromString((String)"id:$host_ip");
        Assert.assertEquals((Object)"192.2.0.42", (Object)data.getId());
        Assert.assertNotNull((Object)data.getIdStyle());
    }

    @Test
    public void testHostname() {
        GeoServerNodeData data = GeoServerNodeData.createFromString((String)"id:$host_name");
        Assert.assertEquals((Object)"test.local", (Object)data.getId());
        Assert.assertNotNull((Object)data.getIdStyle());
    }

    @Test
    public void testShortHostname() {
        GeoServerNodeData data = GeoServerNodeData.createFromString((String)"id:$host_short_name");
        Assert.assertEquals((Object)"test", (Object)data.getId());
        Assert.assertNotNull((Object)data.getIdStyle());
    }

    @Test
    public void testCompactHostname() {
        GeoServerNodeData data = GeoServerNodeData.createFromString((String)"id:$host_compact_name");
        Assert.assertEquals((Object)"test.l", (Object)data.getId());
        Assert.assertNotNull((Object)data.getIdStyle());
    }
}

