/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.geoserver.ManifestLoader;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.SystemTest;
import org.geoserver.test.TestSetup;
import org.geoserver.test.TestSetupFrequency;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SystemTest.class})
public class ManifestLoaderTest
extends GeoServerSystemTestSupport {
    private static ManifestLoader loader;
    private static String resourceName;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        try {
            loader = new ManifestLoader(this.getResourceLoader());
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, e.getMessage(), e);
            Assert.fail((String)e.getLocalizedMessage());
        }
    }

    @Test
    public void manifestLoaderVersionsTest() {
        Assert.assertNotNull((Object)ManifestLoader.getVersions());
    }

    @Test
    public void manifestLoaderResourcesTest() {
        Assert.assertNotNull((Object)ManifestLoader.getResources());
    }

    @Test
    public void filterNameByRegex() throws IllegalArgumentException {
        ManifestLoader.AboutModel resources = ManifestLoader.getResources();
        ManifestLoader.AboutModel filtered = resources.filterNameByRegex(resourceName);
        ManifestLoader.AboutModel.ManifestModel mm = (ManifestLoader.AboutModel.ManifestModel)filtered.getManifests().first();
        if (mm != null) {
            TestCase.assertTrue((boolean)mm.getName().matches(resourceName));
        } else {
            LOGGER.log(Level.WARNING, "Unable to test with this resource name: " + resourceName + "\nNo resource found.");
        }
    }

    @Test
    public void filterPropertyByKeyOrValueTest() throws IllegalArgumentException {
        ManifestLoader.AboutModel resources = ManifestLoader.getResources();
        ManifestLoader.AboutModel.ManifestModel mm = (ManifestLoader.AboutModel.ManifestModel)resources.getManifests().first();
        if (mm == null) {
            LOGGER.log(Level.WARNING, "Unable to test with this resource name: " + resourceName + "\nNo resource found.");
            return;
        }
        Iterator it = mm.getEntries().entrySet().iterator();
        if (!it.hasNext()) {
            LOGGER.log(Level.WARNING, "Unable to test with this resource name which does not has properties.");
            return;
        }
        Map.Entry entry = it.next();
        String propertyKey = (String)entry.getKey();
        String propertyVal = (String)entry.getValue();
        ManifestLoader.AboutModel filtered = resources.filterPropertyByKey(propertyKey);
        for (ManifestLoader.AboutModel.ManifestModel model : filtered.getManifests()) {
            TestCase.assertTrue((boolean)model.getEntries().containsKey(propertyKey));
        }
        filtered = resources.filterPropertyByValue(propertyVal);
        for (ManifestLoader.AboutModel.ManifestModel model : filtered.getManifests()) {
            TestCase.assertTrue((boolean)model.getEntries().containsValue(propertyVal));
        }
    }

    @Test
    public void filterPropertyByKeyAndValueTest() throws IllegalArgumentException {
        ManifestLoader.AboutModel resources = ManifestLoader.getResources();
        ManifestLoader.AboutModel.ManifestModel mm = (ManifestLoader.AboutModel.ManifestModel)resources.getManifests().first();
        if (mm == null) {
            LOGGER.log(Level.WARNING, "Unable to test with this resource name: " + resourceName + "\nNo resource found.");
            return;
        }
        Iterator it = mm.getEntries().entrySet().iterator();
        if (!it.hasNext()) {
            LOGGER.log(Level.WARNING, "Unable to test with this resource name which does not has properties.");
            return;
        }
        Map.Entry entry = it.next();
        String propertyKey = (String)entry.getKey();
        String propertyVal = (String)entry.getValue();
        ManifestLoader.AboutModel filtered = resources.filterPropertyByKeyValue(propertyKey, propertyVal);
        for (ManifestLoader.AboutModel.ManifestModel model : filtered.getManifests()) {
            TestCase.assertTrue((boolean)model.getEntries().containsKey(propertyKey));
            String value = (String)model.getEntries().get(propertyKey);
            TestCase.assertTrue((boolean)value.equals(propertyVal));
        }
    }

    @Test
    public void removeTest() {
        ManifestLoader.AboutModel resources = ManifestLoader.getResources();
        ManifestLoader.AboutModel newResources = ManifestLoader.getResources();
        ManifestLoader.AboutModel.ManifestModel mm = (ManifestLoader.AboutModel.ManifestModel)newResources.getManifests().first();
        TestCase.assertTrue((boolean)resources.getManifests().contains(mm));
        resources.remove(mm.getName());
        TestCase.assertTrue((!resources.getManifests().contains(mm) ? 1 : 0) != 0);
    }

    static {
        resourceName = "freemarker-.*";
    }

    @Category(value={SystemTest.class})
    @TestSetup(run=TestSetupFrequency.REPEAT)
    public static class ManifestPropertiesTest
    extends GeoServerSystemTestSupport {
        private File properties;
        String propertyKey;

        @Override
        protected void setUpTestData(SystemTestData testData) throws Exception {
        }

        @Before
        public void paranoidCleanup() {
            File rootMonitor = new File(".", "manifest.properties");
            if (rootMonitor.exists()) {
                rootMonitor.delete();
            }
        }

        @Override
        protected void onSetUp(SystemTestData testData) throws Exception {
            ManifestLoader.AboutModel resources = ManifestLoader.getResources();
            ManifestLoader.AboutModel.ManifestModel mm = (ManifestLoader.AboutModel.ManifestModel)resources.getManifests().first();
            if (mm == null) {
                LOGGER.log(Level.WARNING, "Unable to test with this resource name: " + resourceName + "\nNo resource found.");
                return;
            }
            Iterator it = mm.getEntries().entrySet().iterator();
            if (!it.hasNext()) {
                LOGGER.log(Level.WARNING, "Unable to test with this resource name which does not has properties.");
                return;
            }
            Map.Entry entry = it.next();
            this.propertyKey = (String)entry.getKey();
            this.properties = new File(testData.getDataDirectoryRoot(), "manifest.properties");
            try (FileWriter writer = new FileWriter(this.properties);){
                writer.write("versionAttributeInclusions=" + this.propertyKey + "\n");
                writer.write("resourceAttributeExclusions=" + this.propertyKey);
                writer.flush();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Unable to write test data to:" + testData.getDataDirectoryRoot());
                Assert.fail((String)e.getLocalizedMessage());
            }
            try {
                loader = new ManifestLoader(this.getResourceLoader());
            }
            catch (Exception e) {
                LOGGER.log(Level.FINER, e.getMessage(), e);
                Assert.fail((String)e.getLocalizedMessage());
            }
        }

        @Override
        protected void onTearDown(SystemTestData testData) throws Exception {
            FileUtils.deleteQuietly((File)this.properties);
        }

        @Test
        public void filterExcludingAttributes() {
            ManifestLoader.AboutModel resources = ManifestLoader.getResources();
            Iterator mmit = resources.getManifests().iterator();
            while (mmit.hasNext()) {
                for (Map.Entry entry : ((ManifestLoader.AboutModel.ManifestModel)mmit.next()).getEntries().entrySet()) {
                    TestCase.assertTrue((!this.propertyKey.equals(entry.getKey()) ? 1 : 0) != 0);
                }
            }
        }

        @Test
        public void filterIncludingAttributes() {
            ManifestLoader.AboutModel versions = ManifestLoader.getVersions();
            Iterator mmit = versions.getManifests().iterator();
            while (mmit.hasNext()) {
                for (Map.Entry entry : ((ManifestLoader.AboutModel.ManifestModel)mmit.next()).getEntries().entrySet()) {
                    TestCase.assertTrue((boolean)this.propertyKey.equals(entry.getKey()));
                }
            }
        }
    }
}

