/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogRepository;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.data.DataStore;
import org.geotools.feature.NameImpl;
import org.geotools.util.URLs;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.type.Name;

public class CatalogRepositoryTest
extends GeoServerSystemTestSupport {
    @Test
    public void testLookupExistingStore() throws IOException {
        CatalogRepository repository = this.getCatalog().getResourcePool().getRepository();
        DataStore store = repository.dataStore((Name)new NameImpl(MockData.SF_PREFIX, MockData.SF_PREFIX));
        TestCase.assertNotNull((Object)store);
        List<String> typeNames = Arrays.asList(store.getTypeNames());
        Assert.assertTrue((boolean)typeNames.contains(MockData.PRIMITIVEGEOFEATURE.getLocalPart()));
    }

    @Test
    public void testLookupNotQualified() throws IOException {
        CatalogRepository repository = this.getCatalog().getResourcePool().getRepository();
        DataStore store = repository.dataStore((Name)new NameImpl(null, MockData.SF_PREFIX));
        TestCase.assertNotNull((Object)store);
        List<String> typeNames = Arrays.asList(store.getTypeNames());
        Assert.assertTrue((boolean)typeNames.contains(MockData.PRIMITIVEGEOFEATURE.getLocalPart()));
    }

    @Test
    public void testLookupNotExisting() {
        CatalogRepository repository = this.getCatalog().getResourcePool().getRepository();
        DataStore store = repository.dataStore((Name)new NameImpl("foo", "bar"));
        Assert.assertNull((Object)store);
    }

    @Test
    public void testLookupFreshlyAdded() {
        Catalog catalog = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        String nsURI = catalog.getDefaultNamespace().getURI();
        URL buildings = MockData.class.getResource("Buildings.properties");
        File testData = URLs.urlToFile((URL)buildings).getParentFile();
        DataStoreInfo storeInfo = cb.buildDataStore("freshOffTheBoat");
        storeInfo.getConnectionParameters().put("directory", testData);
        storeInfo.getConnectionParameters().put("namespace", nsURI);
        catalog.save((StoreInfo)storeInfo);
        CatalogRepository repository = this.getCatalog().getResourcePool().getRepository();
        DataStore store = repository.dataStore((Name)new NameImpl("freshOffTheBoat"));
        TestCase.assertNotNull((Object)store);
    }
}

