/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.measure.Unit;
import org.geoserver.catalog.CoverageDimensionCustomizerReader;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.impl.CoverageDimensionImpl;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.util.NumberRange;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.SampleDimensionType;
import org.opengis.geometry.Envelope;
import tech.units.indriya.unit.BaseUnit;

public class CoverageDimensionCustomizerReaderTest
extends GeoServerSystemTestSupport {
    private static final double DELTA = 1.0E-4;

    @Test
    public void testDimensionsWrapping() throws IOException {
        GridSampleDimension sampleDim = new GridSampleDimension((CharSequence)"original", SampleDimensionType.REAL_64BITS, ColorInterpretation.GRAY_INDEX, null, null, new double[]{-9999.0}, -1000.0, 1000.0, 1.0, 0.0, null);
        CoverageDimensionImpl coverageDim = new CoverageDimensionImpl();
        String wrappedName = "wrapped";
        coverageDim.setName("wrapped");
        coverageDim.setDimensionType(SampleDimensionType.REAL_64BITS);
        double newMinimum = -2000.0;
        double newMaximum = 2000.0;
        NumberRange range = new NumberRange(Double.class, (Number)-2000.0, (Number)2000.0);
        coverageDim.setRange(range);
        ArrayList<Double> nullValues = new ArrayList<Double>();
        double noData1 = -32768.0;
        double noData2 = -32767.0;
        nullValues.add(-32768.0);
        nullValues.add(-32767.0);
        coverageDim.setNullValues(nullValues);
        CoverageDimensionCustomizerReader.WrappedSampleDimension wrappedDim = CoverageDimensionCustomizerReader.WrappedSampleDimension.build((GridSampleDimension)sampleDim, (CoverageDimensionInfo)coverageDim);
        double[] noData = wrappedDim.getNoDataValues();
        Assert.assertEquals((long)2L, (long)noData.length);
        Assert.assertEquals((double)-32768.0, (double)noData[0], (double)1.0E-4);
        Assert.assertEquals((double)-32767.0, (double)noData[1], (double)1.0E-4);
        NumberRange wrappedRange = wrappedDim.getRange();
        Assert.assertEquals((double)-2000.0, (double)wrappedRange.getMinimum(), (double)1.0E-4);
        Assert.assertEquals((double)2000.0, (double)wrappedRange.getMaximum(), (double)1.0E-4);
        Assert.assertEquals((Object)"wrapped", (Object)wrappedDim.getDescription().toString());
    }

    @Test
    public void testWrapCustomizationSurviveCopyConstructor() throws Exception {
        GridSampleDimension sampleDim = new GridSampleDimension((CharSequence)"original", SampleDimensionType.REAL_64BITS, ColorInterpretation.GRAY_INDEX, null, null, new double[]{-9999.0}, -1000.0, 1000.0, 1.0, 0.0, null);
        CoverageDimensionImpl coverageDim = new CoverageDimensionImpl();
        String wrappedName = "wrapped";
        coverageDim.setName("wrapped");
        coverageDim.setDimensionType(SampleDimensionType.REAL_64BITS);
        double newMinimum = -2000.0;
        double newMaximum = 2000.0;
        NumberRange range = new NumberRange(Double.class, (Number)-2000.0, (Number)2000.0);
        coverageDim.setRange(range);
        ArrayList<Double> nullValues = new ArrayList<Double>();
        double noData1 = -32768.0;
        double noData2 = -32767.0;
        nullValues.add(-32768.0);
        nullValues.add(-32767.0);
        coverageDim.setNullValues(nullValues);
        CoverageDimensionCustomizerReader.WrappedSampleDimension wrappedDim = CoverageDimensionCustomizerReader.WrappedSampleDimension.build((GridSampleDimension)sampleDim, (CoverageDimensionInfo)coverageDim);
        double[] noData = wrappedDim.getNoDataValues();
        Assert.assertEquals((long)2L, (long)noData.length);
        Assert.assertEquals((double)-32768.0, (double)noData[0], (double)1.0E-4);
        Assert.assertEquals((double)-32767.0, (double)noData[1], (double)1.0E-4);
        NumberRange wrappedRange = wrappedDim.getRange();
        Assert.assertEquals((double)-2000.0, (double)wrappedRange.getMinimum(), (double)1.0E-4);
        Assert.assertEquals((double)2000.0, (double)wrappedRange.getMaximum(), (double)1.0E-4);
    }

    @Test
    public void testIntegerNoDataCategoryWrapping() throws IOException {
        CoverageDimensionImpl coverageDim = new CoverageDimensionImpl();
        String wrappedName = "wrapped";
        coverageDim.setName("wrapped");
        coverageDim.setDimensionType(SampleDimensionType.SIGNED_16BITS);
        coverageDim.setRange(NumberRange.create((double)0.0, (double)10000.0));
        ArrayList<Double> nullValues = new ArrayList<Double>();
        double noData1 = -32768.0;
        nullValues.add(-32768.0);
        coverageDim.setNullValues(nullValues);
        GridSampleDimension sampleDim = new GridSampleDimension((CharSequence)"original", new Category[]{new Category((CharSequence)Vocabulary.formatInternational((int)147), new Color[]{new Color(0, 0, 0, 0)}, NumberRange.create((int)-9999, (int)-9999))}, null);
        CoverageDimensionCustomizerReader.WrappedSampleDimension copy = CoverageDimensionCustomizerReader.WrappedSampleDimension.build((GridSampleDimension)sampleDim, (CoverageDimensionInfo)coverageDim);
        List categories = copy.getCategories();
        Category category = (Category)categories.get(0);
        Assert.assertTrue((boolean)category.getName().equals(Category.NODATA.getName()));
        Assert.assertEquals((double)category.getRange().getMinimum(), (double)-32768.0, (double)1.0E-4);
        Assert.assertEquals((double)category.getRange().getMaximum(), (double)-32768.0, (double)1.0E-4);
    }

    @Test
    public void testNoDataCategoryWrapping() throws IOException {
        CoverageDimensionImpl coverageDim = new CoverageDimensionImpl();
        String wrappedName = "wrapped";
        coverageDim.setName("wrapped");
        coverageDim.setDimensionType(SampleDimensionType.REAL_64BITS);
        ArrayList<Double> nullValues = new ArrayList<Double>();
        double noData1 = -32768.0;
        double noData2 = -32767.0;
        nullValues.add(-32768.0);
        nullValues.add(-32767.0);
        coverageDim.setNullValues(nullValues);
        GridSampleDimension sampleDim = new GridSampleDimension((CharSequence)"original", new Category[]{new Category((CharSequence)Vocabulary.formatInternational((int)147), new Color(0, 0, 0, 0), Double.NaN)}, null);
        CoverageDimensionCustomizerReader.WrappedSampleDimension wrappedDim = CoverageDimensionCustomizerReader.WrappedSampleDimension.build((GridSampleDimension)sampleDim, (CoverageDimensionInfo)coverageDim);
        GridSampleDimension copy = new GridSampleDimension((GridSampleDimension)wrappedDim){};
        List categories = copy.getCategories();
        Category category = (Category)categories.get(0);
        Assert.assertTrue((boolean)category.getName().equals(Category.NODATA.getName()));
        Assert.assertEquals((double)category.getRange().getMinimum(), (double)Double.NaN, (double)1.0E-4);
        Assert.assertEquals((double)category.getRange().getMaximum(), (double)Double.NaN, (double)1.0E-4);
        sampleDim = new GridSampleDimension((CharSequence)"original", new Category[]{new Category((CharSequence)Vocabulary.formatInternational((int)147), new Color[]{new Color(0, 0, 0, 0)}, NumberRange.create((int)-9999, (int)-9999))}, null);
        copy = CoverageDimensionCustomizerReader.WrappedSampleDimension.build((GridSampleDimension)sampleDim, (CoverageDimensionInfo)coverageDim);
        categories = copy.getCategories();
        category = (Category)categories.get(0);
        Assert.assertTrue((boolean)category.getName().equals(Category.NODATA.getName()));
        Assert.assertEquals((double)category.getRange().getMinimum(), (double)-32768.0, (double)1.0E-4);
        Assert.assertEquals((double)category.getRange().getMaximum(), (double)-32768.0, (double)1.0E-4);
    }

    @Test
    public void testNoRange() throws IOException {
        GridSampleDimension sampleDim = new GridSampleDimension((CharSequence)"original", SampleDimensionType.REAL_64BITS, ColorInterpretation.GRAY_INDEX, null, null, new double[]{-9999.0}, -1000.0, 1000.0, 1.0, 0.0, null);
        CoverageDimensionImpl coverageDim = new CoverageDimensionImpl();
        String wrappedName = "wrapped";
        coverageDim.setName("wrapped");
        coverageDim.setDimensionType(SampleDimensionType.REAL_64BITS);
        CoverageDimensionCustomizerReader.WrappedSampleDimension wrappedDim = CoverageDimensionCustomizerReader.WrappedSampleDimension.build((GridSampleDimension)sampleDim, (CoverageDimensionInfo)coverageDim);
        NumberRange wrappedRange = wrappedDim.getRange();
        Assert.assertNull((Object)wrappedRange);
        Assert.assertEquals((double)-9999.0, (double)wrappedDim.getMinimumValue(), (double)1.0E-4);
        Assert.assertEquals((double)1000.0, (double)wrappedDim.getMaximumValue(), (double)1.0E-4);
        Assert.assertEquals((Object)"wrapped", (Object)wrappedDim.getDescription().toString());
        sampleDim = new GridSampleDimension((CharSequence)"original", null, (Unit)new BaseUnit("test"));
        wrappedDim = CoverageDimensionCustomizerReader.WrappedSampleDimension.build((GridSampleDimension)sampleDim, (CoverageDimensionInfo)coverageDim);
        wrappedRange = wrappedDim.getRange();
        Assert.assertNull((Object)wrappedRange);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)wrappedDim.getMinimumValue(), (double)1.0E-4);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)wrappedDim.getMaximumValue(), (double)1.0E-4);
    }

    @Test
    public void testGridCoverageUnwrapping() throws IOException {
        GridCoverageFactory gcFactory = new GridCoverageFactory();
        BufferedImage image = new BufferedImage(1, 1, 10);
        GridCoverage2D original = gcFactory.create((CharSequence)"original", (RenderedImage)image, (Envelope)new GeneralEnvelope((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, 64.0, 64.0)));
        GridSampleDimension[] gsd = new GridSampleDimension[]{new GridSampleDimension((CharSequence)"wrappedSampleDimension")};
        CoverageDimensionCustomizerReader.GridCoverageWrapper wrapper = new CoverageDimensionCustomizerReader.GridCoverageWrapper("wrapped", original, gsd, null);
        Assert.assertNotSame((Object)original.getSampleDimensions(), (Object)wrapper.getSampleDimensions());
        Assert.assertNotSame((Object)wrapper, (Object)original);
        Assert.assertSame((Object)original, (Object)wrapper.unwrap(original.getClass()));
    }
}

