/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.media.jai.PlanarImage;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.data.test.TestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.coverage.grid.io.footprint.FootprintBehavior;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.util.ImageUtilities;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.FeatureVisitor;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CoverageViewTest
extends GeoServerSystemTestSupport {
    private static final String RGB_IR_VIEW = "RgbIrView";
    private static final String S2_REDUCED_VIEW = "s2reduced_view";
    private static final String BANDS_FLAGS_VIEW = "BandsFlagsView";
    protected static QName WATTEMP = new QName(MockData.SF_URI, "watertemp", MockData.SF_PREFIX);
    protected static QName S2REDUCED = new QName(MockData.SF_URI, "s2reduced", MockData.SF_PREFIX);
    protected static QName IR_RGB = new QName(MockData.SF_URI, "ir-rgb", MockData.SF_PREFIX);
    protected static QName BANDS_FLAGS = new QName(MockData.SF_URI, "bands-flags", MockData.SF_PREFIX);
    static CoordinateReferenceSystem UTM32N;

    @Before
    public void cleanupCatalog() {
        this.getGeoServer().reset();
    }

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpRasterLayer(WATTEMP, "watertemp.zip", null, null, TestData.class);
        testData.setUpRasterLayer(S2REDUCED, "s2reduced.zip", null, null, TestData.class);
        testData.setUpRasterLayer(IR_RGB, "ir-rgb.zip", null, null, TestData.class);
        testData.setUpRasterLayer(BANDS_FLAGS, "bands-flags.zip", null, null, TestData.class);
        UTM32N = CRS.decode((String)"EPSG:32632", (boolean)true);
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog cat = this.getCatalog();
        this.configureIROnCatalog(cat);
        this.configureBandsFlagsOnCatalog(cat);
    }

    private void configureIROnCatalog(Catalog cat) throws Exception {
        CoverageStoreInfo storeInfo = cat.getCoverageStoreByName("ir-rgb");
        CoverageView coverageView = this.buildRgbIRView();
        CatalogBuilder builder = new CatalogBuilder(cat);
        builder.setStore((StoreInfo)storeInfo);
        CoverageInfo coverageInfo = coverageView.createCoverageInfo(RGB_IR_VIEW, storeInfo, builder);
        coverageInfo.getParameters().put("USE_JAI_IMAGEREAD", "false");
        ((CoverageDimensionInfo)coverageInfo.getDimensions().get(0)).setName("Red");
        ((CoverageDimensionInfo)coverageInfo.getDimensions().get(1)).setName("Green");
        ((CoverageDimensionInfo)coverageInfo.getDimensions().get(2)).setName("Blue");
        ((CoverageDimensionInfo)coverageInfo.getDimensions().get(3)).setName("Infrared");
        cat.add((ResourceInfo)coverageInfo);
    }

    private void configureBandsFlagsOnCatalog(Catalog cat) throws Exception {
        CoverageStoreInfo storeInfo = cat.getCoverageStoreByName("bands-flags");
        CoverageView coverageView = this.buildBandsFlagsView();
        CatalogBuilder builder = new CatalogBuilder(cat);
        builder.setStore((StoreInfo)storeInfo);
        CoverageInfo coverageInfo = coverageView.createCoverageInfo(BANDS_FLAGS_VIEW, storeInfo, builder);
        coverageInfo.getParameters().put("USE_JAI_IMAGEREAD", "false");
        cat.add((ResourceInfo)coverageInfo);
    }

    private CoverageView buildRgbIRView() {
        CoverageView.CoverageBand rBand = new CoverageView.CoverageBand(Arrays.asList(new CoverageView.InputCoverageBand("rgb", "0")), "rband", 0, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.CoverageBand gBand = new CoverageView.CoverageBand(Arrays.asList(new CoverageView.InputCoverageBand("rgb", "1")), "gband", 1, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.CoverageBand bBand = new CoverageView.CoverageBand(Arrays.asList(new CoverageView.InputCoverageBand("rgb", "2")), "bband", 2, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.CoverageBand irBand = new CoverageView.CoverageBand(Collections.singletonList(new CoverageView.InputCoverageBand("ir", "0")), "irband", 3, CoverageView.CompositionType.BAND_SELECT);
        CoverageView coverageView = new CoverageView(RGB_IR_VIEW, Arrays.asList(rBand, gBand, bBand, irBand));
        coverageView.setEnvelopeCompositionType(null);
        coverageView.setSelectedResolution(null);
        return coverageView;
    }

    private CoverageView buildBandsFlagsView() {
        String[] sources = new String[]{"SWIR", "VNIR", "QUALITY_CLASSES", "QUALITY_CLOUD", "QUALITY_CLOUDSHADOW", "QUALITY_HAZE", "QUALITY_SNOW"};
        ArrayList<CoverageView.CoverageBand> bands = new ArrayList<CoverageView.CoverageBand>();
        for (String source : sources) {
            if (source.startsWith("QUALITY_")) {
                CoverageView.CoverageBand band = new CoverageView.CoverageBand(Arrays.asList(new CoverageView.InputCoverageBand(source, "0")), source, 0, CoverageView.CompositionType.BAND_SELECT);
                bands.add(band);
                continue;
            }
            for (int i = 0; i < 3; ++i) {
                CoverageView.CoverageBand band = new CoverageView.CoverageBand(Arrays.asList(new CoverageView.InputCoverageBand(source, "" + i)), source + "_" + i, i, CoverageView.CompositionType.BAND_SELECT);
                bands.add(band);
            }
        }
        CoverageView coverageView = new CoverageView(BANDS_FLAGS_VIEW, bands);
        return coverageView;
    }

    @Test
    public void testPreserveCoverageBandNames() throws Exception {
        Catalog cat = this.getCatalog();
        CoverageStoreInfo storeInfo = cat.getCoverageStoreByName("ir-rgb");
        CoverageView coverageView = this.buildRgbIRView();
        CatalogBuilder builder = new CatalogBuilder(cat);
        builder.setStore((StoreInfo)storeInfo);
        CoverageInfo coverageInfo = coverageView.createCoverageInfo(RGB_IR_VIEW, storeInfo, builder);
        List dimensions = coverageInfo.getDimensions();
        Assert.assertEquals((Object)"rband", (Object)((CoverageDimensionInfo)dimensions.get(0)).getName());
        Assert.assertEquals((Object)"gband", (Object)((CoverageDimensionInfo)dimensions.get(1)).getName());
        Assert.assertEquals((Object)"bband", (Object)((CoverageDimensionInfo)dimensions.get(2)).getName());
        Assert.assertEquals((Object)"irband", (Object)((CoverageDimensionInfo)dimensions.get(3)).getName());
    }

    @Test
    public void testCoverageView() throws Exception {
        Catalog cat = this.getCatalog();
        CoverageStoreInfo storeInfo = cat.getCoverageStoreByName("watertemp");
        CoverageView.InputCoverageBand band = new CoverageView.InputCoverageBand("watertemp", "0");
        CoverageView.CoverageBand outputBand = new CoverageView.CoverageBand(Collections.singletonList(band), "watertemp@0", 0, CoverageView.CompositionType.BAND_SELECT);
        CoverageView coverageView = new CoverageView("waterView", Collections.singletonList(outputBand));
        CatalogBuilder builder = new CatalogBuilder(cat);
        builder.setStore((StoreInfo)storeInfo);
        CoverageInfo coverageInfo = coverageView.createCoverageInfo("waterView", storeInfo, builder);
        coverageInfo.getParameters().put("USE_JAI_IMAGEREAD", "false");
        cat.add((ResourceInfo)coverageInfo);
        MetadataMap metadata = coverageInfo.getMetadata();
        CoverageView metadataCoverageView = (CoverageView)metadata.get((Object)CoverageView.COVERAGE_VIEW);
        Assert.assertEquals((Object)metadataCoverageView, (Object)coverageView);
        ResourcePool resPool = cat.getResourcePool();
        ReferencedEnvelope bbox = coverageInfo.getLatLonBoundingBox();
        GridCoverage coverage = resPool.getGridCoverage(coverageInfo, "waterView", bbox, null);
        Assert.assertEquals((long)coverage.getNumSampleDimensions(), (long)1L);
        this.disposeCoverage(coverage);
        GridCoverageReader reader = resPool.getGridCoverageReader(coverageInfo, null);
        reader.dispose();
    }

    private void disposeCoverage(GridCoverage coverage) {
        RenderedImage ri = coverage.getRenderedImage();
        if (coverage instanceof GridCoverage2D) {
            ((GridCoverage2D)coverage).dispose(true);
        }
        if (ri instanceof PlanarImage) {
            ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)ri));
        }
    }

    @Test
    public void testBands() throws Exception {
        CoverageView.InputCoverageBand u = new CoverageView.InputCoverageBand("u-component", "0");
        CoverageView.InputCoverageBand v = new CoverageView.InputCoverageBand("u-component", "0");
        Assert.assertEquals((Object)u, (Object)v);
        CoverageView.InputCoverageBand empty = new CoverageView.InputCoverageBand();
        v.setCoverageName("v-component");
        v.setBand("1");
        Assert.assertNotEquals((Object)u, (Object)v);
        Assert.assertNotEquals((Object)u, (Object)empty);
        CoverageView.CoverageBand outputBandU = new CoverageView.CoverageBand(Collections.singletonList(u), "u@1", 0, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.CoverageBand outputBandV = new CoverageView.CoverageBand();
        outputBandV.setInputCoverageBands(Collections.singletonList(v));
        outputBandV.setDefinition("v@0");
        outputBandV.setIndex(1);
        outputBandV.setCompositionType(CoverageView.CompositionType.BAND_SELECT);
        Assert.assertNotEquals((Object)outputBandU, (Object)outputBandV);
        CoverageView.CompositionType defaultComposition = CoverageView.CompositionType.getDefault();
        Assert.assertEquals((Object)"Band Selection", (Object)defaultComposition.displayValue());
        Assert.assertEquals((Object)"BAND_SELECT", (Object)defaultComposition.toValue());
        Assert.assertEquals((Object)outputBandU.getCompositionType(), (Object)defaultComposition);
        ArrayList<CoverageView.CoverageBand> bands = new ArrayList<CoverageView.CoverageBand>();
        bands.add(outputBandU);
        bands.add(outputBandV);
        CoverageView coverageView = new CoverageView("wind", bands);
        CoverageView sameViewDifferentName = new CoverageView();
        sameViewDifferentName.setName("winds");
        sameViewDifferentName.setCoverageBands(bands);
        Assert.assertNotEquals((Object)coverageView, (Object)sameViewDifferentName);
        Assert.assertEquals((Object)coverageView.getBand(1), (Object)outputBandV);
        Assert.assertEquals((Object)outputBandU, coverageView.getBands("u-component").get(0));
        Assert.assertEquals((long)2L, (long)coverageView.getSize());
        Assert.assertEquals((long)2L, (long)coverageView.getCoverageBands().size());
        Assert.assertEquals((Object)"wind", (Object)coverageView.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRGBIrToRGB() throws IOException {
        Catalog cat = this.getCatalog();
        CoverageInfo coverageInfo = cat.getCoverageByName(RGB_IR_VIEW);
        ResourcePool rp = cat.getResourcePool();
        GridCoverageReader reader = rp.getGridCoverageReader(coverageInfo, RGB_IR_VIEW, null);
        GeneralParameterValue[] params = this.buildFootprintBandParams(FootprintBehavior.None, new int[]{0, 1, 2});
        GridCoverage solidCoverage = reader.read(params);
        try {
            this.assertBandNames(solidCoverage, "Red", "Green", "Blue");
        }
        finally {
            this.disposeCoverage(solidCoverage);
        }
        params = this.buildFootprintBandParams(FootprintBehavior.Transparent, new int[]{0, 1, 2});
        GridCoverage txCoverage = reader.read(params);
        try {
            this.assertBandNames(txCoverage, "Red", "Green", "Blue", "ALPHA_BAND");
        }
        finally {
            this.disposeCoverage(solidCoverage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRGBIrToIr() throws IOException {
        Catalog cat = this.getCatalog();
        CoverageInfo coverageInfo = cat.getCoverageByName(RGB_IR_VIEW);
        ResourcePool rp = cat.getResourcePool();
        GridCoverageReader reader = rp.getGridCoverageReader(coverageInfo, RGB_IR_VIEW, null);
        GeneralParameterValue[] params = this.buildFootprintBandParams(FootprintBehavior.None, new int[]{3});
        GridCoverage solidCoverage = reader.read(RGB_IR_VIEW, params);
        try {
            this.assertBandNames(solidCoverage, "Infrared");
        }
        finally {
            this.disposeCoverage(solidCoverage);
        }
        params = this.buildFootprintBandParams(FootprintBehavior.Transparent, new int[]{3});
        GridCoverage txCoverage = reader.read(RGB_IR_VIEW, params);
        try {
            this.assertBandNames(txCoverage, "Infrared", "ALPHA_BAND");
        }
        finally {
            this.disposeCoverage(solidCoverage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRGBIrToIrGB() throws IOException {
        Catalog cat = this.getCatalog();
        CoverageInfo coverageInfo = cat.getCoverageByName(RGB_IR_VIEW);
        ResourcePool rp = cat.getResourcePool();
        GridCoverageReader reader = rp.getGridCoverageReader(coverageInfo, RGB_IR_VIEW, null);
        GeneralParameterValue[] params = this.buildFootprintBandParams(FootprintBehavior.None, new int[]{3, 1, 2});
        GridCoverage solidCoverage = reader.read(RGB_IR_VIEW, params);
        try {
            this.assertBandNames(solidCoverage, "Infrared", "Green", "Blue");
        }
        finally {
            this.disposeCoverage(solidCoverage);
        }
        params = this.buildFootprintBandParams(FootprintBehavior.Transparent, new int[]{3, 1, 2});
        GridCoverage txCoverage = reader.read(RGB_IR_VIEW, params);
        try {
            this.assertBandNames(txCoverage, "Infrared", "Green", "Blue", "ALPHA_BAND");
        }
        finally {
            this.disposeCoverage(solidCoverage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRGBIrToRed() throws IOException {
        Catalog cat = this.getCatalog();
        CoverageInfo coverageInfo = cat.getCoverageByName(RGB_IR_VIEW);
        ResourcePool rp = cat.getResourcePool();
        GridCoverageReader reader = rp.getGridCoverageReader(coverageInfo, RGB_IR_VIEW, null);
        GeneralParameterValue[] params = this.buildFootprintBandParams(FootprintBehavior.None, new int[]{0});
        GridCoverage solidCoverage = reader.read(RGB_IR_VIEW, params);
        try {
            this.assertBandNames(solidCoverage, "Red");
        }
        finally {
            this.disposeCoverage(solidCoverage);
        }
        params = this.buildFootprintBandParams(FootprintBehavior.Transparent, new int[]{0});
        GridCoverage txCoverage = reader.read(RGB_IR_VIEW, params);
        try {
            this.assertBandNames(txCoverage, "Red", "ALPHA_BAND");
        }
        finally {
            this.disposeCoverage(solidCoverage);
        }
    }

    private void assertBandNames(GridCoverage coverage, String ... bandNames) {
        Assert.assertEquals((long)bandNames.length, (long)coverage.getNumSampleDimensions());
        for (int i = 0; i < bandNames.length; ++i) {
            String expectedName = bandNames[i];
            String actualName = coverage.getSampleDimension(i).getDescription().toString();
            Assert.assertEquals((Object)expectedName, (Object)actualName);
        }
    }

    private GeneralParameterValue[] buildFootprintBandParams(FootprintBehavior footprintBehavior, int[] bands) {
        ArrayList<ParameterValue> parameters = new ArrayList<ParameterValue>();
        parameters.add(new DefaultParameterDescriptor(AbstractGridFormat.FOOTPRINT_BEHAVIOR.getName().toString(), AbstractGridFormat.FOOTPRINT_BEHAVIOR.getValueClass(), null, (Object)footprintBehavior.name()).createValue());
        parameters.add(new DefaultParameterDescriptor(AbstractGridFormat.BANDS.getName().toString(), AbstractGridFormat.BANDS.getValueClass(), null, (Object)bands).createValue());
        return parameters.toArray(new GeneralParameterValue[parameters.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeterogeneousViewDefaults() throws Exception {
        CoverageInfo info = this.buildHeterogeneousResolutionView("s2AllBandsDefaults", cv -> {}, "B01", "B02", "B03", "B04", "B05", "B06", "B07", "B08", "B09", "B10", "B11", "B12");
        GridCoverage2D coverage = null;
        try {
            GridCoverage2DReader reader = (GridCoverage2DReader)info.getGridCoverageReader(null, null);
            Assert.assertEquals((double)1007.0, (double)reader.getResolutionLevels()[0][0], (double)1.0);
            Assert.assertEquals((double)1007.0, (double)reader.getResolutionLevels()[0][1], (double)1.0);
            GeneralEnvelope envelope = reader.getOriginalEnvelope();
            Assert.assertEquals((double)399960.0, (double)envelope.getMinimum(0), (double)1.0);
            Assert.assertEquals((double)5190240.0, (double)envelope.getMinimum(1), (double)1.0);
            Assert.assertEquals((double)509760.0, (double)envelope.getMaximum(0), (double)1.0);
            Assert.assertEquals((double)5300040.0, (double)envelope.getMaximum(1), (double)1.0);
            coverage = reader.read(null);
            this.assertCoverageResolution(coverage, 1007.0, 1007.0);
            Assert.assertEquals((Object)coverage.getEnvelope(), (Object)envelope);
        }
        finally {
            this.getCatalog().remove((ResourceInfo)info);
            if (coverage != null) {
                coverage.dispose(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeterogeneousViewIntersectionEnvelope() throws Exception {
        CoverageInfo info = this.buildHeterogeneousResolutionView("s2AllBandsIntersection", cv -> cv.setEnvelopeCompositionType(CoverageView.EnvelopeCompositionType.INTERSECTION), "B01", "B02", "B03", "B04", "B05", "B06", "B07", "B08", "B09", "B10", "B11", "B12");
        GridCoverage2D coverage = null;
        try {
            GridCoverage2DReader reader = (GridCoverage2DReader)info.getGridCoverageReader(null, null);
            Assert.assertEquals((double)1007.0, (double)reader.getResolutionLevels()[0][0], (double)1.0);
            Assert.assertEquals((double)1007.0, (double)reader.getResolutionLevels()[0][1], (double)1.0);
            GeneralEnvelope envelope = reader.getOriginalEnvelope();
            Assert.assertEquals((double)399960.0, (double)envelope.getMinimum(0), (double)1.0);
            Assert.assertEquals((double)5192273.0, (double)envelope.getMinimum(1), (double)1.0);
            Assert.assertEquals((double)507726.0, (double)envelope.getMaximum(0), (double)1.0);
            Assert.assertEquals((double)5300040.0, (double)envelope.getMaximum(1), (double)1.0);
            coverage = reader.read(null);
            this.assertCoverageResolution(coverage, 1007.0, 1007.0);
            Envelope coverageEnvelope = coverage.getEnvelope();
            Assert.assertEquals((double)399960.0, (double)coverageEnvelope.getMinimum(0), (double)1.0);
            Assert.assertEquals((double)5190240.0, (double)coverageEnvelope.getMinimum(1), (double)1.0);
            Assert.assertEquals((double)509760.0, (double)coverageEnvelope.getMaximum(0), (double)1.0);
            Assert.assertEquals((double)5300040.0, (double)coverageEnvelope.getMaximum(1), (double)1.0);
        }
        finally {
            this.getCatalog().remove((ResourceInfo)info);
            if (coverage != null) {
                coverage.dispose(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeterogeneousViewResolutionLowest() throws Exception {
        CoverageInfo info = this.buildHeterogeneousResolutionView("s2AllBandsLowest", cv -> cv.setSelectedResolution(CoverageView.SelectedResolution.WORST), "B01", "B02", "B03", "B04", "B05", "B06", "B07", "B08", "B09", "B10", "B11", "B12");
        GridCoverage2D coverage = null;
        try {
            GridCoverage2DReader reader = (GridCoverage2DReader)info.getGridCoverageReader(null, null);
            Assert.assertEquals((double)6100.0, (double)reader.getResolutionLevels()[0][0], (double)1.0);
            Assert.assertEquals((double)6100.0, (double)reader.getResolutionLevels()[0][1], (double)1.0);
            coverage = reader.read(null);
        }
        finally {
            this.getCatalog().remove((ResourceInfo)info);
            if (coverage != null) {
                coverage.dispose(true);
            }
        }
    }

    private void assertCoverageResolution(GridCoverage2D coverage, double resX, double resY) {
        AffineTransform2D mt = (AffineTransform2D)coverage.getGridGeometry().getGridToCRS2D();
        Assert.assertEquals((double)resX, (double)mt.getScaleX(), (double)1.0);
        Assert.assertEquals((double)resY, (double)Math.abs(mt.getScaleY()), (double)1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeterogeneousViewOutsideBounds() throws Exception {
        CoverageInfo info = this.buildHeterogeneousResolutionView("s2AllBandsOutsideBounds", cv -> {}, "B01", "B02", "B03", "B04", "B05", "B06", "B07", "B08", "B09", "B10", "B11", "B12");
        GridCoverage2D coverage = null;
        try {
            ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
            gg.setValue((Object)new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, 10, 10), (Envelope)new ReferencedEnvelope(0.0, 1000.0, 0.0, 1000.0, UTM32N)));
            GridCoverage2DReader reader = (GridCoverage2DReader)info.getGridCoverageReader(null, null);
            coverage = reader.read(new GeneralParameterValue[]{gg});
            Assert.assertNull((Object)coverage);
        }
        finally {
            this.getCatalog().remove((ResourceInfo)info);
            if (coverage != null) {
                coverage.dispose(true);
            }
        }
    }

    @Test
    public void testHeterogeneousViewBandSelectionBestResolution() throws Exception {
        CoverageInfo info = this.buildHeterogeneousResolutionView("s2AllBandsBest", cv -> {}, "B01", "B02", "B03", "B04", "B05", "B06", "B07", "B08", "B09", "B10", "B11", "B12");
        this.checkBandSelectionResolution(info, new int[]{0}, 6100.0, 6100.0);
        this.checkBandSelectionResolution(info, new int[]{0, 1}, 1007.0, 1007.0);
        this.checkBandSelectionResolution(info, new int[]{0, 5}, 2033.0, 2033.0);
        this.checkBandSelectionResolution(info, new int[]{5, 8, 1}, 1007.0, 1007.0);
        this.checkBandSelectionResolution(info, new int[]{1, 8, 5}, 1007.0, 1007.0);
    }

    @Test
    public void testHeterogeneousViewBandSelectionWorstResolution() throws Exception {
        CoverageInfo info = this.buildHeterogeneousResolutionView("s2AllBandsWorst", cv -> cv.setSelectedResolution(CoverageView.SelectedResolution.WORST), "B01", "B02", "B03", "B04", "B05", "B06", "B07", "B08", "B09", "B10", "B11", "B12");
        this.checkBandSelectionResolution(info, new int[]{0}, 6100.0, 6100.0);
        this.checkBandSelectionResolution(info, new int[]{0, 1}, 6100.0, 6100.0);
        this.checkBandSelectionResolution(info, new int[]{0, 5}, 6100.0, 6100.0);
        this.checkBandSelectionResolution(info, new int[]{5, 8, 1}, 6100.0, 6100.0);
        this.checkBandSelectionResolution(info, new int[]{5, 8, 1}, 6100.0, 6100.0);
        this.checkBandSelectionResolution(info, new int[]{1}, 1007.0, 1007.0);
        this.checkBandSelectionResolution(info, new int[]{1, 5}, 2033.0, 2033.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkBandSelectionResolution(CoverageInfo info, int[] bands, double expectedResolutionX, double expectedResolutionY) throws IOException {
        GridCoverage2D coverage = null;
        try {
            GridCoverage2DReader reader = (GridCoverage2DReader)info.getGridCoverageReader(null, null);
            ParameterValue bandsValue = AbstractGridFormat.BANDS.createValue();
            bandsValue.setValue((Object)bands);
            coverage = reader.read(new GeneralParameterValue[]{bandsValue});
            Assert.assertNotNull((Object)coverage);
            this.assertCoverageResolution(coverage, expectedResolutionX, expectedResolutionY);
        }
        finally {
            this.getCatalog().remove((ResourceInfo)info);
            if (coverage != null) {
                coverage.dispose(true);
            }
        }
    }

    private CoverageInfo buildHeterogeneousResolutionView(String name, Consumer<CoverageView> viewCustomizer, String ... coverageNames) throws Exception {
        ArrayList<CoverageView.CoverageBand> bands = new ArrayList<CoverageView.CoverageBand>();
        int bandIdx = 0;
        for (String coverageName : coverageNames) {
            CoverageView.CoverageBand band = new CoverageView.CoverageBand(Arrays.asList(new CoverageView.InputCoverageBand(coverageName, "0")), coverageName, bandIdx++, CoverageView.CompositionType.BAND_SELECT);
            bands.add(band);
        }
        CoverageView coverageView = new CoverageView(name, bands);
        viewCustomizer.accept(coverageView);
        Catalog cat = this.getCatalog();
        CoverageStoreInfo storeInfo = cat.getCoverageStoreByName("s2reduced");
        CatalogBuilder builder = new CatalogBuilder(cat);
        builder.setStore((StoreInfo)storeInfo);
        CoverageInfo coverageInfo = coverageView.createCoverageInfo(name, storeInfo, builder);
        coverageInfo.getParameters().put("USE_JAI_IMAGEREAD", "false");
        cat.add((ResourceInfo)coverageInfo);
        return cat.getCoverage(coverageInfo.getId());
    }

    @Test
    public void testCoverageViewGranuleSource() throws Exception {
        String VIEW_NAME = "view";
        CoverageInfo info = this.buildHeterogeneousResolutionView("view", cv -> cv.setSelectedResolution(CoverageView.SelectedResolution.BEST), "B02", "B03", "B04");
        StructuredGridCoverage2DReader reader = (StructuredGridCoverage2DReader)info.getGridCoverageReader(null, null);
        GranuleSource source = reader.getGranules("view", true);
        Query query = new Query("view");
        SimpleFeatureCollection granules = source.getGranules(query);
        DataUtilities.first((FeatureCollection)granules);
        Assert.assertEquals((long)3L, (long)granules.size());
    }

    @Test
    public void testCoverageViewGranuleSourceAggregation() throws Exception {
        String VIEW_NAME = "viewAggregate";
        CoverageInfo info = this.buildHeterogeneousResolutionView("viewAggregate", cv -> cv.setSelectedResolution(CoverageView.SelectedResolution.BEST), "B02", "B03", "B04", "B01");
        StructuredGridCoverage2DReader reader = (StructuredGridCoverage2DReader)info.getGridCoverageReader(null, null);
        GranuleSource source = reader.getGranules("viewAggregate", true);
        Query query = new Query("viewAggregate");
        SimpleFeatureCollection granules = source.getGranules(query);
        MinVisitor visitor = new MinVisitor("location");
        granules.accepts((FeatureVisitor)visitor, null);
        Assert.assertEquals((Object)"20170410T103021026Z_fullres_CC2.1989_T32TMT_B01.tif", (Object)visitor.getMin());
    }

    @Test
    public void testBandsFlagsView() throws Exception {
        CoverageInfo info = this.getCatalog().getCoverageByName(BANDS_FLAGS_VIEW);
        GridCoverageReader reader = info.getGridCoverageReader(null, null);
        GridCoverage2D coverage = (GridCoverage2D)reader.read(null);
        Assert.assertEquals((long)11L, (long)coverage.getRenderedImage().getSampleModel().getNumBands());
        coverage.dispose(true);
    }
}

