/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;

public abstract class IsolatedWorkspacesTest
extends GeoServerSystemTestSupport {
    protected final List<String> CREATED_WORKSPACES_PREFIXES = new ArrayList<String>();

    @Before
    public void beforeTest() {
        this.CREATED_WORKSPACES_PREFIXES.forEach(this::removeWorkspace);
        LocalWorkspace.set(null);
    }

    protected void updateWorkspaceIsolationState(String prefix, boolean isolated) {
        Catalog catalog = this.getCatalog();
        WorkspaceInfo workspace = catalog.getWorkspaceByName(prefix);
        workspace.setIsolated(isolated);
        catalog.save(workspace);
        NamespaceInfo namespace = catalog.getNamespaceByPrefix(prefix);
        namespace.setIsolated(isolated);
        catalog.save(namespace);
    }

    protected void checkWorkspace(WorkspaceInfo workspace, String expectedPrefix, boolean expectedIsolation) {
        Assert.assertThat((Object)workspace, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)workspace.getName(), (Matcher)Matchers.is((Object)expectedPrefix));
        Assert.assertThat((Object)workspace.isIsolated(), (Matcher)Matchers.is((Object)expectedIsolation));
    }

    protected void checkNamespace(NamespaceInfo namespace, String expectedPrefix, String expectedNamespaceUri, boolean expectedIsolation) {
        Assert.assertThat((Object)namespace, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)namespace.getPrefix(), (Matcher)Matchers.is((Object)expectedPrefix));
        Assert.assertThat((Object)namespace.getName(), (Matcher)Matchers.is((Object)expectedPrefix));
        Assert.assertThat((Object)namespace.getURI(), (Matcher)Matchers.is((Object)expectedNamespaceUri));
        Assert.assertThat((Object)namespace.isIsolated(), (Matcher)Matchers.is((Object)expectedIsolation));
    }

    protected void executeAndValidateException(Statement statement, Class<?> expectedException, String expectedMessage) {
        boolean exceptionHappen = false;
        try {
            statement.execute();
        }
        catch (Exception exception) {
            Assert.assertThat((Object)exception, (Matcher)Matchers.instanceOf(expectedException));
            Assert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)expectedMessage));
            exceptionHappen = true;
        }
        Assert.assertThat((Object)exceptionHappen, (Matcher)Matchers.is((Object)true));
    }

    protected void createWorkspace(String prefix, String namespaceUri, boolean isolated) {
        Catalog catalog = this.getCatalog();
        NamespaceInfoImpl namespace = new NamespaceInfoImpl();
        namespace.setPrefix(prefix);
        namespace.setURI(namespaceUri);
        namespace.setIsolated(isolated);
        catalog.add((NamespaceInfo)namespace);
        WorkspaceInfoImpl workspace = new WorkspaceInfoImpl();
        workspace.setName(prefix);
        workspace.setIsolated(isolated);
        catalog.add((WorkspaceInfo)workspace);
        this.CREATED_WORKSPACES_PREFIXES.add(prefix);
    }

    @FunctionalInterface
    protected static interface Statement {
        public void execute();
    }
}

