/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.Serializable;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.AuthorityURL;
import org.geoserver.catalog.impl.CoverageInfoImpl;
import org.geoserver.catalog.impl.CoverageStoreInfoImpl;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.filter.MultiValuedFilter;

public class PredicatesTest {
    private WorkspaceInfoImpl ws;
    private NamespaceInfoImpl ns;
    private DataStoreInfoImpl dataStore;
    private FeatureTypeInfoImpl featureType;
    private CoverageStoreInfoImpl coverageStore;
    private CoverageInfoImpl coverage;
    private LayerInfoImpl vectorLayer;
    private LayerInfoImpl rasterLayer;
    private StyleInfoImpl defaultStyle;
    private StyleInfoImpl style1;
    private StyleInfoImpl style2;

    @Before
    public void setUp() throws Exception {
        this.ns = new NamespaceInfoImpl();
        this.ns.setId("nsid");
        this.ns.setPrefix("test");
        this.ns.setURI("http://example.com");
        this.ws = new WorkspaceInfoImpl();
        this.ws.setId("wsid");
        this.ws.setName("ws1");
        this.dataStore = new DataStoreInfoImpl(null);
        this.dataStore.getConnectionParameters().put("boolParam", Boolean.TRUE);
        this.dataStore.getConnectionParameters().put("intParam", 1001);
        this.dataStore.getConnectionParameters().put("uriParam", new URI("http://some.place.net"));
        this.dataStore.setDescription("dataStore description");
        this.dataStore.setWorkspace((WorkspaceInfo)this.ws);
        this.dataStore.setName("dataStore");
        this.dataStore.setEnabled(true);
        this.dataStore.setId("dataStoreId");
        this.dataStore.setType("TestType");
        this.featureType = new FeatureTypeInfoImpl(null);
        this.featureType.setId("featureTypeId");
        this.featureType.setName("featureType");
        this.featureType.setNamespace((NamespaceInfo)this.ns);
        this.featureType.setAbstract("featureType abstract");
        this.featureType.setEnabled(true);
        this.featureType.setMaxFeatures(5000);
        this.featureType.setStore((StoreInfo)this.dataStore);
        this.featureType.setTitle("featureType title");
        this.vectorLayer = new LayerInfoImpl();
        this.vectorLayer.setResource((ResourceInfo)this.featureType);
        this.featureType.setAbstract("vectorLayer abstract");
        this.vectorLayer.setAdvertised(true);
        this.vectorLayer.setEnabled(true);
        this.vectorLayer.setName("vectorLayer");
        this.vectorLayer.setId("vectorLayerId");
        this.vectorLayer.setType(PublishedType.VECTOR);
        this.defaultStyle = new StyleInfoImpl(null);
        this.defaultStyle.setName("default");
        this.defaultStyle.setId("defaultStyle_id");
        this.vectorLayer.setDefaultStyle((StyleInfo)this.defaultStyle);
        this.style1 = new StyleInfoImpl(null);
        this.style1.setName("style1");
        this.style1.setId("style1_id");
        this.style2 = new StyleInfoImpl(null);
        this.style2.setName("style2");
        this.style2.setId("style2_id");
        this.vectorLayer.getStyles().add(this.style1);
        this.vectorLayer.getStyles().add(this.style2);
    }

    @Test
    public void testPropertyEqualsSimple() {
        Assert.assertTrue((boolean)Predicates.equal((String)"prefix", (Object)this.ns.getPrefix()).evaluate((Object)this.ns));
        Assert.assertTrue((boolean)Predicates.equal((String)"id", (Object)this.ws.getId()).evaluate((Object)this.ws));
        Assert.assertFalse((boolean)Predicates.equal((String)"id", (Object)"somethingElse").evaluate((Object)this.ws));
        HashSet<StyleInfoImpl> styles = new HashSet<StyleInfoImpl>();
        styles.add(this.style1);
        Assert.assertFalse((boolean)Predicates.equal((String)"styles", styles, (MultiValuedFilter.MatchAction)MultiValuedFilter.MatchAction.ALL).evaluate((Object)this.vectorLayer));
        Assert.assertTrue((boolean)Predicates.equal((String)"styles", styles, (MultiValuedFilter.MatchAction)MultiValuedFilter.MatchAction.ANY).evaluate((Object)this.vectorLayer));
        styles.add(this.style2);
        Assert.assertTrue((boolean)Predicates.equal((String)"styles", styles).evaluate((Object)this.vectorLayer));
    }

    @Test
    public void testPropertyNotEqualsSimple() {
        Assert.assertTrue((boolean)Predicates.notEqual((String)"id", (Object)"somethingElse").evaluate((Object)this.ws));
    }

    @Test
    public void testPropertyEqualsCompound() {
        Assert.assertTrue((boolean)Predicates.equal((String)"resource.id", (Object)this.featureType.getId()).evaluate((Object)this.vectorLayer));
        Assert.assertTrue((boolean)Predicates.equal((String)"resource.maxFeatures", (Object)this.featureType.getMaxFeatures()).evaluate((Object)this.vectorLayer));
        Assert.assertTrue((boolean)Predicates.equal((String)"resource.store.type", (Object)this.dataStore.getType()).evaluate((Object)this.vectorLayer));
        Assert.assertTrue((boolean)Predicates.equal((String)"resource.store.connectionParameters.boolParam", (Object)true).evaluate((Object)this.vectorLayer));
        Assert.assertFalse((boolean)Predicates.equal((String)"resource.store.connectionParameters.boolParam", (Object)false).evaluate((Object)this.vectorLayer));
        this.ws.getMetadata().put("checkMe", (Serializable)new Date(1000L));
        Assert.assertTrue((boolean)Predicates.equal((String)"metadata.checkMe", (Object)new Date(1000L)).evaluate((Object)this.ws));
        Assert.assertFalse((boolean)Predicates.equal((String)"resource.store.someNonExistentProperty", (Object)"someValue").evaluate((Object)this.vectorLayer));
    }

    @Test
    public void testPropertyEqualsConverters() {
        Object expected = this.featureType.getMaxFeatures();
        Assert.assertTrue((boolean)Predicates.equal((String)"resource.maxFeatures", (Object)expected).evaluate((Object)this.vectorLayer));
        expected = String.valueOf(this.featureType.getMaxFeatures());
        Assert.assertTrue((boolean)Predicates.equal((String)"resource.maxFeatures", (Object)expected).evaluate((Object)this.vectorLayer));
        expected = (double)this.featureType.getMaxFeatures();
        Assert.assertTrue((boolean)Predicates.equal((String)"resource.maxFeatures", (Object)expected).evaluate((Object)this.vectorLayer));
        expected = "true";
        Assert.assertTrue((boolean)Predicates.equal((String)"resource.store.connectionParameters.boolParam", (Object)expected).evaluate((Object)this.vectorLayer));
        expected = "false";
        Assert.assertFalse((boolean)Predicates.equal((String)"resource.store.connectionParameters.boolParam", (Object)false).evaluate((Object)this.vectorLayer));
        this.ws.getMetadata().put("checkMe", (Serializable)new Date(1000L));
        expected = new Timestamp(1000L);
        Assert.assertTrue((boolean)Predicates.equal((String)"resource.store.workspace.metadata.checkMe", (Object)expected).evaluate((Object)this.vectorLayer));
        Assert.assertFalse((boolean)Predicates.equal((String)"resource.store.someNonExistentProperty", (Object)"someValue").evaluate((Object)this.vectorLayer));
    }

    @Test
    public void testPropertyEqualsIndexed() {
        AuthorityURL aurl1 = new AuthorityURL();
        aurl1.setName("url1");
        AuthorityURL aurl2 = new AuthorityURL();
        aurl2.setName("url2");
        AuthorityURL aurl3 = new AuthorityURL();
        aurl3.setName("url3");
        this.vectorLayer.setAuthorityURLs(Arrays.asList(aurl1, aurl2, aurl3));
        Assert.assertTrue((boolean)Predicates.equal((String)"authorityURLs[1]", (Object)aurl1).evaluate((Object)this.vectorLayer));
        Assert.assertTrue((boolean)Predicates.equal((String)"authorityURLs[1].name", (Object)aurl1.getName()).evaluate((Object)this.vectorLayer));
        Assert.assertTrue((boolean)Predicates.equal((String)"authorityURLs[2]", (Object)aurl2).evaluate((Object)this.vectorLayer));
        Assert.assertTrue((boolean)Predicates.equal((String)"authorityURLs[2].name", (Object)aurl2.getName()).evaluate((Object)this.vectorLayer));
        Assert.assertTrue((boolean)Predicates.equal((String)"authorityURLs[3]", (Object)aurl3).evaluate((Object)this.vectorLayer));
        Assert.assertTrue((boolean)Predicates.equal((String)"authorityURLs[3].name", (Object)aurl3.getName()).evaluate((Object)this.vectorLayer));
    }

    @Test
    public void testPropertyEqualsAny() {
        Assert.assertTrue((boolean)Predicates.equal((String)"styles.id", (Object)this.style1.getId()).evaluate((Object)this.vectorLayer));
        Assert.assertTrue((boolean)Predicates.equal((String)"styles.name", (Object)this.style2.getName()).evaluate((Object)this.vectorLayer));
        Assert.assertFalse((boolean)Predicates.equal((String)"styles.id", (Object)"nonExistent").evaluate((Object)this.vectorLayer));
    }

    @Test
    public void testContains() {
        Assert.assertTrue((boolean)Predicates.contains((String)"URI", (String)"example").evaluate((Object)this.ns));
        Assert.assertFalse((boolean)Predicates.contains((String)"resource.ns.URI", (String)"example").evaluate((Object)this.vectorLayer));
        Assert.assertTrue((boolean)Predicates.contains((String)"resource.namespace.URI", (String)"example").evaluate((Object)this.vectorLayer));
        Assert.assertTrue((boolean)Predicates.contains((String)"id", (String)"vectorLayerId").evaluate((Object)this.vectorLayer));
        Assert.assertTrue((boolean)Predicates.contains((String)"id", (String)"vectorLayerID").evaluate((Object)this.vectorLayer));
        Assert.assertTrue((boolean)Predicates.contains((String)"id", (String)"torLAY").evaluate((Object)this.vectorLayer));
        Assert.assertTrue((boolean)Predicates.contains((String)"styles.name", (String)"style2").evaluate((Object)this.vectorLayer));
        Assert.assertTrue((boolean)Predicates.contains((String)"styles.name", (String)"Style2").evaluate((Object)this.vectorLayer));
        Assert.assertTrue((boolean)Predicates.contains((String)"styles.name", (String)"YL").evaluate((Object)this.vectorLayer));
        Assert.assertFalse((boolean)Predicates.contains((String)"styles.name", (String)"style3").evaluate((Object)this.vectorLayer));
        String name = this.featureType.getName();
        Assert.assertTrue((boolean)Predicates.contains((String)"resource.name", (String)name).evaluate((Object)this.vectorLayer));
        Assert.assertFalse((boolean)Predicates.contains((String)"resource.name", (String)"?").evaluate((Object)this.vectorLayer));
        this.featureType.setName("name?.*$[]&()");
        Assert.assertTrue((boolean)Predicates.contains((String)"resource.name", (String)"?").evaluate((Object)this.vectorLayer));
        Assert.assertTrue((boolean)Predicates.contains((String)"resource.name", (String)".").evaluate((Object)this.vectorLayer));
        Assert.assertTrue((boolean)Predicates.contains((String)"resource.name", (String)"*").evaluate((Object)this.vectorLayer));
        this.featureType.setName(null);
        Assert.assertFalse((boolean)Predicates.contains((String)"resource.name", (String)name).evaluate((Object)this.vectorLayer));
    }
}

