/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.Styles;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.ResourceLocator;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.UserLayer;
import org.geotools.util.Version;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Fill;
import org.opengis.style.Graphic;
import org.opengis.style.Stroke;
import org.xml.sax.EntityResolver;

public class PropertyStyleHandler
extends StyleHandler {
    public static final String FORMAT = "psl";
    public static final String MIMETYPE = "application/prs.gs.psl";
    StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
    FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory();

    public PropertyStyleHandler() {
        super("Property", FORMAT);
    }

    public String getFileExtension() {
        return "properties";
    }

    public String mimeType(Version version) {
        return MIMETYPE;
    }

    public StyledLayerDescriptor parse(Object input, Version version, ResourceLocator resourceLocator, EntityResolver enityResolver) throws IOException {
        Properties p = new Properties();
        try (Reader reader = this.toReader(input);){
            p.load(reader);
        }
        Color color = this.color(p.getProperty("color"), Color.BLACK);
        RasterSymbolizer sym = null;
        String type = p.getProperty("type");
        if ("line".equalsIgnoreCase(type)) {
            LineSymbolizer ls = this.styleFactory.createLineSymbolizer();
            ls.setStroke((Stroke)this.styleFactory.createStroke((Expression)this.filterFactory.literal((Object)color), (Expression)this.filterFactory.literal(2)));
            sym = ls;
        } else if ("polygon".equalsIgnoreCase(type)) {
            PolygonSymbolizer ps = this.styleFactory.createPolygonSymbolizer();
            ps.setFill((Fill)this.styleFactory.createFill((Expression)this.filterFactory.literal((Object)color)));
            sym = ps;
        } else if ("raster".equalsIgnoreCase(type)) {
            RasterSymbolizer rs;
            sym = rs = this.styleFactory.createRasterSymbolizer();
        } else {
            Mark mark = this.styleFactory.createMark();
            mark.setFill((Fill)this.styleFactory.createFill((Expression)this.filterFactory.literal((Object)color)));
            PointSymbolizer ps = this.styleFactory.createPointSymbolizer();
            ps.setGraphic((Graphic)this.styleFactory.createDefaultGraphic());
            ps.getGraphic().graphicalSymbols().add(mark);
            sym = ps;
        }
        Rule r = this.styleFactory.createRule();
        r.symbolizers().add(sym);
        FeatureTypeStyle fts = this.styleFactory.createFeatureTypeStyle();
        fts.rules().add(r);
        Style s = this.styleFactory.createStyle();
        s.featureTypeStyles().add(fts);
        UserLayer l = this.styleFactory.createUserLayer();
        l.userStyles().add(s);
        StyledLayerDescriptor sld = this.styleFactory.createStyledLayerDescriptor();
        sld.layers().add(l);
        return sld;
    }

    Color color(String color, Color def) {
        if (color == null) {
            return def;
        }
        return new Color(Integer.valueOf(color.substring(0, 2), 16), Integer.valueOf(color.substring(2, 4), 16), Integer.valueOf(color.substring(4, 6), 16));
    }

    public void encode(StyledLayerDescriptor sld, Version version, boolean pretty, OutputStream output) throws IOException {
        Properties props = new Properties();
        for (Symbolizer sym : SLD.symbolizers((Style)Styles.style((StyledLayerDescriptor)sld))) {
            if (sym instanceof PointSymbolizer) {
                props.put("type", "point");
                continue;
            }
            if (sym instanceof LineSymbolizer) {
                props.put("type", "line");
                continue;
            }
            if (sym instanceof PolygonSymbolizer) {
                props.put("type", "polygon");
                continue;
            }
            if (!(sym instanceof RasterSymbolizer)) continue;
            props.put("type", "raster");
        }
        props.store(output, null);
    }

    public List<Exception> validate(Object input, Version version, EntityResolver entityResolver) throws IOException {
        return Collections.emptyList();
    }

    public boolean supportsEncoding(Version version) {
        return true;
    }
}

