/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.media.jai.PlanarImage;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeCallback;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.ResourcePoolInitializer;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.util.ReaderUtils;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.data.test.TestData;
import org.geoserver.platform.GeoServerEnvironment;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.RunTestSetup;
import org.geoserver.test.SystemTest;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.feature.collection.DecoratingFeatureCollection;
import org.geotools.feature.collection.SortedSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.image.util.ImageUtilities;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.VirtualTable;
import org.geotools.jdbc.VirtualTableParameter;
import org.geotools.ows.ServiceException;
import org.geotools.styling.AbstractStyleVisitor;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Mark;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.URLs;
import org.geotools.util.Version;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.locationtech.jts.geom.Point;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.sort.SortBy;
import org.opengis.style.ExternalGraphic;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@Category(value={SystemTest.class})
public class ResourcePoolTest
extends GeoServerSystemTestSupport {
    private static final String SQLVIEW_DATASTORE = "sqlviews";
    private static final String VT_NAME = "pgeo_view";
    private static final String HUMANS = "humans";
    private static File rockFillSymbolFile;
    protected static QName TIMERANGES;
    private static final String EXTERNAL_ENTITIES = "externalEntities";
    boolean cleared = false;
    boolean disposeCalled;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addStyle("relative", "se_relativepath.sld", ResourcePoolTest.class, this.getCatalog());
        testData.addStyle("relative_protocol", "se_relativepath_protocol.sld", ResourcePoolTest.class, this.getCatalog());
        testData.addStyle(HUMANS, "humans.sld", ResourcePoolTest.class, this.getCatalog());
        testData.addStyle(EXTERNAL_ENTITIES, "externalEntities.sld", TestData.class, this.getCatalog());
        StyleInfo style = this.getCatalog().getStyleByName("relative");
        style.setFormatVersion(new Version("1.1.0"));
        this.getCatalog().save(style);
        style = this.getCatalog().getStyleByName(HUMANS);
        style.setFormatVersion(new Version("1.1.0"));
        this.getCatalog().save(style);
        File images = new File(testData.getDataDirectoryRoot(), "styles/images");
        Assert.assertTrue((boolean)images.mkdir());
        File image = new File("./src/test/resources/org/geoserver/catalog/rockFillSymbol.png");
        Assert.assertTrue((boolean)image.exists());
        FileUtils.copyFileToDirectory((File)image, (File)images);
        rockFillSymbolFile = new File(images, image.getName()).getCanonicalFile();
        testData.addRasterLayer(TIMERANGES, "timeranges.zip", null, null, SystemTestData.class, this.getCatalog());
        FileUtils.copyFileToDirectory((File)new File("./src/test/resources/geoserver-environment.properties"), (File)testData.getDataDirectoryRoot());
    }

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpWcs11RasterLayers();
    }

    @Test
    public void testFeatureTypeCacheInstance() throws Exception {
        ResourcePool pool = ResourcePool.create((Catalog)this.getCatalog());
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        FeatureType ft1 = pool.getFeatureType(info);
        FeatureType ft2 = pool.getFeatureType(info);
        FeatureType ft3 = pool.getFeatureType(info);
        Assert.assertSame((Object)ft1, (Object)ft2);
        Assert.assertSame((Object)ft1, (Object)ft3);
    }

    @Test
    public void testAttributeCache() throws Exception {
        Catalog catalog = this.getCatalog();
        ResourcePool pool = ResourcePool.create((Catalog)catalog);
        FeatureTypeInfo oldInfo = catalog.getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        List layers = catalog.getLayers((ResourceInfo)oldInfo);
        for (LayerInfo layerInfo : layers) {
            catalog.remove(layerInfo);
        }
        catalog.remove((ResourceInfo)oldInfo);
        CatalogBuilder builder = new CatalogBuilder(catalog);
        builder.setStore(catalog.getStoreByName(MockData.CITE_PREFIX, MockData.CITE_PREFIX, DataStoreInfo.class));
        FeatureTypeInfo info = builder.buildFeatureType((Name)new NameImpl(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart()));
        List att1 = pool.getAttributes(info);
        List att2 = pool.getAttributes(info);
        Assert.assertNotSame((Object)att1, (Object)att2);
        Assert.assertEquals((Object)att1, (Object)att2);
        catalog.add((ResourceInfo)info);
        List att3 = pool.getAttributes(info);
        List att4 = pool.getAttributes(info);
        Assert.assertSame((Object)att3, (Object)att4);
        Assert.assertNotSame((Object)att1, (Object)att3);
        Assert.assertEquals((Object)att1, (Object)att3);
    }

    @Test
    public void testCacheClearing() throws IOException {
        this.cleared = false;
        ResourcePool pool = new ResourcePool(this.getCatalog()){

            public void clear(FeatureTypeInfo info) {
                ResourcePoolTest.this.cleared = true;
                super.clear(info);
            }
        };
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        Assert.assertNotNull((Object)pool.getFeatureType(info));
        info.setTitle("changed");
        Assert.assertFalse((boolean)this.cleared);
        this.getCatalog().save((ResourceInfo)info);
        Assert.assertTrue((boolean)this.cleared);
        this.cleared = false;
        Assert.assertNotNull((Object)pool.getFeatureType(info));
        for (LayerInfo l : this.getCatalog().getLayers((ResourceInfo)info)) {
            this.getCatalog().remove(l);
        }
        this.getCatalog().remove((ResourceInfo)info);
        Assert.assertTrue((boolean)this.cleared);
    }

    @Test
    public void testDispose() throws IOException {
        this.disposeCalled = false;
        Catalog catalog = this.getCatalog();
        class ResourcePool2
        extends ResourcePool {
            public ResourcePool2(Catalog catalog) {
                super(catalog);
                this.dataStoreCache = new ResourcePool.DataStoreCache(){

                    protected void dispose(String name, DataAccess dataStore) {
                        ResourcePoolTest.this.disposeCalled = true;
                        super.dispose(name, dataStore);
                    }
                };
            }
        }
        ResourcePool2 pool = new ResourcePool2(catalog);
        catalog.setResourcePool((ResourcePool)pool);
        DataStoreInfo info = (DataStoreInfo)catalog.getDataStores().get(0);
        DataAccess dataStore = pool.getDataStore(info);
        Assert.assertNotNull((Object)dataStore);
        Assert.assertFalse((boolean)this.disposeCalled);
        pool.clear(info);
        Assert.assertTrue((boolean)this.disposeCalled);
        dataStore = pool.getDataStore(info);
        Assert.assertNotNull((Object)dataStore);
        this.disposeCalled = false;
        pool.dispose();
        Assert.assertTrue((boolean)this.disposeCalled);
    }

    @Test
    public void testConfigureFeatureTypeCacheSize() {
        GeoServer gs = this.getGeoServer();
        GeoServerInfo global = gs.getGlobal();
        global.setFeatureTypeCacheSize(200);
        gs.save(global);
        Catalog catalog = this.getCatalog();
        Assert.assertEquals((long)400L, (long)((SoftValueHashMap)catalog.getResourcePool().getFeatureTypeCache()).getHardReferencesCount());
    }

    @Test
    public void testDropCoverageStore() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        CoverageStoreInfo store = cb.buildCoverageStore("dem");
        store.setURL(MockData.class.getResource("tazdem.tiff").toExternalForm());
        store.setType("GeoTIFF");
        cat.add((StoreInfo)store);
        cb.setStore((StoreInfo)store);
        CoverageInfo ci = cb.buildCoverage();
        cat.add((ResourceInfo)ci);
        LayerInfo layer = cb.buildLayer(ci);
        cat.add(layer);
        ci.getGridCoverage(null, null);
        ci.getGridCoverageReader(null, GeoTools.getDefaultHints());
        CascadeDeleteVisitor visitor = new CascadeDeleteVisitor(cat);
        visitor.visit(store);
        this.getGeoServer().reload();
    }

    @Test
    public void testNativeCoverageName() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        CoverageStoreInfo store = cb.buildCoverageStore("geotiff");
        store.setURL(MockData.class.getResource("/org/geoserver/data/test/tazdem.tiff").toExternalForm());
        store.setType("GeoTIFF");
        cat.add((StoreInfo)store);
        cb.setStore((StoreInfo)store);
        CoverageInfo ci = cb.buildCoverage();
        ci.setNativeCoverageName("geotiff_coverage");
        cat.add((ResourceInfo)ci);
        GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, GeoTools.getDefaultHints());
        GeneralEnvelope envelop = reader.getOriginalEnvelope();
        Assert.assertNotNull((Object)ci);
        Assert.assertTrue((boolean)(reader.getFormat() instanceof GeoTiffFormat));
        Assert.assertNotNull((Object)envelop);
        Assert.assertEquals((Object)"tazdem", (Object)ci.getNativeCoverageName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RunTestSetup
    @Test
    public void testGeoServerReload() throws Exception {
        Catalog cat = this.getCatalog();
        FeatureTypeInfo lakes = cat.getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        Assert.assertFalse((boolean)"foo".equals(lakes.getTitle()));
        GeoServerDataDirectory dd = new GeoServerDataDirectory(this.getResourceLoader());
        File info = dd.config(lakes).file();
        FileReader in = new FileReader(info);
        Element dom = ReaderUtils.parse((Reader)in);
        Element title = ReaderUtils.getChildElement((Element)dom, (String)"title");
        title.getFirstChild().setNodeValue("foo");
        try (FileOutputStream output = new FileOutputStream(info);){
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(dom), new StreamResult(output));
        }
        this.getGeoServer().reload();
        lakes = cat.getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        Assert.assertEquals((Object)"foo", (Object)lakes.getTitle());
    }

    @Test
    public void testSEStyleWithRelativePath() throws IOException {
        StyleInfo si = this.getCatalog().getStyleByName("relative");
        Assert.assertNotNull((Object)si);
        Style style = si.getStyle();
        PolygonSymbolizer ps = (PolygonSymbolizer)((Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        ExternalGraphic eg = (ExternalGraphic)ps.getFill().getGraphicFill().graphicalSymbols().get(0);
        URI uri = eg.getOnlineResource().getLinkage();
        Assert.assertNotNull((Object)uri);
        File actual = URLs.urlToFile((URL)uri.toURL()).getCanonicalFile();
        Assert.assertEquals((Object)rockFillSymbolFile, (Object)actual);
    }

    @Test
    public void testSEStyleWithRelativePathProtocol() throws IOException {
        StyleInfo si = this.getCatalog().getStyleByName("relative_protocol");
        Assert.assertNotNull((Object)si);
        Style style = si.getStyle();
        PolygonSymbolizer ps = (PolygonSymbolizer)((Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        ExternalGraphic eg = (ExternalGraphic)ps.getFill().getGraphicFill().graphicalSymbols().get(0);
        URI uri = eg.getOnlineResource().getLinkage();
        Assert.assertNotNull((Object)uri);
        File actual = URLs.urlToFile((URL)uri.toURL()).getCanonicalFile();
        Assert.assertEquals((Object)rockFillSymbolFile, (Object)actual);
    }

    @Test
    public void testPreserveStructuredReader() throws IOException {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(TIMERANGES));
        Assert.assertTrue((boolean)(ci.getGridCoverageReader(null, null) instanceof StructuredGridCoverage2DReader));
        String name = ci.getGridCoverageReader(null, null).getGridCoverageNames()[0];
        ci.setNativeCoverageName(name);
        this.getCatalog().save((ResourceInfo)ci);
        ci = this.getCatalog().getCoverageByName(this.getLayerId(TIMERANGES));
        Assert.assertTrue((boolean)(ci.getGridCoverageReader(null, null) instanceof StructuredGridCoverage2DReader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingNullValuesInCoverageDimensions() throws IOException {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
        List dimensions = ci.getDimensions();
        ((CoverageDimensionInfo)dimensions.get(0)).getNullValues().clear();
        this.getCatalog().save((ResourceInfo)ci);
        ci = this.getCatalog().getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
        GridCoverageReader reader = ci.getGridCoverageReader(null, null);
        GridCoverage2D gc = null;
        try {
            gc = (GridCoverage2D)reader.read(null);
            Assert.assertEquals((double)-9999.0, (double)CoverageUtilities.getNoDataProperty((GridCoverage2D)gc).getAsSingleValue(), (double)0.0);
        }
        finally {
            if (gc != null) {
                RenderedImage ri = gc.getRenderedImage();
                if (gc instanceof GridCoverage2D) {
                    gc.dispose(true);
                }
                if (ri instanceof PlanarImage) {
                    ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)ri));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RunTestSetup
    @Test
    public void testEnvParametrizationValues() throws Exception {
        GeoServerEnvironment gsEnvironment = (GeoServerEnvironment)GeoServerExtensions.bean(GeoServerEnvironment.class);
        DataStoreInfo ds = this.getCatalog().getFactory().createDataStore();
        ds.getConnectionParameters().put("host", "${jdbc.host}");
        ds.getConnectionParameters().put("port", "${jdbc.port}");
        try {
            String dsName = "GS-ENV-TEST-DS";
            ds.setName("GS-ENV-TEST-DS");
            this.getCatalog().save((StoreInfo)ds);
            ds = this.getCatalog().getDataStoreByName("GS-ENV-TEST-DS");
            DataStoreInfo expandedDs = this.getCatalog().getResourcePool().clone(ds, true);
            Assert.assertTrue((boolean)((Serializable)ds.getConnectionParameters().get("host")).equals("${jdbc.host}"));
            Assert.assertTrue((boolean)((Serializable)ds.getConnectionParameters().get("port")).equals("${jdbc.port}"));
            if (GeoServerEnvironment.allowEnvParametrization()) {
                Assert.assertEquals(expandedDs.getConnectionParameters().get("host"), (Object)gsEnvironment.resolveValue((Object)"${jdbc.host}"));
                Assert.assertEquals(expandedDs.getConnectionParameters().get("port"), (Object)gsEnvironment.resolveValue((Object)"${jdbc.port}"));
            } else {
                Assert.assertTrue((boolean)((Serializable)expandedDs.getConnectionParameters().get("host")).equals("${jdbc.host}"));
                Assert.assertTrue((boolean)((Serializable)expandedDs.getConnectionParameters().get("port")).equals("${jdbc.port}"));
            }
        }
        finally {
            this.getCatalog().remove((StoreInfo)ds);
        }
    }

    @Test
    public void testCloneStoreInfo() throws Exception {
        Catalog catalog = this.getCatalog();
        DataStoreInfo source1 = (DataStoreInfo)catalog.getDataStores().get(0);
        DataStoreInfo clonedDs = catalog.getResourcePool().clone(source1, false);
        Assert.assertNotNull((Object)source1);
        Assert.assertNotNull((Object)clonedDs);
        Assert.assertEquals((Object)source1, (Object)clonedDs);
        CoverageStoreInfo source2 = (CoverageStoreInfo)catalog.getCoverageStores().get(0);
        CoverageStoreInfo clonedCs = catalog.getResourcePool().clone(source2, false);
        Assert.assertNotNull((Object)source2);
        Assert.assertNotNull((Object)clonedCs);
        Assert.assertEquals((Object)source2, (Object)clonedCs);
    }

    @Test
    public void testAddFilePathWithSpaces() throws Exception {
        ((ResourcePoolInitializer)GeoServerExtensions.extensions(ResourcePoolInitializer.class).get(0)).initialize(this.getGeoServer());
        ResourcePool rp = this.getCatalog().getResourcePool();
        CoverageStoreInfo info = this.getCatalog().getFactory().createCoverageStore();
        info.setName("spaces");
        info.setType("ImagePyramid");
        info.setEnabled(true);
        info.setURL("file://./src/test/resources/data_dir/nested_layer_groups/data/pyramid with space");
        try {
            rp.getGridCoverageReader(info, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Unable to add an imagepyramid with a space in it's name");
        }
        rp.dispose();
    }

    @Test
    public void testWmsCascadeEntityExpansion() throws Exception {
        Exception cause;
        SAXException saxException;
        ServiceException serviceException;
        ((ResourcePoolInitializer)GeoServerExtensions.extensions(ResourcePoolInitializer.class).get(0)).initialize(this.getGeoServer());
        ResourcePool rp = this.getCatalog().getResourcePool();
        WMSStoreInfo info = this.getCatalog().getFactory().createWebMapServer();
        URL url = this.getClass().getResource("1.3.0Capabilities-xxe.xml");
        info.setCapabilitiesURL(url.toExternalForm());
        info.setEnabled(true);
        info.setUseConnectionPooling(false);
        try {
            rp.getWebMapServer(info);
            Assert.fail((String)"WebMapServer instantiation should fail");
        }
        catch (IOException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(ServiceException.class));
            serviceException = (ServiceException)e.getCause();
            Assert.assertThat((Object)serviceException.getMessage(), (Matcher)CoreMatchers.containsString((String)"Error while parsing XML"));
            saxException = (SAXException)serviceException.getCause();
            cause = saxException.getException();
            Assert.assertFalse((String)"Expect external entity cause", (cause != null && cause instanceof FileNotFoundException ? 1 : 0) != 0);
        }
        this.getGeoServer().reload();
        rp = this.getCatalog().getResourcePool();
        try {
            rp.getWebMapServer(info);
            Assert.fail((String)"WebMapServer instantiation should fail");
        }
        catch (IOException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(ServiceException.class));
            serviceException = (ServiceException)e.getCause();
            Assert.assertThat((Object)serviceException.getMessage(), (Matcher)CoreMatchers.containsString((String)"Error while parsing XML"));
            saxException = (SAXException)serviceException.getCause();
            cause = saxException.getException();
            Assert.assertFalse((String)"Expect external entity cause", (cause != null && cause instanceof FileNotFoundException ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWfsCascadeEntityExpansion() throws Exception {
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        DataStoreInfo ds = cb.buildDataStore("wfs-xxe");
        URL url = this.getClass().getResource("wfs1.1.0Capabilities-xxe.xml");
        ds.getConnectionParameters().put(WFSDataStoreFactory.URL.key, url);
        ds.getConnectionParameters().put("TESTING", Boolean.TRUE);
        ResourcePool rp = this.getCatalog().getResourcePool();
        try {
            rp.getDataStore(ds);
            Assert.fail((String)"Store creation should have failed to to XXE attack");
        }
        catch (Exception e) {
            String message = e.getMessage();
            Assert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"Entity resolution disallowed"));
            Assert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"file:///file/not/there"));
        }
    }

    @Test
    public void testStyleWithExternalEntities() throws Exception {
        StyleInfo si = this.getCatalog().getStyleByName(EXTERNAL_ENTITIES);
        try {
            si.getStyle();
            Assert.fail((String)"Should have failed with a parse error");
        }
        catch (Exception e) {
            String message = e.getMessage();
            Assert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"Entity resolution disallowed"));
            Assert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"/this/file/does/not/exist"));
        }
    }

    @Test
    public void testParseExternalMark() throws Exception {
        StyleInfo si = this.getCatalog().getStyleByName(HUMANS);
        Style s = si.getStyle();
        s.accept((StyleVisitor)new AbstractStyleVisitor(){

            public void visit(Mark mark) {
                Assert.assertEquals((Object)"ttf://Webdings", (Object)mark.getExternalMark().getOnlineResource().getLinkage().toASCIIString());
            }
        });
    }

    @Test
    public void testDataStoreScan() throws Exception {
        Catalog catalog = this.getCatalog();
        Catalog cat = this.getCatalog();
        DataStoreInfo ds = cat.getFactory().createDataStore();
        ds.setName(SQLVIEW_DATASTORE);
        WorkspaceInfo ws = cat.getDefaultWorkspace();
        ds.setWorkspace(ws);
        ds.setEnabled(true);
        Map params = ds.getConnectionParameters();
        params.put("dbtype", "h2");
        File dbFile = new File(((SystemTestData)this.getTestData()).getDataDirectoryRoot().getAbsolutePath(), "data/h2test");
        params.put("database", dbFile.getAbsolutePath());
        cat.add((StoreInfo)ds);
        SimpleFeatureSource fsp = this.getFeatureSource(SystemTestData.PRIMITIVEGEOFEATURE);
        DataStore store = (DataStore)ds.getDataStore(null);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.init((SimpleFeatureType)fsp.getSchema());
        tb.remove("surfaceProperty");
        tb.remove("curveProperty");
        tb.remove("uriProperty");
        tb.setName("pgeo");
        SimpleFeatureType schema = tb.buildFeatureType();
        store.createSchema((FeatureType)schema);
        SimpleFeatureStore featureStore = (SimpleFeatureStore)store.getFeatureSource("pgeo");
        featureStore.addFeatures((FeatureCollection)fsp.getFeatures());
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)ds);
        FeatureTypeInfo tft = cb.buildFeatureType((FeatureSource)featureStore);
        cat.add((ResourceInfo)tft);
        JDBCDataStore jds = (JDBCDataStore)ds.getDataStore(null);
        VirtualTable vt = new VirtualTable(VT_NAME, "select \"name\", \"pointProperty\" from \"pgeo\" where \"booleanProperty\" = %bool% and \"name\" = '%name%'");
        vt.addParameter(new VirtualTableParameter("bool", "true"));
        vt.addParameter(new VirtualTableParameter("name", "name-f001"));
        vt.addGeometryMetadatata("pointProperty", Point.class, 4326);
        jds.createVirtualTable(vt);
        FeatureTypeInfo vft = cb.buildFeatureType((FeatureSource)jds.getFeatureSource(vt.getName()));
        vft.getMetadata().put("JDBC_VIRTUAL_TABLE", (Serializable)vt);
        cat.add((ResourceInfo)vft);
        final AtomicInteger counter = new AtomicInteger();
        ResourcePool testPool = new ResourcePool(){

            protected Name getTemporaryName(FeatureTypeInfo info, DataAccess<? extends FeatureType, ? extends Feature> dataAccess, FeatureTypeCallback initializer) throws IOException {
                if (ResourcePoolTest.VT_NAME.equals(info.getNativeName())) {
                    counter.incrementAndGet();
                }
                return super.getTemporaryName(info, dataAccess, initializer);
            }
        };
        testPool.setCatalog(catalog);
        FeatureTypeInfo ft = catalog.getFeatureTypeByName(VT_NAME);
        testPool.getFeatureSource(ft, null);
        Assert.assertEquals((long)0L, (long)counter.get());
        ft.setName("foobar");
        testPool.getFeatureSource(ft, null);
        Assert.assertThat((Object)counter.get(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void testRepositoryHints() throws Exception {
        Catalog catalog = this.getCatalog();
        ResourcePool pool = new ResourcePool(catalog){

            public CoverageStoreInfo clone(CoverageStoreInfo source, boolean allowEnvParametrization) {
                return source;
            }
        };
        String url = "http://www.geoserver.org/mock/format";
        AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)EasyMock.createNiceMock((String)"theReader", AbstractGridCoverage2DReader.class);
        EasyMock.replay((Object[])new Object[]{reader});
        AbstractGridFormat format = (AbstractGridFormat)EasyMock.createNiceMock((String)"theFormat", AbstractGridFormat.class);
        Capture capturedHints = Capture.newInstance((CaptureType)CaptureType.LAST);
        EasyMock.expect((Object)format.getReader(EasyMock.eq((Object)"http://www.geoserver.org/mock/format"), (Hints)EasyMock.capture((Capture)capturedHints))).andReturn((Object)reader).anyTimes();
        EasyMock.replay((Object[])new Object[]{format});
        CoverageStoreInfo storeInfo = (CoverageStoreInfo)EasyMock.createNiceMock((String)"storeInfo", CoverageStoreInfo.class);
        EasyMock.expect((Object)storeInfo.getURL()).andReturn((Object)"http://www.geoserver.org/mock/format").anyTimes();
        EasyMock.expect((Object)storeInfo.getFormat()).andReturn((Object)format).anyTimes();
        EasyMock.replay((Object[])new Object[]{storeInfo});
        GridCoverageReader returnedReader = pool.getGridCoverageReader(storeInfo, null);
        Assert.assertThat((Object)reader, (Matcher)Matchers.equalTo((Object)returnedReader));
        Hints hints1 = (Hints)capturedHints.getValue();
        Assert.assertThat((Object)hints1, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)hints1, (Matcher)Matchers.hasEntry((Object)Hints.REPOSITORY, (Object)pool.repository));
        capturedHints.reset();
        GridCoverageReader returnedReader2 = pool.getGridCoverageReader(storeInfo, new Hints(Hints.KEY_ANTIALIASING, Hints.VALUE_ANTIALIAS_ON));
        Assert.assertThat((Object)reader, (Matcher)Matchers.equalTo((Object)returnedReader2));
        Hints hints2 = (Hints)capturedHints.getValue();
        Assert.assertThat((Object)hints2, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)hints2, (Matcher)Matchers.hasEntry((Object)Hints.REPOSITORY, (Object)pool.repository));
        Assert.assertThat((Object)hints2, (Matcher)Matchers.hasEntry((Object)Hints.KEY_ANTIALIASING, (Object)Hints.VALUE_ANTIALIAS_ON));
    }

    @Test
    public void testGetParamsFixesDatabaseFilePath() {
        Catalog catalog = this.getCatalog();
        ResourcePool pool = new ResourcePool(catalog);
        DataStoreInfo ds = this.getCatalog().getFactory().createDataStore();
        ds.getConnectionParameters().put("database", "file:data/test.gpkg");
        Map newParams = ResourcePool.getParams((Map)ds.getConnectionParameters(), (GeoServerResourceLoader)this.getResourceLoader());
        GeoServerDataDirectory dataDir = new GeoServerDataDirectory(this.getResourceLoader());
        String absolutePath = dataDir.get("data/test.gpkg").dir().getAbsolutePath();
        Assert.assertNotEquals(newParams.get("database"), (Object)"file:data/test.gpkg");
        Assert.assertTrue((boolean)((String)newParams.get("database")).contains(absolutePath));
    }

    @Test
    public void testEmptySort() throws IOException, IllegalAccessException {
        SimpleFeatureSource fsp = this.getFeatureSource(SystemTestData.PRIMITIVEGEOFEATURE);
        Query q = new Query();
        q.setSortBy(SortBy.UNSORTED);
        SimpleFeatureCollection fc = fsp.getFeatures(q);
        while (fc instanceof DecoratingFeatureCollection) {
            Assert.assertThat((Object)fc, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(SortedSimpleFeatureCollection.class)));
            Field field = FieldUtils.getDeclaredField(SortedSimpleFeatureCollection.class, (String)"delegate");
            field.setAccessible(true);
            Object delegate = field.get(fc);
            fc = (SimpleFeatureCollection)delegate;
        }
    }

    @Test
    public void testDefaultGeometry() throws IOException {
        FeatureTypeInfo featureType = (FeatureTypeInfo)this.getCatalog().getResourceByName("cdf", "Nulls", FeatureTypeInfo.class);
        GeometryDescriptor schemaDefaultGeometry = featureType.getFeatureType().getGeometryDescriptor();
        FeatureIterator i = featureType.getFeatureSource(null, null).getFeatures().features();
        GeometryDescriptor featureDefaultGeometry = i.next().getDefaultGeometryProperty().getDescriptor();
        Assert.assertNotNull((Object)schemaDefaultGeometry);
        Assert.assertNotNull((Object)featureDefaultGeometry);
        Assert.assertEquals((Object)"pointProperty", (Object)schemaDefaultGeometry.getLocalName());
        Assert.assertEquals((Object)schemaDefaultGeometry, (Object)featureDefaultGeometry);
    }

    @Test
    public void testCoverageReaderInputConverter() throws IOException {
        Catalog catalog = this.getCatalog();
        ResourcePool pool = new ResourcePool(catalog);
        CoverageStoreInfo info = catalog.getFactory().createCoverageStore();
        info.setType("ImagePyramid");
        info.setURL("file://./src/test/resources/data_dir/nested_layer_groups/data/pyramid%20with%20space");
        GridCoverageReader reader = pool.getGridCoverageReader(info, null);
        Assert.assertTrue((boolean)(reader.getSource() instanceof File));
    }

    static {
        System.setProperty("ALLOW_ENV_PARAMETRIZATION", "true");
        TIMERANGES = new QName(MockData.SF_URI, "timeranges", MockData.SF_PREFIX);
    }
}

