/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.IOException;
import java.util.List;
import org.geoserver.catalog.CatalogIntegrationTest;
import org.geoserver.catalog.SLDNamedLayerRenameHelper;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.resource.Resource;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.styling.StyledLayerDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class SLDNamedLayerRenameHelperTest
extends GeoServerSystemTestSupport {
    @Override
    protected void onSetUp(SystemTestData testData) throws IOException {
        testData.addStyle("singleStyleGroup", "singleStyleGroup.sld", CatalogIntegrationTest.class, this.getCatalog());
    }

    @Test
    public void testGetStyles() throws IOException {
        SLDNamedLayerRenameHelper helper = new SLDNamedLayerRenameHelper(this.getCatalog(), true);
        helper.registerLayerRename("Streams", "Stream");
        List stylesToRename = helper.visitStyles(false);
        Assert.assertEquals((long)1L, (long)stylesToRename.size());
        Assert.assertTrue((boolean)stylesToRename.contains(this.getCatalog().getStyleByName("singleStyleGroup")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameStyles() throws IOException {
        SLDNamedLayerRenameHelper helper = new SLDNamedLayerRenameHelper(this.getCatalog(), true);
        helper.registerLayerRename("Streams", "Stream");
        List stylesToRename = helper.visitStyles(true);
        try {
            Assert.assertEquals((long)1L, (long)stylesToRename.size());
            StyleInfo s = this.getCatalog().getStyleByName("singleStyleGroup");
            Resource newStyle = this.getCatalog().getResourceLoader().get("styles/singleStyleGroup.sld");
            Resource oldStyle = this.getCatalog().getResourceLoader().get("styles/singleStyleGroup_BACKUP.sld");
            Assert.assertEquals((Object)Resource.Type.RESOURCE, (Object)newStyle.getType());
            Assert.assertEquals((Object)Resource.Type.RESOURCE, (Object)oldStyle.getType());
            Assert.assertEquals((Object)"singleStyleGroup.sld", (Object)s.getFilename());
            StyledLayerDescriptor newSld = Styles.handler((String)s.getFormat()).parse((Object)newStyle.file(), s.getFormatVersion(), null, this.getCatalog().getResourcePool().getEntityResolver());
            StyledLayerDescriptor oldSld = Styles.handler((String)s.getFormat()).parse((Object)oldStyle.file(), s.getFormatVersion(), null, this.getCatalog().getResourcePool().getEntityResolver());
            Assert.assertNotNull((Object)newSld);
            Assert.assertNotNull((Object)oldSld);
            Assert.assertEquals((Object)"Streams", (Object)oldSld.getStyledLayers()[0].getName());
            Assert.assertEquals((Object)"Stream", (Object)newSld.getStyledLayers()[0].getName());
        }
        finally {
            helper = new SLDNamedLayerRenameHelper(this.getCatalog(), true);
            helper.registerLayerRename("Stream", "Streams");
            helper.visitStyles(true);
        }
    }
}

