/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.util.Properties;
import org.geoserver.catalog.PropertyStyleHandler;
import org.geoserver.catalog.SLDHandler;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.LockProvider;
import org.geoserver.platform.resource.MemoryLockProvider;
import org.geoserver.platform.resource.Resource;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.DefaultResourceLocator;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.ResourceLocator;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.xml.styling.SLDParser;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class StylesTest
extends GeoServerSystemTestSupport {
    @Test
    public void testLookup() throws Exception {
        Assert.assertTrue((boolean)(Styles.handler((String)"sld") instanceof SLDHandler));
        Assert.assertTrue((boolean)(Styles.handler((String)"psl") instanceof PropertyStyleHandler));
        try {
            Styles.handler(null);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Styles.handler((String)"foo");
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testParse() throws Exception {
        Properties props = new Properties();
        props.setProperty("type", "point");
        props.setProperty("color", "ff0000");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        props.store(bout, null);
        StyledLayerDescriptor sld = Styles.handler((String)"psl").parse((Object)new ByteArrayInputStream(bout.toByteArray()), null, null, null);
        Assert.assertNotNull((Object)sld);
        Style style = Styles.style((StyledLayerDescriptor)sld);
        PointSymbolizer point = SLD.pointSymbolizer((Style)style);
        Assert.assertNotNull((Object)point);
    }

    @Test
    public void testEmptyStyle() throws Exception {
        SLDParser parser = new SLDParser(CommonFactoryFinder.getStyleFactory());
        parser.setInput(StylesTest.class.getResourceAsStream("empty.sld"));
        StyledLayerDescriptor sld = parser.parseSLD();
        Assert.assertNull((Object)Styles.style((StyledLayerDescriptor)sld));
    }

    @Test
    public void testParseStyleTwiceLock() throws Exception {
        StyleInfo style = (StyleInfo)this.getCatalog().getStyles().get(0);
        FileSystemResourceStore store = (FileSystemResourceStore)this.getDataDirectory().getResourceStore();
        store.setLockProvider((LockProvider)new MemoryLockProvider());
        Resource resource = this.getDataDirectory().style(style);
        Styles.handler((String)style.getFormat()).parse((Object)resource, style.getFormatVersion(), (ResourceLocator)new DefaultResourceLocator(), null);
        Styles.handler((String)style.getFormat()).parse((Object)resource, style.getFormatVersion(), (ResourceLocator)new DefaultResourceLocator(), null);
    }

    @Test
    public void testEntityExpansionOnValidation() throws Exception {
        URL url = this.getClass().getResource("../data/test/externalEntities.sld");
        try {
            Styles.handler((String)"SLD").validate((Object)url, null, this.getCatalog().getResourcePool().getEntityResolver());
            Assert.fail((String)"Should have failed due to the entity resolution attempt");
        }
        catch (Exception e) {
            String message = e.getMessage();
            Assert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"Entity resolution disallowed"));
            Assert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"/this/file/does/not/exist"));
        }
    }
}

