/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.SystemTest;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;

@Category(value={SystemTest.class})
public class CatalogBuilderIntTest
extends GeoServerSystemTestSupport {
    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpDefaultRasterLayers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLargeNDMosaic() throws Exception {
        File mosaic = new File("./target/largeMosaic");
        try {
            this.createTimeMosaic(mosaic, 1025);
            Catalog cat = this.getCatalog();
            CatalogBuilder cb = new CatalogBuilder(cat);
            CoverageStoreInfo store = cb.buildCoverageStore("largeMosaic");
            store.setURL(mosaic.getAbsolutePath());
            store.setType("ImageMosaic");
            cat.add((StoreInfo)store);
            cb.setStore((StoreInfo)store);
            CoverageInfo ci = cb.buildCoverage();
            cat.add((ResourceInfo)ci);
            cat.getResourcePool().dispose();
        }
        finally {
            if (mosaic.exists() && mosaic.isDirectory()) {
                FileUtils.deleteDirectory((File)mosaic);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMosaicParameters() throws Exception {
        File mosaic = new File("./target/smallMosaic");
        try {
            this.createTimeMosaic(mosaic, 4);
            Catalog cat = this.getCatalog();
            CatalogBuilder cb = new CatalogBuilder(cat);
            CoverageStoreInfo store = cb.buildCoverageStore("smallMosaic");
            store.setURL(mosaic.getAbsolutePath());
            store.setType("ImageMosaic");
            cat.add((StoreInfo)store);
            cb.setStore((StoreInfo)store);
            CoverageInfo ci = cb.buildCoverage();
            cat.add((ResourceInfo)ci);
            Assert.assertEquals((Object)String.valueOf(-1), ci.getParameters().get(ImageMosaicFormat.MAX_ALLOWED_TILES.getName().toString()));
            Assert.assertEquals((Object)"", ci.getParameters().get(ImageMosaicFormat.FILTER.getName().toString()));
            cat.getResourcePool().dispose();
        }
        finally {
            if (mosaic.exists() && mosaic.isDirectory()) {
                FileUtils.deleteDirectory((File)mosaic);
            }
        }
    }

    private void createTimeMosaic(File mosaic, int fileCount) throws Exception {
        if (mosaic.exists()) {
            if (mosaic.isDirectory()) {
                FileUtils.deleteDirectory((File)mosaic);
            } else {
                mosaic.delete();
            }
        }
        mosaic.mkdir();
        GridCoverageFactory factory = new GridCoverageFactory();
        BufferedImage bi = new BufferedImage(10, 10, 6);
        ReferencedEnvelope envelope = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, CRS.decode((String)"EPSG:4326"));
        GridCoverage2D test = factory.create((CharSequence)"test", (RenderedImage)bi, (Envelope)envelope);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GeoTiffWriter writer = new GeoTiffWriter((Object)bos);
        writer.write((GridCoverage)test, null);
        writer.dispose();
        byte[] bytes = bos.toByteArray();
        for (int i = 0; i < fileCount; ++i) {
            String pad = "";
            if (i < 10) {
                pad = "000";
            } else if (i < 100) {
                pad = "00";
            } else if (i < 1000) {
                pad = "0";
            }
            File target = new File(mosaic, "tile_" + pad + i + ".tiff");
            FileUtils.writeByteArrayToFile((File)target, (byte[])bytes);
        }
        Properties p = new Properties();
        p.put("ElevationAttribute", "elevation");
        p.put("Schema", "*the_geom:Polygon,location:String,elevation:Integer");
        p.put("PropertyCollectors", "IntegerFileNameExtractorSPI[elevationregex](elevation)");
        FileOutputStream fos = new FileOutputStream(new File(mosaic, "indexer.properties"));
        p.store(fos, null);
        fos.close();
        p.clear();
        p.put("regex", "(?<=_)(\\d{4})");
        fos = new FileOutputStream(new File(mosaic, "elevationregex.properties"));
        p.store(fos, null);
        fos.close();
    }
}

