/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataLinkInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.CatalogPropertyAccessor;
import org.geoserver.catalog.impl.CoverageInfoImpl;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.RunnerBase;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.security.AccessMode;
import org.geoserver.security.SecuredResourceNameChangeListener;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.logging.Logging;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.sort.SortBy;

public class CatalogImplTest
extends GeoServerSystemTestSupport {
    protected Catalog catalog;
    protected WorkspaceInfo ws;
    protected WorkspaceInfo wsA;
    protected WorkspaceInfo wsB;
    protected NamespaceInfo ns;
    protected NamespaceInfo nsA;
    protected NamespaceInfo nsB;
    protected DataStoreInfo ds;
    protected DataStoreInfo dsA;
    protected DataStoreInfo dsB;
    protected CoverageStoreInfo cs;
    protected WMSStoreInfo wms;
    protected WMTSStoreInfo wmtss;
    protected FeatureTypeInfo ft;
    protected CoverageInfo cv;
    protected WMSLayerInfo wl;
    protected WMTSLayerInfo wmtsl;
    protected LayerInfo l;
    protected StyleInfo s;
    protected StyleInfo defaultLineStyle;
    protected LayerGroupInfo lg;
    protected int GET_LAYER_BY_ID_WITH_CONCURRENT_ADD_TEST_COUNT = 500;
    private static final int GET_LAYER_BY_ID_WITH_CONCURRENT_ADD_THREAD_COUNT = 10;

    @Before
    public void setUp() throws Exception {
        this.catalog = this.createCatalog();
        this.catalog.setResourceLoader(new GeoServerResourceLoader());
        CatalogFactory factory = this.catalog.getFactory();
        this.ns = factory.createNamespace();
        this.ns.setPrefix("wsName");
        this.ns.setURI("nsURI");
        this.nsA = factory.createNamespace();
        this.nsA.setPrefix("aaa");
        this.nsA.setURI("nsURIaaa");
        this.nsB = factory.createNamespace();
        this.nsB.setPrefix("bbb");
        this.nsB.setURI("nsURIbbb");
        this.ws = factory.createWorkspace();
        this.ws.setName("wsName");
        this.wsA = factory.createWorkspace();
        this.wsA.setName("aaa");
        this.wsB = factory.createWorkspace();
        this.wsB.setName("bbb");
        this.ds = factory.createDataStore();
        this.ds.setEnabled(true);
        this.ds.setName("dsName");
        this.ds.setDescription("dsDescription");
        this.ds.setWorkspace(this.ws);
        this.dsA = factory.createDataStore();
        this.dsA.setEnabled(true);
        this.dsA.setName("dsNameA");
        this.dsA.setDescription("dsDescription");
        this.dsA.setWorkspace(this.wsA);
        this.dsB = factory.createDataStore();
        this.dsB.setEnabled(true);
        this.dsB.setName("dsNameB");
        this.dsB.setDescription("dsDescription");
        this.dsB.setWorkspace(this.wsB);
        this.ft = factory.createFeatureType();
        this.ft.setEnabled(true);
        this.ft.setName("ftName");
        this.ft.setAbstract("ftAbstract");
        this.ft.setDescription("ftDescription");
        this.ft.setStore((StoreInfo)this.ds);
        this.ft.setNamespace(this.ns);
        this.cs = factory.createCoverageStore();
        this.cs.setName("csName");
        this.cs.setType("fakeCoverageType");
        this.cs.setURL("file://fake");
        this.cv = factory.createCoverage();
        this.cv.setName("cvName");
        this.cv.setStore((StoreInfo)this.cs);
        this.wms = factory.createWebMapServer();
        this.wms.setName("wmsName");
        this.wms.setType("WMS");
        this.wms.setCapabilitiesURL("http://fake.url");
        this.wms.setWorkspace(this.ws);
        this.wl = factory.createWMSLayer();
        this.wl.setEnabled(true);
        this.wl.setName("wmsLayer");
        this.wl.setStore((StoreInfo)this.wms);
        this.wl.setNamespace(this.ns);
        this.wmtss = factory.createWebMapTileServer();
        this.wmtss.setName("wmtsName");
        this.wmtss.setType("WMTS");
        this.wmtss.setCapabilitiesURL("http://fake.wmts.url");
        this.wmtss.setWorkspace(this.ws);
        this.wmtsl = factory.createWMTSLayer();
        this.wmtsl.setEnabled(true);
        this.wmtsl.setName("wmtsLayer");
        this.wmtsl.setStore((StoreInfo)this.wmtss);
        this.wmtsl.setNamespace(this.ns);
        this.s = factory.createStyle();
        this.s.setName("styleName");
        this.s.setFilename("styleFilename");
        this.defaultLineStyle = factory.createStyle();
        this.defaultLineStyle.setName("line");
        this.defaultLineStyle.setFilename("line.sld");
        this.l = factory.createLayer();
        this.l.setResource((ResourceInfo)this.ft);
        this.l.setEnabled(true);
        this.l.setDefaultStyle(this.s);
        this.lg = factory.createLayerGroup();
        this.lg.setName("layerGroup");
        this.lg.getLayers().add(this.l);
        this.lg.getStyles().add(this.s);
    }

    protected Catalog createCatalog() {
        return new CatalogImpl();
    }

    protected void addWorkspace() {
        this.catalog.add(this.ws);
    }

    protected void addNamespace() {
        this.catalog.add(this.ns);
    }

    protected void addDataStore() {
        this.addWorkspace();
        this.catalog.add((StoreInfo)this.ds);
    }

    protected void addCoverageStore() {
        this.addWorkspace();
        this.catalog.add((StoreInfo)this.cs);
    }

    protected void addWMSStore() {
        this.addWorkspace();
        this.catalog.add((StoreInfo)this.wms);
    }

    protected void addWMTSStore() {
        this.addWorkspace();
        this.catalog.add((StoreInfo)this.wmtss);
    }

    protected void addFeatureType() {
        this.addDataStore();
        this.addNamespace();
        this.catalog.add((ResourceInfo)this.ft);
    }

    protected void addCoverage() {
        this.addCoverageStore();
        this.addNamespace();
        this.catalog.add((ResourceInfo)this.cv);
    }

    protected void addWMSLayer() {
        this.addWMSStore();
        this.addNamespace();
        this.catalog.add((ResourceInfo)this.wl);
    }

    protected void addWMTSLayer() {
        this.addWMTSStore();
        this.addNamespace();
        this.catalog.add((ResourceInfo)this.wmtsl);
    }

    protected void addStyle() {
        this.catalog.add(this.s);
    }

    protected void addDefaultStyle() {
        this.catalog.add(this.defaultLineStyle);
    }

    protected void addLayer() {
        this.addFeatureType();
        this.addStyle();
        this.catalog.add(this.l);
    }

    protected void addLayerGroup() {
        this.addLayer();
        this.catalog.add(this.lg);
    }

    @Test
    public void testAddNamespace() {
        Assert.assertTrue((boolean)this.catalog.getNamespaces().isEmpty());
        this.catalog.add(this.ns);
        Assert.assertEquals((long)1L, (long)this.catalog.getNamespaces().size());
        NamespaceInfo ns2 = this.catalog.getFactory().createNamespace();
        try {
            this.catalog.add(ns2);
            Assert.fail((String)"adding without a prefix should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ns2.setPrefix("ns2Prefix");
        try {
            this.catalog.add(ns2);
            Assert.fail((String)"adding without a uri should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ns2.setURI("bad uri");
        try {
            this.catalog.add(ns2);
            Assert.fail((String)"adding an invalid uri should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ns2.setURI("ns2URI");
        try {
            this.catalog.getNamespaces().add(ns2);
            Assert.fail((String)"adding directly should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.catalog.add(ns2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddIsolatedNamespace() {
        NamespaceInfoImpl namespace1 = new NamespaceInfoImpl();
        namespace1.setPrefix("isolated_namespace_1");
        namespace1.setURI("http://www.isolated_namespace.com");
        NamespaceInfoImpl namespace2 = new NamespaceInfoImpl();
        namespace2.setPrefix("isolated_namespace_2");
        namespace2.setURI("http://www.isolated_namespace.com");
        namespace2.setIsolated(true);
        try {
            this.catalog.add((NamespaceInfo)namespace1);
            this.catalog.add((NamespaceInfo)namespace2);
            NamespaceInfo foundNamespace1 = this.catalog.getNamespaceByPrefix("isolated_namespace_1");
            Assert.assertThat((Object)foundNamespace1.getPrefix(), (Matcher)Matchers.is((Object)"isolated_namespace_1"));
            Assert.assertThat((Object)foundNamespace1.getURI(), (Matcher)Matchers.is((Object)"http://www.isolated_namespace.com"));
            Assert.assertThat((Object)foundNamespace1.isIsolated(), (Matcher)Matchers.is((Object)false));
            NamespaceInfo foundNamespace2 = this.catalog.getNamespaceByPrefix("isolated_namespace_2");
            Assert.assertThat((Object)foundNamespace2.getPrefix(), (Matcher)Matchers.is((Object)"isolated_namespace_2"));
            Assert.assertThat((Object)foundNamespace2.getURI(), (Matcher)Matchers.is((Object)"http://www.isolated_namespace.com"));
            Assert.assertThat((Object)foundNamespace2.isIsolated(), (Matcher)Matchers.is((Object)true));
            NamespaceInfo foundNamespace3 = this.catalog.getNamespaceByURI("http://www.isolated_namespace.com");
            Assert.assertThat((Object)foundNamespace3.getPrefix(), (Matcher)Matchers.is((Object)"isolated_namespace_1"));
            Assert.assertThat((Object)foundNamespace3.getURI(), (Matcher)Matchers.is((Object)"http://www.isolated_namespace.com"));
            Assert.assertThat((Object)foundNamespace3.isIsolated(), (Matcher)Matchers.is((Object)false));
            this.catalog.remove(foundNamespace1);
            NamespaceInfo foundNamespace4 = this.catalog.getNamespaceByURI("http://www.isolated_namespace.com");
            Assert.assertThat((Object)foundNamespace4, (Matcher)Matchers.nullValue());
        }
        finally {
            this.catalog.remove((NamespaceInfo)namespace1);
            this.catalog.remove((NamespaceInfo)namespace2);
        }
    }

    @Test
    public void testRemoveNamespace() {
        this.catalog.add(this.ns);
        Assert.assertEquals((long)1L, (long)this.catalog.getNamespaces().size());
        try {
            Assert.assertFalse((boolean)this.catalog.getNamespaces().remove(this.ns));
            Assert.fail((String)"removing directly should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.catalog.remove(this.ns);
        Assert.assertTrue((boolean)this.catalog.getNamespaces().isEmpty());
    }

    @Test
    public void testGetNamespaceById() {
        this.catalog.add(this.ns);
        NamespaceInfo ns2 = this.catalog.getNamespace(this.ns.getId());
        Assert.assertNotNull((Object)ns2);
        Assert.assertFalse((this.ns == ns2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.ns, (Object)ns2);
    }

    @Test
    public void testGetNamespaceByPrefix() {
        this.catalog.add(this.ns);
        NamespaceInfo ns2 = this.catalog.getNamespaceByPrefix(this.ns.getPrefix());
        Assert.assertNotNull((Object)ns2);
        Assert.assertFalse((this.ns == ns2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.ns, (Object)ns2);
        NamespaceInfo ns3 = this.catalog.getNamespaceByPrefix(null);
        Assert.assertNotNull((Object)ns3);
        Assert.assertFalse((this.ns == ns3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.ns, (Object)ns3);
        NamespaceInfo ns4 = this.catalog.getNamespaceByPrefix("default");
        Assert.assertNotNull((Object)ns4);
        Assert.assertFalse((this.ns == ns4 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.ns, (Object)ns4);
    }

    @Test
    public void testGetNamespaceByURI() {
        this.catalog.add(this.ns);
        NamespaceInfo ns2 = this.catalog.getNamespaceByURI(this.ns.getURI());
        Assert.assertNotNull((Object)ns2);
        Assert.assertFalse((this.ns == ns2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.ns, (Object)ns2);
    }

    @Test
    public void testSetDefaultNamespaceInvalid() {
        try {
            this.catalog.setDefaultNamespace(this.ns);
            Assert.fail((String)"Default namespace must exist in catalog");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"No such namespace: 'wsName'", (Object)e.getMessage());
        }
    }

    @Test
    public void testModifyNamespace() {
        this.catalog.add(this.ns);
        NamespaceInfo ns2 = this.catalog.getNamespaceByPrefix(this.ns.getPrefix());
        ns2.setPrefix(null);
        ns2.setURI(null);
        try {
            this.catalog.save(ns2);
            Assert.fail((String)"setting prefix to null should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ns2.setPrefix("ns2Prefix");
        try {
            this.catalog.save(ns2);
            Assert.fail((String)"setting uri to null should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ns2.setURI("ns2URI");
        NamespaceInfo ns3 = this.catalog.getNamespaceByPrefix(this.ns.getPrefix());
        Assert.assertEquals((Object)this.ns.getPrefix(), (Object)ns3.getPrefix());
        Assert.assertEquals((Object)this.ns.getURI(), (Object)ns3.getURI());
        this.catalog.save(ns2);
        ns3 = this.catalog.getNamespaceByPrefix("ns2Prefix");
        Assert.assertEquals((Object)ns2, (Object)ns3);
        Assert.assertEquals((Object)"ns2Prefix", (Object)ns3.getPrefix());
        Assert.assertEquals((Object)"ns2URI", (Object)ns3.getURI());
    }

    @Test
    public void testNamespaceEvents() {
        TestListener l = new TestListener();
        this.catalog.addListener((CatalogListener)l);
        NamespaceInfo ns = this.catalog.getFactory().createNamespace();
        ns.setPrefix("ns2Prefix");
        ns.setURI("ns2URI");
        Assert.assertTrue((boolean)l.added.isEmpty());
        Assert.assertTrue((boolean)l.modified.isEmpty());
        this.catalog.add(ns);
        Assert.assertEquals((long)1L, (long)l.added.size());
        Assert.assertEquals((Object)ns, (Object)l.added.get(0).getSource());
        Assert.assertEquals((long)1L, (long)l.modified.size());
        Assert.assertEquals((Object)this.catalog, (Object)l.modified.get(0).getSource());
        Assert.assertEquals((Object)"defaultNamespace", l.modified.get(0).getPropertyNames().get(0));
        Assert.assertEquals((long)1L, (long)l.postModified.size());
        Assert.assertEquals((Object)this.catalog, (Object)l.postModified.get(0).getSource());
        Assert.assertEquals((Object)"defaultNamespace", l.postModified.get(0).getPropertyNames().get(0));
        ns = this.catalog.getNamespaceByPrefix("ns2Prefix");
        ns.setURI("changed");
        this.catalog.save(ns);
        Assert.assertEquals((long)2L, (long)l.modified.size());
        Assert.assertEquals((long)1L, (long)l.modified.get(1).getPropertyNames().size());
        Assert.assertTrue((boolean)((String)l.modified.get(1).getPropertyNames().get(0)).equalsIgnoreCase("uri"));
        Assert.assertTrue((boolean)l.modified.get(1).getOldValues().contains("ns2URI"));
        Assert.assertTrue((boolean)l.modified.get(1).getNewValues().contains("changed"));
        Assert.assertEquals((long)2L, (long)l.postModified.size());
        Assert.assertEquals((long)1L, (long)l.postModified.get(1).getPropertyNames().size());
        Assert.assertTrue((boolean)((String)l.postModified.get(1).getPropertyNames().get(0)).equalsIgnoreCase("uri"));
        Assert.assertTrue((boolean)l.postModified.get(1).getOldValues().contains("ns2URI"));
        Assert.assertTrue((boolean)l.postModified.get(1).getNewValues().contains("changed"));
        Assert.assertTrue((boolean)l.removed.isEmpty());
        this.catalog.remove(ns);
        Assert.assertEquals((long)1L, (long)l.removed.size());
        Assert.assertEquals((Object)ns, (Object)l.removed.get(0).getSource());
    }

    @Test
    public void testAddWorkspace() {
        Assert.assertTrue((boolean)this.catalog.getWorkspaces().isEmpty());
        this.catalog.add(this.ws);
        Assert.assertEquals((long)1L, (long)this.catalog.getWorkspaces().size());
        WorkspaceInfo ws2 = this.catalog.getFactory().createWorkspace();
        try {
            this.catalog.getWorkspaces().add(ws2);
            Assert.fail((String)"adding directly should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.catalog.add(ws2);
            Assert.fail((String)"addign without a name should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ws2.setName("ws2");
        this.catalog.add(ws2);
    }

    @Test
    public void testRemoveWorkspace() {
        this.catalog.add(this.ws);
        Assert.assertEquals((long)1L, (long)this.catalog.getWorkspaces().size());
        try {
            Assert.assertFalse((boolean)this.catalog.getWorkspaces().remove(this.ws));
            Assert.fail((String)"removing directly should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.catalog.remove(this.ws);
        Assert.assertTrue((boolean)this.catalog.getWorkspaces().isEmpty());
    }

    @Test
    public void testAddIsolatedWorkspace() {
        WorkspaceInfoImpl workspace = new WorkspaceInfoImpl();
        workspace.setName("isolated_workspace");
        workspace.setIsolated(true);
        try {
            this.catalog.add((WorkspaceInfo)workspace);
            WorkspaceInfo foundWorkspace = this.catalog.getWorkspaceByName("isolated_workspace");
            Assert.assertThat((Object)foundWorkspace.isIsolated(), (Matcher)Matchers.is((Object)true));
        }
        finally {
            this.catalog.remove((WorkspaceInfo)workspace);
        }
    }

    @Test
    public void testAutoSetDefaultWorkspace() {
        this.catalog.add(this.ws);
        Assert.assertEquals((long)1L, (long)this.catalog.getWorkspaces().size());
        Assert.assertEquals((Object)this.ws, (Object)this.catalog.getDefaultWorkspace());
        Assert.assertNull((Object)this.catalog.getDefaultNamespace());
    }

    @Test
    public void testRemoveDefaultWorkspace() {
        this.catalog.add(this.ws);
        Assert.assertNotNull((Object)this.catalog.getDefaultWorkspace());
        this.catalog.remove(this.ws);
        Assert.assertNull((Object)this.catalog.getDefaultWorkspace());
    }

    @Test
    public void testAutoCascadeDefaultWorksapce() {
        CatalogFactory factory = this.catalog.getFactory();
        WorkspaceInfo ws1 = factory.createWorkspace();
        ws1.setName("ws1Name");
        WorkspaceInfo ws2 = factory.createWorkspace();
        ws2.setName("ws2Name");
        this.catalog.add(ws1);
        this.catalog.add(ws2);
        Assert.assertEquals((Object)ws1, (Object)this.catalog.getDefaultWorkspace());
        this.catalog.remove(ws1);
        Assert.assertEquals((Object)ws2, (Object)this.catalog.getDefaultWorkspace());
    }

    @Test
    public void testAutoSetDefaultNamespace() {
        this.catalog.add(this.ns);
        Assert.assertEquals((long)1L, (long)this.catalog.getNamespaces().size());
        Assert.assertEquals((Object)this.ns, (Object)this.catalog.getDefaultNamespace());
    }

    @Test
    public void testRemoveDefaultNamespace() {
        this.catalog.add(this.ns);
        this.catalog.remove(this.ns);
        Assert.assertNull((Object)this.catalog.getDefaultNamespace());
    }

    @Test
    public void testAutoCascadeDefaultNamespace() {
        CatalogFactory factory = this.catalog.getFactory();
        NamespaceInfo ns1 = factory.createNamespace();
        ns1.setPrefix("1");
        ns1.setURI("http://www.geoserver.org/1");
        NamespaceInfo ns2 = factory.createNamespace();
        ns2.setPrefix("2");
        ns2.setURI("http://www.geoserver.org/2");
        this.catalog.add(ns1);
        this.catalog.add(ns2);
        Assert.assertEquals((Object)ns1, (Object)this.catalog.getDefaultNamespace());
        this.catalog.remove(ns1);
        Assert.assertEquals((Object)ns2, (Object)this.catalog.getDefaultNamespace());
    }

    @Test
    public void testAutoSetDefaultStore() {
        this.catalog.add(this.ws);
        this.catalog.add((StoreInfo)this.ds);
        Assert.assertEquals((long)1L, (long)this.catalog.getDataStores().size());
        Assert.assertEquals((Object)this.ds, (Object)this.catalog.getDefaultDataStore(this.ws));
    }

    @Test
    public void testRemoveDefaultStore() {
        this.catalog.add(this.ws);
        this.catalog.add((StoreInfo)this.ds);
        this.catalog.remove((StoreInfo)this.ds);
        Assert.assertNull((Object)this.catalog.getDefaultDataStore(this.ws));
    }

    @Test
    public void testGetWorkspaceById() {
        this.catalog.add(this.ws);
        WorkspaceInfo ws2 = this.catalog.getWorkspace(this.ws.getId());
        Assert.assertNotNull((Object)ws2);
        Assert.assertFalse((this.ws == ws2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.ws, (Object)ws2);
    }

    @Test
    public void testGetWorkspaceByName() {
        this.catalog.add(this.ws);
        WorkspaceInfo ws2 = this.catalog.getWorkspaceByName(this.ws.getName());
        Assert.assertNotNull((Object)ws2);
        Assert.assertFalse((this.ws == ws2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.ws, (Object)ws2);
        WorkspaceInfo ws3 = this.catalog.getWorkspaceByName(null);
        Assert.assertNotNull((Object)ws3);
        Assert.assertFalse((this.ws == ws3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.ws, (Object)ws3);
        WorkspaceInfo ws4 = this.catalog.getWorkspaceByName("default");
        Assert.assertNotNull((Object)ws4);
        Assert.assertFalse((this.ws == ws4 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.ws, (Object)ws4);
    }

    @Test
    public void testSetDefaultWorkspaceInvalid() {
        try {
            this.catalog.setDefaultWorkspace(this.ws);
            Assert.fail((String)"Default workspace must exist in catalog");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"No such workspace: 'wsName'", (Object)e.getMessage());
        }
    }

    @Test
    public void testModifyWorkspace() {
        this.catalog.add(this.ws);
        WorkspaceInfo ws2 = this.catalog.getWorkspaceByName(this.ws.getName());
        ws2.setName(null);
        try {
            this.catalog.save(ws2);
            Assert.fail((String)"setting name to null should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ws2.setName("ws2");
        WorkspaceInfo ws3 = this.catalog.getWorkspaceByName(this.ws.getName());
        Assert.assertEquals((Object)"wsName", (Object)ws3.getName());
        this.catalog.save(ws2);
        ws3 = this.catalog.getWorkspaceByName(ws2.getName());
        Assert.assertEquals((Object)ws2, (Object)ws3);
        Assert.assertEquals((Object)"ws2", (Object)ws3.getName());
    }

    @Test
    public void testWorkspaceEvents() {
        TestListener l = new TestListener();
        this.catalog.addListener((CatalogListener)l);
        WorkspaceInfo ws = this.catalog.getFactory().createWorkspace();
        ws.setName("ws2");
        Assert.assertTrue((boolean)l.added.isEmpty());
        Assert.assertTrue((boolean)l.modified.isEmpty());
        this.catalog.add(ws);
        Assert.assertEquals((long)1L, (long)l.added.size());
        Assert.assertEquals((Object)ws, (Object)l.added.get(0).getSource());
        Assert.assertEquals((Object)this.catalog, (Object)l.modified.get(0).getSource());
        Assert.assertEquals((Object)"defaultWorkspace", l.modified.get(0).getPropertyNames().get(0));
        Assert.assertEquals((Object)this.catalog, (Object)l.postModified.get(0).getSource());
        Assert.assertEquals((Object)"defaultWorkspace", l.postModified.get(0).getPropertyNames().get(0));
        ws = this.catalog.getWorkspaceByName("ws2");
        ws.setName("changed");
        this.catalog.save(ws);
        Assert.assertEquals((long)2L, (long)l.modified.size());
        Assert.assertTrue((boolean)l.modified.get(1).getPropertyNames().contains("name"));
        Assert.assertTrue((boolean)l.modified.get(1).getOldValues().contains("ws2"));
        Assert.assertTrue((boolean)l.modified.get(1).getNewValues().contains("changed"));
        Assert.assertTrue((boolean)l.postModified.get(1).getPropertyNames().contains("name"));
        Assert.assertTrue((boolean)l.postModified.get(1).getOldValues().contains("ws2"));
        Assert.assertTrue((boolean)l.postModified.get(1).getNewValues().contains("changed"));
        Assert.assertTrue((boolean)l.removed.isEmpty());
        this.catalog.remove(ws);
        Assert.assertEquals((long)1L, (long)l.removed.size());
        Assert.assertEquals((Object)ws, (Object)l.removed.get(0).getSource());
    }

    @Test
    public void testAddDataStore() {
        Assert.assertTrue((boolean)this.catalog.getDataStores().isEmpty());
        this.ds.setWorkspace(null);
        try {
            this.catalog.add((StoreInfo)this.ds);
            Assert.fail((String)"adding with no workspace should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ds.setWorkspace(this.ws);
        this.catalog.add(this.ws);
        this.catalog.add((StoreInfo)this.ds);
        Assert.assertEquals((long)1L, (long)this.catalog.getDataStores().size());
        DataStoreInfo retrieved = this.catalog.getDataStore(this.ds.getId());
        DataStoreInfo ds2 = this.catalog.getFactory().createDataStore();
        try {
            this.catalog.add((StoreInfo)ds2);
            Assert.fail((String)"adding without a name should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ds2.setName("ds2Name");
        try {
            this.catalog.getDataStores().add(ds2);
            Assert.fail((String)"adding directly should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ds2.setWorkspace(this.ws);
        this.catalog.add((StoreInfo)ds2);
        Assert.assertEquals((long)2L, (long)this.catalog.getDataStores().size());
    }

    @Test
    public void testAddDataStoreDefaultWorkspace() {
        this.catalog.add(this.ws);
        this.catalog.setDefaultWorkspace(this.ws);
        DataStoreInfo ds2 = this.catalog.getFactory().createDataStore();
        ds2.setName("ds2Name");
        this.catalog.add((StoreInfo)ds2);
        Assert.assertEquals((Object)this.ws, (Object)ds2.getWorkspace());
    }

    @Test
    public void testRemoveDataStore() {
        this.addDataStore();
        Assert.assertEquals((long)1L, (long)this.catalog.getDataStores().size());
        try {
            Assert.assertFalse((boolean)this.catalog.getDataStores().remove(this.ds));
            Assert.fail((String)"removing directly should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.catalog.remove((StoreInfo)this.ds);
        Assert.assertTrue((boolean)this.catalog.getDataStores().isEmpty());
    }

    @Test
    public void testGetDataStoreById() {
        this.addDataStore();
        DataStoreInfo ds2 = this.catalog.getDataStore(this.ds.getId());
        Assert.assertNotNull((Object)ds2);
        Assert.assertFalse((this.ds == ds2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.ds, (Object)ds2);
    }

    @Test
    public void testGetDataStoreByName() {
        this.addDataStore();
        DataStoreInfo ds2 = this.catalog.getDataStoreByName(this.ds.getName());
        Assert.assertNotNull((Object)ds2);
        Assert.assertFalse((this.ds == ds2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.ds, (Object)ds2);
        DataStoreInfo ds3 = this.catalog.getDataStoreByName(this.ws, null);
        Assert.assertNotNull((Object)ds3);
        Assert.assertFalse((this.ds == ds3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.ds, (Object)ds3);
        DataStoreInfo ds4 = this.catalog.getDataStoreByName(this.ws, "default");
        Assert.assertNotNull((Object)ds4);
        Assert.assertFalse((this.ds == ds4 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.ds, (Object)ds4);
        DataStoreInfo ds5 = this.catalog.getDataStoreByName("default", "default");
        Assert.assertNotNull((Object)ds5);
        Assert.assertFalse((this.ds == ds5 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.ds, (Object)ds5);
    }

    @Test
    public void testGetStoreByName() {
        this.addDataStore();
        StoreInfo ds2 = this.catalog.getStoreByName(this.ds.getName(), StoreInfo.class);
        Assert.assertNotNull((Object)ds2);
        Assert.assertFalse((this.ds == ds2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.ds, (Object)ds2);
        StoreInfo ds3 = this.catalog.getStoreByName(this.ws, null, StoreInfo.class);
        Assert.assertNotNull((Object)ds3);
        Assert.assertFalse((this.ds == ds3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.ds, (Object)ds3);
        StoreInfo ds4 = this.catalog.getStoreByName(this.ws, "default", StoreInfo.class);
        Assert.assertNotNull((Object)ds4);
        Assert.assertFalse((this.ds == ds4 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.ds, (Object)ds4);
        StoreInfo ds5 = this.catalog.getStoreByName("default", "default", StoreInfo.class);
        Assert.assertNotNull((Object)ds5);
        Assert.assertFalse((this.ds == ds5 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.ds, (Object)ds5);
        StoreInfo ds6 = this.catalog.getStoreByName((String)null, null, StoreInfo.class);
        Assert.assertNotNull((Object)ds6);
        Assert.assertFalse((this.ds == ds6 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.ds, (Object)ds3);
        StoreInfo ds7 = this.catalog.getStoreByName("default", "default", StoreInfo.class);
        Assert.assertNotNull((Object)ds7);
        Assert.assertFalse((this.ds == ds7 ? 1 : 0) != 0);
        Assert.assertEquals((Object)ds6, (Object)ds7);
    }

    @Test
    public void testModifyDataStore() {
        this.addDataStore();
        DataStoreInfo ds2 = this.catalog.getDataStoreByName(this.ds.getName());
        ds2.setName("dsName2");
        ds2.setDescription("dsDescription2");
        DataStoreInfo ds3 = this.catalog.getDataStoreByName(this.ds.getName());
        Assert.assertEquals((Object)"dsName", (Object)ds3.getName());
        Assert.assertEquals((Object)"dsDescription", (Object)ds3.getDescription());
        this.catalog.save((StoreInfo)ds2);
        ds3 = this.catalog.getDataStoreByName("dsName2");
        Assert.assertEquals((Object)ds2, (Object)ds3);
        Assert.assertEquals((Object)"dsName2", (Object)ds3.getName());
        Assert.assertEquals((Object)"dsDescription2", (Object)ds3.getDescription());
    }

    @Test
    public void testChangeDataStoreWorkspace() throws Exception {
        this.addDataStore();
        WorkspaceInfo ws2 = this.catalog.getFactory().createWorkspace();
        ws2.setName("newWorkspace");
        this.catalog.add(ws2);
        ws2 = this.catalog.getWorkspaceByName(ws2.getName());
        DataStoreInfo ds2 = this.catalog.getDataStoreByName(this.ds.getName());
        ds2.setWorkspace(ws2);
        this.catalog.save((StoreInfo)ds2);
        Assert.assertNull((Object)this.catalog.getDataStoreByName(this.ws, ds2.getName()));
        Assert.assertNotNull((Object)this.catalog.getDataStoreByName(ws2, ds2.getName()));
    }

    @Test
    public void testDataStoreEvents() {
        this.addWorkspace();
        TestListener l = new TestListener();
        this.catalog.addListener((CatalogListener)l);
        Assert.assertEquals((long)0L, (long)l.added.size());
        this.catalog.add((StoreInfo)this.ds);
        Assert.assertEquals((long)1L, (long)l.added.size());
        Assert.assertEquals((Object)this.ds, (Object)l.added.get(0).getSource());
        Assert.assertEquals((long)1L, (long)l.modified.size());
        Assert.assertEquals((Object)this.catalog, (Object)l.modified.get(0).getSource());
        Assert.assertEquals((long)1L, (long)l.postModified.size());
        Assert.assertEquals((Object)this.catalog, (Object)l.postModified.get(0).getSource());
        DataStoreInfo ds2 = this.catalog.getDataStoreByName(this.ds.getName());
        ds2.setDescription("changed");
        Assert.assertEquals((long)1L, (long)l.modified.size());
        this.catalog.save((StoreInfo)ds2);
        Assert.assertEquals((long)2L, (long)l.modified.size());
        CatalogModifyEvent me = l.modified.get(1);
        Assert.assertEquals((Object)ds2, (Object)me.getSource());
        Assert.assertEquals((long)1L, (long)me.getPropertyNames().size());
        Assert.assertEquals((Object)"description", me.getPropertyNames().get(0));
        Assert.assertEquals((long)1L, (long)me.getOldValues().size());
        Assert.assertEquals((long)1L, (long)me.getNewValues().size());
        Assert.assertEquals((Object)"dsDescription", me.getOldValues().get(0));
        Assert.assertEquals((Object)"changed", me.getNewValues().get(0));
        CatalogPostModifyEvent pme = l.postModified.get(1);
        Assert.assertEquals((Object)ds2, (Object)pme.getSource());
        Assert.assertEquals((long)1L, (long)pme.getPropertyNames().size());
        Assert.assertEquals((Object)"description", pme.getPropertyNames().get(0));
        Assert.assertEquals((long)1L, (long)pme.getOldValues().size());
        Assert.assertEquals((long)1L, (long)pme.getNewValues().size());
        Assert.assertEquals((Object)"dsDescription", pme.getOldValues().get(0));
        Assert.assertEquals((Object)"changed", pme.getNewValues().get(0));
        Assert.assertEquals((long)0L, (long)l.removed.size());
        this.catalog.remove((StoreInfo)this.ds);
        Assert.assertEquals((long)1L, (long)l.removed.size());
        Assert.assertEquals((Object)this.ds, (Object)l.removed.get(0).getSource());
    }

    @Test
    public void testAddFeatureType() {
        Assert.assertTrue((boolean)this.catalog.getFeatureTypes().isEmpty());
        this.addFeatureType();
        Assert.assertEquals((long)1L, (long)this.catalog.getFeatureTypes().size());
        FeatureTypeInfo ft2 = this.catalog.getFactory().createFeatureType();
        try {
            this.catalog.add((ResourceInfo)ft2);
            Assert.fail((String)"adding with no name should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ft2.setName("ft2Name");
        try {
            this.catalog.add((ResourceInfo)ft2);
            Assert.fail((String)"adding with no store should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ft2.setStore((StoreInfo)this.ds);
        ft2.getKeywords().add(new Keyword("keyword"));
        this.catalog.add((ResourceInfo)ft2);
        FeatureTypeInfo ft3 = this.catalog.getFactory().createFeatureType();
        ft3.setName("ft3Name");
        try {
            this.catalog.getFeatureTypes().add(ft3);
            Assert.fail((String)"adding directly should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testAddCoverage() {
        Assert.assertNotNull((Object)this.catalog.getCoverages());
        Assert.assertTrue((boolean)this.catalog.getCoverages().isEmpty());
        this.addCoverage();
        Assert.assertEquals((long)1L, (long)this.catalog.getCoverages().size());
        CoverageInfo cv2 = this.catalog.getFactory().createCoverage();
        try {
            this.catalog.add((ResourceInfo)cv2);
            Assert.fail((String)"adding with no name should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        cv2.setName("cv2Name");
        try {
            this.catalog.add((ResourceInfo)cv2);
            Assert.fail((String)"adding with no store should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        cv2.setStore((StoreInfo)this.cs);
        this.catalog.add((ResourceInfo)cv2);
        Assert.assertEquals((long)2L, (long)this.catalog.getCoverages().size());
        CoverageInfo fromCatalog = this.catalog.getCoverageByName("cv2Name");
        Assert.assertNotNull((Object)fromCatalog);
        Assert.assertNotNull((Object)fromCatalog.getParameters());
        CoverageInfo cv3 = this.catalog.getFactory().createCoverage();
        cv3.setName("cv3Name");
        try {
            this.catalog.getCoverages().add(cv3);
            Assert.fail((String)"adding directly should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testAddWMSLayer() {
        Assert.assertTrue((boolean)this.catalog.getResources(WMSLayerInfo.class).isEmpty());
        this.addWMSLayer();
        Assert.assertEquals((long)1L, (long)this.catalog.getResources(WMSLayerInfo.class).size());
    }

    @Test
    public void testAddWMTSLayer() {
        Assert.assertTrue((boolean)this.catalog.getResources(WMTSLayerInfo.class).isEmpty());
        this.addWMTSLayer();
        Assert.assertEquals((long)1L, (long)this.catalog.getResources(WMTSLayerInfo.class).size());
    }

    @Test
    public void testRemoveFeatureType() {
        this.addFeatureType();
        Assert.assertFalse((boolean)this.catalog.getFeatureTypes().isEmpty());
        try {
            this.catalog.getFeatureTypes().remove(this.ft);
            Assert.fail((String)"removing directly should cause exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.catalog.remove((ResourceInfo)this.ft);
        Assert.assertTrue((boolean)this.catalog.getFeatureTypes().isEmpty());
    }

    @Test
    public void testRemoveWMSLayer() {
        this.addWMSLayer();
        Assert.assertFalse((boolean)this.catalog.getResources(WMSLayerInfo.class).isEmpty());
        this.catalog.remove((ResourceInfo)this.wl);
        Assert.assertTrue((boolean)this.catalog.getResources(WMSLayerInfo.class).isEmpty());
    }

    @Test
    public void testRemoveWMTSLayer() {
        this.addWMTSLayer();
        Assert.assertFalse((boolean)this.catalog.getResources(WMTSLayerInfo.class).isEmpty());
        this.catalog.remove((ResourceInfo)this.wmtsl);
        Assert.assertTrue((boolean)this.catalog.getResources(WMTSLayerInfo.class).isEmpty());
    }

    @Test
    public void testGetFeatureTypeById() {
        this.addFeatureType();
        FeatureTypeInfo ft2 = this.catalog.getFeatureType(this.ft.getId());
        Assert.assertNotNull((Object)ft2);
        Assert.assertFalse((this.ft == ft2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.ft, (Object)ft2);
    }

    @Test
    public void testGetFeatureTypeByName() {
        this.addFeatureType();
        FeatureTypeInfo ft2 = this.catalog.getFeatureTypeByName(this.ft.getName());
        Assert.assertNotNull((Object)ft2);
        Assert.assertFalse((this.ft == ft2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.ft, (Object)ft2);
        NamespaceInfo ns2 = this.catalog.getFactory().createNamespace();
        ns2.setPrefix("ns2Prefix");
        ns2.setURI("ns2URI");
        this.catalog.add(ns2);
        FeatureTypeInfo ft3 = this.catalog.getFactory().createFeatureType();
        ft3.setName("ft3Name");
        ft3.setStore((StoreInfo)this.ds);
        ft3.setNamespace(ns2);
        this.catalog.add((ResourceInfo)ft3);
        FeatureTypeInfo ft4 = this.catalog.getFeatureTypeByName(ns2.getPrefix(), ft3.getName());
        Assert.assertNotNull((Object)ft4);
        Assert.assertFalse((ft4 == ft3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)ft3, (Object)ft4);
        ft4 = this.catalog.getFeatureTypeByName(ns2.getURI(), ft3.getName());
        Assert.assertNotNull((Object)ft4);
        Assert.assertFalse((ft4 == ft3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)ft3, (Object)ft4);
    }

    @Test
    public void testGetFeatureTypesByStore() {
        this.catalog.add(this.ns);
        this.catalog.add(this.ws);
        this.catalog.setDefaultNamespace(this.ns);
        this.catalog.setDefaultWorkspace(this.ws);
        DataStoreInfo ds1 = this.catalog.getFactory().createDataStore();
        ds1.setName("ds1");
        this.catalog.add((StoreInfo)ds1);
        FeatureTypeInfo ft1 = this.catalog.getFactory().createFeatureType();
        ft1.setName("ft1");
        ft1.setStore((StoreInfo)ds1);
        this.catalog.add((ResourceInfo)ft1);
        FeatureTypeInfo ft2 = this.catalog.getFactory().createFeatureType();
        ft2.setName("ft2");
        ft2.setStore((StoreInfo)ds1);
        this.catalog.add((ResourceInfo)ft2);
        DataStoreInfo ds2 = this.catalog.getFactory().createDataStore();
        ds2.setName("ds2");
        this.catalog.add((StoreInfo)ds2);
        FeatureTypeInfo ft3 = this.catalog.getFactory().createFeatureType();
        ft3.setName("ft3");
        ft3.setStore((StoreInfo)ds2);
        this.catalog.add((ResourceInfo)ft3);
        List r = this.catalog.getResourcesByStore((StoreInfo)ds1, ResourceInfo.class);
        Assert.assertEquals((long)2L, (long)r.size());
        Assert.assertTrue((boolean)r.contains(ft1));
        Assert.assertTrue((boolean)r.contains(ft2));
    }

    @Test
    public void testModifyFeatureType() {
        this.addFeatureType();
        FeatureTypeInfo ft2 = this.catalog.getFeatureTypeByName(this.ft.getName());
        ft2.setDescription("ft2Description");
        ft2.getKeywords().add(new Keyword("ft2"));
        FeatureTypeInfo ft3 = this.catalog.getFeatureTypeByName(this.ft.getName());
        Assert.assertEquals((Object)"ftName", (Object)ft3.getName());
        Assert.assertEquals((Object)"ftDescription", (Object)ft3.getDescription());
        Assert.assertTrue((boolean)ft3.getKeywords().isEmpty());
        this.catalog.save((ResourceInfo)ft2);
        ft3 = this.catalog.getFeatureTypeByName(this.ft.getName());
        Assert.assertEquals((Object)ft2, (Object)ft3);
        Assert.assertEquals((Object)"ft2Description", (Object)ft3.getDescription());
        Assert.assertEquals((long)1L, (long)ft3.getKeywords().size());
    }

    @Test
    public void testModifyMetadataLinks() {
        this.addFeatureType();
        FeatureTypeInfo ft2 = this.catalog.getFeatureTypeByName(this.ft.getName());
        MetadataLinkInfo ml = this.catalog.getFactory().createMetadataLink();
        ml.setContent("http://www.geoserver.org/meta");
        ml.setType("text/plain");
        ml.setMetadataType("iso");
        ft2.getMetadataLinks().clear();
        ft2.getMetadataLinks().add(ml);
        this.catalog.save((ResourceInfo)ft2);
        FeatureTypeInfo ft3 = this.catalog.getFeatureTypeByName(this.ft.getName());
        MetadataLinkInfo ml3 = (MetadataLinkInfo)ft3.getMetadataLinks().get(0);
        ml3.setType("application/json");
        FeatureTypeInfo ft4 = this.catalog.getFeatureTypeByName(this.ft.getName());
        MetadataLinkInfo ml4 = (MetadataLinkInfo)ft4.getMetadataLinks().get(0);
        Assert.assertEquals((Object)"text/plain", (Object)ml4.getType());
        this.catalog.save((ResourceInfo)ft3);
        FeatureTypeInfo ft5 = this.catalog.getFeatureTypeByName(this.ft.getName());
        MetadataLinkInfo ml5 = (MetadataLinkInfo)ft5.getMetadataLinks().get(0);
        Assert.assertEquals((Object)"application/json", (Object)ml5.getType());
    }

    @Test
    public void testModifyDataLinks() {
        this.addFeatureType();
        FeatureTypeInfo ft2 = this.catalog.getFeatureTypeByName(this.ft.getName());
        DataLinkInfo ml = this.catalog.getFactory().createDataLink();
        ml.setContent("http://www.geoserver.org/meta");
        ml.setType("text/plain");
        ft2.getDataLinks().clear();
        ft2.getDataLinks().add(ml);
        this.catalog.save((ResourceInfo)ft2);
        FeatureTypeInfo ft3 = this.catalog.getFeatureTypeByName(this.ft.getName());
        DataLinkInfo ml3 = (DataLinkInfo)ft3.getDataLinks().get(0);
        ml3.setType("application/json");
        FeatureTypeInfo ft4 = this.catalog.getFeatureTypeByName(this.ft.getName());
        DataLinkInfo ml4 = (DataLinkInfo)ft4.getDataLinks().get(0);
        Assert.assertEquals((Object)"text/plain", (Object)ml4.getType());
        this.catalog.save((ResourceInfo)ft3);
        FeatureTypeInfo ft5 = this.catalog.getFeatureTypeByName(this.ft.getName());
        DataLinkInfo ml5 = (DataLinkInfo)ft5.getDataLinks().get(0);
        Assert.assertEquals((Object)"application/json", (Object)ml5.getType());
    }

    @Test
    public void testFeatureTypeEvents() {
        this.addNamespace();
        this.addDataStore();
        TestListener l = new TestListener();
        this.catalog.addListener((CatalogListener)l);
        FeatureTypeInfo ft = this.catalog.getFactory().createFeatureType();
        ft.setName("ftName");
        ft.setDescription("ftDescription");
        ft.setStore((StoreInfo)this.ds);
        Assert.assertTrue((boolean)l.added.isEmpty());
        this.catalog.add((ResourceInfo)ft);
        Assert.assertEquals((long)1L, (long)l.added.size());
        Assert.assertEquals((Object)ft, (Object)l.added.get(0).getSource());
        ft = this.catalog.getFeatureTypeByName("ftName");
        ft.setDescription("changed");
        Assert.assertTrue((boolean)l.modified.isEmpty());
        this.catalog.save((ResourceInfo)ft);
        Assert.assertEquals((long)1L, (long)l.modified.size());
        Assert.assertEquals((Object)ft, (Object)l.modified.get(0).getSource());
        Assert.assertTrue((boolean)l.modified.get(0).getPropertyNames().contains("description"));
        Assert.assertTrue((boolean)l.modified.get(0).getOldValues().contains("ftDescription"));
        Assert.assertTrue((boolean)l.modified.get(0).getNewValues().contains("changed"));
        Assert.assertEquals((long)1L, (long)l.modified.size());
        Assert.assertEquals((Object)ft, (Object)l.postModified.get(0).getSource());
        Assert.assertTrue((boolean)l.postModified.get(0).getPropertyNames().contains("description"));
        Assert.assertTrue((boolean)l.postModified.get(0).getOldValues().contains("ftDescription"));
        Assert.assertTrue((boolean)l.postModified.get(0).getNewValues().contains("changed"));
        Assert.assertTrue((boolean)l.removed.isEmpty());
        this.catalog.remove((ResourceInfo)ft);
        Assert.assertEquals((long)1L, (long)l.removed.size());
        Assert.assertEquals((Object)ft, (Object)l.removed.get(0).getSource());
    }

    @Test
    public void testModifyMetadata() {
        this.addNamespace();
        this.addDataStore();
        TestListener l = new TestListener();
        this.catalog.addListener((CatalogListener)l);
        FeatureTypeInfo ft = this.catalog.getFactory().createFeatureType();
        ft.setName("ftName");
        ft.setDescription("ftDescription");
        ft.setStore((StoreInfo)this.ds);
        Assert.assertTrue((boolean)l.added.isEmpty());
        this.catalog.add((ResourceInfo)ft);
        Assert.assertEquals((long)1L, (long)l.added.size());
        Assert.assertEquals((Object)ft, (Object)l.added.get(0).getSource());
        ft = this.catalog.getFeatureTypeByName("ftName");
        ft.getMetadata().put("newValue", (Serializable)((Object)"abcd"));
        MetadataMap newMetadata = new MetadataMap((Map)ft.getMetadata());
        this.catalog.save((ResourceInfo)ft);
        Assert.assertEquals((long)1L, (long)l.modified.size());
        Assert.assertEquals((Object)ft, (Object)l.modified.get(0).getSource());
        Assert.assertTrue((boolean)l.modified.get(0).getPropertyNames().contains("metadata"));
        Assert.assertTrue((boolean)l.modified.get(0).getOldValues().contains(new MetadataMap()));
        Assert.assertTrue((boolean)l.modified.get(0).getNewValues().contains(newMetadata));
    }

    @Test
    public void testAddLayer() {
        Assert.assertTrue((boolean)this.catalog.getLayers().isEmpty());
        this.addLayer();
        Assert.assertEquals((long)1L, (long)this.catalog.getLayers().size());
        LayerInfo l2 = this.catalog.getFactory().createLayer();
        try {
            this.catalog.add(l2);
            Assert.fail((String)"adding with no name should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.catalog.add(l2);
            Assert.fail((String)"adding with no resource should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        l2.setResource((ResourceInfo)this.ft);
        l2.setDefaultStyle(this.s);
        try {
            this.catalog.add(l2);
            Assert.fail((String)"Adding a second layer for the same resource should throw exception, layer name is tied to resource name and would end up with two layers named the same or a broken catalog");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("already exists"));
        }
        Assert.assertEquals((long)1L, (long)this.catalog.getLayers().size());
    }

    @Test
    public void testGetLayerById() {
        this.addLayer();
        LayerInfo l2 = this.catalog.getLayer(this.l.getId());
        Assert.assertNotNull((Object)l2);
        Assert.assertNotSame((Object)this.l, (Object)l2);
        Assert.assertEquals((Object)this.l, (Object)l2);
    }

    @Test
    public void testGetLayerByName() {
        this.addLayer();
        LayerInfo l2 = this.catalog.getLayerByName(this.l.getName());
        Assert.assertNotNull((Object)l2);
        Assert.assertNotSame((Object)this.l, (Object)l2);
        Assert.assertEquals((Object)this.l, (Object)l2);
    }

    @Test
    public void testGetLayerByNameWithoutColon() {
        this.catalog.add(this.nsA);
        this.catalog.add(this.nsB);
        this.catalog.add(this.wsA);
        this.catalog.add(this.wsB);
        this.catalog.setDefaultNamespace(this.nsB);
        this.catalog.setDefaultWorkspace(this.wsB);
        this.catalog.add((StoreInfo)this.dsA);
        this.catalog.add((StoreInfo)this.dsB);
        FeatureTypeInfo ftA = this.catalog.getFactory().createFeatureType();
        ftA.setEnabled(true);
        ftA.setName("bar");
        ftA.setAbstract("ftAbstract");
        ftA.setDescription("ftDescription");
        ftA.setStore((StoreInfo)this.dsA);
        ftA.setNamespace(this.nsA);
        FeatureTypeInfo ftB = this.catalog.getFactory().createFeatureType();
        ftB.setName("bar");
        ftB.setAbstract("ftAbstract");
        ftB.setDescription("ftDescription");
        ftB.setStore((StoreInfo)this.dsB);
        ftB.setNamespace(this.nsB);
        FeatureTypeInfo ftC = this.catalog.getFactory().createFeatureType();
        ftC.setName("bar2");
        ftC.setAbstract("ftAbstract");
        ftC.setDescription("ftDescription");
        ftC.setStore((StoreInfo)this.dsA);
        ftC.setNamespace(this.nsA);
        ftC.setEnabled(true);
        ftB.setEnabled(true);
        this.catalog.add((ResourceInfo)ftA);
        this.catalog.add((ResourceInfo)ftB);
        this.catalog.add((ResourceInfo)ftC);
        this.addStyle();
        LayerInfo lA = this.catalog.getFactory().createLayer();
        lA.setResource((ResourceInfo)ftA);
        lA.setDefaultStyle(this.s);
        lA.setEnabled(true);
        LayerInfo lB = this.catalog.getFactory().createLayer();
        lB.setResource((ResourceInfo)ftB);
        lB.setDefaultStyle(this.s);
        lB.setEnabled(true);
        LayerInfo lC = this.catalog.getFactory().createLayer();
        lC.setResource((ResourceInfo)ftC);
        lC.setDefaultStyle(this.s);
        lC.setEnabled(true);
        this.catalog.add(lA);
        this.catalog.add(lB);
        this.catalog.add(lC);
        LayerInfo searchedResult = this.catalog.getLayerByName("bar");
        Assert.assertNotNull((Object)searchedResult);
        Assert.assertEquals((Object)lB, (Object)searchedResult);
        searchedResult = this.catalog.getLayerByName("aaa:bar");
        Assert.assertNotNull((Object)searchedResult);
        Assert.assertEquals((Object)lA, (Object)searchedResult);
        searchedResult = this.catalog.getLayerByName("bar2");
        Assert.assertNotNull((Object)searchedResult);
        Assert.assertEquals((Object)lC, (Object)searchedResult);
        searchedResult = this.catalog.getLayerByName("aaa:bar2");
        Assert.assertNotNull((Object)searchedResult);
        Assert.assertEquals((Object)lC, (Object)searchedResult);
        searchedResult = this.catalog.getLayerByName("bbb:bar2");
        Assert.assertNull((Object)searchedResult);
    }

    @Test
    public void testGetLayerByNameWithColon() {
        this.addNamespace();
        this.addDataStore();
        FeatureTypeInfo ft = this.catalog.getFactory().createFeatureType();
        ft.setEnabled(true);
        ft.setName("foo:bar");
        ft.setAbstract("ftAbstract");
        ft.setDescription("ftDescription");
        ft.setStore((StoreInfo)this.ds);
        ft.setNamespace(this.ns);
        this.catalog.add((ResourceInfo)ft);
        this.addStyle();
        LayerInfo l = this.catalog.getFactory().createLayer();
        l.setResource((ResourceInfo)ft);
        l.setEnabled(true);
        l.setDefaultStyle(this.s);
        this.catalog.add(l);
        Assert.assertNotNull((Object)this.catalog.getLayerByName("foo:bar"));
    }

    @Test
    public void testGetLayerByResource() {
        this.addLayer();
        List layers = this.catalog.getLayers((ResourceInfo)this.ft);
        Assert.assertEquals((long)1L, (long)layers.size());
        LayerInfo l2 = (LayerInfo)layers.get(0);
        Assert.assertNotSame((Object)this.l, (Object)l2);
        Assert.assertEquals((Object)this.l, (Object)l2);
    }

    @Test
    public void testRemoveLayer() {
        this.addLayer();
        Assert.assertEquals((long)1L, (long)this.catalog.getLayers().size());
        this.catalog.remove(this.l);
        Assert.assertTrue((boolean)this.catalog.getLayers().isEmpty());
    }

    @Test
    public void testRemoveLayerAndAssociatedDataRules() throws IOException {
        DataAccessRuleDAO dao = DataAccessRuleDAO.get();
        SecuredResourceNameChangeListener listener = new SecuredResourceNameChangeListener(this.catalog, dao);
        this.addLayer();
        Assert.assertEquals((long)1L, (long)this.catalog.getLayers().size());
        String workspaceName = this.l.getResource().getStore().getWorkspace().getName();
        this.addLayerAccessRule(workspaceName, this.l.getName(), AccessMode.WRITE, "*");
        Assert.assertTrue((boolean)this.layerHasSecurityRule(dao, workspaceName, this.l.getName()));
        this.catalog.remove(this.l);
        Assert.assertTrue((boolean)this.catalog.getLayers().isEmpty());
        dao.reload();
        Assert.assertFalse((boolean)this.layerHasSecurityRule(dao, workspaceName, this.l.getName()));
        this.catalog.removeListener((CatalogListener)listener);
    }

    private boolean layerHasSecurityRule(DataAccessRuleDAO dao, String workspaceName, String layerName) {
        List rules = dao.getRules();
        for (DataAccessRule rule : rules) {
            if (!rule.getRoot().equalsIgnoreCase(workspaceName) || !rule.getLayer().equalsIgnoreCase(layerName)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testModifyLayer() {
        this.addLayer();
        LayerInfo l2 = this.catalog.getLayerByName(this.l.getName());
        l2.setResource(null);
        LayerInfo l3 = this.catalog.getLayerByName(this.l.getName());
        Assert.assertEquals((Object)this.l.getName(), (Object)l3.getName());
        try {
            this.catalog.save(l2);
            Assert.fail((String)"setting resource to null should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        l2.setResource((ResourceInfo)this.ft);
        this.catalog.save(l2);
        l3 = this.catalog.getLayerByName(this.ft.getName());
        Assert.assertNotNull((Object)l3);
    }

    @Test
    public void testModifyLayerDefaultStyle() {
        CatalogFactory factory = this.catalog.getFactory();
        StyleInfo s2 = factory.createStyle();
        s2.setName("styleName2");
        s2.setFilename("styleFilename2");
        this.catalog.add(s2);
        this.addLayer();
        LayerInfo l2 = this.catalog.getLayerByName(this.l.getName());
        l2.setDefaultStyle(this.catalog.getStyleByName("styleName2"));
        this.catalog.save(l2);
        LayerInfo l3 = this.catalog.getLayerByName(this.l.getName());
        LayerInfo l4 = this.catalog.getLayerByName(this.l.getName());
        Assert.assertEquals((Object)l3, (Object)l4);
    }

    @Test
    public void testEnableLayer() {
        this.addLayer();
        LayerInfo l2 = this.catalog.getLayerByName(this.l.getName());
        Assert.assertTrue((boolean)l2.isEnabled());
        Assert.assertTrue((boolean)l2.enabled());
        Assert.assertTrue((boolean)l2.getResource().isEnabled());
        l2.setEnabled(false);
        this.catalog.save(l2);
        this.catalog.save(l2.getResource());
        l2 = this.catalog.getLayerByName(l2.getName());
        Assert.assertFalse((boolean)l2.isEnabled());
        Assert.assertFalse((boolean)l2.enabled());
        Assert.assertFalse((boolean)l2.getResource().isEnabled());
    }

    @Test
    public void testLayerEvents() {
        this.addFeatureType();
        this.addStyle();
        TestListener tl = new TestListener();
        this.catalog.addListener((CatalogListener)tl);
        Assert.assertTrue((boolean)tl.added.isEmpty());
        this.catalog.add(this.l);
        Assert.assertEquals((long)1L, (long)tl.added.size());
        Assert.assertEquals((Object)this.l, (Object)tl.added.get(0).getSource());
        LayerInfo l2 = this.catalog.getLayerByName(this.l.getName());
        l2.setPath("newPath");
        Assert.assertTrue((boolean)tl.modified.isEmpty());
        this.catalog.save(l2);
        Assert.assertEquals((long)1L, (long)tl.modified.size());
        Assert.assertEquals((Object)l2, (Object)tl.modified.get(0).getSource());
        Assert.assertTrue((boolean)tl.modified.get(0).getPropertyNames().contains("path"));
        Assert.assertTrue((boolean)tl.modified.get(0).getOldValues().contains(null));
        Assert.assertTrue((boolean)tl.modified.get(0).getNewValues().contains("newPath"));
        Assert.assertEquals((long)1L, (long)tl.postModified.size());
        Assert.assertEquals((Object)l2, (Object)tl.postModified.get(0).getSource());
        Assert.assertTrue((boolean)tl.postModified.get(0).getPropertyNames().contains("path"));
        Assert.assertTrue((boolean)tl.postModified.get(0).getOldValues().contains(null));
        Assert.assertTrue((boolean)tl.postModified.get(0).getNewValues().contains("newPath"));
        Assert.assertTrue((boolean)tl.removed.isEmpty());
        this.catalog.remove(l2);
        Assert.assertEquals((long)1L, (long)tl.removed.size());
        Assert.assertEquals((Object)l2, (Object)tl.removed.get(0).getSource());
    }

    @Test
    public void testAddStyle() {
        Assert.assertTrue((boolean)this.catalog.getStyles().isEmpty());
        this.addStyle();
        Assert.assertEquals((long)1L, (long)this.catalog.getStyles().size());
        StyleInfo s2 = this.catalog.getFactory().createStyle();
        try {
            this.catalog.add(s2);
            Assert.fail((String)"adding without name should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        s2.setName("s2Name");
        try {
            this.catalog.add(s2);
            Assert.fail((String)"adding without fileName should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        s2.setFilename("s2Filename");
        try {
            this.catalog.getStyles().add(s2);
            Assert.fail((String)"adding directly should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.catalog.add(s2);
        Assert.assertEquals((long)2L, (long)this.catalog.getStyles().size());
    }

    @Test
    public void testAddStyleWithNameConflict() throws Exception {
        this.addWorkspace();
        this.addStyle();
        StyleInfo s2 = this.catalog.getFactory().createStyle();
        s2.setName(this.s.getName());
        s2.setFilename(this.s.getFilename());
        try {
            this.catalog.add(s2);
            Assert.fail((String)"Shoudl have failed with existing global style with same name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        List currStyles = this.catalog.getStyles();
        s2.setWorkspace(this.ws);
        this.catalog.add(s2);
        Assert.assertFalse((boolean)new HashSet(currStyles).equals(new HashSet(this.catalog.getStyles())));
        StyleInfo s3 = this.catalog.getFactory().createStyle();
        s3.setName(s2.getName());
        s3.setFilename(s2.getFilename());
        try {
            this.catalog.add(s3);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        s3.setWorkspace(this.ws);
        try {
            this.catalog.add(s3);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetStyleById() {
        this.addStyle();
        StyleInfo s2 = this.catalog.getStyle(this.s.getId());
        Assert.assertNotNull((Object)s2);
        Assert.assertNotSame((Object)this.s, (Object)s2);
        Assert.assertEquals((Object)this.s, (Object)s2);
    }

    @Test
    public void testGetStyleByName() {
        this.addStyle();
        StyleInfo s2 = this.catalog.getStyleByName(this.s.getName());
        Assert.assertNotNull((Object)s2);
        Assert.assertNotSame((Object)this.s, (Object)s2);
        Assert.assertEquals((Object)this.s, (Object)s2);
    }

    @Test
    public void testGetStyleByNameWithWorkspace() {
        this.addWorkspace();
        this.addStyle();
        StyleInfo s2 = this.catalog.getFactory().createStyle();
        s2.setName("styleNameWithWorkspace");
        s2.setFilename("styleFilenameWithWorkspace");
        s2.setWorkspace(this.ws);
        this.catalog.add(s2);
        Assert.assertNotNull((Object)this.catalog.getStyleByName("styleNameWithWorkspace"));
        Assert.assertNotNull((Object)this.catalog.getStyleByName(this.ws.getName(), "styleNameWithWorkspace"));
        Assert.assertNotNull((Object)this.catalog.getStyleByName(this.ws, "styleNameWithWorkspace"));
        Assert.assertNull((Object)this.catalog.getStyleByName((WorkspaceInfo)null, "styleNameWithWorkspace"));
        Assert.assertNull((Object)this.catalog.getStyleByName(this.ws.getName(), "styleName"));
        Assert.assertNull((Object)this.catalog.getStyleByName(this.ws, "styleName"));
        Assert.assertNotNull((Object)this.catalog.getStyleByName((WorkspaceInfo)null, "styleName"));
    }

    @Test
    public void testGetStyleByNameWithWorkspace2() throws Exception {
        this.addWorkspace();
        WorkspaceInfo ws2 = this.catalog.getFactory().createWorkspace();
        ws2.setName("wsName2");
        this.catalog.add(ws2);
        StyleInfo s1 = this.catalog.getFactory().createStyle();
        s1.setName("foo");
        s1.setFilename("foo1.sld");
        s1.setWorkspace(this.ws);
        this.catalog.add(s1);
        StyleInfo s2 = this.catalog.getFactory().createStyle();
        s2.setName("foo");
        s2.setFilename("foo2.sld");
        s2.setWorkspace(ws2);
        this.catalog.add(s2);
        Assert.assertEquals((Object)s1, (Object)this.catalog.getStyleByName("foo"));
        Assert.assertEquals((Object)s1, (Object)this.catalog.getStyleByName(this.ws.getName(), "foo"));
        Assert.assertEquals((Object)s1, (Object)this.catalog.getStyleByName(this.ws, "foo"));
        Assert.assertEquals((Object)s2, (Object)this.catalog.getStyleByName(ws2.getName(), "foo"));
        Assert.assertEquals((Object)s2, (Object)this.catalog.getStyleByName(ws2, "foo"));
    }

    @Test
    public void testGetStyles() {
        this.addWorkspace();
        this.addStyle();
        Assert.assertEquals((long)1L, (long)this.catalog.getStyles().size());
        Assert.assertEquals((long)0L, (long)this.catalog.getStylesByWorkspace(this.ws.getName()).size());
        Assert.assertEquals((long)0L, (long)this.catalog.getStylesByWorkspace(this.ws).size());
        Assert.assertEquals((long)0L, (long)this.catalog.getStylesByWorkspace((WorkspaceInfo)null).size());
        StyleInfo s2 = this.catalog.getFactory().createStyle();
        s2.setName("styleNameWithWorkspace");
        s2.setFilename("styleFilenameWithWorkspace");
        s2.setWorkspace(this.ws);
        this.catalog.add(s2);
        Assert.assertEquals((long)2L, (long)this.catalog.getStyles().size());
        Assert.assertEquals((long)1L, (long)this.catalog.getStylesByWorkspace(this.ws.getName()).size());
        Assert.assertEquals((long)1L, (long)this.catalog.getStylesByWorkspace(this.ws).size());
        Assert.assertEquals((long)1L, (long)this.catalog.getStylesByWorkspace((WorkspaceInfo)null).size());
    }

    @Test
    public void testModifyStyle() {
        this.addStyle();
        StyleInfo s2 = this.catalog.getStyleByName(this.s.getName());
        s2.setName(null);
        s2.setFilename(null);
        StyleInfo s3 = this.catalog.getStyleByName(this.s.getName());
        Assert.assertEquals((Object)this.s, (Object)s3);
        try {
            this.catalog.save(s2);
            Assert.fail((String)"setting name to null should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        s2.setName(this.s.getName());
        try {
            this.catalog.save(s2);
            Assert.fail((String)"setting filename to null should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        s2.setName("s2Name");
        s2.setFilename("s2Name.sld");
        this.catalog.save(s2);
        s3 = this.catalog.getStyleByName("styleName");
        Assert.assertNull((Object)s3);
        s3 = this.catalog.getStyleByName(s2.getName());
        Assert.assertEquals((Object)s2, (Object)s3);
    }

    @Test
    public void testModifyDefaultStyle() {
        this.addWorkspace();
        this.addDefaultStyle();
        StyleInfo s = this.catalog.getStyleByName("line");
        s.setName("foo");
        try {
            this.catalog.save(s);
            Assert.fail((String)"changing name of default style should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        s = this.catalog.getStyleByName("line");
        s.setWorkspace(this.ws);
        try {
            this.catalog.save(s);
            Assert.fail((String)"changing workspace of default style should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveStyle() {
        this.addStyle();
        Assert.assertEquals((long)1L, (long)this.catalog.getStyles().size());
        this.catalog.remove(this.s);
        Assert.assertTrue((boolean)this.catalog.getStyles().isEmpty());
    }

    @Test
    public void testRemoveDefaultStyle() {
        this.addWorkspace();
        this.addDefaultStyle();
        StyleInfo s = this.catalog.getStyleByName("line");
        try {
            this.catalog.remove(s);
            Assert.fail((String)"removing default style should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testStyleEvents() {
        TestListener l = new TestListener();
        this.catalog.addListener((CatalogListener)l);
        Assert.assertTrue((boolean)l.added.isEmpty());
        this.catalog.add(this.s);
        Assert.assertEquals((long)1L, (long)l.added.size());
        Assert.assertEquals((Object)this.s, (Object)l.added.get(0).getSource());
        StyleInfo s2 = this.catalog.getStyleByName(this.s.getName());
        s2.setFilename("changed");
        Assert.assertTrue((boolean)l.modified.isEmpty());
        Assert.assertTrue((boolean)l.postModified.isEmpty());
        this.catalog.save(s2);
        Assert.assertEquals((long)1L, (long)l.modified.size());
        Assert.assertEquals((Object)s2, (Object)l.modified.get(0).getSource());
        Assert.assertTrue((boolean)l.modified.get(0).getPropertyNames().contains("filename"));
        Assert.assertTrue((boolean)l.modified.get(0).getOldValues().contains("styleFilename"));
        Assert.assertTrue((boolean)l.modified.get(0).getNewValues().contains("changed"));
        Assert.assertEquals((long)1L, (long)l.postModified.size());
        Assert.assertEquals((Object)s2, (Object)l.postModified.get(0).getSource());
        Assert.assertTrue((boolean)l.postModified.get(0).getPropertyNames().contains("filename"));
        Assert.assertTrue((boolean)l.postModified.get(0).getOldValues().contains("styleFilename"));
        Assert.assertTrue((boolean)l.postModified.get(0).getNewValues().contains("changed"));
        Assert.assertTrue((boolean)l.removed.isEmpty());
        this.catalog.remove(s2);
        Assert.assertEquals((long)1L, (long)l.removed.size());
        Assert.assertEquals((Object)s2, (Object)l.removed.get(0).getSource());
    }

    @Test
    public void testProxyBehaviour() throws Exception {
        this.testAddLayer();
        LayerInfo l = this.catalog.getLayerByName(this.ft.getName());
        Assert.assertTrue((boolean)(l instanceof Proxy));
        ResourceInfo r = l.getResource();
        Assert.assertTrue((boolean)(r instanceof Proxy));
        String oldName = this.ft.getName();
        r.setName("changed");
        this.catalog.save(r);
        Assert.assertNull((Object)this.catalog.getLayerByName(oldName));
        l = this.catalog.getLayerByName(r.getName());
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((Object)"changed", (Object)l.getResource().getName());
    }

    @Test
    public void testProxyListBehaviour() throws Exception {
        this.catalog.add(this.s);
        StyleInfo s2 = this.catalog.getFactory().createStyle();
        s2.setName("a" + this.s.getName());
        s2.setFilename("a.sld");
        this.catalog.add(s2);
        ArrayList styles = this.catalog.getStyles();
        Assert.assertEquals((long)2L, (long)styles.size());
        Comparator<StyleInfo> comparator = new Comparator<StyleInfo>(){

            @Override
            public int compare(StyleInfo o1, StyleInfo o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        try {
            Collections.sort(styles, comparator);
            Assert.fail((String)"Expected runtime exception, immutable collection");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
        styles = new ArrayList(styles);
        Collections.sort(styles, comparator);
        Assert.assertEquals((Object)("a" + this.s.getName()), (Object)((StyleInfo)styles.get(0)).getName());
        Assert.assertEquals((Object)this.s.getName(), (Object)((StyleInfo)styles.get(1)).getName());
    }

    @Test
    public void testExceptionThrowingListener() throws Exception {
        ExceptionThrowingListener l = new ExceptionThrowingListener();
        this.catalog.addListener((CatalogListener)l);
        l.throwCatalogException = false;
        WorkspaceInfo ws = this.catalog.getFactory().createWorkspace();
        ws.setName("foo");
        this.catalog.add(ws);
        l.throwCatalogException = true;
        ws = this.catalog.getFactory().createWorkspace();
        ws.setName("bar");
        try {
            this.catalog.add(ws);
            Assert.fail();
        }
        catch (CatalogException catalogException) {
            // empty catch block
        }
    }

    @Test
    public void testAddWMSStore() {
        Assert.assertTrue((boolean)this.catalog.getStores(WMSStoreInfo.class).isEmpty());
        this.addWMSStore();
        Assert.assertEquals((long)1L, (long)this.catalog.getStores(WMSStoreInfo.class).size());
        WMSStoreInfo retrieved = (WMSStoreInfo)this.catalog.getStore(this.wms.getId(), WMSStoreInfo.class);
        WMSStoreInfo wms2 = this.catalog.getFactory().createWebMapServer();
        wms2.setName("wms2Name");
        wms2.setWorkspace(this.ws);
        this.catalog.add((StoreInfo)wms2);
        Assert.assertEquals((long)2L, (long)this.catalog.getStores(WMSStoreInfo.class).size());
    }

    @Test
    public void testAddWMTSStore() {
        Assert.assertTrue((boolean)this.catalog.getStores(WMTSStoreInfo.class).isEmpty());
        this.addWMTSStore();
        Assert.assertEquals((long)1L, (long)this.catalog.getStores(WMTSStoreInfo.class).size());
        WMTSStoreInfo retrieved = (WMTSStoreInfo)this.catalog.getStore(this.wmtss.getId(), WMTSStoreInfo.class);
        Assert.assertNotNull((Object)retrieved);
        WMTSStoreInfo wmts2 = this.catalog.getFactory().createWebMapTileServer();
        wmts2.setName("wmts2Name");
        wmts2.setWorkspace(this.ws);
        this.catalog.add((StoreInfo)wmts2);
        Assert.assertEquals((long)2L, (long)this.catalog.getStores(WMTSStoreInfo.class).size());
    }

    @Test
    @Ignore
    public void testGetLayerByIdWithConcurrentAdd() throws Exception {
        int i;
        this.addDataStore();
        this.addNamespace();
        this.addStyle();
        this.catalog.add((ResourceInfo)this.ft);
        LayerInfo layer = this.catalog.getFactory().createLayer();
        layer.setResource((ResourceInfo)this.ft);
        this.catalog.add(layer);
        String id = layer.getId();
        CountDownLatch ready = new CountDownLatch(11);
        CountDownLatch done = new CountDownLatch(10);
        ArrayList<LayerAddRunner> runners = new ArrayList<LayerAddRunner>();
        for (i = 0; i < 10; ++i) {
            LayerAddRunner runner = new LayerAddRunner(ready, done, i);
            new Thread(runner).start();
            runners.add(runner);
        }
        ready.countDown();
        ready.await();
        for (i = 0; i < this.GET_LAYER_BY_ID_WITH_CONCURRENT_ADD_TEST_COUNT; ++i) {
            this.catalog.getLayer(id);
        }
        done.await();
        RunnerBase.checkForRunnerExceptions(runners);
    }

    @Test
    public void testAddLayerGroupNameConflict() throws Exception {
        this.addLayerGroup();
        LayerGroupInfo lg2 = this.catalog.getFactory().createLayerGroup();
        lg2.setName("layerGroup");
        lg2.getLayers().add(this.l);
        lg2.getStyles().add(this.s);
        try {
            this.catalog.add(lg2);
            Assert.fail((String)"should have failed because same name and no workspace set");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        lg2.setWorkspace(this.ws);
        this.catalog.add(lg2);
    }

    @Test
    public void testAddLayerGroupWithWorkspaceWithResourceFromAnotherWorkspace() {
        WorkspaceInfo ws = this.catalog.getFactory().createWorkspace();
        ws.setName("other");
        this.catalog.add(ws);
        LayerGroupInfo lg2 = this.catalog.getFactory().createLayerGroup();
        lg2.setWorkspace(ws);
        lg2.setName("layerGroup2");
        lg2.getLayers().add(this.l);
        lg2.getStyles().add(this.s);
        try {
            this.catalog.add(lg2);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetLayerGroupByName() {
        this.addLayerGroup();
        Assert.assertNotNull((Object)this.catalog.getLayerGroupByName("layerGroup"));
        Assert.assertNotNull((Object)this.catalog.getLayerGroupByName((WorkspaceInfo)null, "layerGroup"));
        Assert.assertNull((Object)this.catalog.getLayerGroupByName(this.catalog.getDefaultWorkspace(), "layerGroup"));
        LayerGroupInfo lg2 = this.catalog.getFactory().createLayerGroup();
        lg2.setWorkspace(this.ws);
        Assert.assertEquals((Object)this.ws, (Object)this.catalog.getDefaultWorkspace());
        lg2.setName("layerGroup2");
        lg2.getLayers().add(this.l);
        lg2.getStyles().add(this.s);
        this.catalog.add(lg2);
        Assert.assertNotNull((Object)this.catalog.getLayerGroupByName("layerGroup2"));
        Assert.assertNotNull((Object)this.catalog.getLayerGroupByName(this.ws.getName() + ":layerGroup2"));
        Assert.assertNotNull((Object)this.catalog.getLayerGroupByName(this.catalog.getDefaultWorkspace(), "layerGroup2"));
        Assert.assertNull((Object)this.catalog.getLayerGroupByName("cite", "layerGroup2"));
        WorkspaceInfo ws2 = this.catalog.getFactory().createWorkspace();
        ws2.setName("ws2");
        this.catalog.add(ws2);
        this.catalog.setDefaultWorkspace(ws2);
        Assert.assertNull((String)"layerGroup2 is not global, should not be found", (Object)this.catalog.getLayerGroupByName("layerGroup2"));
        Assert.assertNotNull((Object)this.catalog.getLayerGroupByName(this.ws.getName() + ":layerGroup2"));
        Assert.assertNotNull((Object)this.catalog.getLayerGroupByName(this.ws, "layerGroup2"));
        Assert.assertNull((Object)this.catalog.getLayerGroupByName("cite", "layerGroup2"));
    }

    @Test
    public void testRemoveLayerGroupAndAssociatedDataRules() throws IOException {
        DataAccessRuleDAO dao = DataAccessRuleDAO.get();
        SecuredResourceNameChangeListener listener = new SecuredResourceNameChangeListener(this.catalog, dao);
        this.addLayer();
        CatalogFactory factory = this.catalog.getFactory();
        LayerGroupInfo lg = factory.createLayerGroup();
        String lgName = "MyFakeWorkspace:layerGroup";
        lg.setName(lgName);
        lg.setWorkspace(this.ws);
        lg.getLayers().add(this.l);
        lg.getStyles().add(this.s);
        this.catalog.add(lg);
        String workspaceName = this.ws.getName();
        Assert.assertNotNull((Object)this.catalog.getLayerGroupByName(workspaceName, lg.getName()));
        this.addLayerAccessRule(workspaceName, lg.getName(), AccessMode.WRITE, "*");
        Assert.assertTrue((boolean)this.layerHasSecurityRule(dao, workspaceName, lg.getName()));
        this.catalog.remove(lg);
        Assert.assertNull((Object)this.catalog.getLayerGroupByName(workspaceName, lg.getName()));
        Assert.assertFalse((boolean)this.layerHasSecurityRule(dao, workspaceName, lg.getName()));
        this.catalog.removeListener((CatalogListener)listener);
    }

    @Test
    public void testGetLayerGroupByNameWithColon() {
        this.addLayer();
        CatalogFactory factory = this.catalog.getFactory();
        LayerGroupInfo lg = factory.createLayerGroup();
        String lgName = "MyFakeWorkspace:layerGroup";
        lg.setName(lgName);
        lg.setWorkspace(this.ws);
        lg.getLayers().add(this.l);
        lg.getStyles().add(this.s);
        this.catalog.add(lg);
        Assert.assertNull((String)"MyFakeWorkspace:layerGroup is not global, should not be found", (Object)this.catalog.getLayerGroupByName(lgName));
        Assert.assertEquals((Object)lg, (Object)this.catalog.getLayerGroupByName(this.ws.getName(), lgName));
        Assert.assertEquals((Object)lg, (Object)this.catalog.getLayerGroupByName(this.ws, lgName));
        Assert.assertEquals((Object)lg, (Object)this.catalog.getLayerGroupByName(this.ws.getName() + ":" + lgName));
    }

    @Test
    public void testGetLayerGroupByNameWithWorkspace() {
        this.addLayer();
        Assert.assertEquals((Object)this.ws, (Object)this.catalog.getDefaultWorkspace());
        CatalogFactory factory = this.catalog.getFactory();
        LayerGroupInfo lg1 = factory.createLayerGroup();
        lg1.setName("lg");
        lg1.setWorkspace(this.ws);
        lg1.getLayers().add(this.l);
        lg1.getStyles().add(this.s);
        this.catalog.add(lg1);
        WorkspaceInfo ws2 = factory.createWorkspace();
        ws2.setName("ws2");
        this.catalog.add(ws2);
        NamespaceInfo ns2 = factory.createNamespace();
        ns2.setPrefix("ns2");
        ns2.setURI("http://ns2");
        this.catalog.add(ns2);
        DataStoreInfo ds2 = factory.createDataStore();
        ds2.setEnabled(true);
        ds2.setName("dsName");
        ds2.setDescription("dsDescription");
        ds2.setWorkspace(ws2);
        this.catalog.add((StoreInfo)ds2);
        FeatureTypeInfo ft2 = factory.createFeatureType();
        ft2.setEnabled(true);
        ft2.setName("ftName");
        ft2.setAbstract("ftAbstract");
        ft2.setDescription("ftDescription");
        ft2.setStore((StoreInfo)ds2);
        ft2.setNamespace(ns2);
        this.catalog.add((ResourceInfo)ft2);
        StyleInfo s2 = factory.createStyle();
        s2.setName("styleName");
        s2.setFilename("styleFilename");
        s2.setWorkspace(ws2);
        this.catalog.add(s2);
        LayerInfo l2 = factory.createLayer();
        l2.setResource((ResourceInfo)ft2);
        l2.setEnabled(true);
        l2.setDefaultStyle(s2);
        this.catalog.add(l2);
        LayerGroupInfo lg2 = this.catalog.getFactory().createLayerGroup();
        lg2.setName("lg");
        lg2.setWorkspace(ws2);
        lg2.getLayers().add(l2);
        lg2.getStyles().add(s2);
        this.catalog.add(lg2);
        Assert.assertEquals((Object)lg1, (Object)this.catalog.getLayerGroupByName("lg"));
        Assert.assertEquals((Object)lg1, (Object)this.catalog.getLayerGroupByName(this.ws.getName(), "lg"));
        Assert.assertEquals((Object)lg1, (Object)this.catalog.getLayerGroupByName(this.ws, "lg"));
        Assert.assertEquals((Object)lg1, (Object)this.catalog.getLayerGroupByName(this.ws.getName() + ":lg"));
        Assert.assertEquals((Object)lg2, (Object)this.catalog.getLayerGroupByName(ws2, "lg"));
        Assert.assertEquals((Object)lg2, (Object)this.catalog.getLayerGroupByName(ws2, "lg"));
        Assert.assertEquals((Object)lg2, (Object)this.catalog.getLayerGroupByName(ws2.getName() + ":lg"));
    }

    @Test
    public void testGetLayerGroups() {
        this.addLayerGroup();
        Assert.assertEquals((long)1L, (long)this.catalog.getLayerGroups().size());
        Assert.assertEquals((long)0L, (long)this.catalog.getLayerGroupsByWorkspace(this.ws.getName()).size());
        Assert.assertEquals((long)0L, (long)this.catalog.getLayerGroupsByWorkspace(this.ws).size());
        Assert.assertEquals((long)0L, (long)this.catalog.getLayerGroupsByWorkspace((WorkspaceInfo)null).size());
        LayerGroupInfo lg2 = this.catalog.getFactory().createLayerGroup();
        lg2.setWorkspace(this.catalog.getDefaultWorkspace());
        lg2.setName("layerGroup2");
        lg2.getLayers().add(this.l);
        lg2.getStyles().add(this.s);
        this.catalog.add(lg2);
        Assert.assertEquals((long)2L, (long)this.catalog.getLayerGroups().size());
        Assert.assertEquals((long)1L, (long)this.catalog.getLayerGroupsByWorkspace(this.ws.getName()).size());
        Assert.assertEquals((long)1L, (long)this.catalog.getLayerGroupsByWorkspace(this.ws).size());
        Assert.assertEquals((long)1L, (long)this.catalog.getLayerGroupsByWorkspace((WorkspaceInfo)null).size());
    }

    @Test
    public void testLayerGroupTitle() {
        this.addLayer();
        LayerGroupInfo lg2 = this.catalog.getFactory().createLayerGroup();
        lg2.setName("layerGroup2");
        lg2.setTitle("layerGroup2 title");
        lg2.getLayers().add(this.l);
        lg2.getStyles().add(this.s);
        this.catalog.add(lg2);
        Assert.assertEquals((long)1L, (long)this.catalog.getLayerGroups().size());
        lg2 = this.catalog.getLayerGroupByName("layerGroup2");
        Assert.assertEquals((Object)"layerGroup2 title", (Object)lg2.getTitle());
        lg2.setTitle("another title");
        this.catalog.save(lg2);
        lg2 = this.catalog.getLayerGroupByName("layerGroup2");
        Assert.assertEquals((Object)"another title", (Object)lg2.getTitle());
    }

    @Test
    public void testLayerGroupAbstract() {
        this.addLayer();
        LayerGroupInfo lg2 = this.catalog.getFactory().createLayerGroup();
        lg2.setName("layerGroup2");
        lg2.setAbstract("layerGroup2 abstract");
        lg2.getLayers().add(this.l);
        lg2.getStyles().add(this.s);
        this.catalog.add(lg2);
        Assert.assertEquals((long)1L, (long)this.catalog.getLayerGroups().size());
        lg2 = this.catalog.getLayerGroupByName("layerGroup2");
        Assert.assertEquals((Object)"layerGroup2 abstract", (Object)lg2.getAbstract());
        lg2.setAbstract("another abstract");
        this.catalog.save(lg2);
        lg2 = this.catalog.getLayerGroupByName("layerGroup2");
        Assert.assertEquals((Object)"another abstract", (Object)lg2.getAbstract());
    }

    @Test
    public void testLayerGroupType() {
        this.addLayer();
        LayerGroupInfo lg2 = this.catalog.getFactory().createLayerGroup();
        lg2.setWorkspace(null);
        lg2.setName("layerGroup2");
        lg2.setMode(LayerGroupInfo.Mode.NAMED);
        lg2.getLayers().add(this.l);
        lg2.getStyles().add(this.s);
        this.catalog.add(lg2);
        Assert.assertEquals((long)1L, (long)this.catalog.getLayerGroups().size());
        lg2 = this.catalog.getLayerGroupByName("layerGroup2");
        Assert.assertEquals((Object)LayerGroupInfo.Mode.NAMED, (Object)lg2.getMode());
        lg2.setMode(LayerGroupInfo.Mode.SINGLE);
        this.catalog.save(lg2);
        lg2 = this.catalog.getLayerGroupByName("layerGroup2");
        Assert.assertEquals((Object)LayerGroupInfo.Mode.SINGLE, (Object)lg2.getMode());
    }

    @Test
    public void testLayerGroupRootLayer() {
        this.addLayer();
        LayerGroupInfo lg2 = this.catalog.getFactory().createLayerGroup();
        lg2.setWorkspace(null);
        lg2.setName("layerGroup2");
        lg2.getLayers().add(this.l);
        lg2.getStyles().add(this.s);
        lg2.setRootLayer(this.l);
        lg2.setMode(LayerGroupInfo.Mode.SINGLE);
        try {
            this.catalog.add(lg2);
            Assert.fail((String)"only EO layer groups can have a root layer");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        lg2.setMode(LayerGroupInfo.Mode.NAMED);
        try {
            this.catalog.add(lg2);
            Assert.fail((String)"only EO layer groups can have a root layer");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        lg2.setMode(LayerGroupInfo.Mode.CONTAINER);
        try {
            this.catalog.add(lg2);
            Assert.fail((String)"only EO layer groups can have a root layer");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        lg2.setMode(LayerGroupInfo.Mode.EO);
        lg2.setRootLayer(null);
        try {
            this.catalog.add(lg2);
            Assert.fail((String)"EO layer groups must have a root layer");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        lg2.setRootLayer(this.l);
        try {
            this.catalog.add(lg2);
            Assert.fail((String)"EO layer groups must have a root layer style");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        lg2.setRootLayerStyle(this.s);
        this.catalog.add(lg2);
        Assert.assertEquals((long)1L, (long)this.catalog.getLayerGroups().size());
        lg2 = this.catalog.getLayerGroupByName("layerGroup2");
        Assert.assertEquals((Object)LayerGroupInfo.Mode.EO, (Object)lg2.getMode());
        Assert.assertEquals((Object)this.l, (Object)lg2.getRootLayer());
        Assert.assertEquals((Object)this.s, (Object)lg2.getRootLayerStyle());
    }

    @Test
    public void testLayerGroupNullLayerReferences() {
        this.addLayer();
        LayerGroupInfo lg = this.catalog.getFactory().createLayerGroup();
        lg.setWorkspace(null);
        lg.setName("layerGroup2");
        lg.getLayers().add(null);
        lg.getStyles().add(null);
        lg.getLayers().add(this.l);
        lg.getStyles().add(this.s);
        lg.getLayers().add(null);
        lg.getStyles().add(null);
        this.catalog.add(lg);
        LayerGroupInfo resolved = this.catalog.getLayerGroupByName("layerGroup2");
        Assert.assertEquals((long)1L, (long)resolved.layers().size());
        Assert.assertEquals((long)1L, (long)resolved.styles().size());
        Assert.assertEquals((Object)this.s, resolved.styles().get(0));
    }

    @Test
    public void testLayerGroupRenderingLayers() {
        this.addDataStore();
        this.addNamespace();
        FeatureTypeInfo ft1 = this.newFeatureType("ft1", this.ds);
        this.catalog.add((ResourceInfo)ft1);
        FeatureTypeInfo ft2 = this.newFeatureType("ft2", this.ds);
        this.catalog.add((ResourceInfo)ft2);
        FeatureTypeInfo ft3 = this.newFeatureType("ft3", this.ds);
        this.catalog.add((ResourceInfo)ft3);
        StyleInfo s1 = this.newStyle("s1", "s1Filename");
        this.catalog.add(s1);
        StyleInfo s2 = this.newStyle("s2", "s2Filename");
        this.catalog.add(s2);
        StyleInfo s3 = this.newStyle("s3", "s3Filename");
        this.catalog.add(s3);
        LayerInfo l1 = this.newLayer((ResourceInfo)ft1, s1, new StyleInfo[0]);
        this.catalog.add(l1);
        LayerInfo l2 = this.newLayer((ResourceInfo)ft2, s2, new StyleInfo[0]);
        this.catalog.add(l2);
        LayerInfo l3 = this.newLayer((ResourceInfo)ft3, s3, new StyleInfo[0]);
        this.catalog.add(l3);
        LayerGroupInfo lg2 = this.catalog.getFactory().createLayerGroup();
        lg2.setWorkspace(this.catalog.getDefaultWorkspace());
        lg2.setName("layerGroup2");
        lg2.getLayers().add(l1);
        lg2.getLayers().add(l2);
        lg2.getLayers().add(l3);
        lg2.getStyles().add(s1);
        lg2.getStyles().add(s2);
        lg2.getStyles().add(s3);
        lg2.setRootLayer(this.l);
        lg2.setRootLayerStyle(this.s);
        lg2.setMode(LayerGroupInfo.Mode.SINGLE);
        Assert.assertEquals((Object)lg2.getLayers(), (Object)lg2.layers());
        Assert.assertEquals((Object)lg2.getStyles(), (Object)lg2.styles());
        lg2.setMode(LayerGroupInfo.Mode.OPAQUE_CONTAINER);
        Assert.assertEquals((Object)lg2.getLayers(), (Object)lg2.layers());
        Assert.assertEquals((Object)lg2.getStyles(), (Object)lg2.styles());
        lg2.setMode(LayerGroupInfo.Mode.NAMED);
        Assert.assertEquals((Object)lg2.getLayers(), (Object)lg2.layers());
        Assert.assertEquals((Object)lg2.getStyles(), (Object)lg2.styles());
        lg2.setMode(LayerGroupInfo.Mode.CONTAINER);
        try {
            Assert.assertEquals((Object)lg2.getLayers(), (Object)lg2.layers());
            Assert.fail((String)"Layer group of Type Container can not be rendered");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            Assert.assertEquals((Object)lg2.getStyles(), (Object)lg2.styles());
            Assert.fail((String)"Layer group of Type Container can not be rendered");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertTrue((boolean)true);
        }
        lg2.setMode(LayerGroupInfo.Mode.EO);
        Assert.assertEquals((long)1L, (long)lg2.layers().size());
        Assert.assertEquals((long)1L, (long)lg2.styles().size());
        Assert.assertEquals((Object)this.l, lg2.layers().iterator().next());
        Assert.assertEquals((Object)this.s, lg2.styles().iterator().next());
    }

    @Test
    public void testRemoveLayerGroupInLayerGroup() throws Exception {
        this.addLayerGroup();
        LayerGroupInfo lg2 = this.catalog.getFactory().createLayerGroup();
        lg2.setName("layerGroup2");
        lg2.getLayers().add(this.lg);
        lg2.getStyles().add(this.s);
        this.catalog.add(lg2);
        try {
            this.catalog.remove(this.lg);
            Assert.fail((String)"should have failed because lg is in another lg");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.catalog.remove(lg2);
        this.catalog.remove(this.lg);
    }

    @Test
    public void testGet() {
        this.addDataStore();
        this.addNamespace();
        FeatureTypeInfo ft1 = this.newFeatureType("ft1", this.ds);
        ft1.getKeywords().add(new Keyword("kw1_ft1"));
        ft1.getKeywords().add(new Keyword("kw2_ft1"));
        ft1.getKeywords().add(new Keyword("repeatedKw"));
        FeatureTypeInfo ft2 = this.newFeatureType("ft2", this.ds);
        ft2.getKeywords().add(new Keyword("kw1_ft2"));
        ft2.getKeywords().add(new Keyword("kw2_ft2"));
        ft2.getKeywords().add(new Keyword("repeatedKw"));
        this.catalog.add((ResourceInfo)ft1);
        this.catalog.add((ResourceInfo)ft2);
        StyleInfo s1 = this.newStyle("s1", "s1Filename");
        this.catalog.add(s1);
        StyleInfo s2 = this.newStyle("s2", "s2Filename");
        this.catalog.add(s2);
        StyleInfo s3 = this.newStyle("s3", "s3Filename");
        this.catalog.add(s3);
        LayerInfo l1 = this.newLayer((ResourceInfo)ft1, s1, s2, s3);
        LayerInfo l2 = this.newLayer((ResourceInfo)ft2, s2, s1, s3);
        this.catalog.add(l1);
        this.catalog.add(l2);
        Filter filter = Predicates.acceptAll();
        try {
            this.catalog.get(null, filter);
            Assert.fail((String)"Expected precondition validation exception");
        }
        catch (RuntimeException nullCheck) {
            Assert.assertTrue((boolean)true);
        }
        try {
            this.catalog.get(FeatureTypeInfo.class, null);
            Assert.fail((String)"Expected precondition validation exception");
        }
        catch (RuntimeException nullCheck) {
            Assert.assertTrue((boolean)true);
        }
        try {
            this.catalog.get(FeatureTypeInfo.class, filter);
            Assert.fail((String)"Expected IAE on multiple results");
        }
        catch (IllegalArgumentException multipleResults) {
            Assert.assertTrue((boolean)true);
        }
        filter = Predicates.equal((String)"id", (Object)ft1.getId());
        FeatureTypeInfo featureTypeInfo = (FeatureTypeInfo)this.catalog.get(FeatureTypeInfo.class, filter);
        Assert.assertEquals((Object)ft1.getId(), (Object)featureTypeInfo.getId());
        filter = Predicates.equal((String)"name", (Object)ft2.getName());
        Assert.assertEquals((Object)ft2.getName(), (Object)((ResourceInfo)this.catalog.get(ResourceInfo.class, filter)).getName());
        filter = Predicates.equal((String)"keywords[1].value", (Object)((KeywordInfo)ft1.getKeywords().get(0)).getValue());
        Assert.assertEquals((Object)ft1.getName(), (Object)((ResourceInfo)this.catalog.get(ResourceInfo.class, filter)).getName());
        filter = Predicates.equal((String)"keywords[2]", ft2.getKeywords().get(1));
        Assert.assertEquals((Object)ft2.getName(), (Object)((FeatureTypeInfo)this.catalog.get(FeatureTypeInfo.class, filter)).getName());
        filter = Predicates.equal((String)"keywords[3].value", (Object)"repeatedKw");
        try {
            ((FeatureTypeInfo)this.catalog.get(FeatureTypeInfo.class, filter)).getName();
            Assert.fail((String)"Expected IAE on multiple results");
        }
        catch (IllegalArgumentException multipleResults) {
            Assert.assertTrue((boolean)true);
        }
        filter = Predicates.equal((String)"defaultStyle.filename", (Object)"s1Filename");
        Assert.assertEquals((Object)l1.getId(), (Object)((LayerInfo)this.catalog.get(LayerInfo.class, filter)).getId());
        filter = Predicates.equal((String)"defaultStyle.name", (Object)s2.getName());
        Assert.assertEquals((Object)l2.getId(), (Object)((LayerInfo)this.catalog.get(LayerInfo.class, filter)).getId());
        filter = Predicates.equal((String)"styles.id", (Object)s2.getId(), (MultiValuedFilter.MatchAction)MultiValuedFilter.MatchAction.ONE);
        Assert.assertEquals((Object)l1.getId(), (Object)((LayerInfo)this.catalog.get(LayerInfo.class, filter)).getId());
        filter = Predicates.equal((String)"styles.id", (Object)s3.getId(), (MultiValuedFilter.MatchAction)MultiValuedFilter.MatchAction.ANY);
        try {
            this.catalog.get(LayerInfo.class, filter);
            Assert.fail((String)"Expected IAE on multiple results");
        }
        catch (IllegalArgumentException multipleResults) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testListPredicate() {
        this.addDataStore();
        this.addNamespace();
        FeatureTypeInfo ft1 = this.newFeatureType("ft1", this.ds);
        this.catalog.add((ResourceInfo)ft1);
        FeatureTypeInfo ft2 = this.newFeatureType("ft2", this.ds);
        this.catalog.add((ResourceInfo)ft2);
        FeatureTypeInfo ft3 = this.newFeatureType("ft3", this.ds);
        this.catalog.add((ResourceInfo)ft3);
        ft1 = this.catalog.getFeatureType(ft1.getId());
        ft2 = this.catalog.getFeatureType(ft2.getId());
        ft3 = this.catalog.getFeatureType(ft3.getId());
        Filter filter = Predicates.acceptAll();
        HashSet expected = Sets.newHashSet((Object[])new FeatureTypeInfo[]{ft1, ft2, ft3});
        HashSet actual = Sets.newHashSet((Iterator)this.catalog.list(FeatureTypeInfo.class, filter));
        Assert.assertEquals((long)3L, (long)actual.size());
        Assert.assertEquals((Object)expected, (Object)actual);
        filter = Predicates.contains((String)"name", (String)"t");
        actual = Sets.newHashSet((Iterator)this.catalog.list(FeatureTypeInfo.class, filter));
        Assert.assertTrue((boolean)expected.equals(actual));
        Assert.assertEquals((Object)expected, (Object)actual);
        filter = Predicates.or((Filter)Predicates.contains((String)"name", (String)"t2"), (Filter)Predicates.contains((String)"name", (String)"t1"));
        expected = Sets.newHashSet((Object[])new FeatureTypeInfo[]{ft1, ft2});
        actual = Sets.newHashSet((Iterator)this.catalog.list(FeatureTypeInfo.class, filter));
        Assert.assertEquals((Object)expected, (Object)actual);
        StyleInfo s1 = this.newStyle("s1", "s1Filename");
        this.catalog.add(s1);
        StyleInfo s2 = this.newStyle("s2", "s2Filename");
        this.catalog.add(s2);
        StyleInfo s3 = this.newStyle("s3", "s3Filename");
        this.catalog.add(s3);
        StyleInfo s4 = this.newStyle("s4", "s4Filename");
        this.catalog.add(s4);
        StyleInfo s5 = this.newStyle("s5", "s5Filename");
        this.catalog.add(s5);
        StyleInfo s6 = this.newStyle("s6", "s6Filename");
        this.catalog.add(s6);
        LayerInfo l1 = this.newLayer((ResourceInfo)ft1, s1, new StyleInfo[0]);
        this.catalog.add(l1);
        LayerInfo l2 = this.newLayer((ResourceInfo)ft2, s2, s3, s4);
        this.catalog.add(l2);
        LayerInfo l3 = this.newLayer((ResourceInfo)ft3, s3, s5, s6);
        this.catalog.add(l3);
        filter = Predicates.contains((String)"styles.name", (String)"s6");
        expected = Sets.newHashSet((Object[])new LayerInfo[]{l3});
        actual = Sets.newHashSet((Iterator)this.catalog.list(LayerInfo.class, filter));
        Assert.assertEquals((Object)expected, (Object)actual);
        filter = Predicates.equal((String)"defaultStyle.name", (Object)"s1");
        expected = Sets.newHashSet((Object[])new LayerInfo[]{l1});
        actual = Sets.newHashSet((Iterator)this.catalog.list(LayerInfo.class, filter));
        Assert.assertEquals((Object)expected, (Object)actual);
        filter = Predicates.or((Filter)Predicates.contains((String)"styles.name", (String)"s6"), (Filter)Predicates.equal((String)"defaultStyle.name", (Object)"s1"));
        expected = Sets.newHashSet((Object[])new LayerInfo[]{l1, l3});
        actual = Sets.newHashSet((Iterator)this.catalog.list(LayerInfo.class, filter));
        Assert.assertEquals((Object)expected, (Object)actual);
        filter = Predicates.acceptAll();
        ArrayList naturalOrder = Lists.newArrayList((Iterator)this.catalog.list(LayerInfo.class, filter));
        Assert.assertEquals((long)3L, (long)naturalOrder.size());
        int offset = 0;
        int limit = 2;
        Assert.assertEquals(naturalOrder.subList(0, 2), (Object)Lists.newArrayList((Iterator)this.catalog.list(LayerInfo.class, filter, Integer.valueOf(offset), Integer.valueOf(limit), null)));
        offset = 1;
        Assert.assertEquals(naturalOrder.subList(1, 3), (Object)Lists.newArrayList((Iterator)this.catalog.list(LayerInfo.class, filter, Integer.valueOf(offset), Integer.valueOf(limit), null)));
        limit = 1;
        Assert.assertEquals(naturalOrder.subList(1, 2), (Object)Lists.newArrayList((Iterator)this.catalog.list(LayerInfo.class, filter, Integer.valueOf(offset), Integer.valueOf(limit), null)));
    }

    @Test
    public void testListPredicateExtended() {
        this.addDataStore();
        this.addNamespace();
        FilterFactory factory = CommonFactoryFinder.getFilterFactory();
        FeatureTypeInfo ft1 = this.newFeatureType("ft1", this.ds);
        this.catalog.add((ResourceInfo)ft1);
        FeatureTypeInfo ft2 = this.newFeatureType("ft2", this.ds);
        this.catalog.add((ResourceInfo)ft2);
        FeatureTypeInfo ft3 = this.newFeatureType("ft3", this.ds);
        this.catalog.add((ResourceInfo)ft3);
        ft1 = this.catalog.getFeatureType(ft1.getId());
        ft2 = this.catalog.getFeatureType(ft2.getId());
        ft3 = this.catalog.getFeatureType(ft3.getId());
        ft1.getKeywords().add(new Keyword("keyword1"));
        ft1.getKeywords().add(new Keyword("keyword2"));
        ft1.getKeywords().add(new Keyword("ft1"));
        ft1.setDescription("ft1 description");
        this.catalog.save((ResourceInfo)ft1);
        ft2.getKeywords().add(new Keyword("keyword1"));
        ft2.getKeywords().add(new Keyword("keyword1"));
        ft2.setDescription("ft2");
        this.catalog.save((ResourceInfo)ft2);
        ft3.getKeywords().add(new Keyword("ft3"));
        ft3.getKeywords().add(new Keyword("ft3"));
        ft3.setDescription("FT3");
        this.catalog.save((ResourceInfo)ft3);
        Filter filter = Predicates.acceptAll();
        filter = factory.equal((Expression)factory.literal((Object)ft1.getId()), (Expression)factory.property("id"), true);
        HashSet expected = Sets.newHashSet((Object[])new FeatureTypeInfo[]{ft1});
        HashSet actual = Sets.newHashSet((Iterator)this.catalog.list(ResourceInfo.class, filter));
        Assert.assertEquals((Object)expected, (Object)actual);
        filter = factory.equal((Expression)factory.literal((Object)"FT1"), (Expression)factory.property("name"), false);
        expected = Sets.newHashSet((Object[])new FeatureTypeInfo[]{ft1});
        actual = Sets.newHashSet((Iterator)this.catalog.list(ResourceInfo.class, filter));
        Assert.assertEquals((Object)expected, (Object)actual);
        filter = factory.equal((Expression)factory.property("name"), (Expression)factory.property("description"), true);
        expected = Sets.newHashSet((Object[])new FeatureTypeInfo[]{ft2});
        actual = Sets.newHashSet((Iterator)this.catalog.list(ResourceInfo.class, filter));
        Assert.assertEquals((Object)expected, (Object)actual);
        filter = factory.equal((Expression)factory.property("name"), (Expression)factory.property("description"), false);
        expected = Sets.newHashSet((Object[])new FeatureTypeInfo[]{ft2, ft3});
        actual = Sets.newHashSet((Iterator)this.catalog.list(ResourceInfo.class, filter));
        Assert.assertEquals((Object)expected, (Object)actual);
        filter = factory.equal((Expression)factory.literal((Object)new Keyword("keyword1")), (Expression)factory.property("keywords"), true, MultiValuedFilter.MatchAction.ANY);
        expected = Sets.newHashSet((Object[])new FeatureTypeInfo[]{ft1, ft2});
        actual = Sets.newHashSet((Iterator)this.catalog.list(FeatureTypeInfo.class, filter));
        Assert.assertEquals((Object)expected, (Object)actual);
        filter = factory.equal((Expression)factory.literal((Object)new Keyword("keyword1")), (Expression)factory.property("keywords"), true, MultiValuedFilter.MatchAction.ALL);
        expected = Sets.newHashSet((Object[])new FeatureTypeInfo[]{ft2});
        actual = Sets.newHashSet((Iterator)this.catalog.list(FeatureTypeInfo.class, filter));
        Assert.assertEquals((Object)expected, (Object)actual);
        filter = factory.equal((Expression)factory.literal((Object)new Keyword("keyword1")), (Expression)factory.property("keywords"), true, MultiValuedFilter.MatchAction.ONE);
        expected = Sets.newHashSet((Object[])new FeatureTypeInfo[]{ft1});
        actual = Sets.newHashSet((Iterator)this.catalog.list(FeatureTypeInfo.class, filter));
        Assert.assertEquals((Object)expected, (Object)actual);
        filter = factory.like((Expression)factory.property("keywords"), "key*d1", "*", "?", "\\", true, MultiValuedFilter.MatchAction.ANY);
        expected = Sets.newHashSet((Object[])new FeatureTypeInfo[]{ft1, ft2});
        actual = Sets.newHashSet((Iterator)this.catalog.list(FeatureTypeInfo.class, filter));
        Assert.assertEquals((Object)expected, (Object)actual);
        filter = factory.like((Expression)factory.property("keywords"), "key*d1", "*", "?", "\\", true, MultiValuedFilter.MatchAction.ALL);
        expected = Sets.newHashSet((Object[])new FeatureTypeInfo[]{ft2});
        actual = Sets.newHashSet((Iterator)this.catalog.list(FeatureTypeInfo.class, filter));
        Assert.assertEquals((Object)expected, (Object)actual);
        filter = factory.like((Expression)factory.property("keywords"), "key*d1", "*", "?", "\\", true, MultiValuedFilter.MatchAction.ONE);
        expected = Sets.newHashSet((Object[])new FeatureTypeInfo[]{ft1});
        actual = Sets.newHashSet((Iterator)this.catalog.list(FeatureTypeInfo.class, filter));
        Assert.assertEquals((Object)expected, (Object)actual);
        ArrayList<String> values = new ArrayList<String>();
        values.add("ft1");
        values.add("ft2");
        filter = factory.equal((Expression)factory.literal(values), (Expression)factory.property("name"), true, MultiValuedFilter.MatchAction.ANY);
        expected = Sets.newHashSet((Object[])new FeatureTypeInfo[]{ft1, ft2});
        actual = Sets.newHashSet((Iterator)this.catalog.list(FeatureTypeInfo.class, filter));
        Assert.assertEquals((Object)expected, (Object)actual);
        values = new ArrayList();
        values.add("ft1");
        values.add("ft1");
        filter = factory.equal((Expression)factory.literal(values), (Expression)factory.property("name"), true, MultiValuedFilter.MatchAction.ALL);
        expected = Sets.newHashSet((Object[])new FeatureTypeInfo[]{ft1});
        actual = Sets.newHashSet((Iterator)this.catalog.list(FeatureTypeInfo.class, filter));
        Assert.assertEquals((Object)expected, (Object)actual);
        values = new ArrayList();
        values.add("ft1");
        values.add("ft2");
        filter = factory.equal((Expression)factory.literal(values), (Expression)factory.property("name"), true, MultiValuedFilter.MatchAction.ALL);
        expected = Sets.newHashSet();
        actual = Sets.newHashSet((Iterator)this.catalog.list(FeatureTypeInfo.class, filter));
        Assert.assertEquals((Object)expected, (Object)actual);
        values = new ArrayList();
        values.add("ft1");
        values.add("ft1");
        values.add("ft2");
        filter = factory.equal((Expression)factory.literal(values), (Expression)factory.property("name"), true, MultiValuedFilter.MatchAction.ONE);
        expected = Sets.newHashSet((Object[])new FeatureTypeInfo[]{ft2});
        actual = Sets.newHashSet((Iterator)this.catalog.list(FeatureTypeInfo.class, filter));
        Assert.assertEquals((Object)expected, (Object)actual);
        values = new ArrayList();
        values.add((String)new Keyword("keyword1"));
        values.add((String)new Keyword("keyword2"));
        filter = factory.equal((Expression)factory.literal(values), (Expression)factory.property("keywords"), true, MultiValuedFilter.MatchAction.ANY);
        expected = Sets.newHashSet((Object[])new FeatureTypeInfo[]{ft1, ft2});
        actual = Sets.newHashSet((Iterator)this.catalog.list(FeatureTypeInfo.class, filter));
        Assert.assertEquals((Object)expected, (Object)actual);
        values = new ArrayList();
        values.add((String)new Keyword("keyword1"));
        values.add((String)new Keyword("keyword1"));
        filter = factory.equal((Expression)factory.literal(values), (Expression)factory.property("keywords"), true, MultiValuedFilter.MatchAction.ALL);
        expected = Sets.newHashSet((Object[])new FeatureTypeInfo[]{ft2});
        actual = Sets.newHashSet((Iterator)this.catalog.list(FeatureTypeInfo.class, filter));
        Assert.assertEquals((Object)expected, (Object)actual);
        values = new ArrayList();
        values.add((String)new Keyword("keyword1"));
        values.add((String)new Keyword("blah"));
        filter = factory.equal((Expression)factory.literal(values), (Expression)factory.property("keywords"), true, MultiValuedFilter.MatchAction.ONE);
        expected = Sets.newHashSet((Object[])new FeatureTypeInfo[]{ft1});
        actual = Sets.newHashSet((Iterator)this.catalog.list(FeatureTypeInfo.class, filter));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testOrderBy() {
        this.addDataStore();
        this.addNamespace();
        FeatureTypeInfo ft1 = this.newFeatureType("ft1", this.ds);
        FeatureTypeInfo ft2 = this.newFeatureType("ft2", this.ds);
        FeatureTypeInfo ft3 = this.newFeatureType("ft3", this.ds);
        ft2.getKeywords().add(new Keyword("keyword1"));
        ft2.getKeywords().add(new Keyword("keyword2"));
        this.catalog.add((ResourceInfo)ft1);
        this.catalog.add((ResourceInfo)ft2);
        this.catalog.add((ResourceInfo)ft3);
        StyleInfo s1 = this.newStyle("s1", "s1Filename");
        this.catalog.add(s1);
        StyleInfo s2 = this.newStyle("s2", "s2Filename");
        this.catalog.add(s2);
        StyleInfo s3 = this.newStyle("s3", "s3Filename");
        this.catalog.add(s3);
        StyleInfo s4 = this.newStyle("s4", "s4Filename");
        this.catalog.add(s4);
        StyleInfo s5 = this.newStyle("s5", "s5Filename");
        this.catalog.add(s5);
        StyleInfo s6 = this.newStyle("s6", "s6Filename");
        this.catalog.add(s6);
        LayerInfo l1 = this.newLayer((ResourceInfo)ft1, s1, new StyleInfo[0]);
        LayerInfo l2 = this.newLayer((ResourceInfo)ft2, s1, s3, s4);
        LayerInfo l3 = this.newLayer((ResourceInfo)ft3, s2, s5, s6);
        this.catalog.add(l1);
        this.catalog.add(l2);
        this.catalog.add(l3);
        Assert.assertEquals((long)3L, (long)this.catalog.getLayers().size());
        Filter filter = Predicates.acceptAll();
        SortBy sortOrder = Predicates.asc((String)"resource.name");
        ArrayList expected = Lists.newArrayList((Object[])new LayerInfo[]{l1, l2, l3});
        this.testOrderBy(LayerInfo.class, filter, null, null, sortOrder, expected);
        sortOrder = Predicates.desc((String)"resource.name");
        expected = Lists.newArrayList((Object[])new LayerInfo[]{l3, l2, l1});
        this.testOrderBy(LayerInfo.class, filter, null, null, sortOrder, expected);
        sortOrder = Predicates.asc((String)"defaultStyle.name");
        expected = Lists.newArrayList((Object[])new LayerInfo[]{l1, l2, l3});
        this.testOrderBy(LayerInfo.class, filter, null, null, sortOrder, expected);
        sortOrder = Predicates.desc((String)"defaultStyle.name");
        expected = Lists.newArrayList((Object[])new LayerInfo[]{l3, l2, l1});
        this.testOrderBy(LayerInfo.class, filter, null, null, sortOrder, expected);
        expected = Lists.newArrayList((Object[])new LayerInfo[]{l2, l1});
        this.testOrderBy(LayerInfo.class, filter, 1, null, sortOrder, expected);
        expected = Lists.newArrayList((Object[])new LayerInfo[]{l2});
        this.testOrderBy(LayerInfo.class, filter, 1, 1, sortOrder, expected);
        sortOrder = Predicates.asc((String)"defaultStyle.name");
        expected = Lists.newArrayList((Object[])new LayerInfo[]{l2, l3});
        this.testOrderBy(LayerInfo.class, filter, 1, 10, sortOrder, expected);
        filter = Predicates.equal((String)"styles.name", (Object)s3.getName());
        expected = Lists.newArrayList((Object[])new LayerInfo[]{l2});
        this.testOrderBy(LayerInfo.class, filter, 0, 10, sortOrder, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends CatalogInfo> void testOrderBy(Class<T> clazz, Filter filter, Integer offset, Integer limit, SortBy sortOrder, List<T> expected) {
        CatalogPropertyAccessor pe = new CatalogPropertyAccessor();
        ArrayList<Object> props = new ArrayList<Object>();
        ArrayList<Object> actual = new ArrayList<Object>();
        String sortProperty = sortOrder.getPropertyName().getPropertyName();
        for (CatalogInfo info : expected) {
            Object pval = pe.getProperty((Object)info, sortProperty);
            props.add(pval);
        }
        try (CloseableIterator it = this.catalog.list(clazz, filter, offset, limit, sortOrder);){
            while (it.hasNext()) {
                Object property = pe.getProperty(it.next(), sortProperty);
                actual.add(property);
            }
        }
        Assert.assertEquals(props, actual);
    }

    @Test
    public void testFullTextSearch() {
        this.ft.setTitle("Global .5 deg Air Temperature [C]");
        this.cv.setTitle("Global .5 deg Dewpoint Depression [C]");
        this.ft.setDescription("FeatureType description");
        this.ft.setAbstract("GeoServer OpenSource GIS");
        this.cv.setDescription("Coverage description");
        this.cv.setAbstract("GeoServer uses GeoTools");
        this.l.setResource((ResourceInfo)this.ft);
        this.addLayer();
        this.catalog.add((StoreInfo)this.cs);
        this.catalog.add((ResourceInfo)this.cv);
        LayerInfo l2 = this.newLayer((ResourceInfo)this.cv, this.s, new StyleInfo[0]);
        this.catalog.add(l2);
        Filter filter = Predicates.fullTextSearch((String)"Description");
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new ResourceInfo[]{this.ft, this.cv}), this.asSet(this.catalog.list(ResourceInfo.class, filter)));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new FeatureTypeInfo[]{this.ft}), this.asSet(this.catalog.list(FeatureTypeInfo.class, filter)));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new CoverageInfo[]{this.cv}), this.asSet(this.catalog.list(CoverageInfo.class, filter)));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new LayerInfo[]{this.l, l2}), this.asSet(this.catalog.list(LayerInfo.class, filter)));
        filter = Predicates.fullTextSearch((String)"opensource");
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new LayerInfo[]{this.l}), this.asSet(this.catalog.list(LayerInfo.class, filter)));
        filter = Predicates.fullTextSearch((String)"geotools");
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new LayerInfo[]{l2}), this.asSet(this.catalog.list(LayerInfo.class, filter)));
        filter = Predicates.fullTextSearch((String)"Global");
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new LayerInfo[]{this.l, l2}), this.asSet(this.catalog.list(LayerInfo.class, filter)));
        filter = Predicates.fullTextSearch((String)"Temperature");
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new LayerInfo[]{this.l}), this.asSet(this.catalog.list(LayerInfo.class, filter)));
        filter = Predicates.fullTextSearch((String)"Depression");
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new LayerInfo[]{l2}), this.asSet(this.catalog.list(LayerInfo.class, filter)));
    }

    @Test
    public void testFullTextSearchLayerGroupTitle() {
        this.addLayer();
        this.lg.setTitle("LayerGroup title");
        this.catalog.add(this.lg);
        Filter filter = Predicates.fullTextSearch((String)"title");
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new LayerGroupInfo[]{this.lg}), this.asSet(this.catalog.list(LayerGroupInfo.class, filter)));
    }

    @Test
    public void testFullTextSearchLayerGroupName() {
        this.addLayer();
        this.catalog.add(this.lg);
        Filter filter = Predicates.fullTextSearch((String)"Group");
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new LayerGroupInfo[]{this.lg}), this.asSet(this.catalog.list(LayerGroupInfo.class, filter)));
    }

    @Test
    public void testFullTextSearchLayerGroupAbstract() {
        this.addLayer();
        this.lg.setAbstract("GeoServer OpenSource GIS");
        this.catalog.add(this.lg);
        Filter filter = Predicates.fullTextSearch((String)"geoserver");
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new LayerGroupInfo[]{this.lg}), this.asSet(this.catalog.list(LayerGroupInfo.class, filter)));
    }

    @Test
    public void testFullTextSearchKeywords() {
        this.ft.getKeywords().add(new Keyword("air_temp"));
        this.ft.getKeywords().add(new Keyword("temperatureAir"));
        this.cv.getKeywords().add(new Keyword("dwpt_dprs"));
        this.cv.getKeywords().add(new Keyword("temperatureDewpointDepression"));
        this.l.setResource((ResourceInfo)this.ft);
        this.addLayer();
        this.catalog.add((StoreInfo)this.cs);
        this.catalog.add((ResourceInfo)this.cv);
        LayerInfo l2 = this.newLayer((ResourceInfo)this.cv, this.s, new StyleInfo[0]);
        this.catalog.add(l2);
        Filter filter = Predicates.fullTextSearch((String)"temperature");
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new LayerInfo[]{this.l, l2}), this.asSet(this.catalog.list(LayerInfo.class, filter)));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new ResourceInfo[]{this.ft, this.cv}), this.asSet(this.catalog.list(ResourceInfo.class, filter)));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new FeatureTypeInfo[]{this.ft}), this.asSet(this.catalog.list(FeatureTypeInfo.class, filter)));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new CoverageInfo[]{this.cv}), this.asSet(this.catalog.list(CoverageInfo.class, filter)));
        filter = Predicates.fullTextSearch((String)"air");
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new LayerInfo[]{this.l}), this.asSet(this.catalog.list(LayerInfo.class, filter)));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new FeatureTypeInfo[]{this.ft}), this.asSet(this.catalog.list(ResourceInfo.class, filter)));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new FeatureTypeInfo[]{this.ft}), this.asSet(this.catalog.list(FeatureTypeInfo.class, filter)));
        Assert.assertEquals((Object)Sets.newHashSet(), this.asSet(this.catalog.list(CoverageInfo.class, filter)));
        filter = Predicates.fullTextSearch((String)"dewpoint");
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new LayerInfo[]{l2}), this.asSet(this.catalog.list(LayerInfo.class, filter)));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new CoverageInfo[]{this.cv}), this.asSet(this.catalog.list(ResourceInfo.class, filter)));
        Assert.assertEquals((Object)Sets.newHashSet(), this.asSet(this.catalog.list(FeatureTypeInfo.class, filter)));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new CoverageInfo[]{this.cv}), this.asSet(this.catalog.list(CoverageInfo.class, filter)));
        filter = Predicates.fullTextSearch((String)"pressure");
        Assert.assertEquals((Object)Sets.newHashSet(), this.asSet(this.catalog.list(LayerInfo.class, filter)));
        Assert.assertEquals((Object)Sets.newHashSet(), this.asSet(this.catalog.list(ResourceInfo.class, filter)));
        Assert.assertEquals((Object)Sets.newHashSet(), this.asSet(this.catalog.list(FeatureTypeInfo.class, filter)));
        Assert.assertEquals((Object)Sets.newHashSet(), this.asSet(this.catalog.list(CoverageInfo.class, filter)));
    }

    @Test
    public void testFullTextSearchAddedKeyword() {
        this.ft.getKeywords().add(new Keyword("air_temp"));
        this.ft.getKeywords().add(new Keyword("temperatureAir"));
        this.l.setResource((ResourceInfo)this.ft);
        this.addLayer();
        LayerInfo lproxy = this.catalog.getLayer(this.l.getId());
        FeatureTypeInfo ftproxy = (FeatureTypeInfo)lproxy.getResource();
        ftproxy.getKeywords().add(new Keyword("newKeyword"));
        this.catalog.save((ResourceInfo)ftproxy);
        Filter filter = Predicates.fullTextSearch((String)"newKeyword");
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new FeatureTypeInfo[]{ftproxy}), this.asSet(this.catalog.list(FeatureTypeInfo.class, filter)));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new LayerInfo[]{lproxy}), this.asSet(this.catalog.list(LayerInfo.class, filter)));
    }

    private <T> Set<T> asSet(CloseableIterator<T> list) {
        ImmutableSet set;
        try {
            set = ImmutableSet.copyOf(list);
        }
        finally {
            list.close();
        }
        return set;
    }

    protected LayerInfo newLayer(ResourceInfo resource, StyleInfo defStyle, StyleInfo ... extraStyles) {
        LayerInfo l2 = this.catalog.getFactory().createLayer();
        l2.setResource(resource);
        l2.setDefaultStyle(defStyle);
        if (extraStyles != null) {
            for (StyleInfo es : extraStyles) {
                l2.getStyles().add(es);
            }
        }
        return l2;
    }

    protected StyleInfo newStyle(String name, String fileName) {
        StyleInfo s2 = this.catalog.getFactory().createStyle();
        s2.setName(name);
        s2.setFilename(fileName);
        return s2;
    }

    protected FeatureTypeInfo newFeatureType(String name, DataStoreInfo ds) {
        FeatureTypeInfo ft2 = this.catalog.getFactory().createFeatureType();
        ft2.setNamespace(this.ns);
        ft2.setName(name);
        ft2.setStore((StoreInfo)ds);
        return ft2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentCatalogModification() throws Exception {
        Logger logger = Logging.getLogger(CatalogImpl.class);
        int tasks = 8;
        ExecutorService executor = Executors.newFixedThreadPool(4);
        Level previousLevel = logger.getLevel();
        new ArrayList<CatalogListener>(this.catalog.getListeners()).forEach(l -> this.catalog.removeListener(l));
        try {
            int i;
            logger.setLevel(Level.OFF);
            ExecutorCompletionService completionService = new ExecutorCompletionService(executor);
            for (i = 0; i < 8; ++i) {
                completionService.submit(() -> {
                    ArrayList<TestListener> listeners = new ArrayList<TestListener>();
                    for (int j = 0; j < 3; ++j) {
                        TestListener tl = new TestListener();
                        listeners.add(tl);
                        this.catalog.addListener((CatalogListener)tl);
                    }
                    CoverageInfoImpl catalogInfo = new CoverageInfoImpl();
                    this.catalog.fireRemoved((CatalogInfo)catalogInfo);
                    for (TestListener testListener : listeners) {
                        Assert.assertTrue((String)"Did not find the expected even in the listener", (boolean)testListener.removed.stream().anyMatch(arg_0 -> CatalogImplTest.lambda$testConcurrentCatalogModification$1((CatalogInfo)catalogInfo, arg_0)));
                    }
                    listeners.forEach(l -> this.catalog.removeListener((CatalogListener)l));
                }, null);
            }
            for (i = 0; i < 8; ++i) {
                completionService.take().get();
            }
        }
        finally {
            executor.shutdown();
            logger.setLevel(previousLevel);
        }
    }

    @Test
    public void testChangeLayerGroupOrder() {
        this.addLayerGroup();
        FeatureTypeInfo ft2 = this.catalog.getFactory().createFeatureType();
        ft2.setName("ft2Name");
        ft2.setStore((StoreInfo)this.ds);
        ft2.setNamespace(this.ns);
        this.catalog.add((ResourceInfo)ft2);
        LayerInfo l2 = this.catalog.getFactory().createLayer();
        l2.setResource((ResourceInfo)ft2);
        l2.setDefaultStyle(this.s);
        this.catalog.add(l2);
        LayerGroupInfo group = this.catalog.getLayerGroupByName(this.lg.getName());
        group.getLayers().add(l2);
        group.getStyles().add(null);
        this.catalog.save(group);
        group = this.catalog.getLayerGroupByName(this.lg.getName());
        PublishedInfo pi = (PublishedInfo)group.getLayers().remove(1);
        group.getLayers().add(0, pi);
        this.catalog.save(group);
        StyleInfo s2 = this.catalog.getFactory().createStyle();
        s2.setName("s2Name");
        s2.setFilename("s2Filename");
        this.catalog.add(s2);
        LayerInfo ll = this.catalog.getLayerByName(this.l.prefixedName());
        ll.setDefaultStyle(this.catalog.getStyleByName(s2.getName()));
        this.catalog.save(ll);
        LayerGroupInfo g1 = this.catalog.getFacade().getLayerGroupByName(this.lg.getName());
        LayerGroupInfo g2 = this.catalog.getFacade().getLayerGroupByName(this.lg.getName());
        Assert.assertTrue((boolean)LayerGroupInfo.equals((LayerGroupInfo)g1, (Object)g2));
    }

    private static /* synthetic */ boolean lambda$testConcurrentCatalogModification$1(CatalogInfo catalogInfo, CatalogRemoveEvent event) {
        return event.getSource() == catalogInfo;
    }

    class LayerAddRunner
    extends RunnerBase {
        private int idx;

        protected LayerAddRunner(CountDownLatch ready, CountDownLatch done, int idx) {
            super(ready, done);
            this.idx = idx;
        }

        @Override
        protected void runInternal() throws Exception {
            CatalogFactory factory = CatalogImplTest.this.catalog.getFactory();
            for (int i = 0; i < CatalogImplTest.this.GET_LAYER_BY_ID_WITH_CONCURRENT_ADD_TEST_COUNT; ++i) {
                String name = "LAYER-" + i + "-" + this.idx;
                FeatureTypeInfo resource = factory.createFeatureType();
                resource.setName(name);
                resource.setNamespace(CatalogImplTest.this.ns);
                resource.setStore((StoreInfo)CatalogImplTest.this.ds);
                CatalogImplTest.this.catalog.add((ResourceInfo)resource);
                LayerInfo layer = factory.createLayer();
                layer.setResource((ResourceInfo)resource);
                layer.setName(name);
                CatalogImplTest.this.catalog.add(layer);
            }
        }
    }

    static class ExceptionThrowingListener
    implements CatalogListener {
        public boolean throwCatalogException;

        ExceptionThrowingListener() {
        }

        public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
            if (this.throwCatalogException) {
                throw new CatalogException();
            }
            throw new RuntimeException();
        }

        public void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
        }

        public void handlePostModifyEvent(CatalogPostModifyEvent event) throws CatalogException {
        }

        public void handleRemoveEvent(CatalogRemoveEvent event) throws CatalogException {
        }

        public void reloaded() {
        }
    }

    static class TestListener
    implements CatalogListener {
        public List<CatalogAddEvent> added = new CopyOnWriteArrayList<CatalogAddEvent>();
        public List<CatalogModifyEvent> modified = new CopyOnWriteArrayList<CatalogModifyEvent>();
        public List<CatalogPostModifyEvent> postModified = new CopyOnWriteArrayList<CatalogPostModifyEvent>();
        public List<CatalogRemoveEvent> removed = new CopyOnWriteArrayList<CatalogRemoveEvent>();

        TestListener() {
        }

        public void handleAddEvent(CatalogAddEvent event) {
            this.added.add(event);
        }

        public void handleModifyEvent(CatalogModifyEvent event) {
            this.modified.add(event);
        }

        public void handlePostModifyEvent(CatalogPostModifyEvent event) {
            this.postModified.add(event);
        }

        public void handleRemoveEvent(CatalogRemoveEvent event) {
            this.removed.add(event);
        }

        public void reloaded() {
        }
    }
}

