/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.io.InputStream;
import java.io.OutputStream;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.resource.Resource;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CatalogProxiesTest
extends GeoServerSystemTestSupport {
    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpVectorLayer(SystemTestData.BUILDINGS);
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        Document dom;
        super.onSetUp(testData);
        LayerInfo li = this.getCatalog().getLayerByName(this.getLayerId(SystemTestData.BUILDINGS));
        Resource resource = this.getDataDirectory().config(li);
        try (InputStream is = resource.in();){
            dom = this.dom(resource.in());
        }
        Element defaultStyle = (Element)dom.getElementsByTagName("defaultStyle").item(0);
        Element defaultStyleId = (Element)defaultStyle.getElementsByTagName("id").item(0);
        defaultStyleId.setTextContent("danglingReference");
        try (OutputStream os = resource.out();){
            this.print(dom, os);
        }
        this.getGeoServer().reload();
    }

    @Test
    public void testDanglingReferenceOnModificationProxy() {
        LayerInfo li = this.getCatalog().getLayerByName(this.getLayerId(SystemTestData.BUILDINGS));
        Assert.assertNull((Object)li.getDefaultStyle());
    }

    @Test
    public void testDanglingReferenceEqualsHashcode() {
        LayerInfo li = this.getCatalog().getLayerByName(this.getLayerId(SystemTestData.BUILDINGS));
        Assert.assertEquals((long)li.hashCode(), (long)li.hashCode());
        Assert.assertTrue((boolean)li.equals(li));
    }
}

