/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.SettingsInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.LocalPublished;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.ows.Request;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalWorkspaceLayersTest
extends GeoServerSystemTestSupport {
    static final String GLOBAL_GROUP = "globalGroup";
    static final String GLOBAL_GROUP2 = "globalGroup2";
    static final String NESTED_GROUP = "nestedGroup";
    static final String LOCAL_GROUP = "localGroup";
    Catalog catalog;

    @Before
    public void setUpInternal() {
        this.catalog = this.getCatalog();
        LocalPublished.remove();
        LocalWorkspace.remove();
        Dispatcher.REQUEST.remove();
        this.cleanupGroupByName(GLOBAL_GROUP);
        this.cleanupGroupByName(GLOBAL_GROUP2);
        this.cleanupGroupByName(NESTED_GROUP);
        this.cleanupGroupByName(LOCAL_GROUP);
    }

    private void cleanupGroupByName(String name) {
        for (LayerGroupInfo lg : new ArrayList(this.catalog.getLayerGroups())) {
            if (!lg.getName().equals(name)) continue;
            this.catalog.remove(lg);
        }
    }

    @Test
    public void testGroupLayerInWorkspace() {
        WorkspaceInfo workspace = this.catalog.getWorkspaceByName("sf");
        WorkspaceInfo workspace2 = this.catalog.getWorkspaceByName("cite");
        CatalogFactory factory = this.catalog.getFactory();
        LayerGroupInfo globalGroup = factory.createLayerGroup();
        globalGroup.setName(GLOBAL_GROUP);
        globalGroup.setWorkspace(workspace2);
        globalGroup.getLayers().add(this.catalog.getLayerByName("Lakes"));
        globalGroup.getStyles().add(null);
        this.catalog.add(globalGroup);
        LayerGroupInfo localGroup = factory.createLayerGroup();
        localGroup.setName(LOCAL_GROUP);
        localGroup.setWorkspace(workspace);
        localGroup.getLayers().add(this.catalog.getLayerByName("GenericEntity"));
        localGroup.getStyles().add(null);
        this.catalog.add(localGroup);
        String localName = localGroup.prefixedName();
        Assert.assertEquals((Object)"sf:localGroup", (Object)localName);
        Assert.assertEquals((long)2L, (long)this.catalog.getLayerGroups().size());
        LocalWorkspace.set((WorkspaceInfo)workspace2);
        Assert.assertNull((Object)this.catalog.getLayerGroupByName(LOCAL_GROUP));
        LocalWorkspace.remove();
        LocalWorkspace.set((WorkspaceInfo)workspace);
        Assert.assertNotNull((Object)this.catalog.getLayerGroupByName(LOCAL_GROUP));
        Assert.assertEquals((long)1L, (long)this.catalog.getLayerGroups().size());
        Assert.assertEquals((Object)LOCAL_GROUP, (Object)this.catalog.getLayerGroupByName(LOCAL_GROUP).prefixedName());
        GeoServer gs = this.getGeoServer();
        SettingsInfo settings = gs.getFactory().createSettings();
        settings.setLocalWorkspaceIncludesPrefix(true);
        settings.setWorkspace(workspace);
        gs.add(settings);
        Assert.assertEquals((Object)"sf:localGroup", (Object)this.catalog.getLayerGroupByName(LOCAL_GROUP).prefixedName());
        Assert.assertEquals((Object)"sf:localGroup", (Object)((LayerGroupInfo)this.catalog.getLayerGroups().get(0)).prefixedName());
        gs.remove(settings);
        LocalWorkspace.remove();
    }

    @Test
    public void testLayersInLocalWorkspace() {
        WorkspaceInfo sf = this.catalog.getWorkspaceByName("sf");
        WorkspaceInfo cite = this.catalog.getWorkspaceByName("cite");
        CatalogFactory factory = this.catalog.getFactory();
        DataStoreInfo citeStore = factory.createDataStore();
        citeStore.setEnabled(true);
        citeStore.setName("globalStore");
        citeStore.setWorkspace(cite);
        this.catalog.add((StoreInfo)citeStore);
        FeatureTypeInfo citeFeatureType = factory.createFeatureType();
        citeFeatureType.setName("citeLayer");
        citeFeatureType.setStore((StoreInfo)citeStore);
        citeFeatureType.setNamespace(this.catalog.getNamespaceByPrefix("cite"));
        this.catalog.add((ResourceInfo)citeFeatureType);
        LayerInfo citeLayer = factory.createLayer();
        citeLayer.setResource((ResourceInfo)citeFeatureType);
        citeLayer.setEnabled(true);
        this.catalog.add(citeLayer);
        Assert.assertNotNull((Object)this.catalog.getLayerByName("citeLayer"));
        Assert.assertEquals((Object)"cite:citeLayer", (Object)this.catalog.getLayerByName("citeLayer").prefixedName());
        DataStoreInfo sfStore = factory.createDataStore();
        sfStore.setEnabled(true);
        sfStore.setName("localStore");
        sfStore.setWorkspace(sf);
        this.catalog.add((StoreInfo)sfStore);
        FeatureTypeInfo sfFeatureType = factory.createFeatureType();
        sfFeatureType.setName("sfLayer");
        sfFeatureType.setStore((StoreInfo)sfStore);
        sfFeatureType.setNamespace(this.catalog.getNamespaceByPrefix("sf"));
        this.catalog.add((ResourceInfo)sfFeatureType);
        LayerInfo sfLayer = factory.createLayer();
        sfLayer.setResource((ResourceInfo)sfFeatureType);
        sfLayer.setEnabled(true);
        this.catalog.add(sfLayer);
        Assert.assertNotNull((Object)this.catalog.getLayerByName("citeLayer"));
        Assert.assertNotNull((Object)this.catalog.getLayerByName("sfLayer"));
        LocalWorkspace.set((WorkspaceInfo)sf);
        Assert.assertNull((Object)this.catalog.getLayerByName("citeLayer"));
        Assert.assertNotNull((Object)this.catalog.getLayerByName("sfLayer"));
        Assert.assertEquals((Object)"sfLayer", (Object)this.catalog.getLayerByName("sfLayer").prefixedName());
        LocalWorkspace.remove();
        LocalWorkspace.set((WorkspaceInfo)cite);
        Assert.assertNull((Object)this.catalog.getLayerByName("sfLayer"));
        Assert.assertNotNull((Object)this.catalog.getLayerByName("citeLayer"));
        Assert.assertEquals((Object)"citeLayer", (Object)this.catalog.getLayerByName("citeLayer").prefixedName());
        LocalWorkspace.remove();
    }

    @Test
    public void testGlobalGroupSpecificRequest() {
        CatalogFactory factory = this.catalog.getFactory();
        LayerGroupInfo globalGroup = factory.createLayerGroup();
        globalGroup.setName(GLOBAL_GROUP);
        globalGroup.getLayers().add(this.getBuildingsLayer());
        globalGroup.getLayers().add(this.getAggregateGeoFeatureLayer());
        globalGroup.getStyles().add(null);
        globalGroup.getStyles().add(null);
        this.catalog.add(globalGroup);
        LayerGroupInfo globalGroup2 = factory.createLayerGroup();
        globalGroup2.setName(GLOBAL_GROUP2);
        globalGroup2.getLayers().add(this.getBridgesLayer());
        globalGroup2.getStyles().add(null);
        this.catalog.add(globalGroup2);
        LocalPublished.set((PublishedInfo)this.catalog.getLayerGroupByName(GLOBAL_GROUP));
        Assert.assertNull((Object)this.catalog.getLayerByName(this.getLayerId(SystemTestData.BASIC_POLYGONS)));
        Assert.assertNull((Object)this.getBridgesLayer());
        Assert.assertNull((Object)this.catalog.getLayerGroupByName(GLOBAL_GROUP2));
        Assert.assertNotNull((Object)this.getBuildingsLayer());
        Assert.assertNotNull((Object)this.getAggregateGeoFeatureLayer());
        Assert.assertNotNull((Object)this.catalog.getLayerGroupByName(GLOBAL_GROUP));
        List layers = this.catalog.getLayers();
        Assert.assertEquals((long)2L, (long)layers.size());
        Assert.assertThat((Object)layers, (Matcher)Matchers.containsInAnyOrder((Object[])new LayerInfo[]{this.getBuildingsLayer(), this.getAggregateGeoFeatureLayer()}));
        Request request = new Request();
        request.setService("WMS");
        request.setRequest("GetCapabilities");
        Dispatcher.REQUEST.set(request);
        Assert.assertNull((Object)this.catalog.getLayerByName(this.getLayerId(SystemTestData.BASIC_POLYGONS)));
        Assert.assertNull((Object)this.getBridgesLayer());
        Assert.assertNull((Object)this.catalog.getLayerGroupByName(GLOBAL_GROUP2));
        Assert.assertNull((Object)this.getBuildingsLayer());
        Assert.assertNull((Object)this.getAggregateGeoFeatureLayer());
        Assert.assertNotNull((Object)this.catalog.getLayerGroupByName(GLOBAL_GROUP));
        Assert.assertEquals((long)0L, (long)this.catalog.getLayers().size());
        LocalPublished.remove();
    }

    @Test
    public void testNestedGroupSpecificRequest() {
        CatalogFactory factory = this.catalog.getFactory();
        LayerGroupInfo nestedGroup = factory.createLayerGroup();
        nestedGroup.setName(NESTED_GROUP);
        nestedGroup.getLayers().add(this.getBridgesLayer());
        nestedGroup.getStyles().add(null);
        this.catalog.add(nestedGroup);
        LayerGroupInfo globalGroup = factory.createLayerGroup();
        globalGroup.setName(GLOBAL_GROUP);
        globalGroup.getLayers().add(this.getBuildingsLayer());
        globalGroup.getLayers().add(this.getAggregateGeoFeatureLayer());
        globalGroup.getLayers().add(nestedGroup);
        globalGroup.getStyles().add(null);
        globalGroup.getStyles().add(null);
        globalGroup.getStyles().add(null);
        this.catalog.add(globalGroup);
        LocalPublished.set((PublishedInfo)this.catalog.getLayerGroupByName(GLOBAL_GROUP));
        Assert.assertNull((Object)this.catalog.getLayerByName(this.getLayerId(SystemTestData.BASIC_POLYGONS)));
        Assert.assertNotNull((Object)this.getBridgesLayer());
        Assert.assertNotNull((Object)this.getBuildingsLayer());
        Assert.assertNotNull((Object)this.getAggregateGeoFeatureLayer());
        Assert.assertNotNull((Object)this.catalog.getLayerGroupByName(NESTED_GROUP));
        Assert.assertNotNull((Object)this.catalog.getLayerGroupByName(GLOBAL_GROUP));
        Assert.assertThat((Object)this.catalog.getLayers(), (Matcher)Matchers.containsInAnyOrder((Object[])new LayerInfo[]{this.getBuildingsLayer(), this.getAggregateGeoFeatureLayer(), this.getBridgesLayer()}));
        Request request = new Request();
        request.setService("WMS");
        request.setRequest("GetCapabilities");
        Dispatcher.REQUEST.set(request);
        Assert.assertNull((Object)this.catalog.getLayerByName(this.getLayerId(SystemTestData.BASIC_POLYGONS)));
        Assert.assertNull((Object)this.getBridgesLayer());
        Assert.assertNull((Object)this.catalog.getLayerGroupByName(NESTED_GROUP));
        Assert.assertNull((Object)this.getBuildingsLayer());
        Assert.assertNull((Object)this.getAggregateGeoFeatureLayer());
        Assert.assertNotNull((Object)this.catalog.getLayerGroupByName(GLOBAL_GROUP));
        Assert.assertEquals((long)0L, (long)this.catalog.getLayers().size());
        globalGroup = this.catalog.getLayerGroupByName(GLOBAL_GROUP);
        globalGroup.setMode(LayerGroupInfo.Mode.NAMED);
        this.catalog.save(globalGroup);
        Assert.assertNull((Object)this.catalog.getLayerByName(this.getLayerId(SystemTestData.BASIC_POLYGONS)));
        Assert.assertNotNull((Object)this.getBridgesLayer());
        Assert.assertNotNull((Object)this.catalog.getLayerGroupByName(NESTED_GROUP));
        Assert.assertNotNull((Object)this.getBuildingsLayer());
        Assert.assertNotNull((Object)this.getAggregateGeoFeatureLayer());
        Assert.assertNotNull((Object)this.catalog.getLayerGroupByName(GLOBAL_GROUP));
        Assert.assertThat((Object)this.catalog.getLayers(), (Matcher)Matchers.containsInAnyOrder((Object[])new LayerInfo[]{this.getBuildingsLayer(), this.getAggregateGeoFeatureLayer(), this.getBridgesLayer()}));
        LocalPublished.remove();
    }

    @Test
    public void testWorkspaceGroupSpecificRequest() {
        CatalogFactory factory = this.catalog.getFactory();
        WorkspaceInfo citeWs = this.catalog.getWorkspaceByName("cite");
        this.addLocalGroup(factory, citeWs);
        LayerGroupInfo globalGroup = factory.createLayerGroup();
        globalGroup.setName(GLOBAL_GROUP);
        globalGroup.getLayers().add(this.getAggregateGeoFeatureLayer());
        globalGroup.getStyles().add(null);
        this.catalog.add(globalGroup);
        LocalWorkspace.set((WorkspaceInfo)citeWs);
        LocalPublished.set((PublishedInfo)this.catalog.getLayerGroupByName(LOCAL_GROUP));
        Assert.assertNull((Object)this.catalog.getLayerByName(this.getLayerId(SystemTestData.BASIC_POLYGONS)));
        Assert.assertNull((Object)this.getAggregateGeoFeatureLayer());
        Assert.assertNull((Object)this.catalog.getLayerGroupByName(GLOBAL_GROUP));
        Assert.assertNotNull((Object)this.getBridgesLayer());
        Assert.assertNotNull((Object)this.getBuildingsLayer());
        List layers = this.catalog.getLayers();
        Assert.assertEquals((long)2L, (long)layers.size());
        Assert.assertThat((Object)layers, (Matcher)Matchers.containsInAnyOrder((Object[])new LayerInfo[]{this.getBuildingsLayer(), this.getBridgesLayer()}));
        Request request = new Request();
        request.setService("WMS");
        request.setRequest("GetCapabilities");
        Dispatcher.REQUEST.set(request);
        Assert.assertNull((Object)this.catalog.getLayerByName(this.getLayerId(SystemTestData.BASIC_POLYGONS)));
        Assert.assertNull((Object)this.getBridgesLayer());
        Assert.assertNull((Object)this.catalog.getLayerGroupByName(GLOBAL_GROUP));
        Assert.assertNull((Object)this.getBuildingsLayer());
        Assert.assertNull((Object)this.getAggregateGeoFeatureLayer());
        Assert.assertEquals((long)0L, (long)this.catalog.getLayers().size());
        LocalPublished.remove();
        LocalWorkspace.remove();
    }

    @Test
    public void testLayerLocalWithContainingGroup() throws Exception {
        CatalogFactory factory = this.catalog.getFactory();
        WorkspaceInfo citeWs = this.catalog.getWorkspaceByName("cite");
        this.addLocalGroup(factory, citeWs);
        LayerInfo buildingsLayer = this.getBuildingsLayer();
        LocalPublished.set((PublishedInfo)buildingsLayer);
        Assert.assertNotNull((Object)this.catalog.getLayerByName(buildingsLayer.prefixedName()));
        Assert.assertNull((Object)this.catalog.getLayerGroupByName(GLOBAL_GROUP));
        Assert.assertNull((Object)this.catalog.getLayerGroupByName(LOCAL_GROUP));
        Assert.assertEquals((long)1L, (long)this.catalog.getLayers().size());
        Assert.assertThat((Object)this.catalog.getLayerGroups(), (Matcher)Matchers.empty());
    }

    @Test
    public void testLayerLocalWithNonContainingGroup() throws Exception {
        CatalogFactory factory = this.catalog.getFactory();
        WorkspaceInfo citeWs = this.catalog.getWorkspaceByName("cite");
        this.addLocalGroup(factory, citeWs);
        LayerInfo dividedRoutes = this.catalog.getLayerByName(this.getLayerId(SystemTestData.DIVIDED_ROUTES));
        LocalPublished.set((PublishedInfo)dividedRoutes);
        Assert.assertNotNull((Object)this.catalog.getLayerByName(dividedRoutes.prefixedName()));
        Assert.assertNull((Object)this.catalog.getLayerGroupByName(GLOBAL_GROUP));
        Assert.assertNull((Object)this.catalog.getLayerGroupByName(LOCAL_GROUP));
        Assert.assertEquals((long)1L, (long)this.catalog.getLayers().size());
        Assert.assertThat((Object)this.catalog.getLayerGroups(), (Matcher)Matchers.empty());
    }

    private void addLocalGroup(CatalogFactory factory, WorkspaceInfo citeWs) {
        LayerGroupInfo localGroup = factory.createLayerGroup();
        localGroup.setName(LOCAL_GROUP);
        localGroup.setWorkspace(citeWs);
        localGroup.getLayers().add(this.getBuildingsLayer());
        localGroup.getLayers().add(this.getBridgesLayer());
        localGroup.getStyles().add(null);
        localGroup.getStyles().add(null);
        this.catalog.add(localGroup);
    }

    private LayerInfo getBridgesLayer() {
        return this.catalog.getLayerByName(this.getLayerId(SystemTestData.BRIDGES));
    }

    private LayerInfo getAggregateGeoFeatureLayer() {
        return this.catalog.getLayerByName(this.getLayerId(SystemTestData.AGGREGATEGEOFEATURE));
    }

    private LayerInfo getBuildingsLayer() {
        return this.catalog.getLayerByName(this.getLayerId(SystemTestData.BUILDINGS));
    }
}

