/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.geoserver.catalog.impl.ModificationProxyCloner;
import org.geotools.jdbc.VirtualTable;
import org.junit.Assert;
import org.junit.Test;

public class ModificationProxyClonerTest {
    @Test
    public void testCloneNull() throws Exception {
        Object copy = ModificationProxyCloner.clone(null);
        Assert.assertNull((Object)copy);
    }

    @Test
    public void testCloneString() throws Exception {
        String source = new String("abc");
        String copy = (String)ModificationProxyCloner.clone((Object)source);
        Assert.assertSame((Object)source, (Object)copy);
    }

    @Test
    public void testCloneDouble() throws Exception {
        Double source = 12.56;
        Double copy = (Double)ModificationProxyCloner.clone((Object)source);
        Assert.assertSame((Object)source, (Object)copy);
    }

    @Test
    public void testCloneCloneable() throws Exception {
        TestCloneable source = new TestCloneable("test");
        TestCloneable copy = (TestCloneable)ModificationProxyCloner.clone((Object)source);
        Assert.assertNotSame((Object)source, (Object)copy);
        Assert.assertEquals((Object)source, (Object)copy);
    }

    @Test
    public void testByCopyConstructor() throws Exception {
        VirtualTable source = new VirtualTable("test", "select * from tables");
        VirtualTable copy = (VirtualTable)ModificationProxyCloner.clone((Object)source);
        Assert.assertNotSame((Object)source, (Object)copy);
        Assert.assertEquals((Object)source, (Object)copy);
    }

    @Test
    public void testNotCloneable() throws Exception {
        TestNotCloneable source = new TestNotCloneable("test");
        TestNotCloneable copy = (TestNotCloneable)ModificationProxyCloner.clone((Object)source);
        Assert.assertNotSame((Object)source, (Object)copy);
        Assert.assertEquals((Object)source, (Object)copy);
    }

    @Test
    public void testDeepCopyMap() throws Exception {
        HashMap<String, Cloneable> source = new HashMap<String, Cloneable>();
        HashMap<String, String> subMap = new HashMap<String, String>();
        subMap.put("a", "b");
        subMap.put("c", "d");
        source.put("submap", subMap);
        ArrayList<String> list = new ArrayList<String>();
        list.add("x");
        list.add("y");
        list.add("z");
        source.put("list", list);
        Map copy = (Map)ModificationProxyCloner.clone(source);
        Assert.assertNotSame(source, (Object)copy);
        Assert.assertEquals(source, (Object)copy);
        Assert.assertNotSame(source.get("submap"), copy.get("submap"));
        Assert.assertEquals(source.get("submap"), copy.get("submap"));
        Assert.assertNotSame(source.get("list"), copy.get("list"));
        Assert.assertEquals(source.get("list"), copy.get("list"));
    }

    static class TestCloneable
    extends TestNotCloneable {
        public TestCloneable(String myState) {
            super(myState);
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    static class TestNotCloneable {
        private String myState;

        public TestNotCloneable(String myState) {
            this.myState = myState;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myState == null ? 0 : this.myState.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestNotCloneable other = (TestNotCloneable)obj;
            return !(this.myState == null ? other.myState != null : !this.myState.equals(other.myState));
        }
    }
}

