/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geoserver.catalog.impl.ModificationProxy;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.junit.Assert;
import org.junit.Test;

public class ModificationProxyTest {
    @Test
    public void testRewrapNoProxyIdentity() throws Exception {
        TestBeanImpl bean = new TestBeanImpl("Mr. Bean", "Uhh", "Bean");
        TestBean result = (TestBean)ModificationProxy.rewrap((Object)bean, b -> b, TestBean.class);
        Assert.assertThat((Object)result, (Matcher)Matchers.sameInstance((Object)bean));
    }

    @Test
    public void testRewrapNoProxyInnerChange() throws Exception {
        TestBeanImpl bean = new TestBeanImpl("Mr. Bean", "Uhh", "Bean");
        TestBeanImpl newBean = new TestBeanImpl("Johnny English", "Not", "Bond");
        TestBean result = (TestBean)ModificationProxy.rewrap((Object)bean, b -> newBean, TestBean.class);
        Assert.assertThat((Object)result, (Matcher)Matchers.sameInstance((Object)newBean));
    }

    @Test
    public void testRewrapEmptyProxyIdentity() throws Exception {
        TestBeanImpl bean = new TestBeanImpl("Mr. Bean", "Uhh", "Bean");
        TestBean proxy = (TestBean)ModificationProxy.create((Object)bean, TestBean.class);
        TestBean result = (TestBean)ModificationProxy.rewrap((Object)proxy, b -> b, TestBean.class);
        Assert.assertThat((Object)result, ModificationProxyTest.modProxy(Matchers.sameInstance((Object)bean)));
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.equalTo((Object)"Mr. Bean"));
        Assert.assertThat(result.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Uhh", "Bean"}));
    }

    @Test
    public void testRewrapChangedProxyIdentity() throws Exception {
        TestBeanImpl bean = new TestBeanImpl("Mr. Bean", "Uhh", "Bean");
        TestBean proxy = (TestBean)ModificationProxy.create((Object)bean, TestBean.class);
        proxy.setValue("Edmond Blackadder");
        proxy.setListValue(Arrays.asList("Cunning", "Plan"));
        TestBean result = (TestBean)ModificationProxy.rewrap((Object)proxy, b -> b, TestBean.class);
        Assert.assertThat((Object)result, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)proxy)));
        Assert.assertThat((Object)result, ModificationProxyTest.modProxy(Matchers.sameInstance((Object)bean)));
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.equalTo((Object)"Edmond Blackadder"));
        Assert.assertThat(result.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Cunning", "Plan"}));
        Assert.assertThat((Object)bean.getValue(), (Matcher)Matchers.equalTo((Object)"Mr. Bean"));
        Assert.assertThat(bean.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Uhh", "Bean"}));
    }

    @Test
    public void testRewrapChangedProxyInnerChange() throws Exception {
        TestBeanImpl bean = new TestBeanImpl("Mr. Bean", "Uhh", "Bean");
        TestBeanImpl newBean = new TestBeanImpl("Johnny English", "Not", "Bond");
        TestBean proxy = (TestBean)ModificationProxy.create((Object)bean, TestBean.class);
        proxy.setValue("Edmond Blackadder");
        proxy.setListValue(Arrays.asList("Cunning", "Plan"));
        TestBean result = (TestBean)ModificationProxy.rewrap((Object)proxy, b -> newBean, TestBean.class);
        Assert.assertThat((Object)result, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)proxy)));
        Assert.assertThat((Object)result, ModificationProxyTest.modProxy(Matchers.sameInstance((Object)newBean)));
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.equalTo((Object)"Edmond Blackadder"));
        Assert.assertThat(result.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Cunning", "Plan"}));
        Assert.assertThat((Object)bean.getValue(), (Matcher)Matchers.equalTo((Object)"Mr. Bean"));
        Assert.assertThat(bean.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Uhh", "Bean"}));
        Assert.assertThat((Object)newBean.getValue(), (Matcher)Matchers.equalTo((Object)"Johnny English"));
        Assert.assertThat(newBean.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Not", "Bond"}));
    }

    @Test
    public void testRewrapEmptyProxyInnerChange() throws Exception {
        TestBeanImpl bean = new TestBeanImpl("Mr. Bean", "Uhh", "Bean");
        TestBeanImpl newBean = new TestBeanImpl("Johnny English", "Not", "Bond");
        TestBean proxy = (TestBean)ModificationProxy.create((Object)bean, TestBean.class);
        TestBean result = (TestBean)ModificationProxy.rewrap((Object)proxy, b -> newBean, TestBean.class);
        Assert.assertThat((Object)result, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)proxy)));
        Assert.assertThat((Object)result, ModificationProxyTest.modProxy(Matchers.sameInstance((Object)newBean)));
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.equalTo((Object)"Johnny English"));
        Assert.assertThat(result.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Not", "Bond"}));
        Assert.assertThat((Object)bean.getValue(), (Matcher)Matchers.equalTo((Object)"Mr. Bean"));
        Assert.assertThat(bean.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Uhh", "Bean"}));
        Assert.assertThat((Object)newBean.getValue(), (Matcher)Matchers.equalTo((Object)"Johnny English"));
        Assert.assertThat(newBean.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Not", "Bond"}));
    }

    @Test
    public void testRewrapCommitToNew() throws Exception {
        TestBeanImpl bean = new TestBeanImpl("Mr. Bean", "Uhh", "Bean");
        TestBeanImpl newBean = new TestBeanImpl("Johnny English", "Not", "Bond");
        TestBean proxy = (TestBean)ModificationProxy.create((Object)bean, TestBean.class);
        proxy.setValue("Edmond Blackadder");
        proxy.setListValue(Arrays.asList("Cunning", "Plan"));
        TestBean result = (TestBean)ModificationProxy.rewrap((Object)proxy, b -> newBean, TestBean.class);
        ModificationProxy.handler((Object)result).commit();
        Assert.assertThat((Object)bean.getValue(), (Matcher)Matchers.equalTo((Object)"Mr. Bean"));
        Assert.assertThat(bean.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Uhh", "Bean"}));
        Assert.assertThat((Object)newBean.getValue(), (Matcher)Matchers.equalTo((Object)"Edmond Blackadder"));
        Assert.assertThat(newBean.getListValue(), (Matcher)Matchers.contains((Object[])new String[]{"Cunning", "Plan"}));
    }

    public static <T> Matcher<T> modProxy(final Matcher<T> objectMatcher) {
        return new BaseMatcher<T>(){

            public boolean matches(Object item) {
                ModificationProxy handler = ModificationProxy.handler((Object)item);
                if (handler == null) {
                    return false;
                }
                return objectMatcher.matches(handler.getProxyObject());
            }

            public void describeTo(Description description) {
                description.appendText("ModificationProxy wrapping ").appendDescriptionOf((SelfDescribing)objectMatcher);
            }
        };
    }

    static class TestBeanImpl
    implements TestBean {
        String value;
        List<String> listValue;

        public TestBeanImpl(String value, List<String> listValue) {
            this.value = value;
            this.listValue = new ArrayList<String>(listValue);
        }

        public TestBeanImpl(String value, String ... listValues) {
            this(value, Arrays.asList(listValues));
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public List<String> getListValue() {
            return this.listValue;
        }

        @Override
        public void setListValue(List<String> listValue) {
            this.listValue = listValue;
        }
    }

    static interface TestBean {
        public String getValue();

        public void setValue(String var1);

        public List<String> getListValue();

        public void setListValue(List<String> var1);
    }
}

