/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.List;
import java.util.concurrent.CountDownLatch;

public abstract class RunnerBase
implements Runnable {
    private CountDownLatch ready;
    private CountDownLatch done;
    private Exception problem;

    protected RunnerBase(CountDownLatch ready, CountDownLatch done) {
        this.ready = ready;
        this.done = done;
    }

    @Override
    public void run() {
        boolean readied = false;
        try {
            this.doBeforeReady();
            if (this.ready != null) {
                this.ready.countDown();
                readied = true;
                this.ready.await();
            }
            this.runInternal();
        }
        catch (Exception e) {
            if (this.ready != null && !readied) {
                try {
                    this.ready.countDown();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            this.setProblem(e);
        }
        if (this.done != null) {
            this.done.countDown();
        }
    }

    protected abstract void runInternal() throws Exception;

    protected void doBeforeReady() {
    }

    private synchronized void setProblem(Exception problem) {
        this.problem = problem;
    }

    public synchronized Exception getProblem() {
        return this.problem;
    }

    public static void checkForRunnerException(RunnerBase runner) throws Exception {
        Exception problem = runner.getProblem();
        if (problem != null) {
            throw problem;
        }
    }

    public static void checkForRunnerExceptions(List<? extends RunnerBase> runners) throws Exception {
        for (RunnerBase runnerBase : runners) {
            RunnerBase.checkForRunnerException(runnerBase);
        }
    }
}

