/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.Arrays;
import java.util.HashMap;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.NamespaceWorkspaceConsistencyListener;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.junit.Test;

public class WorkspaceNamespaceConstencyTest {
    @Test
    public void testChangeWorkspace() {
        Catalog cat = (Catalog)EasyMock.createMock(Catalog.class);
        cat.addListener((CatalogListener)EasyMock.anyObject());
        EasyMock.expectLastCall();
        NamespaceInfo ns = (NamespaceInfo)EasyMock.createMock(NamespaceInfo.class);
        ns.setPrefix("abcd");
        EasyMock.expectLastCall();
        EasyMock.expect((Object)cat.getNamespaceByPrefix("gs")).andReturn((Object)ns);
        cat.save(ns);
        EasyMock.expectLastCall();
        WorkspaceInfo ws = (WorkspaceInfo)EasyMock.createNiceMock(WorkspaceInfo.class);
        CatalogModifyEvent e = (CatalogModifyEvent)EasyMock.createNiceMock(CatalogModifyEvent.class);
        EasyMock.expect((Object)e.getSource()).andReturn((Object)ws).anyTimes();
        EasyMock.expect((Object)e.getPropertyNames()).andReturn(Arrays.asList("name"));
        EasyMock.expect((Object)e.getOldValues()).andReturn(Arrays.asList("gs"));
        EasyMock.expect((Object)e.getNewValues()).andReturn(Arrays.asList("abcd"));
        EasyMock.replay((Object[])new Object[]{e, ws, ns, cat});
        new NamespaceWorkspaceConsistencyListener(cat).handleModifyEvent(e);
        EasyMock.verify((Object[])new Object[]{ns, cat});
    }

    @Test
    public void testChangeNamespace() {
        Catalog cat = (Catalog)EasyMock.createMock(Catalog.class);
        cat.addListener((CatalogListener)EasyMock.anyObject());
        EasyMock.expectLastCall();
        WorkspaceInfo ws = (WorkspaceInfo)EasyMock.createMock(WorkspaceInfo.class);
        ws.setName("abcd");
        EasyMock.expectLastCall();
        EasyMock.expect((Object)cat.getWorkspaceByName("gs")).andReturn((Object)ws);
        cat.save(ws);
        EasyMock.expectLastCall();
        NamespaceInfo ns = (NamespaceInfo)EasyMock.createNiceMock(NamespaceInfo.class);
        CatalogModifyEvent e = (CatalogModifyEvent)EasyMock.createNiceMock(CatalogModifyEvent.class);
        EasyMock.expect((Object)e.getSource()).andReturn((Object)ns).anyTimes();
        EasyMock.expect((Object)e.getPropertyNames()).andReturn(Arrays.asList("prefix"));
        EasyMock.expect((Object)e.getOldValues()).andReturn(Arrays.asList("gs"));
        EasyMock.expect((Object)e.getNewValues()).andReturn(Arrays.asList("abcd"));
        EasyMock.replay((Object[])new Object[]{e, ws, ns, cat});
        new NamespaceWorkspaceConsistencyListener(cat).handleModifyEvent(e);
        EasyMock.verify((Object[])new Object[]{ws, cat});
    }

    @Test
    public void testChangeDefaultWorkspace() {
        Catalog cat = (Catalog)EasyMock.createMock(Catalog.class);
        cat.addListener((CatalogListener)EasyMock.anyObject());
        EasyMock.expectLastCall();
        NamespaceInfo def = (NamespaceInfo)EasyMock.createNiceMock(NamespaceInfo.class);
        EasyMock.expect((Object)cat.getDefaultNamespace()).andReturn((Object)def);
        NamespaceInfo ns = (NamespaceInfo)EasyMock.createNiceMock(NamespaceInfo.class);
        EasyMock.expect((Object)cat.getNamespaceByPrefix("abcd")).andReturn((Object)ns);
        cat.setDefaultNamespace(ns);
        EasyMock.expectLastCall();
        WorkspaceInfo ws = (WorkspaceInfo)EasyMock.createNiceMock(WorkspaceInfo.class);
        EasyMock.expect((Object)ws.getName()).andReturn((Object)"abcd");
        CatalogModifyEvent e = (CatalogModifyEvent)EasyMock.createNiceMock(CatalogModifyEvent.class);
        EasyMock.expect((Object)e.getSource()).andReturn((Object)cat).anyTimes();
        EasyMock.expect((Object)e.getPropertyNames()).andReturn(Arrays.asList("defaultWorkspace"));
        EasyMock.expect((Object)e.getNewValues()).andReturn(Arrays.asList(ws));
        EasyMock.replay((Object[])new Object[]{ns, ws, e, cat});
        new NamespaceWorkspaceConsistencyListener(cat).handleModifyEvent(e);
        EasyMock.verify((Object[])new Object[]{ns, ws, cat});
    }

    @Test
    public void testChangeDefaultNamespace() {
        Catalog cat = (Catalog)EasyMock.createMock(Catalog.class);
        cat.addListener((CatalogListener)EasyMock.anyObject());
        EasyMock.expectLastCall();
        WorkspaceInfo def = (WorkspaceInfo)EasyMock.createNiceMock(WorkspaceInfo.class);
        EasyMock.expect((Object)cat.getDefaultWorkspace()).andReturn((Object)def);
        WorkspaceInfo ws = (WorkspaceInfo)EasyMock.createNiceMock(WorkspaceInfo.class);
        EasyMock.expect((Object)cat.getWorkspaceByName("abcd")).andReturn((Object)ws);
        cat.setDefaultWorkspace(ws);
        EasyMock.expectLastCall();
        NamespaceInfo ns = (NamespaceInfo)EasyMock.createNiceMock(NamespaceInfo.class);
        EasyMock.expect((Object)ns.getPrefix()).andReturn((Object)"abcd");
        CatalogModifyEvent e = (CatalogModifyEvent)EasyMock.createNiceMock(CatalogModifyEvent.class);
        EasyMock.expect((Object)e.getSource()).andReturn((Object)cat).anyTimes();
        EasyMock.expect((Object)e.getPropertyNames()).andReturn(Arrays.asList("defaultNamespace"));
        EasyMock.expect((Object)e.getNewValues()).andReturn(Arrays.asList(ns));
        EasyMock.replay((Object[])new Object[]{ns, ws, e, cat});
        new NamespaceWorkspaceConsistencyListener(cat).handleModifyEvent(e);
        EasyMock.verify((Object[])new Object[]{ns, ws, cat});
    }

    @Test
    public void testChangeNamespaceURI() {
        Catalog cat = (Catalog)EasyMock.createMock(Catalog.class);
        cat.addListener((CatalogListener)EasyMock.anyObject());
        EasyMock.expectLastCall();
        NamespaceInfo ns = (NamespaceInfo)EasyMock.createNiceMock(NamespaceInfo.class);
        EasyMock.expect((Object)ns.getPrefix()).andReturn((Object)"foo");
        EasyMock.expect((Object)ns.getURI()).andReturn((Object)"http://foo.org");
        WorkspaceInfo ws = (WorkspaceInfo)EasyMock.createNiceMock(WorkspaceInfo.class);
        EasyMock.expect((Object)cat.getWorkspaceByName("foo")).andReturn((Object)ws);
        DataStoreInfo ds = (DataStoreInfo)EasyMock.createNiceMock(DataStoreInfo.class);
        EasyMock.expect((Object)cat.getDataStoresByWorkspace(ws)).andReturn(Arrays.asList(ds));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("namespace", "http://bar.org");
        EasyMock.expect((Object)ds.getConnectionParameters()).andReturn(params).anyTimes();
        cat.save(this.hasNamespace("http://foo.org"));
        EasyMock.expectLastCall();
        CatalogPostModifyEvent e = (CatalogPostModifyEvent)EasyMock.createNiceMock(CatalogPostModifyEvent.class);
        EasyMock.expect((Object)e.getSource()).andReturn((Object)ns).anyTimes();
        EasyMock.expect((Object)ns.getPrefix()).andReturn((Object)"foo");
        EasyMock.expect((Object)cat.getWorkspaceByName("foo")).andReturn((Object)ws);
        EasyMock.replay((Object[])new Object[]{ds, ws, ns, e, cat});
        new NamespaceWorkspaceConsistencyListener(cat).handlePostModifyEvent(e);
        EasyMock.verify((Object[])new Object[]{cat});
    }

    protected StoreInfo hasNamespace(final String namespace) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public boolean matches(Object argument) {
                return namespace.equals(((StoreInfo)argument).getConnectionParameters().get("namespace"));
            }

            public void appendTo(StringBuffer buffer) {
                buffer.append("hasNamespace '").append(namespace).append("'");
            }
        });
        return null;
    }
}

