/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CatalogFactoryImpl;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.config.GeoServerDataDirectory;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.geotools.util.Version;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.style.GraphicalSymbol;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class GeoServerDataDirectoryTest {
    ClassPathXmlApplicationContext ctx;
    GeoServerDataDirectory dataDir;
    CatalogFactory factory = new CatalogFactoryImpl((Catalog)new CatalogImpl());

    @Before
    public void setUp() throws Exception {
        this.ctx = new ClassPathXmlApplicationContext("GeoServerDataDirectoryTest-applicationContext.xml", this.getClass());
        this.ctx.refresh();
        this.dataDir = new GeoServerDataDirectory(Files.createTempDirectory("data", new FileAttribute[0]).toFile());
        this.dataDir.root().deleteOnExit();
    }

    @After
    public void tearDown() throws Exception {
        this.ctx.close();
    }

    @Test
    public void testNullWorkspace() {
        Assert.assertEquals((Object)this.dataDir.get((WorkspaceInfo)null, new String[]{"test"}).path(), (Object)this.dataDir.get("test").path());
        Assert.assertEquals((Object)this.dataDir.getStyles((WorkspaceInfo)null, new String[]{"test"}).path(), (Object)this.dataDir.getStyles(new String[]{"test"}).path());
        Assert.assertEquals((Object)this.dataDir.getLayerGroups((WorkspaceInfo)null, new String[]{"test"}).path(), (Object)this.dataDir.getLayerGroups(new String[]{"test"}).path());
    }

    @Test
    public void testParsedStyle() throws IOException {
        File styleDir = new File(this.dataDir.root(), "styles");
        styleDir.mkdir();
        File styleFile = new File(styleDir, "external.sld");
        Files.copy(this.getClass().getResourceAsStream("external.sld"), styleFile.toPath(), new CopyOption[0]);
        File iconFile = new File(styleDir, "icon.png");
        Assert.assertFalse((boolean)iconFile.exists());
        StyleInfoImpl si = new StyleInfoImpl(null);
        si.setName("");
        si.setId("");
        si.setFormat("sld");
        si.setFormatVersion(new Version("1.0.0"));
        si.setFilename(styleFile.getName());
        Style s = this.dataDir.parsedStyle((StyleInfo)si);
        Symbolizer symbolizer = (Symbolizer)((Rule)((FeatureTypeStyle)s.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        Assert.assertTrue((boolean)(symbolizer instanceof PointSymbolizer));
        GraphicalSymbol graphic = (GraphicalSymbol)((PointSymbolizer)symbolizer).getGraphic().graphicalSymbols().get(0);
        Assert.assertTrue((boolean)(graphic instanceof ExternalGraphic));
        Assert.assertEquals((Object)((ExternalGraphic)graphic).getLocation(), (Object)iconFile.toURI().toURL());
        Assert.assertFalse((boolean)iconFile.exists());
    }

    @Test
    public void testParsedStyleExternalWithParams() throws IOException {
        File styleDir = new File(this.dataDir.root(), "styles");
        styleDir.mkdir();
        File styleFile = new File(styleDir, "external_with_params.sld");
        Files.copy(this.getClass().getResourceAsStream("external_with_params.sld"), styleFile.toPath(), new CopyOption[0]);
        File iconFile = new File(styleDir, "icon.png");
        Assert.assertFalse((boolean)iconFile.exists());
        StyleInfoImpl si = new StyleInfoImpl(null);
        si.setName("");
        si.setId("");
        si.setFormat("sld");
        si.setFormatVersion(new Version("1.0.0"));
        si.setFilename(styleFile.getName());
        Style s = this.dataDir.parsedStyle((StyleInfo)si);
        Symbolizer symbolizer = (Symbolizer)((Rule)((FeatureTypeStyle)s.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        Assert.assertTrue((boolean)(symbolizer instanceof PointSymbolizer));
        GraphicalSymbol graphic = (GraphicalSymbol)((PointSymbolizer)symbolizer).getGraphic().graphicalSymbols().get(0);
        Assert.assertTrue((boolean)(graphic instanceof ExternalGraphic));
        Assert.assertEquals((Object)((ExternalGraphic)graphic).getLocation().getPath(), (Object)iconFile.toURI().toURL().getPath());
        Assert.assertEquals((Object)"param1=1", (Object)((ExternalGraphic)graphic).getLocation().getQuery());
        Assert.assertFalse((boolean)iconFile.exists());
    }

    @Test
    public void testParsedStyleExternalWithParamsAndFragment() throws IOException {
        File styleDir = new File(this.dataDir.root(), "styles");
        styleDir.mkdir();
        File styleFile = new File(styleDir, "external_with_params_and_fragment.sld");
        Files.copy(this.getClass().getResourceAsStream("external_with_params_and_fragment.sld"), styleFile.toPath(), new CopyOption[0]);
        File iconFile = new File(styleDir, "icon.png");
        Assert.assertFalse((boolean)iconFile.exists());
        StyleInfoImpl si = new StyleInfoImpl(null);
        si.setName("");
        si.setId("");
        si.setFormat("sld");
        si.setFormatVersion(new Version("1.0.0"));
        si.setFilename(styleFile.getName());
        Style s = this.dataDir.parsedStyle((StyleInfo)si);
        Symbolizer symbolizer = (Symbolizer)((Rule)((FeatureTypeStyle)s.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        Assert.assertTrue((boolean)(symbolizer instanceof PointSymbolizer));
        GraphicalSymbol graphic = (GraphicalSymbol)((PointSymbolizer)symbolizer).getGraphic().graphicalSymbols().get(0);
        Assert.assertTrue((boolean)(graphic instanceof ExternalGraphic));
        Assert.assertEquals((Object)((ExternalGraphic)graphic).getLocation().getPath(), (Object)iconFile.toURI().toURL().getPath());
        Assert.assertEquals((Object)"param1=1", (Object)((ExternalGraphic)graphic).getLocation().getQuery());
        Assert.assertEquals((Object)"textAfterHash", (Object)((ExternalGraphic)graphic).getLocation().getRef());
        Assert.assertFalse((boolean)iconFile.exists());
    }
}

