/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class GeoServerPropertyConfigurerTest {
    ClassPathXmlApplicationContext ctx;

    @Before
    public void setUp() throws Exception {
        File f = new File("target/foo.properties");
        if (f.exists()) {
            f.delete();
        }
        this.ctx = new ClassPathXmlApplicationContext("GeoServerPropertyConfigurerTest-applicationContext.xml", this.getClass());
        this.ctx.refresh();
    }

    @After
    public void tearDown() throws Exception {
        this.ctx.close();
    }

    @Test
    public void testDefaults() {
        Foo f = (Foo)this.ctx.getBean("myBean");
        Assert.assertEquals((Object)"value1", (Object)f.getBar());
        Assert.assertEquals((Object)"value2", (Object)f.getBaz());
    }

    @Test
    public void testUserSpecified() throws Exception {
        Properties p = new Properties();
        p.put("prop1", "foobar");
        p.put("prop2", "barfoo");
        FileOutputStream out = new FileOutputStream("target/foo.properties");
        p.store(out, "");
        out.flush();
        out.close();
        this.ctx.refresh();
        Foo f = (Foo)this.ctx.getBean("myBean");
        Assert.assertEquals((Object)"foobar", (Object)f.getBar());
        Assert.assertEquals((Object)"barfoo", (Object)f.getBaz());
    }

    static class Foo {
        String bar;
        String baz;

        Foo() {
        }

        public String getBar() {
            return this.bar;
        }

        public void setBar(String bar) {
            this.bar = bar;
        }

        public void setBaz(String baz) {
            this.baz = baz;
        }

        public String getBaz() {
            return this.baz;
        }
    }
}

