/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.ServicePersister;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.SystemTest;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SystemTest.class})
public class ServicePersisterTest
extends GeoServerSystemTestSupport {
    GeoServer geoServer;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        GeoServer geoServer = this.getGeoServer();
        geoServer.addListener((ConfigurationListener)new ServicePersister(Arrays.asList(new ServiceLoader(this.getResourceLoader())), geoServer));
    }

    @Override
    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("classpath*:/org/geoserver/config/ServicePersisterTest-applicationContext.xml");
    }

    @Before
    public void init() {
        this.geoServer = this.getGeoServer();
    }

    @Before
    public void removeFooService() throws IOException {
        File serviceFile;
        WorkspaceInfo ws;
        GeoServer geoServer = this.getGeoServer();
        ServiceInfo s = geoServer.getServiceByName(ws = this.getCatalog().getDefaultWorkspace(), "foo", ServiceInfo.class);
        if (s != null) {
            geoServer.remove(s);
        }
        if ((serviceFile = this.getDataDirectory().findFile(new String[]{"service.xml"})) != null) {
            serviceFile.delete();
        }
    }

    @Test
    public void testAddWorkspaceLocalService() throws Exception {
        File dataDirRoot = ((SystemTestData)this.getTestData()).getDataDirectoryRoot();
        WorkspaceInfo ws = this.getCatalog().getDefaultWorkspace();
        ServiceInfo s = this.geoServer.getFactory().createService();
        s.setName("foo");
        s.setWorkspace(ws);
        File f = new File(dataDirRoot, "workspaces/" + ws.getName() + "/service.xml");
        Assert.assertFalse((boolean)f.exists());
        this.geoServer.add(s);
        Assert.assertTrue((boolean)f.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveWorkspaceLocalService() throws Exception {
        this.testAddWorkspaceLocalService();
        File dataDirRoot = ((SystemTestData)this.getTestData()).getDataDirectoryRoot();
        WorkspaceInfo ws = this.getCatalog().getDefaultWorkspace();
        File f = new File(dataDirRoot, "workspaces/" + ws.getName() + "/service.xml");
        Assert.assertTrue((boolean)f.exists());
        Logger logger = Logging.getLogger(GeoServerImpl.class);
        Level level = logger.getLevel();
        try {
            logger.setLevel(Level.OFF);
            ServiceInfo s = this.geoServer.getServiceByName(ws, "foo", ServiceInfo.class);
            this.geoServer.remove(s);
            Assert.assertFalse((boolean)f.exists());
        }
        finally {
            logger.setLevel(level);
        }
    }

    @Test
    public void testReloadWithLocalServices() throws Exception {
        WorkspaceInfo ws = this.getCatalog().getFactory().createWorkspace();
        ws.setName("nonDefault");
        NamespaceInfo ni = this.getCatalog().getFactory().createNamespace();
        ni.setPrefix("nonDefault");
        ni.setURI("http://www.geoserver.org/nonDefault");
        this.getCatalog().add(ws);
        this.getCatalog().add(ni);
        SettingsInfo s = this.geoServer.getFactory().createSettings();
        s.setWorkspace(ws);
        this.geoServer.add(s);
        this.getGeoServer().reload();
    }

    @Test
    public void testLoadGibberish() throws Exception {
        File service = new File(this.getDataDirectory().getResourceLoader().getBaseDirectory(), "service.xml");
        FileUtils.writeStringToFile((File)service, (String)"duDaDa", (String)"UTF-8");
        this.getGeoServer().reload();
        Assert.assertEquals((long)0L, (long)this.geoServer.getServices().size());
    }

    public static class ServiceLoader
    extends XStreamServiceLoader {
        public ServiceLoader(GeoServerResourceLoader resourceLoader) {
            super(resourceLoader, "service");
        }

        public Class getServiceClass() {
            return ServiceInfo.class;
        }

        protected ServiceInfo createServiceFromScratch(GeoServer gs) {
            return null;
        }
    }
}

