/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.impl.LayerIdentifier;
import org.geoserver.config.util.LayerIdentifierInfoListConverter;
import org.junit.Assert;
import org.junit.Test;

public class LayerIdentifierInfoListConverterTest {
    @Test
    public void testFromString() {
        String serialized = "[{\"authority\":\"auth1\",\"identifier\":\"IDENTIFIER_1\"},{\"authority\":\"auth2\",\"identifier\":\"IDENTIFIER_2\"}]";
        ArrayList<LayerIdentifier> expected = new ArrayList<LayerIdentifier>();
        LayerIdentifier id1 = new LayerIdentifier();
        id1.setAuthority("auth1");
        id1.setIdentifier("IDENTIFIER_1");
        expected.add(id1);
        LayerIdentifier id2 = new LayerIdentifier();
        id2.setAuthority("auth2");
        id2.setIdentifier("IDENTIFIER_2");
        expected.add(id2);
        List actual = LayerIdentifierInfoListConverter.fromString((String)"[{\"authority\":\"auth1\",\"identifier\":\"IDENTIFIER_1\"},{\"authority\":\"auth2\",\"identifier\":\"IDENTIFIER_2\"}]");
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testFromInvalidString() {
        String serialized = "[{\"name:\"auth1\",\"href\":\"http://geoserver.org/auth1?\"},]";
        try {
            LayerIdentifierInfoListConverter.fromString((String)"[{\"name:\"auth1\",\"href\":\"http://geoserver.org/auth1?\"},]");
            Assert.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testToString() {
        ArrayList<LayerIdentifier> list = new ArrayList<LayerIdentifier>();
        LayerIdentifier id1 = new LayerIdentifier();
        id1.setAuthority("auth1");
        id1.setIdentifier("IDENTIFIER_1");
        list.add(id1);
        LayerIdentifier id2 = new LayerIdentifier();
        id2.setAuthority("auth2");
        id2.setIdentifier("IDENTIFIER_2");
        list.add(id2);
        String actual = LayerIdentifierInfoListConverter.toString(list);
        String expected = "[{\"authority\":\"auth1\",\"identifier\":\"IDENTIFIER_1\"},{\"authority\":\"auth2\",\"identifier\":\"IDENTIFIER_2\"}]";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testToStringListWithNullElement() {
        ArrayList<LayerIdentifier> list = new ArrayList<LayerIdentifier>();
        LayerIdentifier id1 = new LayerIdentifier();
        id1.setAuthority("auth1");
        id1.setIdentifier("IDENTIFIER_1");
        list.add(id1);
        list.add(null);
        String actual = LayerIdentifierInfoListConverter.toString(list);
        String expected = "[{\"authority\":\"auth1\",\"identifier\":\"IDENTIFIER_1\"}]";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testToStringListWithOnlyNullElements() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(null);
        list.add(null);
        list.add(null);
        Assert.assertNull((Object)LayerIdentifierInfoListConverter.toString(list));
    }

    @Test
    public void testToStringEmptyList() {
        ArrayList list = new ArrayList();
        String actual = LayerIdentifierInfoListConverter.toString(list);
        Assert.assertNull((Object)actual);
    }
}

