/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class XStreamPersisterIntegrationTest
extends GeoServerSystemTestSupport {
    private XStreamPersister persister;

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Before
    public void setupPersister() {
        this.persister = new XStreamPersister();
        this.persister.setEncryptPasswordFields(true);
    }

    @Test
    public void testWmsStorePasswordEncryption() throws Exception {
        WMSStoreInfo wms = this.buildWmsStore();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.persister.save((Object)wms, (OutputStream)out);
        Document dom = this.dom(new ByteArrayInputStream(out.toByteArray()));
        XMLAssert.assertXpathExists((String)"/wmsStore/password", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/wmsStore[password = 'password']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/wmsStore[starts-with(password, 'crypt1:')]", (Document)dom);
        WMSStoreInfo loaded = (WMSStoreInfo)this.persister.load((InputStream)new ByteArrayInputStream(out.toByteArray()), WMSStoreInfo.class);
        Assert.assertEquals((Object)"password", (Object)loaded.getPassword());
    }

    @Test
    public void testWmsStoreBackwardsCompatibility() throws Exception {
        WMSStoreInfo wms = this.buildWmsStore();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.persister.setEncryptPasswordFields(false);
        this.persister.save((Object)wms, (OutputStream)out);
        Document dom = this.dom(new ByteArrayInputStream(out.toByteArray()));
        this.print(dom);
        XMLAssert.assertXpathExists((String)"/wmsStore/password", (Document)dom);
        XMLAssert.assertXpathExists((String)"/wmsStore[password = 'password']", (Document)dom);
        this.persister.setEncryptPasswordFields(true);
        WMSStoreInfo loaded = (WMSStoreInfo)this.persister.load((InputStream)new ByteArrayInputStream(out.toByteArray()), WMSStoreInfo.class);
        Assert.assertEquals((Object)"password", (Object)loaded.getPassword());
        this.persister.setEncryptPasswordFields(false);
        WMSStoreInfo loaded2 = (WMSStoreInfo)this.persister.load((InputStream)new ByteArrayInputStream(out.toByteArray()), WMSStoreInfo.class);
        Assert.assertEquals((Object)"password", (Object)loaded2.getPassword());
    }

    private WMSStoreInfo buildWmsStore() {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        WMSStoreInfo wms = cFactory.createWebMapServer();
        wms.setName("bar");
        wms.setWorkspace(ws);
        wms.setCapabilitiesURL("http://fake.host/wms?request=GetCapabilities&service=wms");
        wms.setUsername("user");
        wms.setPassword("password");
        return wms;
    }
}

