/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.SLDHandler;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.CoverageDimensionImpl;
import org.geoserver.catalog.impl.CoverageStoreInfoImpl;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.MetadataLinkInfoImpl;
import org.geoserver.catalog.impl.WMSStoreInfoImpl;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerFactory;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.impl.ServiceInfoImpl;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.config.util.XStreamPersisterInitializer;
import org.geotools.jdbc.RegexpValidator;
import org.geotools.jdbc.VirtualTable;
import org.geotools.jdbc.VirtualTableParameter;
import org.geotools.measure.Measure;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.referencing.wkt.UnformattableObjectException;
import org.geotools.util.NumberRange;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.locationtech.jts.geom.LineString;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import si.uom.SI;

public class XStreamPersisterTest {
    GeoServerFactory factory;
    CatalogFactory cfactory;
    XStreamPersister persister;

    @Before
    public void init() {
        this.factory = new GeoServerImpl().getFactory();
        this.persister = new XStreamPersisterFactory().createXMLPersister();
    }

    @Test
    public void testGlobal() throws Exception {
        GeoServerInfo g1 = this.factory.createGlobal();
        g1.setAdminPassword("foo");
        g1.setAdminUsername("bar");
        g1.getSettings().setCharset("ISO-8859-1");
        ContactInfo contact = this.factory.createContact();
        g1.getSettings().setContact(contact);
        contact.setAddress("123");
        contact.setAddressCity("Victoria");
        contact.setAddressCountry("Canada");
        contact.setAddressPostalCode("V1T3T8");
        contact.setAddressState("BC");
        contact.setAddressType("house");
        contact.setContactEmail("bob@acme.org");
        contact.setContactFacsimile("+1 250 123 4567");
        contact.setContactOrganization("Acme");
        contact.setContactPerson("Bob");
        contact.setContactPosition("hacker");
        contact.setContactVoice("+1 250 765 4321");
        g1.getSettings().setNumDecimals(2);
        g1.getSettings().setOnlineResource("http://acme.org");
        g1.getSettings().setProxyBaseUrl("http://proxy.acme.org");
        g1.getSettings().setSchemaBaseUrl("http://schemas.acme.org");
        g1.getSettings().setTitle("Acme's GeoServer");
        g1.setUpdateSequence(123L);
        g1.getSettings().setVerbose(true);
        g1.getSettings().setVerboseExceptions(true);
        g1.getMetadata().put("one", (Serializable)Integer.valueOf(1));
        g1.getMetadata().put("two", (Serializable)Double.valueOf(2.2));
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)g1, (OutputStream)out);
        GeoServerInfo g2 = (GeoServerInfo)this.persister.load((InputStream)this.in(out), GeoServerInfo.class);
        Assert.assertEquals((Object)g1, (Object)g2);
        Document dom = this.dom(this.in(out));
        Assert.assertEquals((Object)"global", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testLogging() throws Exception {
        LoggingInfo logging = this.factory.createLogging();
        logging.setLevel("CRAZY_LOGGING");
        logging.setLocation("some/place/geoserver.log");
        logging.setStdOutLogging(true);
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)logging, (OutputStream)out);
        LoggingInfo logging2 = (LoggingInfo)this.persister.load((InputStream)this.in(out), LoggingInfo.class);
        Assert.assertEquals((Object)logging, (Object)logging2);
        Document dom = this.dom(this.in(out));
        Assert.assertEquals((Object)"logging", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testGobalContactDefault() throws Exception {
        GeoServerInfo g1 = this.factory.createGlobal();
        ContactInfo contact = this.factory.createContact();
        g1.getSettings().setContact(contact);
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)g1, (OutputStream)out);
        ByteArrayInputStream in = this.in(out);
        Document dom = this.dom(in);
        Element e = (Element)dom.getElementsByTagName("contact").item(0);
        e.removeAttribute("class");
        in = this.in(dom);
        GeoServerInfo g2 = (GeoServerInfo)this.persister.load((InputStream)in, GeoServerInfo.class);
        Assert.assertEquals((Object)g1, (Object)g2);
    }

    @Test
    public void testService() throws Exception {
        MyServiceInfo s1 = new MyServiceInfo();
        s1.setAbstract("my service abstract");
        s1.setAccessConstraints("no constraints");
        s1.setCiteCompliant(true);
        s1.setEnabled(true);
        s1.setFees("no fees");
        s1.setFoo("bar");
        s1.setId("id");
        s1.setMaintainer("Bob");
        s1.setMetadataLink(this.factory.createMetadataLink());
        s1.setName("MS");
        s1.setOnlineResource("http://acme.org?service=myservice");
        s1.setOutputStrategy("FAST");
        s1.setSchemaBaseURL("http://schemas.acme.org/");
        s1.setTitle("My Service");
        s1.setVerbose(true);
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)s1, (OutputStream)out);
        MyServiceInfo s2 = (MyServiceInfo)((Object)this.persister.load((InputStream)this.in(out), MyServiceInfo.class));
        Assert.assertEquals((Object)s1.getAbstract(), (Object)s2.getAbstract());
        Assert.assertEquals((Object)s1.getAccessConstraints(), (Object)s2.getAccessConstraints());
        Assert.assertEquals((Object)s1.isCiteCompliant(), (Object)s2.isCiteCompliant());
        Assert.assertEquals((Object)s1.isEnabled(), (Object)s2.isEnabled());
        Assert.assertEquals((Object)s1.getFees(), (Object)s2.getFees());
        Assert.assertEquals((Object)s1.getFoo(), (Object)s2.getFoo());
        Assert.assertEquals((Object)s1.getId(), (Object)s2.getId());
        Assert.assertEquals((Object)s1.getMaintainer(), (Object)s2.getMaintainer());
        Assert.assertEquals((Object)s1.getMetadataLink(), (Object)s2.getMetadataLink());
        Assert.assertEquals((Object)s1.getName(), (Object)s2.getName());
        Assert.assertEquals((Object)s1.getOnlineResource(), (Object)s2.getOnlineResource());
        Assert.assertEquals((Object)s1.getOutputStrategy(), (Object)s2.getOutputStrategy());
        Assert.assertEquals((Object)s1.getSchemaBaseURL(), (Object)s2.getSchemaBaseURL());
        Assert.assertEquals((Object)s1.getTitle(), (Object)s2.getTitle());
        Assert.assertEquals((Object)s1.isVerbose(), (Object)s2.isVerbose());
    }

    @Test
    public void testServiceOmitGlobal() throws Exception {
        MyServiceInfo s1 = new MyServiceInfo();
        s1.setGeoServer((GeoServer)new GeoServerImpl());
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)s1, (OutputStream)out);
        MyServiceInfo s2 = (MyServiceInfo)((Object)this.persister.load((InputStream)this.in(out), MyServiceInfo.class));
        Assert.assertNull((Object)s2.getGeoServer());
    }

    @Test
    public void testServiceCustomAlias() throws Exception {
        XStreamPersister p = this.persister = new XStreamPersisterFactory().createXMLPersister();
        p.getXStream().alias("ms", MyServiceInfo.class);
        MyServiceInfo s1 = new MyServiceInfo();
        ByteArrayOutputStream out = this.out();
        p.save((Object)s1, (OutputStream)out);
        Document dom = this.dom(this.in(out));
        Assert.assertEquals((Object)"ms", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testDataStore() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        DataStoreInfo ds1 = cFactory.createDataStore();
        ds1.setName("bar");
        ds1.setWorkspace(ws);
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)ds1, (OutputStream)out);
        DataStoreInfo ds2 = (DataStoreInfo)this.persister.load((InputStream)this.in(out), DataStoreInfo.class);
        Assert.assertEquals((Object)"bar", (Object)ds2.getName());
        Assert.assertNotNull((Object)ds2.getWorkspace());
        Assert.assertEquals((Object)"foo", (Object)ds2.getWorkspace().getId());
        Document dom = this.dom(this.in(out));
        Assert.assertEquals((Object)"dataStore", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testDataStoreReferencedByName() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        DataStoreInfo ds1 = cFactory.createDataStore();
        ds1.setName("bar");
        ds1.setWorkspace(ws);
        catalog.detach((StoreInfo)ds1);
        ((DataStoreInfoImpl)ds1).setId(null);
        ByteArrayOutputStream out = this.out();
        XStreamPersister persister = new XStreamPersisterFactory().createXMLPersister();
        persister.setReferenceByName(true);
        persister.save((Object)ds1, (OutputStream)out);
        DataStoreInfo ds2 = (DataStoreInfo)persister.load((InputStream)this.in(out), DataStoreInfo.class);
        Assert.assertEquals((Object)"bar", (Object)ds2.getName());
        Assert.assertNotNull((Object)ds2.getWorkspace());
        Assert.assertEquals((Object)"foo", (Object)ds2.getWorkspace().getId());
        Document dom = this.dom(this.in(out));
        Assert.assertEquals((Object)"dataStore", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testCoverageStore() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        CoverageStoreInfo cs1 = cFactory.createCoverageStore();
        cs1.setName("bar");
        cs1.setWorkspace(ws);
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)cs1, (OutputStream)out);
        CoverageStoreInfo ds2 = (CoverageStoreInfo)this.persister.load((InputStream)this.in(out), CoverageStoreInfo.class);
        Assert.assertEquals((Object)"bar", (Object)ds2.getName());
        Assert.assertNotNull((Object)ds2.getWorkspace());
        Assert.assertEquals((Object)"foo", (Object)ds2.getWorkspace().getId());
        Document dom = this.dom(this.in(out));
        Assert.assertEquals((Object)"coverageStore", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testCoverageStoreReferencedByName() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        CoverageStoreInfo cs1 = cFactory.createCoverageStore();
        cs1.setName("bar");
        cs1.setWorkspace(ws);
        catalog.detach((StoreInfo)cs1);
        ((CoverageStoreInfoImpl)cs1).setId(null);
        ByteArrayOutputStream out = this.out();
        XStreamPersister persister = new XStreamPersisterFactory().createXMLPersister();
        persister.setReferenceByName(true);
        persister.save((Object)cs1, (OutputStream)out);
        CoverageStoreInfo ds2 = (CoverageStoreInfo)persister.load((InputStream)this.in(out), CoverageStoreInfo.class);
        Assert.assertEquals((Object)"bar", (Object)ds2.getName());
        Assert.assertNotNull((Object)ds2.getWorkspace());
        Assert.assertEquals((Object)"foo", (Object)ds2.getWorkspace().getId());
        Document dom = this.dom(this.in(out));
        Assert.assertEquals((Object)"coverageStore", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testWMSStore() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        WMSStoreInfo wms1 = cFactory.createWebMapServer();
        wms1.setName("bar");
        wms1.setWorkspace(ws);
        wms1.setCapabilitiesURL("http://fake.host/wms?request=GetCapabilities&service=wms");
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)wms1, (OutputStream)out);
        WMSStoreInfo wms2 = (WMSStoreInfo)this.persister.load((InputStream)this.in(out), WMSStoreInfo.class);
        Assert.assertEquals((Object)"bar", (Object)wms2.getName());
        Assert.assertEquals((long)6L, (long)wms2.getMaxConnections());
        Assert.assertEquals((long)30L, (long)wms2.getConnectTimeout());
        Assert.assertEquals((long)60L, (long)wms2.getReadTimeout());
        Assert.assertNotNull((Object)wms2.getWorkspace());
        Assert.assertEquals((Object)"foo", (Object)wms2.getWorkspace().getId());
        Document dom = this.dom(this.in(out));
        Assert.assertEquals((Object)"wmsStore", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testWMSStoreReferencedByName() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        WMSStoreInfo wms1 = cFactory.createWebMapServer();
        wms1.setName("bar");
        wms1.setWorkspace(ws);
        wms1.setCapabilitiesURL("http://fake.host/wms?request=GetCapabilities&service=wms");
        catalog.detach((StoreInfo)wms1);
        ((WMSStoreInfoImpl)wms1).setId(null);
        ByteArrayOutputStream out = this.out();
        XStreamPersister persister = new XStreamPersisterFactory().createXMLPersister();
        persister.setReferenceByName(true);
        persister.save((Object)wms1, (OutputStream)out);
        WMSStoreInfo wms2 = (WMSStoreInfo)persister.load((InputStream)this.in(out), WMSStoreInfo.class);
        Assert.assertEquals((Object)"bar", (Object)wms2.getName());
        Assert.assertEquals((long)6L, (long)wms2.getMaxConnections());
        Assert.assertEquals((long)30L, (long)wms2.getConnectTimeout());
        Assert.assertEquals((long)60L, (long)wms2.getReadTimeout());
        Assert.assertNotNull((Object)wms2.getWorkspace());
        Assert.assertEquals((Object)"foo", (Object)wms2.getWorkspace().getId());
        Document dom = this.dom(this.in(out));
        Assert.assertEquals((Object)"wmsStore", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testWMSStoreBackwardsCompatibility() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        WMSStoreInfo wms1 = cFactory.createWebMapServer();
        wms1.setName("bar");
        wms1.setWorkspace(ws);
        wms1.setCapabilitiesURL("http://fake.host/wms?request=GetCapabilities&service=wms");
        wms1.getMetadata().put("maxConnections", (Serializable)Integer.valueOf(18));
        wms1.getMetadata().put("connectTimeout", (Serializable)Integer.valueOf(25));
        wms1.getMetadata().put("readTimeout", (Serializable)Integer.valueOf(78));
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)wms1, (OutputStream)out);
        WMSStoreInfo wms2 = (WMSStoreInfo)this.persister.load((InputStream)this.in(out), WMSStoreInfo.class);
        Assert.assertEquals((Object)"bar", (Object)wms2.getName());
        Assert.assertEquals((long)18L, (long)wms2.getMaxConnections());
        Assert.assertEquals((long)25L, (long)wms2.getConnectTimeout());
        Assert.assertEquals((long)78L, (long)wms2.getReadTimeout());
        Assert.assertNull((Object)wms2.getMetadata().get((Object)"maxConnections"));
        Assert.assertNull((Object)wms2.getMetadata().get((Object)"connectTimeout"));
        Assert.assertNull((Object)wms2.getMetadata().get((Object)"readTimeout"));
    }

    @Test
    public void testStyle() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        StyleInfo s1 = cFactory.createStyle();
        s1.setName("foo");
        s1.setFilename("foo.sld");
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)s1, (OutputStream)out);
        ByteArrayInputStream in = this.in(out);
        StyleInfo s2 = (StyleInfo)this.persister.load((InputStream)in, StyleInfo.class);
        Assert.assertEquals((Object)s1, (Object)s2);
        Document dom = this.dom(this.in(out));
        Assert.assertEquals((Object)"style", (Object)dom.getDocumentElement().getNodeName());
        catalog.add(s2);
        Assert.assertNull((Object)s2.getWorkspace());
    }

    @Test
    public void testLegacyStyle() throws Exception {
        String xml = "<style>\n  <id>StyleInfoImpl--570ae188:124761b8d78:-7fe2</id>\n  <name>raster</name>\n  <filename>raster.sld</filename>\n</style>";
        StyleInfo style = (StyleInfo)this.persister.load((InputStream)new ByteArrayInputStream(xml.getBytes("UTF-8")), StyleInfo.class);
        Assert.assertEquals((Object)"sld", (Object)style.getFormat());
        Assert.assertEquals((Object)SLDHandler.VERSION_10, (Object)style.getFormatVersion());
    }

    @Test
    public void testWorkspaceStyle() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        StyleInfo s1 = cFactory.createStyle();
        s1.setName("bar");
        s1.setFilename("bar.sld");
        s1.setWorkspace(ws);
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)s1, (OutputStream)out);
        ByteArrayInputStream in = this.in(out);
        StyleInfo s2 = (StyleInfo)this.persister.load((InputStream)in, StyleInfo.class);
        Assert.assertEquals((Object)"bar", (Object)s2.getName());
        Assert.assertNotNull((Object)s2.getWorkspace());
        Assert.assertEquals((Object)"foo", (Object)s2.getWorkspace().getId());
        Document dom = this.dom(this.in(out));
        Assert.assertEquals((Object)"style", (Object)dom.getDocumentElement().getNodeName());
        catalog.add(ws);
        catalog.add(s2);
        Assert.assertEquals((Object)"foo", (Object)s2.getWorkspace().getName());
    }

    @Test
    @Ignore
    public void testCatalog() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        catalog.add(ws);
        NamespaceInfo ns = cFactory.createNamespace();
        ns.setPrefix("acme");
        ns.setURI("http://acme.org");
        catalog.add(ns);
        DataStoreInfo ds = cFactory.createDataStore();
        ds.setWorkspace(ws);
        ds.setName("foo");
        catalog.add((StoreInfo)ds);
        CoverageStoreInfo cs = cFactory.createCoverageStore();
        cs.setWorkspace(ws);
        cs.setName("bar");
        catalog.add((StoreInfo)cs);
        StyleInfo s = cFactory.createStyle();
        s.setName("style");
        s.setFilename("style.sld");
        catalog.add(s);
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)catalog, (OutputStream)out);
        catalog = (Catalog)this.persister.load((InputStream)this.in(out), Catalog.class);
        Assert.assertNotNull((Object)catalog);
        Assert.assertEquals((long)1L, (long)catalog.getWorkspaces().size());
        Assert.assertNotNull((Object)catalog.getDefaultWorkspace());
        ws = catalog.getDefaultWorkspace();
        Assert.assertEquals((Object)"foo", (Object)ws.getName());
        Assert.assertEquals((long)1L, (long)catalog.getNamespaces().size());
        Assert.assertNotNull((Object)catalog.getDefaultNamespace());
        ns = catalog.getDefaultNamespace();
        Assert.assertEquals((Object)"acme", (Object)ns.getPrefix());
        Assert.assertEquals((Object)"http://acme.org", (Object)ns.getURI());
        Assert.assertEquals((long)1L, (long)catalog.getDataStores().size());
        ds = (DataStoreInfo)catalog.getDataStores().get(0);
        Assert.assertEquals((Object)"foo", (Object)ds.getName());
        Assert.assertNotNull((Object)ds.getWorkspace());
        Assert.assertEquals((Object)ws, (Object)ds.getWorkspace());
        Assert.assertEquals((long)1L, (long)catalog.getCoverageStores().size());
        cs = (CoverageStoreInfo)catalog.getCoverageStores().get(0);
        Assert.assertEquals((Object)"bar", (Object)cs.getName());
        Assert.assertEquals((Object)ws, (Object)cs.getWorkspace());
        Assert.assertEquals((long)1L, (long)catalog.getStyles().size());
        s = (StyleInfo)catalog.getStyles().get(0);
        Assert.assertEquals((Object)"style", (Object)s.getName());
        Assert.assertEquals((Object)"style.sld", (Object)s.getFilename());
    }

    @Test
    public void testFeatureType() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        catalog.add(ws);
        NamespaceInfo ns = cFactory.createNamespace();
        ns.setPrefix("acme");
        ns.setURI("http://acme.org");
        catalog.add(ns);
        DataStoreInfo ds = cFactory.createDataStore();
        ds.setWorkspace(ws);
        ds.setName("foo");
        catalog.add((StoreInfo)ds);
        FeatureTypeInfo ft = cFactory.createFeatureType();
        ft.setStore((StoreInfo)ds);
        ft.setNamespace(ns);
        ft.setName("ft");
        ft.setAbstract("abstract");
        ft.setSRS("EPSG:4326");
        ft.setNativeCRS(CRS.decode((String)"EPSG:4326"));
        ft.setLinearizationTolerance(new Measure(10.0, SI.METRE));
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)ft, (OutputStream)out);
        this.persister.setCatalog((Catalog)catalog);
        ft = (FeatureTypeInfo)this.persister.load((InputStream)this.in(out), FeatureTypeInfo.class);
        Assert.assertNotNull((Object)ft);
        Assert.assertEquals((Object)"ft", (Object)ft.getName());
        Assert.assertEquals((Object)ds, (Object)ft.getStore());
        Assert.assertEquals((Object)ns, (Object)ft.getNamespace());
        Assert.assertEquals((Object)"EPSG:4326", (Object)ft.getSRS());
        Assert.assertEquals((Object)new Measure(10.0, SI.METRE), (Object)ft.getLinearizationTolerance());
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)CRS.decode((String)"EPSG:4326"), (Object)ft.getNativeCRS()));
    }

    @Test
    public void testCoverage() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        catalog.add(ws);
        NamespaceInfo ns = cFactory.createNamespace();
        ns.setPrefix("acme");
        ns.setURI("http://acme.org");
        catalog.add(ns);
        CoverageStoreInfo cs = cFactory.createCoverageStore();
        cs.setWorkspace(ws);
        cs.setName("foo");
        catalog.add((StoreInfo)cs);
        CoverageInfo cv = cFactory.createCoverage();
        cv.setStore((StoreInfo)cs);
        cv.setNamespace(ns);
        cv.setName("cv");
        cv.setAbstract("abstract");
        cv.setSRS("EPSG:4326");
        cv.setNativeCRS(CRS.decode((String)"EPSG:4326"));
        cv.getParameters().put("foo", null);
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)cv, (OutputStream)out);
        this.persister.setCatalog((Catalog)catalog);
        cv = (CoverageInfo)this.persister.load((InputStream)this.in(out), CoverageInfo.class);
        Assert.assertNotNull((Object)cv);
        Assert.assertEquals((Object)"cv", (Object)cv.getName());
        Assert.assertEquals((Object)cs, (Object)cv.getStore());
        Assert.assertEquals((Object)ns, (Object)cv.getNamespace());
        Assert.assertEquals((Object)"EPSG:4326", (Object)cv.getSRS());
        Assert.assertTrue((boolean)cv.getParameters().containsKey("foo"));
        Assert.assertNull(cv.getParameters().get("foo"));
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)CRS.decode((String)"EPSG:4326"), (Object)cv.getNativeCRS()));
    }

    @Test
    public void testWMTSLayer() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        catalog.add(ws);
        NamespaceInfo ns = cFactory.createNamespace();
        ns.setPrefix("acme");
        ns.setURI("http://acme.org");
        catalog.add(ns);
        WMTSStoreInfo wmts = cFactory.createWebMapTileServer();
        wmts.setWorkspace(ws);
        wmts.setName("foo");
        wmts.setCapabilitiesURL("http://fake.host/wmts?request=getCapabilities");
        catalog.add((StoreInfo)wmts);
        WMTSLayerInfo wl = cFactory.createWMTSLayer();
        wl.setStore((StoreInfo)wmts);
        wl.setNamespace(ns);
        wl.setName("wmtsLayer");
        wl.setAbstract("abstract");
        wl.setSRS("EPSG:4326");
        wl.setNativeCRS(CRS.decode((String)"EPSG:4326"));
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)wl, (OutputStream)out);
        this.persister.setCatalog((Catalog)catalog);
        wl = (WMTSLayerInfo)this.persister.load((InputStream)this.in(out), WMTSLayerInfo.class);
        Assert.assertNotNull((Object)wl);
        Assert.assertEquals((Object)"wmtsLayer", (Object)wl.getName());
        Assert.assertEquals((Object)wmts, (Object)wl.getStore());
        Assert.assertEquals((Object)ns, (Object)wl.getNamespace());
        Assert.assertEquals((Object)"EPSG:4326", (Object)wl.getSRS());
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)CRS.decode((String)"EPSG:4326"), (Object)wl.getNativeCRS()));
        Document dom = this.dom(this.in(out));
        Assert.assertEquals((Object)"wmtsLayer", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testWMSLayer() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        catalog.add(ws);
        NamespaceInfo ns = cFactory.createNamespace();
        ns.setPrefix("acme");
        ns.setURI("http://acme.org");
        catalog.add(ns);
        WMSStoreInfo wms = cFactory.createWebMapServer();
        wms.setWorkspace(ws);
        wms.setName("foo");
        wms.setCapabilitiesURL("http://fake.host/wms?request=getCapabilities");
        catalog.add((StoreInfo)wms);
        WMSLayerInfo wl = cFactory.createWMSLayer();
        wl.setStore((StoreInfo)wms);
        wl.setNamespace(ns);
        wl.setName("wmsLayer");
        wl.setAbstract("abstract");
        wl.setSRS("EPSG:4326");
        wl.setNativeCRS(CRS.decode((String)"EPSG:4326"));
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)wl, (OutputStream)out);
        this.persister.setCatalog((Catalog)catalog);
        wl = (WMSLayerInfo)this.persister.load((InputStream)this.in(out), WMSLayerInfo.class);
        Assert.assertNotNull((Object)wl);
        Assert.assertEquals((Object)"wmsLayer", (Object)wl.getName());
        Assert.assertEquals((Object)wms, (Object)wl.getStore());
        Assert.assertEquals((Object)ns, (Object)wl.getNamespace());
        Assert.assertEquals((Object)"EPSG:4326", (Object)wl.getSRS());
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)CRS.decode((String)"EPSG:4326"), (Object)wl.getNativeCRS()));
        Document dom = this.dom(this.in(out));
        Assert.assertEquals((Object)"wmsLayer", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testLayer() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        catalog.add(ws);
        NamespaceInfo ns = cFactory.createNamespace();
        ns.setPrefix("acme");
        ns.setURI("http://acme.org");
        catalog.add(ns);
        DataStoreInfo ds = cFactory.createDataStore();
        ds.setWorkspace(ws);
        ds.setName("foo");
        catalog.add((StoreInfo)ds);
        FeatureTypeInfo ft = cFactory.createFeatureType();
        ft.setStore((StoreInfo)ds);
        ft.setNamespace(ns);
        ft.setName("ft");
        ft.setAbstract("abstract");
        ft.setSRS("EPSG:4326");
        ft.setNativeCRS(CRS.decode((String)"EPSG:4326"));
        catalog.add((ResourceInfo)ft);
        StyleInfo s = cFactory.createStyle();
        s.setName("style");
        s.setFilename("style.sld");
        catalog.add(s);
        LayerInfo l = cFactory.createLayer();
        l.setResource((ResourceInfo)ft);
        l.setDefaultStyle(s);
        l.getStyles().add(s);
        catalog.add(l);
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)l, (OutputStream)out);
        this.persister.setCatalog((Catalog)catalog);
        l = (LayerInfo)this.persister.load((InputStream)this.in(out), LayerInfo.class);
        Assert.assertEquals((Object)l.getResource().getName(), (Object)l.getName());
        Assert.assertEquals((Object)ft, (Object)l.getResource());
        Assert.assertEquals((Object)s, (Object)l.getDefaultStyle());
        Assert.assertNotNull((Object)l.getStyles());
        Assert.assertEquals((long)1L, (long)l.getStyles().size());
        Assert.assertTrue((boolean)l.getStyles().contains(s));
    }

    @Test
    public void testLayerGroupInfo() throws Exception {
        for (LayerGroupInfo.Mode mode : LayerGroupInfo.Mode.values()) {
            this.testSerializationWithMode(mode);
        }
    }

    private void testSerializationWithMode(LayerGroupInfo.Mode mode) throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        LayerGroupInfo group1 = cFactory.createLayerGroup();
        group1.setName("foo");
        group1.setTitle("foo title");
        group1.setAbstract("foo abstract");
        group1.setMode(mode);
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)group1, (OutputStream)out);
        ByteArrayInputStream in = this.in(out);
        LayerGroupInfo group2 = (LayerGroupInfo)this.persister.load((InputStream)in, LayerGroupInfo.class);
        Assert.assertEquals((Object)group1.getName(), (Object)group2.getName());
        Assert.assertEquals((Object)group1.getTitle(), (Object)group2.getTitle());
        Assert.assertEquals((Object)group1.getAbstract(), (Object)group2.getAbstract());
        Assert.assertEquals((Object)group1.getMode(), (Object)group2.getMode());
        Document dom = this.dom(this.in(out));
        Assert.assertEquals((Object)"layerGroup", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testLegacyLayerGroupWithoutMode() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<layerGroup>\n<name>foo</name>\n<title>foo title</title>\n<abstractTxt>foo abstract</abstractTxt>\n<layers>\n<layer>\n<id>LayerInfoImpl--570ae188:124761b8d78:-7fb0</id>\n</layer>\n</layers>\n<styles>\n<style/>\n</styles>\n<bounds>\n<minx>589425.9342365642</minx>\n<maxx>609518.6719560538</maxx>\n<miny>4913959.224611808</miny>\n<maxy>4928082.949945881</maxy>\n<crs class=\"projected\">EPSG:26713</crs>\n</bounds>\n</layerGroup>\n";
        LayerGroupInfo group = (LayerGroupInfo)this.persister.load((InputStream)new ByteArrayInputStream(xml.getBytes()), LayerGroupInfo.class);
        Assert.assertEquals((Object)LayerGroupInfo.Mode.SINGLE, (Object)group.getMode());
        CatalogImpl catalog = new CatalogImpl();
        Assert.assertTrue((boolean)catalog.validate(group, false).isValid());
    }

    @Test
    public void testVirtualTable() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        catalog.add(ws);
        NamespaceInfo ns = cFactory.createNamespace();
        ns.setPrefix("acme");
        ns.setURI("http://acme.org");
        catalog.add(ns);
        DataStoreInfo ds = cFactory.createDataStore();
        ds.setWorkspace(ws);
        ds.setName("foo");
        catalog.add((StoreInfo)ds);
        VirtualTable vt = new VirtualTable("riverReduced", "select a, b, c * %mulparam% \n from table \n where x > 1 %andparam%");
        vt.addGeometryMetadatata("geom", LineString.class, 4326);
        vt.setPrimaryKeyColumns(Arrays.asList("a", "b"));
        vt.addParameter(new VirtualTableParameter("mulparam", "1", (VirtualTableParameter.Validator)new RegexpValidator("\\d+")));
        vt.addParameter(new VirtualTableParameter("andparam", null));
        FeatureTypeInfo ft = cFactory.createFeatureType();
        ft.setStore((StoreInfo)ds);
        ft.setNamespace(ns);
        ft.setName("ft");
        ft.setAbstract("abstract");
        ft.setSRS("EPSG:4326");
        ft.setNativeCRS(CRS.decode((String)"EPSG:4326"));
        ft.getMetadata().put("JDBC_VIRTUAL_TABLE", (Serializable)vt);
        catalog.add((ResourceInfo)ft);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.persister.save((Object)ft, (OutputStream)out);
        this.persister.setCatalog((Catalog)catalog);
        ft = (FeatureTypeInfo)this.persister.load((InputStream)this.in(out), FeatureTypeInfo.class);
        VirtualTable vt2 = (VirtualTable)ft.getMetadata().get((Object)"JDBC_VIRTUAL_TABLE");
        Assert.assertNotNull((Object)vt2);
        Assert.assertEquals((Object)vt, (Object)vt2);
    }

    @Test
    public void testVirtualTableMissingEscapeSql() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        catalog.add(ws);
        NamespaceInfo ns = cFactory.createNamespace();
        ns.setPrefix("acme");
        ns.setURI("http://acme.org");
        catalog.add(ns);
        DataStoreInfo ds = cFactory.createDataStore();
        ds.setWorkspace(ws);
        ds.setName("foo");
        catalog.add((StoreInfo)ds);
        this.persister.setCatalog((Catalog)catalog);
        FeatureTypeInfo ft = (FeatureTypeInfo)this.persister.load(this.getClass().getResourceAsStream("/org/geoserver/config/virtualtable_error.xml"), FeatureTypeInfo.class);
        VirtualTable vt2 = (VirtualTable)ft.getMetadata().get((Object)"JDBC_VIRTUAL_TABLE");
        Assert.assertNotNull((Object)vt2);
        Assert.assertEquals((long)1L, (long)ft.getMetadata().size());
    }

    @Test
    public void testVirtualTableMissingEscapeSqlDoesntSkipElements() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        catalog.add(ws);
        NamespaceInfo ns = cFactory.createNamespace();
        ns.setPrefix("acme");
        ns.setURI("http://acme.org");
        catalog.add(ns);
        DataStoreInfo ds = cFactory.createDataStore();
        ds.setWorkspace(ws);
        ds.setName("foo");
        catalog.add((StoreInfo)ds);
        this.persister.setCatalog((Catalog)catalog);
        FeatureTypeInfo ft = (FeatureTypeInfo)this.persister.load(this.getClass().getResourceAsStream("/org/geoserver/config/virtualtable_error_2.xml"), FeatureTypeInfo.class);
        VirtualTable vt2 = (VirtualTable)ft.getMetadata().get((Object)"JDBC_VIRTUAL_TABLE");
        Assert.assertNotNull((Object)vt2);
        Assert.assertEquals((long)1L, (long)ft.getMetadata().size());
        Assert.assertEquals((long)1L, (long)vt2.getGeometries().size());
        String geometryName = (String)vt2.getGeometries().iterator().next();
        Assert.assertEquals((Object)"geometry", (Object)geometryName);
        Assert.assertNotNull((Object)vt2.getGeometryType(geometryName));
        Assert.assertNotNull((Object)vt2.getNativeSrid(geometryName));
    }

    @Test
    public void testOldJTSBindingConversion() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        catalog.add(ws);
        NamespaceInfo ns = cFactory.createNamespace();
        ns.setPrefix("acme");
        ns.setURI("http://acme.org");
        catalog.add(ns);
        DataStoreInfo ds = cFactory.createDataStore();
        ds.setWorkspace(ws);
        ds.setName("foo");
        catalog.add((StoreInfo)ds);
        this.persister.setCatalog((Catalog)catalog);
        FeatureTypeInfo ft = (FeatureTypeInfo)this.persister.load(this.getClass().getResourceAsStream("/org/geoserver/config/old_jts_binding.xml"), FeatureTypeInfo.class);
        Assert.assertNotNull((Object)ft);
        Assert.assertEquals(LineString.class, (Object)((AttributeTypeInfo)ft.getAttributes().get(0)).getBinding());
    }

    @Test
    public void testCRSConverter() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
        XStreamPersister.CRSConverter c = new XStreamPersister.CRSConverter();
        Assert.assertEquals((Object)crs.toWKT(), (Object)c.toString((Object)crs));
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84.toWKT(), (Object)c.toString((Object)DefaultGeographicCRS.WGS84));
        CoordinateReferenceSystem crs2 = (CoordinateReferenceSystem)c.fromString(crs.toWKT());
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)crs, (Object)crs2));
        crs2 = (CoordinateReferenceSystem)c.fromString("EPSG:4326");
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)crs, (Object)crs2));
    }

    @Test
    public void testSRSConverter() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4901");
        XStreamPersister.SRSConverter c = new XStreamPersister.SRSConverter();
        Assert.assertEquals((Object)"EPSG:4901", (Object)c.toString((Object)crs));
        Assert.assertFalse((boolean)"EPSG:4901".equals(c.toString((Object)CRS.parseWKT((String)"GEOGCS[\"GCS_ATF_Paris\",DATUM[\"D_ATF\",SPHEROID[\"Plessis_1817\",6376523.0,308.64]],PRIMEM[\"Paris\",2.337229166666667],UNIT[\"Grad\",0.01570796326794897]]"))));
    }

    @Test
    public void testCRSConverterInvalidWKT() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3575");
        try {
            ((Formattable)crs).toWKT(2, true);
            Assert.fail((String)"expected exception");
        }
        catch (UnformattableObjectException unformattableObjectException) {
            // empty catch block
        }
        String wkt = null;
        try {
            wkt = new XStreamPersister.CRSConverter().toString((Object)crs);
        }
        catch (UnformattableObjectException e) {
            Assert.fail((String)"Should have thrown exception");
        }
        CoordinateReferenceSystem crs2 = (CoordinateReferenceSystem)new XStreamPersister.CRSConverter().fromString(wkt);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)crs, (Object)crs2));
    }

    @Test
    public void testMultimapConverter() throws Exception {
        XStreamPersisterFactory factory = new XStreamPersisterFactory();
        XStreamPersister xmlPersister = factory.createXMLPersister();
        XStream xs = xmlPersister.getXStream();
        ArrayListMultimap mmap = ArrayListMultimap.create();
        mmap.put((Object)"one", (Object)"abc");
        mmap.put((Object)"one", (Object)2);
        mmap.put((Object)"two", (Object)new NumberRange(Integer.class, (Number)10, (Number)20));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.persister.save((Object)mmap, (OutputStream)out);
        Multimap mmap2 = (Multimap)this.persister.load((InputStream)this.in(out), Multimap.class);
        Assert.assertEquals((Object)mmap, (Object)mmap2);
    }

    @Test
    public void testPersisterCustomization() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        ws.getMetadata().put("banana", (Serializable)new SweetBanana("Musa acuminata"));
        XStreamPersisterFactory factory = new XStreamPersisterFactory();
        factory.addInitializer(new XStreamPersisterInitializer(){

            public void init(XStreamPersister persister) {
                persister.getXStream().alias("sweetBanana", SweetBanana.class);
                persister.getXStream().aliasAttribute(SweetBanana.class, "scientificName", "name");
                persister.registerBreifMapComplexType("sweetBanana", SweetBanana.class);
            }
        });
        XStreamPersister persister = factory.createXMLPersister();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        persister.save((Object)ws, (OutputStream)out);
        WorkspaceInfo ws2 = (WorkspaceInfo)persister.load((InputStream)this.in(out), WorkspaceInfo.class);
        Assert.assertEquals((Object)ws, (Object)ws2);
        Document dom = this.dom(this.in(out));
        XMLAssert.assertXpathEvaluatesTo((String)"Musa acuminata", (String)"/workspace/metadata/entry[@key='banana']/sweetBanana/@name", (Document)dom);
    }

    @Test
    public void testCoverageView() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        CoverageInfo coverage = cFactory.createCoverage();
        MetadataMap metadata = coverage.getMetadata();
        coverage.setName("test");
        coverage.setEnabled(true);
        coverage.getAlias().add("alias");
        coverage.getKeywords().add(new Keyword("key"));
        MetadataLinkInfoImpl metadataLink = new MetadataLinkInfoImpl();
        metadataLink.setAbout("about");
        coverage.getMetadataLinks().add(metadataLink);
        CoverageDimensionImpl coverageDimension = new CoverageDimensionImpl("time");
        coverageDimension.setNullValues(Collections.singletonList(0.0));
        coverage.getDimensions().add(coverageDimension);
        coverage.getInterpolationMethods().add("Bilinear");
        coverage.getParameters().put("ParameterKey", "ParameterValue");
        coverage.getSupportedFormats().add("GEOTIFF");
        coverage.getRequestSRS().add("EPSG:4326");
        coverage.getResponseSRS().add("EPSG:4326");
        CoverageView.InputCoverageBand band_u = new CoverageView.InputCoverageBand("u-component_of_current_surface", "0");
        CoverageView.CoverageBand outputBand_u = new CoverageView.CoverageBand(Collections.singletonList(band_u), "u-component_of_current_surface@0", 0, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.InputCoverageBand band_v = new CoverageView.InputCoverageBand("v-component_of_current_surface", "0");
        CoverageView.CoverageBand outputBand_v = new CoverageView.CoverageBand(Collections.singletonList(band_v), "v-component_of_current_surface@0", 1, CoverageView.CompositionType.BAND_SELECT);
        ArrayList<CoverageView.CoverageBand> coverageBands = new ArrayList<CoverageView.CoverageBand>(2);
        coverageBands.add(outputBand_u);
        coverageBands.add(outputBand_v);
        CoverageView coverageView = new CoverageView("regional_currents", coverageBands);
        metadata.put("COVERAGE_VIEW", (Serializable)coverageView);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.persister.save((Object)coverage, (OutputStream)out);
        CoverageInfo coverage2 = (CoverageInfo)this.persister.load((InputStream)this.in(out), CoverageInfo.class);
        Assert.assertEquals((Object)coverage, (Object)coverage2);
    }

    @Test
    public void testVirtualTableOrder() throws Exception {
        FeatureTypeInfo ft = (FeatureTypeInfo)this.persister.load(this.getClass().getResourceAsStream("/org/geoserver/config/virtualtable_order_error.xml"), FeatureTypeInfo.class);
        VirtualTable vtc = (VirtualTable)ft.getMetadata().get((Object)"JDBC_VIRTUAL_TABLE");
        Assert.assertEquals((Object)vtc.getSql(), (Object)"select * from table\n");
        Assert.assertEquals((Object)vtc.getName(), (Object)"sqlview");
    }

    @Test
    public void testVirtualTableMultipleGeoms() throws IOException {
        HashMap<String, String> types = new HashMap<String, String>(){
            {
                this.put("southernmost_point", "org.locationtech.jts.geom.Geometry");
                this.put("location_polygon", "org.locationtech.jts.geom.Geometry");
                this.put("centroid", "org.locationtech.jts.geom.Geometry");
                this.put("northernmost_point", "org.locationtech.jts.geom.Geometry");
                this.put("easternmost_point", "org.locationtech.jts.geom.Geometry");
                this.put("location", "org.locationtech.jts.geom.Geometry");
                this.put("location_original", "org.locationtech.jts.geom.Geometry");
                this.put("westernmost_point", "org.locationtech.jts.geom.Geometry");
            }
        };
        HashMap<String, Integer> srids = new HashMap<String, Integer>(){
            {
                this.put("southernmost_point", 4326);
                this.put("location_polygon", 3003);
                this.put("centroid", 3004);
                this.put("northernmost_point", 3857);
                this.put("easternmost_point", 4326);
                this.put("location", 3003);
                this.put("location_original", 3004);
                this.put("westernmost_point", 3857);
            }
        };
        FeatureTypeInfo ft = (FeatureTypeInfo)this.persister.load(this.getClass().getResourceAsStream("/org/geoserver/config/virtualtable_error_GEOS-7400.xml"), FeatureTypeInfo.class);
        VirtualTable vt3 = (VirtualTable)ft.getMetadata().get((Object)"JDBC_VIRTUAL_TABLE");
        Assert.assertEquals((long)8L, (long)vt3.getGeometries().size());
        for (String g : vt3.getGeometries()) {
            Class geom = vt3.getGeometryType(g);
            Assert.assertEquals((long)((Integer)srids.get(g)).intValue(), (long)vt3.getNativeSrid(g));
            Assert.assertEquals(types.get(g), (Object)geom.getName());
        }
    }

    @Test
    public void testGridGeometry2DConverterUnmarshalling() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        CatalogFactory cFactory = catalog.getFactory();
        WorkspaceInfo ws = cFactory.createWorkspace();
        ws.setName("foo");
        catalog.add(ws);
        NamespaceInfo ns = cFactory.createNamespace();
        ns.setPrefix("acme");
        ns.setURI("http://acme.org");
        catalog.add(ns);
        CoverageStoreInfo cs = cFactory.createCoverageStore();
        cs.setWorkspace(ws);
        cs.setName("coveragestore");
        catalog.add((StoreInfo)cs);
        CoverageInfo cv = cFactory.createCoverage();
        cv.setStore((StoreInfo)cs);
        cv.setNamespace(ns);
        cv.setName("coverage");
        cv.setAbstract("abstract");
        cv.setSRS("EPSG:4326");
        cv.setNativeCRS(CRS.decode((String)"EPSG:4326"));
        cv.getParameters().put("foo", null);
        ByteArrayOutputStream out = this.out();
        this.persister.save((Object)cv, (OutputStream)out);
        ByteArrayInputStream in = this.in(out);
        Document dom = this.dom(in);
        Element crs = dom.createElement("crs");
        Text t = dom.createTextNode("EPSG:4326");
        crs.appendChild(t);
        Element high = dom.createElement("high");
        t = dom.createTextNode("4029 4029");
        high.appendChild(t);
        Element low = dom.createElement("low");
        t = dom.createTextNode("0 0");
        low.appendChild(t);
        Element range = dom.createElement("range");
        range.appendChild(high);
        range.appendChild(low);
        Element translateX = dom.createElement("translateX");
        t = dom.createTextNode("0");
        translateX.appendChild(t);
        Element translateY = dom.createElement("translateY");
        t = dom.createTextNode("0");
        translateY.appendChild(t);
        Element scaleX = dom.createElement("scaleX");
        t = dom.createTextNode("1");
        scaleX.appendChild(t);
        Element scaleY = dom.createElement("scaleY");
        t = dom.createTextNode("1");
        scaleY.appendChild(t);
        Element shearX = dom.createElement("shearX");
        t = dom.createTextNode("0");
        shearX.appendChild(t);
        Element shearY = dom.createElement("shearY");
        t = dom.createTextNode("0");
        shearY.appendChild(t);
        Element transform = dom.createElement("transform");
        transform.appendChild(translateX);
        transform.appendChild(translateY);
        transform.appendChild(scaleX);
        transform.appendChild(scaleY);
        transform.appendChild(shearX);
        transform.appendChild(shearY);
        Element grid = dom.createElement("grid");
        grid.setAttribute("dimension", "2");
        grid.appendChild(crs);
        grid.appendChild(range);
        grid.appendChild(transform);
        Element e = (Element)dom.getElementsByTagName("coverage").item(0);
        Element params = (Element)dom.getElementsByTagName("parameters").item(0);
        e.insertBefore(grid, params);
        in = this.in(dom);
        this.persister.setCatalog((Catalog)catalog);
        cv = (CoverageInfo)this.persister.load((InputStream)in, CoverageInfo.class);
        Assert.assertNotNull((Object)cv);
        Assert.assertNotNull((Object)cv.getGrid());
        Assert.assertNotNull((Object)cv.getGrid().getGridRange());
        Assert.assertNotNull((Object)cv.getCRS());
        Assert.assertNotNull((Object)cv.getGrid().getGridToCRS());
        Assert.assertEquals((long)cv.getGrid().getGridRange().getLow(0), (long)0L);
    }

    @Test
    public void readSettingsMetadataInvalidEntry() throws Exception {
        String xml = "<global>\n  <settings>\n    <metadata>\n      <map>\n        <entry>\n            <string>key1</string>\n            <string>value1</string>\n        </entry>\n        <entry>\n          <string>NetCDFOutput.Key</string>\n          <netCDFSettings>\n            <compressionLevel>0</compressionLevel>\n            <shuffle>true</shuffle>\n            <copyAttributes>false</copyAttributes>\n            <copyGlobalAttributes>false</copyGlobalAttributes>\n            <dataPacking>NONE</dataPacking>\n          </netCDFSettings>\n        </entry>\n        <entry>\n            <string>key2</string>\n            <string>value2</string>\n        </entry>\n      </map>\n    </metadata>\n    <localWorkspaceIncludesPrefix>true</localWorkspaceIncludesPrefix>\n  </settings>\n</global>\n";
        GeoServerInfo gs = (GeoServerInfo)this.persister.load((InputStream)new ByteArrayInputStream(xml.getBytes()), GeoServerInfo.class);
        SettingsInfo settings = gs.getSettings();
        MetadataMap metadata = settings.getMetadata();
        Assert.assertEquals((long)2L, (long)metadata.size());
        Assert.assertThat((Object)metadata, (Matcher)Matchers.hasEntry((Object)"key1", (Object)"value1"));
        Assert.assertThat((Object)metadata, (Matcher)Matchers.hasEntry((Object)"key2", (Object)"value2"));
        Assert.assertTrue((boolean)settings.isLocalWorkspaceIncludesPrefix());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.persister.save((Object)gs, (OutputStream)bos);
        Document doc = this.dom(new ByteArrayInputStream(bos.toByteArray()));
        XMLAssert.assertXpathExists((String)"//settings/metadata/map", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//settings/metadata/map/entry)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"key1", (String)"//settings/metadata/map/entry[1]/string[1]", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"value1", (String)"//settings/metadata/map/entry[1]/string[2]", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"key2", (String)"//settings/metadata/map/entry[2]/string[1]", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"value2", (String)"//settings/metadata/map/entry[2]/string[2]", (Document)doc);
    }

    @Test
    public void readCoverageMetadataInvalidEntry() throws Exception {
        String xml = "<coverage>\n  <metadata>\n    <entry key=\"key1\">value1</entry>\n    <entry key=\"netcdf\">\n      <netCDFSettings>\n            <compressionLevel>0</compressionLevel>\n            <shuffle>true</shuffle>\n            <copyAttributes>false</copyAttributes>\n            <copyGlobalAttributes>false</copyGlobalAttributes>\n            <dataPacking>NONE</dataPacking>\n      </netCDFSettings>\n    </entry>\n    <entry key=\"key2\">value2</entry>\n  </metadata>\n</coverage>";
        CoverageInfo ci = (CoverageInfo)this.persister.load((InputStream)new ByteArrayInputStream(xml.getBytes()), CoverageInfo.class);
        MetadataMap metadata = ci.getMetadata();
        Assert.assertEquals((long)3L, (long)metadata.size());
        Assert.assertThat((Object)metadata, (Matcher)Matchers.hasEntry((Object)"key1", (Object)"value1"));
        Assert.assertThat((Object)metadata, (Matcher)Matchers.hasEntry((Object)"key2", (Object)"value2"));
        Assert.assertThat((Object)metadata, (Matcher)Matchers.hasEntry((Object)"netcdf", null));
    }

    @Test
    public void testLegacyWMSLayerInfo() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wmsLayer>\n   <id>WMSLayerInfoImpl-622caab0:16ff63f5f7a:-7ffc</id>\n   <name>states</name>\n   <nativeName>topp:states</nativeName>\n   <namespace>\n      <id>NamespaceInfoImpl--570ae188:124761b8d78:-7ffc</id>\n   </namespace>\n   <title>USA Population</title>\n   <description>This is some census data on the states.</description>\n   <abstract>This is some census data on the states.</abstract>\n   <keywords>\n      <string>census</string>\n      <string>united</string>\n      <string>boundaries</string>\n      <string>state</string>\n      <string>states</string>\n   </keywords>\n   <nativeCRS>GEOGCS[\"WGS 84\", &#xD;\n  DATUM[\"World Geodetic System 1984\", &#xD;\n    SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]], &#xD;\n    AUTHORITY[\"EPSG\",\"6326\"]], &#xD;\n  PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], &#xD;\n  UNIT[\"degree\", 0.017453292519943295], &#xD;\n  AXIS[\"Geodetic longitude\", EAST], &#xD;\n  AXIS[\"Geodetic latitude\", NORTH], &#xD;\n  AUTHORITY[\"EPSG\",\"4326\"]]</nativeCRS>\n   <srs>EPSG:4326</srs>\n   <nativeBoundingBox>\n      <minx>-124.73142200000001</minx>\n      <maxx>-66.969849</maxx>\n      <miny>24.955967</miny>\n      <maxy>49.371735</maxy>\n      <crs>EPSG:4326</crs>\n   </nativeBoundingBox>\n   <latLonBoundingBox>\n      <minx>-124.731422</minx>\n      <maxx>-66.969849</maxx>\n      <miny>24.955967</miny>\n      <maxy>49.371735</maxy>\n      <crs>EPSG:4326</crs>\n   </latLonBoundingBox>\n   <projectionPolicy>FORCE_DECLARED</projectionPolicy>\n   <enabled>true</enabled>\n   <store class=\"wmsStore\">\n      <id>WMSStoreInfoImpl-622caab0:16ff63f5f7a:-7fff</id>\n   </store>\n   <serviceConfiguration>false</serviceConfiguration>\n</wmsLayer>";
        WMSLayerInfo wmsLayerInfo = (WMSLayerInfo)this.persister.load((InputStream)new ByteArrayInputStream(xml.getBytes()), WMSLayerInfo.class);
        Assert.assertTrue((boolean)wmsLayerInfo.getPreferredFormat().equalsIgnoreCase("image/png"));
        Assert.assertTrue((boolean)wmsLayerInfo.getForcedRemoteStyle().isEmpty());
    }

    ByteArrayOutputStream out() {
        return new ByteArrayOutputStream();
    }

    ByteArrayInputStream in(ByteArrayOutputStream in) {
        return new ByteArrayInputStream(in.toByteArray());
    }

    ByteArrayInputStream in(Document dom) throws Exception {
        Transformer tx = TransformerFactory.newInstance().newTransformer();
        tx.setOutputProperty("indent", "yes");
        ByteArrayOutputStream out = this.out();
        tx.transform(new DOMSource(dom), new StreamResult(out));
        return this.in(out);
    }

    protected Document dom(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
    }

    protected void print(InputStream in) throws Exception {
        Transformer tx = TransformerFactory.newInstance().newTransformer();
        tx.setOutputProperty("indent", "yes");
        tx.transform(new StreamSource(in), new StreamResult(System.out));
    }

    static class SweetBanana
    implements Serializable {
        String scientificName;

        public SweetBanana(String scientificName) {
            this.scientificName = scientificName;
        }
    }

    static class MyServiceInfo
    extends ServiceInfoImpl {
        String foo;

        MyServiceInfo() {
        }

        String getFoo() {
            return this.foo;
        }

        void setFoo(String foo) {
            this.foo = foo;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MyServiceInfo)) {
                return false;
            }
            MyServiceInfo other = (MyServiceInfo)((Object)obj);
            if (this.foo == null ? other.foo != null : !this.foo.equals(other.foo)) {
                return false;
            }
            return super.equals((Object)other);
        }
    }
}

