/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.geoserver.data.jdbc.GenericUnWrapper;
import org.geoserver.data.jdbc.TestConnection;
import org.geoserver.data.jdbc.WrapperConnection;
import org.geotools.data.jdbc.datasource.DataSourceFinder;
import org.geotools.data.jdbc.datasource.UnWrapper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GenericUnWrapperTest {
    GenericUnWrapper unwrapper = new GenericUnWrapper();

    @Before
    public void reset() {
        GenericUnWrapper.CONNECTION_METHODS.remove(WrapperConnection.class);
    }

    @Test
    public void testUnwrapConnection() throws SQLException, NoSuchMethodException, SecurityException {
        TestConnection connection = new TestConnection();
        WrapperConnection wrapper = new WrapperConnection(connection);
        Assert.assertTrue((boolean)wrapper.isWrapperFor(Connection.class));
        Connection unwrap = wrapper.unwrap(Connection.class);
        Assert.assertSame((Object)connection, (Object)unwrap);
        GenericUnWrapper unwrapper = new GenericUnWrapper();
        Assert.assertFalse((boolean)unwrapper.canUnwrap((Connection)wrapper));
        try {
            Assert.assertNull((Object)unwrapper.unwrap((Connection)wrapper));
            Assert.fail((String)"Cannot unwrap yet");
        }
        catch (Exception exception) {
            // empty catch block
        }
        GenericUnWrapper.CONNECTION_METHODS.put(WrapperConnection.class, WrapperConnection.class.getMethod("getUnderlyingConnection", null));
        Assert.assertTrue((boolean)unwrapper.canUnwrap((Connection)wrapper));
        Assert.assertSame((Object)connection, (Object)unwrapper.unwrap((Connection)wrapper));
    }

    @Test
    public void testSPIRegistration() throws Exception {
        TestConnection connection = new TestConnection();
        WrapperConnection wrapper = new WrapperConnection(connection);
        GenericUnWrapper.CONNECTION_METHODS.put(WrapperConnection.class, WrapperConnection.class.getMethod("getUnderlyingConnection", null));
        UnWrapper uw = DataSourceFinder.getUnWrapper((Connection)wrapper);
        Assert.assertNotNull((String)"registed and canUnwrap", (Object)uw);
        if (uw instanceof GenericUnWrapper) {
            Assert.assertSame((String)"Generic unwrapper is working", (Object)connection, (Object)uw.unwrap((Connection)wrapper));
        }
    }
}

