/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data.test;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geoserver.data.test.TestData;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class CiteTestData
implements TestData {
    public static String CITE_PREFIX;
    public static String CITE_URI;
    public static QName BASIC_POLYGONS;
    public static QName BRIDGES;
    public static QName BUILDINGS;
    public static QName DIVIDED_ROUTES;
    public static QName FORESTS;
    public static QName LAKES;
    public static QName MAP_NEATLINE;
    public static QName NAMED_PLACES;
    public static QName PONDS;
    public static QName ROAD_SEGMENTS;
    public static QName STREAMS;
    public static String CDF_PREFIX;
    public static String CDF_URI;
    public static QName DELETES;
    public static QName FIFTEEN;
    public static QName INSERTS;
    public static QName LOCKS;
    public static QName NULLS;
    public static QName OTHER;
    public static QName SEVEN;
    public static QName UPDATES;
    public static String CGF_PREFIX;
    public static String CGF_URI;
    public static QName LINES;
    public static QName MLINES;
    public static QName MPOINTS;
    public static QName MPOLYGONS;
    public static QName POINTS;
    public static QName POLYGONS;
    public static String SF_PREFIX;
    public static String SF_URI;
    public static QName PRIMITIVEGEOFEATURE;
    public static QName AGGREGATEGEOFEATURE;
    public static QName GENERICENTITY;
    public static QName GTOPO_DEM;
    public static QName USA_WORLDIMG;
    public static String DEM;
    public static String PNG;
    public static String WCS_PREFIX;
    public static String WCS_URI;
    public static QName TASMANIA_DEM;
    public static QName TASMANIA_BM;
    public static QName ROTATED_CAD;
    public static QName WORLD;
    public static String TIFF;
    public static String DEFAULT_PREFIX;
    public static String DEFAULT_URI;
    public static QName GEOMETRYLESS;
    public static QName[] TYPENAMES;
    public static QName[] WMS_TYPENAMES;
    public static QName[] WCS_TYPENAMES;
    public static QName[] WFS10_TYPENAMES;
    public static QName[] WFS11_TYPENAMES;
    public static QName[] CDF_TYPENAMES;
    public static QName[] CGF_TYPENAMES;
    public static QName[] SF_TYPENAMES;
    public static QName[] CITE_TYPENAMES;
    public static HashMap<QName, Integer> SRS;
    public static String DEFAULT_VECTOR_STYLE;
    public static String DEFAULT_RASTER_STYLE;
    public static HashMap<QName, String[]> COVERAGES;
    public static final ReferencedEnvelope DEFAULT_LATLON_ENVELOPE;

    public static void registerNamespaces(Map<String, String> namespaces) {
        namespaces.put(CITE_PREFIX, CITE_URI);
        namespaces.put(CDF_PREFIX, CDF_URI);
        namespaces.put(CGF_PREFIX, CGF_URI);
        namespaces.put(SF_PREFIX, SF_URI);
    }

    static {
        int i;
        CITE_PREFIX = "cite";
        CITE_URI = "http://www.opengis.net/cite";
        BASIC_POLYGONS = new QName(CITE_URI, "BasicPolygons", CITE_PREFIX);
        BRIDGES = new QName(CITE_URI, "Bridges", CITE_PREFIX);
        BUILDINGS = new QName(CITE_URI, "Buildings", CITE_PREFIX);
        DIVIDED_ROUTES = new QName(CITE_URI, "DividedRoutes", CITE_PREFIX);
        FORESTS = new QName(CITE_URI, "Forests", CITE_PREFIX);
        LAKES = new QName(CITE_URI, "Lakes", CITE_PREFIX);
        MAP_NEATLINE = new QName(CITE_URI, "MapNeatline", CITE_PREFIX);
        NAMED_PLACES = new QName(CITE_URI, "NamedPlaces", CITE_PREFIX);
        PONDS = new QName(CITE_URI, "Ponds", CITE_PREFIX);
        ROAD_SEGMENTS = new QName(CITE_URI, "RoadSegments", CITE_PREFIX);
        STREAMS = new QName(CITE_URI, "Streams", CITE_PREFIX);
        CDF_PREFIX = "cdf";
        CDF_URI = "http://www.opengis.net/cite/data";
        DELETES = new QName(CDF_URI, "Deletes", CDF_PREFIX);
        FIFTEEN = new QName(CDF_URI, "Fifteen", CDF_PREFIX);
        INSERTS = new QName(CDF_URI, "Inserts", CDF_PREFIX);
        LOCKS = new QName(CDF_URI, "Locks", CDF_PREFIX);
        NULLS = new QName(CDF_URI, "Nulls", CDF_PREFIX);
        OTHER = new QName(CDF_URI, "Other", CDF_PREFIX);
        SEVEN = new QName(CDF_URI, "Seven", CDF_PREFIX);
        UPDATES = new QName(CDF_URI, "Updates", CDF_PREFIX);
        CGF_PREFIX = "cgf";
        CGF_URI = "http://www.opengis.net/cite/geometry";
        LINES = new QName(CGF_URI, "Lines", CGF_PREFIX);
        MLINES = new QName(CGF_URI, "MLines", CGF_PREFIX);
        MPOINTS = new QName(CGF_URI, "MPoints", CGF_PREFIX);
        MPOLYGONS = new QName(CGF_URI, "MPolygons", CGF_PREFIX);
        POINTS = new QName(CGF_URI, "Points", CGF_PREFIX);
        POLYGONS = new QName(CGF_URI, "Polygons", CGF_PREFIX);
        SF_PREFIX = "sf";
        SF_URI = "http://cite.opengeospatial.org/gmlsf";
        PRIMITIVEGEOFEATURE = new QName(SF_URI, "PrimitiveGeoFeature", SF_PREFIX);
        AGGREGATEGEOFEATURE = new QName(SF_URI, "AggregateGeoFeature", SF_PREFIX);
        GENERICENTITY = new QName(SF_URI, "GenericEntity", SF_PREFIX);
        GTOPO_DEM = new QName(CDF_URI, "W020N90", CDF_PREFIX);
        USA_WORLDIMG = new QName(CDF_URI, "usa", CDF_PREFIX);
        DEM = "dem";
        PNG = "png";
        WCS_PREFIX = "wcs";
        WCS_URI = "http://www.opengis.net/wcs/1.1.1";
        TASMANIA_DEM = new QName(WCS_URI, "DEM", WCS_PREFIX);
        TASMANIA_BM = new QName(WCS_URI, "BlueMarble", WCS_PREFIX);
        ROTATED_CAD = new QName(WCS_URI, "RotatedCad", WCS_PREFIX);
        WORLD = new QName(WCS_URI, "World", WCS_PREFIX);
        TIFF = "tiff";
        DEFAULT_PREFIX = "gs";
        DEFAULT_URI = "http://geoserver.org";
        GEOMETRYLESS = new QName(CITE_URI, "Geometryless", CITE_PREFIX);
        TYPENAMES = new QName[]{BASIC_POLYGONS, BRIDGES, BUILDINGS, DIVIDED_ROUTES, FORESTS, LAKES, MAP_NEATLINE, NAMED_PLACES, PONDS, ROAD_SEGMENTS, STREAMS, GEOMETRYLESS, DELETES, FIFTEEN, INSERTS, LOCKS, NULLS, OTHER, SEVEN, UPDATES, LINES, MLINES, MPOINTS, MPOLYGONS, POINTS, POLYGONS, PRIMITIVEGEOFEATURE, AGGREGATEGEOFEATURE, GENERICENTITY};
        WMS_TYPENAMES = new QName[]{BASIC_POLYGONS, BRIDGES, BUILDINGS, DIVIDED_ROUTES, FORESTS, LAKES, MAP_NEATLINE, NAMED_PLACES, PONDS, ROAD_SEGMENTS, STREAMS, GEOMETRYLESS};
        WCS_TYPENAMES = new QName[]{TASMANIA_DEM, TASMANIA_BM, ROTATED_CAD, WORLD};
        WFS10_TYPENAMES = new QName[]{DELETES, FIFTEEN, INSERTS, LOCKS, NULLS, OTHER, SEVEN, UPDATES, LINES, MLINES, MPOINTS, MPOLYGONS, POINTS, POLYGONS};
        WFS11_TYPENAMES = new QName[]{PRIMITIVEGEOFEATURE, AGGREGATEGEOFEATURE, GENERICENTITY};
        CDF_TYPENAMES = new QName[]{DELETES, FIFTEEN, INSERTS, LOCKS, NULLS, OTHER, SEVEN, UPDATES};
        CGF_TYPENAMES = new QName[]{LINES, MLINES, MPOINTS, MPOLYGONS, POINTS, POLYGONS};
        SF_TYPENAMES = WFS11_TYPENAMES;
        CITE_TYPENAMES = WMS_TYPENAMES;
        SRS = new HashMap();
        for (i = 0; i < WFS10_TYPENAMES.length; ++i) {
            SRS.put(WFS10_TYPENAMES[i], 32615);
        }
        for (i = 0; i < WFS11_TYPENAMES.length; ++i) {
            SRS.put(WFS11_TYPENAMES[i], 4326);
        }
        DEFAULT_VECTOR_STYLE = "Default";
        DEFAULT_RASTER_STYLE = "raster";
        COVERAGES = new HashMap();
        COVERAGES.put(TASMANIA_DEM, new String[]{"tazdem.tiff", TIFF});
        COVERAGES.put(TASMANIA_BM, new String[]{"tazbm.tiff", TIFF});
        COVERAGES.put(ROTATED_CAD, new String[]{"rotated.tiff", TIFF});
        COVERAGES.put(WORLD, new String[]{"world.tiff", TIFF});
        DEFAULT_LATLON_ENVELOPE = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }
}

