/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data.test;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.SLDHandler;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.util.IOUtils;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.property.PropertyDataStoreFactory;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.util.URLs;
import org.geotools.util.Version;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;

public class MockCatalogBuilder {
    Catalog catalog;
    File dataDirRoot;
    Callback callback;
    LinkedList<WorkspaceInfo> workspaces = new LinkedList();
    LinkedList<NamespaceInfo> namespaces = new LinkedList();
    LinkedList<DataStoreInfo> dataStores = new LinkedList();
    LinkedList<CoverageStoreInfo> coverageStores = new LinkedList();
    LinkedList<FeatureTypeInfo> featureTypes = new LinkedList();
    LinkedList<CoverageInfo> coverages = new LinkedList();
    LinkedList<LayerInfo> layers = new LinkedList();
    LinkedList<StyleInfo> styles = new LinkedList();
    LinkedList<LayerGroupInfo> layerGroups = new LinkedList();
    LinkedList<FeatureTypeInfo> featureTypesByNamespace = new LinkedList();
    LinkedList<FeatureTypeInfo> featureTypesAll = new LinkedList();
    LinkedList<CoverageInfo> coveragesByNamespace = new LinkedList();
    LinkedList<CoverageInfo> coveragesAll = new LinkedList();
    LinkedList<DataStoreInfo> dataStoresAll = new LinkedList();
    LinkedList<CoverageStoreInfo> coverageStoresAll = new LinkedList();

    public MockCatalogBuilder(Catalog catalog, File dataDirRoot) {
        this.catalog = catalog;
        this.dataDirRoot = dataDirRoot;
        this.callback = (Callback)EasyMock.createNiceMock(Callback.class);
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public MockCatalogBuilder workspace(String name, String uri) {
        String wsId = this.newId();
        String nsId = this.newId();
        final WorkspaceInfo ws = (WorkspaceInfo)EasyMock.createNiceMock(WorkspaceInfo.class);
        this.workspaces.add(ws);
        EasyMock.expect((Object)ws.getId()).andReturn((Object)wsId).anyTimes();
        EasyMock.expect((Object)ws.getName()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)ws.getMetadata()).andReturn((Object)new MetadataMap()).anyTimes();
        EasyMock.expect((Object)this.catalog.getWorkspace(wsId)).andReturn((Object)ws).anyTimes();
        EasyMock.expect((Object)this.catalog.getWorkspaceByName(name)).andReturn((Object)ws).anyTimes();
        final NamespaceInfo ns = (NamespaceInfo)EasyMock.createNiceMock(NamespaceInfo.class);
        this.namespaces.add(ns);
        EasyMock.expect((Object)ns.getId()).andReturn((Object)nsId).anyTimes();
        EasyMock.expect((Object)ns.getName()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)ns.getPrefix()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)ns.getMetadata()).andReturn((Object)new MetadataMap()).anyTimes();
        EasyMock.expect((Object)ns.getURI()).andReturn((Object)uri).anyTimes();
        EasyMock.expect((Object)this.catalog.getNamespace(nsId)).andReturn((Object)ns).anyTimes();
        EasyMock.expect((Object)this.catalog.getNamespaceByPrefix(name)).andReturn((Object)ns).anyTimes();
        EasyMock.expect((Object)this.catalog.getNamespaceByURI(uri)).andReturn((Object)ns).anyTimes();
        ws.accept((CatalogVisitor)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer((IAnswer)new VisitAnswer(){

            @Override
            protected void doVisit(CatalogVisitor visitor) {
                visitor.visit(ws);
            }
        }).anyTimes();
        ns.accept((CatalogVisitor)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer((IAnswer)new VisitAnswer(){

            @Override
            protected void doVisit(CatalogVisitor visitor) {
                visitor.visit(ns);
            }
        }).anyTimes();
        this.callback.onWorkspace(name, ws, this);
        EasyMock.replay((Object[])new Object[]{ws, ns});
        return this;
    }

    public MockCatalogBuilder dataStore(String name) {
        String dsId = this.newId();
        WorkspaceInfo ws = this.workspaces.peekLast();
        final NamespaceInfo ns = this.namespaces.peekLast();
        final DataStoreInfo ds = (DataStoreInfo)EasyMock.createNiceMock(DataStoreInfo.class);
        this.dataStores.add(ds);
        this.initStore(ds, DataStoreInfo.class, dsId, name, ws);
        final File propDir = new File(this.dataDirRoot, name);
        HashMap<String, Object> cxParams = new HashMap<String, Object>();
        cxParams.put(PropertyDataStoreFactory.DIRECTORY.key, propDir);
        cxParams.put(PropertyDataStoreFactory.NAMESPACE.key, ns.getURI());
        EasyMock.expect((Object)ds.getConnectionParameters()).andReturn(cxParams).anyTimes();
        try {
            EasyMock.expect((Object)ds.getDataStore(null)).andAnswer((IAnswer)new IAnswer<DataAccess>(){

                public DataAccess answer() throws Throwable {
                    return new PropertyDataStore(propDir, ns.getURI());
                }
            }).anyTimes();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        EasyMock.expect((Object)this.catalog.getDataStore(dsId)).andReturn((Object)ds).anyTimes();
        EasyMock.expect((Object)this.catalog.getDataStoreByName(name)).andReturn((Object)ds).anyTimes();
        EasyMock.expect((Object)this.catalog.getDataStoreByName(ws.getName(), name)).andReturn((Object)ds).anyTimes();
        EasyMock.expect((Object)this.catalog.getDataStoreByName(ws, name)).andReturn((Object)ds).anyTimes();
        ds.accept((CatalogVisitor)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer((IAnswer)new VisitAnswer(){

            @Override
            protected void doVisit(CatalogVisitor visitor) {
                visitor.visit(ds);
            }
        }).anyTimes();
        this.callback.onStore(name, (StoreInfo)ds, ws, this);
        EasyMock.replay((Object[])new Object[]{ds});
        return this;
    }

    public MockCatalogBuilder coverageStore(String name, String filename, String format) {
        String csId = this.newId();
        WorkspaceInfo ws = this.workspaces.peekLast();
        NamespaceInfo ns = this.namespaces.peekLast();
        final CoverageStoreInfo cs = (CoverageStoreInfo)EasyMock.createNiceMock(CoverageStoreInfo.class);
        this.coverageStores.add(cs);
        this.initStore(cs, CoverageStoreInfo.class, csId, name, ws);
        File covDir = new File(this.dataDirRoot, name);
        final File covFile = new File(covDir, filename);
        EasyMock.expect((Object)cs.getURL()).andReturn((Object)URLs.fileToUrl((File)covFile).toString()).anyTimes();
        EasyMock.expect((Object)cs.getType()).andAnswer((IAnswer)new IAnswer<String>(){

            public String answer() throws Throwable {
                return MockCatalogBuilder.this.lookupGridFormat(covFile).getName();
            }
        }).anyTimes();
        EasyMock.expect((Object)cs.getFormat()).andAnswer((IAnswer)new IAnswer<AbstractGridFormat>(){

            public AbstractGridFormat answer() throws Throwable {
                return MockCatalogBuilder.this.lookupGridFormat(covFile);
            }
        }).anyTimes();
        EasyMock.expect((Object)cs.getConnectionParameters()).andReturn(new HashMap()).anyTimes();
        EasyMock.expect((Object)this.catalog.getCoverageStore(csId)).andReturn((Object)cs).anyTimes();
        EasyMock.expect((Object)this.catalog.getCoverageStoreByName(name)).andReturn((Object)cs).anyTimes();
        EasyMock.expect((Object)this.catalog.getCoverageStoreByName(ws.getName(), name)).andReturn((Object)cs).anyTimes();
        EasyMock.expect((Object)this.catalog.getCoverageStoreByName(ws, name)).andReturn((Object)cs).anyTimes();
        cs.accept((CatalogVisitor)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer((IAnswer)new VisitAnswer(){

            @Override
            protected void doVisit(CatalogVisitor visitor) {
                visitor.visit(cs);
            }
        }).anyTimes();
        this.callback.onStore(name, (StoreInfo)cs, ws, this);
        EasyMock.replay((Object[])new Object[]{cs});
        return this;
    }

    AbstractGridFormat lookupGridFormat(Object obj) {
        AbstractGridFormat format = GridFormatFinder.findFormat((Object)obj);
        if (format == null) {
            throw new RuntimeException("No format for " + obj);
        }
        return format;
    }

    <T extends StoreInfo> void initStore(T s, Class<T> clazz, String sId, String name, WorkspaceInfo ws) {
        EasyMock.expect((Object)s.getId()).andReturn((Object)sId).anyTimes();
        EasyMock.expect((Object)s.getName()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)s.getWorkspace()).andReturn((Object)ws).anyTimes();
        EasyMock.expect((Object)s.getCatalog()).andReturn((Object)this.catalog).anyTimes();
        EasyMock.expect((Object)s.isEnabled()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.catalog.getStore(sId, clazz)).andReturn(s).anyTimes();
        EasyMock.expect((Object)this.catalog.getStore(sId, StoreInfo.class)).andReturn(s).anyTimes();
        EasyMock.expect((Object)this.catalog.getStoreByName(name, clazz)).andReturn(s).anyTimes();
        EasyMock.expect((Object)this.catalog.getStoreByName(name, StoreInfo.class)).andReturn(s).anyTimes();
        EasyMock.expect((Object)this.catalog.getStoreByName(ws.getName(), name, clazz)).andReturn(s).anyTimes();
        EasyMock.expect((Object)this.catalog.getStoreByName(ws.getName(), name, StoreInfo.class)).andReturn(s).anyTimes();
        EasyMock.expect((Object)this.catalog.getStoreByName(ws, name, clazz)).andReturn(s).anyTimes();
        EasyMock.expect((Object)this.catalog.getStoreByName(ws, name, StoreInfo.class)).andReturn(s).anyTimes();
    }

    public MockCatalogBuilder featureType(String name) {
        return this.featureType(name, null, ProjectionPolicy.NONE, null, CiteTestData.DEFAULT_LATLON_ENVELOPE);
    }

    public MockCatalogBuilder featureType(final String name, String srs, ProjectionPolicy projPolicy, ReferencedEnvelope envelope, ReferencedEnvelope latLonEnvelope) {
        String ftId = this.newId();
        final DataStoreInfo ds = this.dataStores.peekLast();
        NamespaceInfo ns = this.namespaces.peekLast();
        final FeatureTypeInfo ft = (FeatureTypeInfo)EasyMock.createNiceMock(FeatureTypeInfo.class);
        this.featureTypes.add(ft);
        this.initResource(ft, FeatureTypeInfo.class, ftId, name, (StoreInfo)ds, ns, srs, projPolicy, envelope, latLonEnvelope);
        EasyMock.expect((Object)ft.getNumDecimals()).andReturn((Object)8);
        File propDir = new File(this.dataDirRoot, ds.getName());
        propDir.mkdirs();
        String fileName = name + ".properties";
        try {
            IOUtils.copy((InputStream)this.getClass().getResourceAsStream(fileName), (File)new File(propDir, fileName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EasyMock.expect((Object)ft.getFeatureType()).andAnswer((IAnswer)new IAnswer<FeatureType>(){

                public FeatureType answer() throws Throwable {
                    return ((DataStore)ds.getDataStore(null)).getSchema(name);
                }
            }).anyTimes();
            EasyMock.expect((Object)ft.getFeatureSource(null, null)).andAnswer((IAnswer)new IAnswer<FeatureSource>(){

                public FeatureSource answer() throws Throwable {
                    return ((DataStore)ds.getDataStore(null)).getFeatureSource(name);
                }
            }).anyTimes();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        EasyMock.expect((Object)this.catalog.getFeatureTypeByName((String)EasyMock.or((Object)((String)EasyMock.eq((Object)name)), (Object)((String)EasyMock.eq((Object)(ns.getPrefix() + ":" + name)))))).andReturn((Object)ft).anyTimes();
        EasyMock.expect((Object)this.catalog.getFeatureTypeByName((Name)EasyMock.or((Object)((NameImpl)EasyMock.eq((Object)new NameImpl(ns.getPrefix(), name))), (Object)((NameImpl)EasyMock.eq((Object)new NameImpl(ns.getURI(), name)))))).andReturn((Object)ft).anyTimes();
        EasyMock.expect((Object)this.catalog.getFeatureTypeByName(ns, name)).andReturn((Object)ft).anyTimes();
        EasyMock.expect((Object)this.catalog.getFeatureTypeByName(ns.getPrefix(), name)).andReturn((Object)ft).anyTimes();
        EasyMock.expect((Object)this.catalog.getFeatureTypeByDataStore(ds, name)).andReturn((Object)ft).anyTimes();
        ft.accept((CatalogVisitor)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer((IAnswer)new VisitAnswer(){

            @Override
            protected void doVisit(CatalogVisitor visitor) {
                visitor.visit(ft);
            }
        }).anyTimes();
        this.callback.onResource(name, (ResourceInfo)ft, (StoreInfo)ds, this);
        EasyMock.replay((Object[])new Object[]{ft, this.createLayer((ResourceInfo)ft, name, ns)});
        return this;
    }

    public MockCatalogBuilder coverage(QName qName, String fileName, String srs, Class scope) {
        scope = scope != null ? scope : this.getClass();
        String cId = this.newId();
        CoverageStoreInfo cs = this.coverageStores.peekLast();
        NamespaceInfo ns = this.namespaces.peekLast();
        String name = qName.getLocalPart();
        File dir = new File(this.dataDirRoot, name);
        dir.mkdir();
        try {
            IOUtils.copy((InputStream)scope.getResourceAsStream(fileName), (File)new File(dir, fileName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CatalogBuilder cb = new CatalogBuilder((Catalog)new CatalogImpl());
        cb.setStore((StoreInfo)cs);
        AbstractGridCoverage2DReader reader = cs.getFormat().getReader((Object)cs.getURL());
        if (reader == null) {
            throw new RuntimeException("No reader for " + cs.getURL());
        }
        CoverageInfo real = null;
        try {
            real = cb.buildCoverage((GridCoverage2DReader)reader, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        final CoverageInfo c = (CoverageInfo)EasyMock.createNiceMock(CoverageInfo.class);
        this.coverages.add(c);
        LinkedList<CoverageInfo> coverageList = this.coverages;
        if (srs == null) {
            srs = real.getSRS();
        }
        this.initResource(c, CoverageInfo.class, cId, name, (StoreInfo)cs, ns, srs, real.getProjectionPolicy(), real.getNativeBoundingBox(), real.getLatLonBoundingBox());
        EasyMock.expect((Object)c.getDefaultInterpolationMethod()).andReturn((Object)real.getDefaultInterpolationMethod()).anyTimes();
        EasyMock.expect((Object)c.getDimensions()).andReturn((Object)real.getDimensions()).anyTimes();
        EasyMock.expect((Object)c.getGrid()).andReturn((Object)real.getGrid()).anyTimes();
        EasyMock.expect((Object)c.getInterpolationMethods()).andReturn((Object)real.getInterpolationMethods()).anyTimes();
        EasyMock.expect((Object)c.getRequestSRS()).andReturn((Object)real.getRequestSRS()).anyTimes();
        EasyMock.expect((Object)c.getResponseSRS()).andReturn((Object)real.getResponseSRS()).anyTimes();
        try {
            EasyMock.expect((Object)c.getGridCoverageReader(null, null)).andReturn((Object)reader).anyTimes();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        EasyMock.expect((Object)this.catalog.getCoverageByName((String)EasyMock.or((Object)((String)EasyMock.eq((Object)name)), (Object)((String)EasyMock.eq((Object)(ns.getPrefix() + ":" + name)))))).andReturn((Object)c).anyTimes();
        EasyMock.expect((Object)this.catalog.getCoverageByName((Name)EasyMock.or((Object)((NameImpl)EasyMock.eq((Object)new NameImpl(ns.getPrefix(), name))), (Object)((NameImpl)EasyMock.eq((Object)new NameImpl(ns.getURI(), name)))))).andReturn((Object)c).anyTimes();
        EasyMock.expect((Object)this.catalog.getCoverageByName(ns, name)).andReturn((Object)c).anyTimes();
        EasyMock.expect((Object)this.catalog.getCoverageByName(ns.getPrefix(), name)).andReturn((Object)c).anyTimes();
        EasyMock.expect((Object)this.catalog.getCoveragesByStore(cs)).andReturn(coverageList).anyTimes();
        EasyMock.expect((Object)this.catalog.getCoverageByCoverageStore(cs, name)).andReturn((Object)c).anyTimes();
        c.accept((CatalogVisitor)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer((IAnswer)new VisitAnswer(){

            @Override
            protected void doVisit(CatalogVisitor visitor) {
                visitor.visit(c);
            }
        }).anyTimes();
        this.callback.onResource(name, (ResourceInfo)c, (StoreInfo)cs, this);
        EasyMock.replay((Object[])new Object[]{c, this.createLayer((ResourceInfo)c, name, ns)});
        return this;
    }

    <T extends ResourceInfo> void initResource(T r, Class<T> clazz, String rId, String name, StoreInfo s, NamespaceInfo ns, String srs, ProjectionPolicy projPolicy, ReferencedEnvelope envelope, ReferencedEnvelope latLonEnvelope) {
        EasyMock.expect((Object)r.getId()).andReturn((Object)rId).anyTimes();
        EasyMock.expect((Object)r.getName()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)r.getQualifiedName()).andReturn((Object)new NameImpl(ns.getURI(), name)).anyTimes();
        EasyMock.expect((Object)r.getNativeName()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)r.getQualifiedNativeName()).andReturn((Object)new NameImpl(ns.getURI(), name)).anyTimes();
        EasyMock.expect((Object)r.getTitle()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)r.getAbstract()).andReturn((Object)("abstract about " + name)).anyTimes();
        EasyMock.expect((Object)r.getStore()).andReturn((Object)s).anyTimes();
        EasyMock.expect((Object)r.getNamespace()).andReturn((Object)ns).anyTimes();
        srs = srs != null ? srs : "EPSG:4326";
        EasyMock.expect((Object)r.getSRS()).andReturn((Object)srs).anyTimes();
        try {
            EasyMock.expect((Object)r.getNativeCRS()).andReturn((Object)CRS.decode((String)srs));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        EasyMock.expect((Object)r.getKeywords()).andReturn(Arrays.asList(new Keyword(name))).anyTimes();
        EasyMock.expect((Object)r.isEnabled()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)r.isAdvertised()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)r.getProjectionPolicy()).andReturn((Object)projPolicy).anyTimes();
        EasyMock.expect((Object)r.getLatLonBoundingBox()).andReturn((Object)latLonEnvelope).anyTimes();
        EasyMock.expect((Object)r.getNativeBoundingBox()).andReturn((Object)envelope).anyTimes();
        EasyMock.expect((Object)this.catalog.getResource(rId, clazz)).andReturn(r).anyTimes();
        EasyMock.expect((Object)this.catalog.getResourceByName(ns.getPrefix() + ":" + name, clazz)).andReturn(r).anyTimes();
        EasyMock.expect((Object)this.catalog.getResourceByName(ns.getPrefix() + ":" + name, ResourceInfo.class)).andReturn(r).anyTimes();
        EasyMock.expect((Object)this.catalog.getResourceByName(name, clazz)).andReturn(r).anyTimes();
        EasyMock.expect((Object)this.catalog.getResourceByName(name, ResourceInfo.class)).andReturn(r).anyTimes();
        EasyMock.expect((Object)this.catalog.getResourceByName((Name)new NameImpl(ns.getPrefix(), name), clazz)).andReturn(r).anyTimes();
        EasyMock.expect((Object)this.catalog.getResourceByName((Name)new NameImpl(ns.getPrefix(), name), ResourceInfo.class)).andReturn(r).anyTimes();
        EasyMock.expect((Object)this.catalog.getResourceByName((Name)new NameImpl(ns.getURI(), name), clazz)).andReturn(r).anyTimes();
        EasyMock.expect((Object)this.catalog.getResourceByName((Name)new NameImpl(ns.getURI(), name), ResourceInfo.class)).andReturn(r).anyTimes();
        EasyMock.expect((Object)this.catalog.getResourceByName(ns, name, clazz)).andReturn(r).andReturn(r).anyTimes();
        EasyMock.expect((Object)this.catalog.getResourceByName(ns, name, ResourceInfo.class)).andReturn(r).andReturn(r).anyTimes();
        EasyMock.expect((Object)this.catalog.getResourceByName(ns.getPrefix(), name, clazz)).andReturn(r).anyTimes();
        EasyMock.expect((Object)this.catalog.getResourceByName(ns.getPrefix(), name, ResourceInfo.class)).andReturn(r).anyTimes();
        EasyMock.expect((Object)this.catalog.getResourceByStore(s, name, clazz)).andReturn(r).anyTimes();
        EasyMock.expect((Object)this.catalog.getResourceByStore(s, name, ResourceInfo.class)).andReturn(r).anyTimes();
    }

    LayerInfo createLayer(ResourceInfo r, String name, NamespaceInfo ns) {
        String lId = this.newId();
        StyleInfo s = this.styles.peekLast();
        final LayerInfo l = (LayerInfo)EasyMock.createNiceMock(LayerInfo.class);
        this.layers.add(l);
        EasyMock.expect((Object)l.getId()).andReturn((Object)lId).anyTimes();
        EasyMock.expect((Object)l.getName()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)l.getType()).andReturn((Object)PublishedType.VECTOR).anyTimes();
        EasyMock.expect((Object)l.getResource()).andReturn((Object)r).anyTimes();
        EasyMock.expect((Object)l.getDefaultStyle()).andReturn((Object)s).anyTimes();
        EasyMock.expect((Object)l.getStyles()).andReturn(Collections.singleton(s)).anyTimes();
        EasyMock.expect((Object)l.isEnabled()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)l.isAdvertised()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.catalog.getLayer(lId)).andReturn((Object)l).anyTimes();
        EasyMock.expect((Object)this.catalog.getLayerByName(name)).andReturn((Object)l).anyTimes();
        EasyMock.expect((Object)this.catalog.getLayerByName(ns.getPrefix() + ":" + name)).andReturn((Object)l).anyTimes();
        EasyMock.expect((Object)this.catalog.getLayerByName((Name)new NameImpl(ns.getPrefix(), name))).andReturn((Object)l).anyTimes();
        EasyMock.expect((Object)this.catalog.getLayerByName((Name)new NameImpl(ns.getURI(), name))).andReturn((Object)l).anyTimes();
        EasyMock.expect((Object)this.catalog.getLayers(r)).andReturn(Arrays.asList(l)).anyTimes();
        l.accept((CatalogVisitor)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer((IAnswer)new VisitAnswer(){

            @Override
            protected void doVisit(CatalogVisitor visitor) {
                visitor.visit(l);
            }
        }).anyTimes();
        this.callback.onLayer(name, l, this);
        return l;
    }

    public MockCatalogBuilder style(String name) {
        String filename = name + ".sld";
        if (this.getClass().getResourceAsStream(filename) == null) {
            return this;
        }
        String sId = this.newId();
        String format = "sld";
        Version version = SLDHandler.VERSION_10;
        final StyleInfo s = (StyleInfo)EasyMock.createNiceMock(StyleInfo.class);
        this.styles.add(s);
        EasyMock.expect((Object)s.getId()).andReturn((Object)sId);
        EasyMock.expect((Object)s.getName()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)s.getFilename()).andReturn((Object)filename).anyTimes();
        EasyMock.expect((Object)s.getFormatVersion()).andReturn((Object)version).anyTimes();
        try {
            EasyMock.expect((Object)s.getStyle()).andReturn((Object)Styles.style((StyledLayerDescriptor)new SLDHandler().parse((Object)this.getClass().getResourceAsStream(filename), version, null, null))).anyTimes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        EasyMock.expect((Object)this.catalog.getStyle(sId)).andReturn((Object)s).anyTimes();
        EasyMock.expect((Object)this.catalog.getStyleByName(name)).andReturn((Object)s).anyTimes();
        s.accept((CatalogVisitor)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer((IAnswer)new VisitAnswer(){

            @Override
            protected void doVisit(CatalogVisitor visitor) {
                visitor.visit(s);
            }
        }).anyTimes();
        this.callback.onStyle(name, s, this);
        EasyMock.replay((Object[])new Object[]{s});
        return this;
    }

    public MockCatalogBuilder layerGroup(String name, List<String> layerNames, List<String> styleNames) {
        final LayerGroupInfo lg = (LayerGroupInfo)EasyMock.createMock(LayerGroupInfo.class);
        this.layerGroups.add(lg);
        EasyMock.expect((Object)lg.getId()).andReturn((Object)this.newId()).anyTimes();
        EasyMock.expect((Object)lg.getName()).andReturn((Object)name).anyTimes();
        ArrayList<LayerInfo> grpLayers = new ArrayList<LayerInfo>();
        ArrayList<StyleInfo> grpStyles = new ArrayList<StyleInfo>();
        for (int i = 0; i < layerNames.size(); ++i) {
            String layerName = layerNames.get(i);
            LayerInfo l = null;
            for (LayerInfo layer : this.layers) {
                if (!layerName.equals(layer.getName())) continue;
                l = layer;
                break;
            }
            if (l == null) {
                throw new RuntimeException("No such layer: " + layerName);
            }
            grpLayers.add(l);
            StyleInfo s = null;
            if (styleNames != null) {
                String styleName = styleNames.get(i);
                for (StyleInfo style : this.styles) {
                    if (!styleName.equals(style.getName())) continue;
                    s = style;
                    break;
                }
            }
            grpStyles.add(s);
        }
        EasyMock.expect((Object)lg.getLayers()).andReturn(grpLayers).anyTimes();
        EasyMock.expect((Object)lg.getStyles()).andReturn(grpStyles).anyTimes();
        EasyMock.expect((Object)lg.getRootLayer()).andReturn(null).anyTimes();
        EasyMock.expect((Object)lg.getRootLayerStyle()).andReturn(null).anyTimes();
        lg.accept((CatalogVisitor)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer((IAnswer)new VisitAnswer(){

            @Override
            protected void doVisit(CatalogVisitor visitor) {
                visitor.visit(lg);
            }
        }).anyTimes();
        EasyMock.expect((Object)this.catalog.getLayerGroupByName(name)).andReturn((Object)lg).anyTimes();
        this.callback.onLayerGroup(name, lg, this);
        EasyMock.replay((Object[])new Object[]{lg});
        return this;
    }

    public MockCatalogBuilder commit() {
        if (!this.featureTypes.isEmpty() || !this.coverages.isEmpty()) {
            if (!this.featureTypes.isEmpty()) {
                DataStoreInfo ds = this.dataStores.peekLast();
                EasyMock.expect((Object)this.catalog.getResourcesByStore((StoreInfo)ds, FeatureTypeInfo.class)).andReturn(this.featureTypes).anyTimes();
                EasyMock.expect((Object)this.catalog.getResourcesByStore((StoreInfo)ds, ResourceInfo.class)).andReturn(this.featureTypes).anyTimes();
                EasyMock.expect((Object)this.catalog.getFeatureTypesByDataStore(ds)).andReturn(this.featureTypes).anyTimes();
            }
            if (!this.coverages.isEmpty()) {
                CoverageStoreInfo cs = this.coverageStores.peekLast();
                EasyMock.expect((Object)this.catalog.getResourcesByStore((StoreInfo)cs, CoverageInfo.class)).andReturn(this.coverages).anyTimes();
                EasyMock.expect((Object)this.catalog.getResourcesByStore((StoreInfo)cs, ResourceInfo.class)).andReturn(this.coverages).anyTimes();
                EasyMock.expect((Object)this.catalog.getCoveragesByCoverageStore(cs)).andReturn(this.coverages).anyTimes();
            }
            this.featureTypesByNamespace.addAll(this.featureTypes);
            this.featureTypes = new LinkedList();
            this.coveragesByNamespace.addAll(this.coverages);
            this.coverages = new LinkedList();
        } else if (!this.dataStores.isEmpty() || !this.coverageStores.isEmpty()) {
            WorkspaceInfo ws = this.workspaces.peekLast();
            NamespaceInfo ns = this.namespaces.peekLast();
            EasyMock.expect((Object)this.catalog.getStoresByWorkspace(ws.getName(), DataStoreInfo.class)).andReturn(this.dataStores).anyTimes();
            EasyMock.expect((Object)this.catalog.getStoresByWorkspace(ws, DataStoreInfo.class)).andReturn(this.dataStores).anyTimes();
            EasyMock.expect((Object)this.catalog.getDataStoresByWorkspace(ws.getName())).andReturn(this.dataStores).anyTimes();
            EasyMock.expect((Object)this.catalog.getDataStoresByWorkspace(ws)).andReturn(this.dataStores).anyTimes();
            EasyMock.expect((Object)this.catalog.getStoresByWorkspace(ws.getName(), CoverageStoreInfo.class)).andReturn(this.coverageStores).anyTimes();
            EasyMock.expect((Object)this.catalog.getStoresByWorkspace(ws, CoverageStoreInfo.class)).andReturn(this.coverageStores).anyTimes();
            EasyMock.expect((Object)this.catalog.getCoverageStoresByWorkspace(ws.getName())).andReturn(this.coverageStores).anyTimes();
            EasyMock.expect((Object)this.catalog.getCoverageStoresByWorkspace(ws)).andReturn(this.coverageStores).anyTimes();
            LinkedList<DataStoreInfo> l = new LinkedList<DataStoreInfo>(this.dataStores);
            l.addAll(this.coverageStores);
            EasyMock.expect((Object)this.catalog.getStoresByWorkspace(ws.getName(), StoreInfo.class)).andReturn(l).anyTimes();
            EasyMock.expect((Object)this.catalog.getStoresByWorkspace(ws, StoreInfo.class)).andReturn(l).anyTimes();
            EasyMock.expect((Object)this.catalog.getStylesByWorkspace(ws.getName())).andReturn(this.styles).anyTimes();
            EasyMock.expect((Object)this.catalog.getStylesByWorkspace(ws)).andReturn(this.styles).anyTimes();
            EasyMock.expect((Object)this.catalog.getLayerGroupsByWorkspace(ws.getName())).andReturn(this.layerGroups).anyTimes();
            EasyMock.expect((Object)this.catalog.getLayerGroupsByWorkspace(ws)).andReturn(this.layerGroups).anyTimes();
            LinkedList<FeatureTypeInfo> m = new LinkedList<FeatureTypeInfo>(this.featureTypesByNamespace);
            m.addAll(this.coveragesByNamespace);
            EasyMock.expect((Object)this.catalog.getResourcesByNamespace(ns, ResourceInfo.class)).andReturn(m).anyTimes();
            EasyMock.expect((Object)this.catalog.getResourcesByNamespace(ns, FeatureTypeInfo.class)).andReturn(this.featureTypesByNamespace).anyTimes();
            EasyMock.expect((Object)this.catalog.getResourcesByNamespace(ns, CoverageInfo.class)).andReturn(this.coveragesByNamespace).anyTimes();
            this.dataStoresAll.addAll(this.dataStores);
            this.dataStores = new LinkedList();
            this.coverageStoresAll.addAll(this.coverageStores);
            this.coverageStores = new LinkedList();
            this.featureTypesAll.addAll(this.featureTypesByNamespace);
            this.featureTypesByNamespace = new LinkedList();
            this.coveragesAll.addAll(this.coveragesByNamespace);
            this.coveragesByNamespace = new LinkedList();
        } else if (!this.workspaces.isEmpty()) {
            LinkedList<FeatureTypeInfo> l = new LinkedList<FeatureTypeInfo>(this.featureTypesAll);
            l.addAll(this.coveragesAll);
            EasyMock.expect((Object)this.catalog.getResources(ResourceInfo.class)).andReturn(l).anyTimes();
            EasyMock.expect((Object)this.catalog.getResources(FeatureTypeInfo.class)).andReturn(this.featureTypesAll).anyTimes();
            EasyMock.expect((Object)this.catalog.getResources(CoverageInfo.class)).andReturn(this.coverages).anyTimes();
            EasyMock.expect((Object)this.catalog.getFeatureTypes()).andReturn(this.featureTypesAll).anyTimes();
            EasyMock.expect((Object)this.catalog.getCoverages()).andReturn(this.coveragesAll).anyTimes();
            LinkedList<DataStoreInfo> m = new LinkedList<DataStoreInfo>(this.dataStoresAll);
            m.addAll(this.coverageStoresAll);
            EasyMock.expect((Object)this.catalog.getStores(StoreInfo.class)).andReturn(m).anyTimes();
            EasyMock.expect((Object)this.catalog.getStores(DataStoreInfo.class)).andReturn(this.dataStoresAll).anyTimes();
            EasyMock.expect((Object)this.catalog.getStores(CoverageStoreInfo.class)).andReturn(this.coverageStoresAll).anyTimes();
            EasyMock.expect((Object)this.catalog.getLayers()).andReturn(this.layers).anyTimes();
            EasyMock.expect((Object)this.catalog.getStyles()).andReturn(this.styles).anyTimes();
            EasyMock.expect((Object)this.catalog.getLayerGroups()).andReturn(this.layerGroups).anyTimes();
            EasyMock.expect((Object)this.catalog.getWorkspaces()).andReturn(this.workspaces).anyTimes();
            EasyMock.expect((Object)this.catalog.getNamespaces()).andReturn(this.namespaces).anyTimes();
            EasyMock.expect((Object)this.catalog.getDefaultWorkspace()).andReturn((Object)this.workspaces.peekFirst()).anyTimes();
            EasyMock.expect((Object)this.catalog.getDefaultNamespace()).andReturn((Object)this.namespaces.peekFirst()).anyTimes();
            EasyMock.replay((Object[])new Object[]{this.catalog});
            this.featureTypesAll = new LinkedList();
            this.coveragesAll = new LinkedList();
            this.dataStoresAll = new LinkedList();
            this.coverageStoresAll = new LinkedList();
            this.styles = new LinkedList();
            this.workspaces = new LinkedList();
            this.namespaces = new LinkedList();
        }
        return this;
    }

    WorkspaceInfo findWorkspace(String name) {
        return this.find(name, this.workspaces);
    }

    DataStoreInfo findDataStore(String name) {
        return this.find(name, this.dataStoresAll);
    }

    CoverageStoreInfo findCoverageStore(String name) {
        return this.find(name, this.coverageStoresAll);
    }

    FeatureTypeInfo findFeatureType(String name) {
        return this.find(name, this.featureTypesAll);
    }

    CoverageInfo findCoverage(String name) {
        return this.find(name, this.coveragesAll);
    }

    StyleInfo findStyle(String name) {
        return this.find(name, this.styles);
    }

    LayerInfo findLayer(String name) {
        return this.find(name, this.layers);
    }

    LayerGroupInfo findLayerGroup(String name) {
        return this.find(name, this.layerGroups);
    }

    <T extends CatalogInfo> T find(final String name, List<T> list) {
        return (T)((CatalogInfo)Iterables.find(list, (Predicate)new Predicate<T>(){

            public boolean apply(T input) {
                return name.equals(OwsUtils.get(input, (String)"name"));
            }
        }));
    }

    protected String newId() {
        return UUID.randomUUID().toString();
    }

    static abstract class VisitAnswer
    implements IAnswer<Object> {
        VisitAnswer() {
        }

        public Object answer() throws Throwable {
            CatalogVisitor visitor = (CatalogVisitor)EasyMock.getCurrentArguments()[0];
            this.doVisit(visitor);
            return null;
        }

        protected abstract void doVisit(CatalogVisitor var1);
    }

    public static interface Callback {
        public void onWorkspace(String var1, WorkspaceInfo var2, MockCatalogBuilder var3);

        public void onStore(String var1, StoreInfo var2, WorkspaceInfo var3, MockCatalogBuilder var4);

        public void onResource(String var1, ResourceInfo var2, StoreInfo var3, MockCatalogBuilder var4);

        public void onLayer(String var1, LayerInfo var2, MockCatalogBuilder var3);

        public void onStyle(String var1, StyleInfo var2, MockCatalogBuilder var3);

        public void onLayerGroup(String var1, LayerGroupInfo var2, MockCatalogBuilder var3);
    }
}

